/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.commonizer.core;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.commonizer.core.AbstractStandardCommonizer;
import org.jetbrains.kotlin.descriptors.commonizer.core.TypeParameterListCommonizer;
import org.jetbrains.kotlin.descriptors.commonizer.core.ValueParameterListCommonizer;
import org.jetbrains.kotlin.descriptors.commonizer.core.VisibilityCommonizer;
import org.jetbrains.kotlin.descriptors.commonizer.mergedtree.ir.CirClassConstructor;
import org.jetbrains.kotlin.descriptors.commonizer.mergedtree.ir.CirClassifiersCache;
import org.jetbrains.kotlin.descriptors.commonizer.mergedtree.ir.CirCommonClassConstructor;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0002H\u0014J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0002H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/descriptors/commonizer/core/ClassConstructorCommonizer;", "Lorg/jetbrains/kotlin/descriptors/commonizer/core/AbstractStandardCommonizer;", "Lorg/jetbrains/kotlin/descriptors/commonizer/mergedtree/ir/CirClassConstructor;", "cache", "Lorg/jetbrains/kotlin/descriptors/commonizer/mergedtree/ir/CirClassifiersCache;", "(Lorg/jetbrains/kotlin/descriptors/commonizer/mergedtree/ir/CirClassifiersCache;)V", "hasStableParameterNames", "", "hasSynthesizedParameterNames", "isPrimary", "kind", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor$Kind;", "typeParameters", "Lorg/jetbrains/kotlin/descriptors/commonizer/core/TypeParameterListCommonizer;", "valueParameters", "Lorg/jetbrains/kotlin/descriptors/commonizer/core/ValueParameterListCommonizer;", "visibility", "Lorg/jetbrains/kotlin/descriptors/commonizer/core/VisibilityCommonizer;", "commonizationResult", "Lorg/jetbrains/kotlin/descriptors/commonizer/mergedtree/ir/CirCommonClassConstructor;", "doCommonizeWith", "next", "initialize", "", "first", "commonizer"})
public final class ClassConstructorCommonizer
extends AbstractStandardCommonizer<CirClassConstructor, CirClassConstructor> {
    private boolean isPrimary;
    private CallableMemberDescriptor.Kind kind;
    private final VisibilityCommonizer visibility;
    private final TypeParameterListCommonizer typeParameters;
    private final ValueParameterListCommonizer valueParameters;
    private boolean hasStableParameterNames;
    private boolean hasSynthesizedParameterNames;

    @Override
    @NotNull
    protected CirCommonClassConstructor commonizationResult() {
        CallableMemberDescriptor.Kind kind = this.kind;
        if (kind == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"kind");
        }
        return new CirCommonClassConstructor(this.isPrimary, kind, this.visibility.getResult(), (List)this.typeParameters.getResult(), (List)this.valueParameters.getResult(), this.hasStableParameterNames, this.hasSynthesizedParameterNames);
    }

    @Override
    protected void initialize(@NotNull CirClassConstructor first) {
        Intrinsics.checkParameterIsNotNull((Object)first, (String)"first");
        this.isPrimary = first.isPrimary();
        this.kind = first.getKind();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean doCommonizeWith(@NotNull CirClassConstructor next) {
        Intrinsics.checkParameterIsNotNull((Object)next, (String)"next");
        if (next.getContainingClassKind().isSingleton()) return false;
        if (next.getContainingClassModality() == Modality.SEALED) return false;
        if (this.isPrimary != next.isPrimary()) return false;
        CallableMemberDescriptor.Kind kind = this.kind;
        if (kind == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"kind");
        }
        if (kind != next.getKind()) return false;
        if (!this.visibility.commonizeWith(next)) return false;
        if (!this.typeParameters.commonizeWith(next.getTypeParameters())) return false;
        if (!this.valueParameters.commonizeWith(next.getValueParameters())) return false;
        boolean bl = true;
        boolean result = bl;
        if (!result) return result;
        this.hasStableParameterNames = this.hasStableParameterNames && next.getHasStableParameterNames();
        this.hasSynthesizedParameterNames = this.hasSynthesizedParameterNames || next.getHasSynthesizedParameterNames();
        return result;
    }

    public ClassConstructorCommonizer(@NotNull CirClassifiersCache cache) {
        Intrinsics.checkParameterIsNotNull((Object)cache, (String)"cache");
        this.visibility = VisibilityCommonizer.Companion.equalizing();
        this.typeParameters = TypeParameterListCommonizer.Companion.default(cache);
        this.valueParameters = ValueParameterListCommonizer.Companion.default(cache);
        this.hasStableParameterNames = true;
    }
}

