/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.test.framework.targets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.test.framework.targets.TestSymbolTarget;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\u0006\u0010\u0007\u001a\u00020\nH\u0002J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\u0006\u0010\u0007\u001a\u00020\fH\u0002J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\u0006\u0010\u0007\u001a\u00020\u000eH\u0014J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\u0006\u0010\u0007\u001a\u00020\u0010H\u0014J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\u0006\u0010\u0007\u001a\u00020\u0012H\u0014J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\u0006\u0010\u0007\u001a\u00020\u0014H\u0014J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\u0006\u0010\u0007\u001a\u00020\u0016H\u0014J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\u0006\u0010\u0007\u001a\u00020\u0018H\u0014J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\u0006\u0010\u0007\u001a\u00020\u001aH\u0014J\u001f\u0010\u001b\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0007\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u001eJ\u001f\u0010\u001f\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0007\u001a\u00020 2\u0006\u0010\u001d\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010!J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u0007\u001a\u00020\bH\u0002J7\u0010$\u001a\u00020%\"\n\b\u0001\u0010&\u0018\u0001*\u00028\u00002\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00028\u0000H\u0084\b\u0082\u0002\n\n\b\b\u0000\u001a\u0004\u0010\u0002(\u0000\u00a2\u0006\u0002\u0010'\u00f2\u0001\u0004\n\u0002H&\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/analysis/test/framework/targets/TestSymbolTargetResolver;", "R", "", "<init>", "()V", "resolveTarget", "", "target", "Lorg/jetbrains/kotlin/analysis/test/framework/targets/TestSymbolTarget;", "resolveClassLikeTarget", "Lorg/jetbrains/kotlin/analysis/test/framework/targets/TestSymbolTarget$ClassLikeTarget;", "resolveTargetWithOwner", "Lorg/jetbrains/kotlin/analysis/test/framework/targets/TestSymbolTarget$TargetWithOwner;", "resolvePackageTarget", "Lorg/jetbrains/kotlin/analysis/test/framework/targets/TestSymbolTarget$PackageTarget;", "resolveClassTarget", "Lorg/jetbrains/kotlin/analysis/test/framework/targets/TestSymbolTarget$ClassTarget;", "resolveScriptTarget", "Lorg/jetbrains/kotlin/analysis/test/framework/targets/TestSymbolTarget$ScriptTarget;", "resolveTypeAliasTarget", "Lorg/jetbrains/kotlin/analysis/test/framework/targets/TestSymbolTarget$TypeAliasTarget;", "resolveCallableTarget", "Lorg/jetbrains/kotlin/analysis/test/framework/targets/TestSymbolTarget$CallableTarget;", "resolveEnumEntryInitializerTarget", "Lorg/jetbrains/kotlin/analysis/test/framework/targets/TestSymbolTarget$EnumEntryInitializerTarget;", "resolveSamConstructorTarget", "Lorg/jetbrains/kotlin/analysis/test/framework/targets/TestSymbolTarget$SamConstructorTarget;", "resolveTypeParameterTarget", "Lorg/jetbrains/kotlin/analysis/test/framework/targets/TestSymbolTarget$TypeParameterTarget;", "owner", "(Lorg/jetbrains/kotlin/analysis/test/framework/targets/TestSymbolTarget$TypeParameterTarget;Ljava/lang/Object;)Ljava/lang/Object;", "resolveValueParameterTarget", "Lorg/jetbrains/kotlin/analysis/test/framework/targets/TestSymbolTarget$ValueParameterTarget;", "(Lorg/jetbrains/kotlin/analysis/test/framework/targets/TestSymbolTarget$ValueParameterTarget;Ljava/lang/Object;)Ljava/lang/Object;", "unsupportedTarget", "", "requireSpecificOwner", "", "A", "(Lorg/jetbrains/kotlin/analysis/test/framework/targets/TestSymbolTarget;Ljava/lang/Object;)V", "analysis-test-framework_testFixtures"})
@SourceDebugExtension(value={"SMAP\nTestSymbolTargetResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestSymbolTargetResolver.kt\norg/jetbrains/kotlin/analysis/test/framework/targets/TestSymbolTargetResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,72:1\n1586#2:73\n1661#2,3:74\n*S KotlinDebug\n*F\n+ 1 TestSymbolTargetResolver.kt\norg/jetbrains/kotlin/analysis/test/framework/targets/TestSymbolTargetResolver\n*L\n38#1:73\n38#1:74,3\n*E\n"})
public abstract class TestSymbolTargetResolver<R> {
    @NotNull
    public final List<R> resolveTarget(@NotNull TestSymbolTarget target) {
        List<R> list;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        TestSymbolTarget testSymbolTarget = target;
        if (testSymbolTarget instanceof TestSymbolTarget.PackageTarget) {
            list = this.resolvePackageTarget((TestSymbolTarget.PackageTarget)target);
        } else if (testSymbolTarget instanceof TestSymbolTarget.ClassTarget) {
            list = this.resolveClassTarget((TestSymbolTarget.ClassTarget)target);
        } else if (testSymbolTarget instanceof TestSymbolTarget.ScriptTarget) {
            list = this.resolveScriptTarget((TestSymbolTarget.ScriptTarget)target);
        } else if (testSymbolTarget instanceof TestSymbolTarget.TypeAliasTarget) {
            list = this.resolveTypeAliasTarget((TestSymbolTarget.TypeAliasTarget)target);
        } else if (testSymbolTarget instanceof TestSymbolTarget.ClassLikeTarget) {
            list = this.resolveClassLikeTarget((TestSymbolTarget.ClassLikeTarget)target);
        } else if (testSymbolTarget instanceof TestSymbolTarget.CallableTarget) {
            list = this.resolveCallableTarget((TestSymbolTarget.CallableTarget)target);
        } else if (testSymbolTarget instanceof TestSymbolTarget.EnumEntryInitializerTarget) {
            list = this.resolveEnumEntryInitializerTarget((TestSymbolTarget.EnumEntryInitializerTarget)target);
        } else if (testSymbolTarget instanceof TestSymbolTarget.SamConstructorTarget) {
            list = this.resolveSamConstructorTarget((TestSymbolTarget.SamConstructorTarget)target);
        } else if (testSymbolTarget instanceof TestSymbolTarget.TargetWithOwner) {
            list = this.resolveTargetWithOwner((TestSymbolTarget.TargetWithOwner)target);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }

    private final List<R> resolveClassLikeTarget(TestSymbolTarget.ClassLikeTarget target) {
        return CollectionsKt.plus((Collection)this.resolveClassTarget(new TestSymbolTarget.ClassTarget(target.getClassId())), (Iterable)this.resolveTypeAliasTarget(new TestSymbolTarget.TypeAliasTarget(target.getClassId())));
    }

    /*
     * WARNING - void declaration
     */
    private final List<R> resolveTargetWithOwner(TestSymbolTarget.TargetWithOwner target) {
        void $this$mapTo$iv$iv;
        List<R> owners = this.resolveTarget(target.getOwnerTarget());
        if (owners.isEmpty()) {
            throw new IllegalStateException(("Couldn't resolve an owner for `" + target + "`.").toString());
        }
        Iterable $this$map$iv = owners;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void v0;
            void owner;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            TestSymbolTarget.TargetWithOwner targetWithOwner = target;
            if (targetWithOwner instanceof TestSymbolTarget.TypeParameterTarget) {
                v0 = this.resolveTypeParameterTarget((TestSymbolTarget.TypeParameterTarget)target, owner);
                if (v0 == null) {
                    throw new IllegalStateException(("Cannot find a type parameter `" + ((TestSymbolTarget.TypeParameterTarget)target).getName() + "` in the owner `" + owner + "`.").toString());
                }
            } else if (targetWithOwner instanceof TestSymbolTarget.ValueParameterTarget) {
                v0 = this.resolveValueParameterTarget((TestSymbolTarget.ValueParameterTarget)target, owner);
                if (v0 == null) {
                    throw new IllegalStateException(("Cannot find a value parameter `" + ((TestSymbolTarget.ValueParameterTarget)target).getName() + "` in the owner `" + owner + "`.").toString());
                }
            } else {
                throw new NoWhenBranchMatchedException();
            }
            collection.add(v0);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    protected List<R> resolvePackageTarget(@NotNull TestSymbolTarget.PackageTarget target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.unsupportedTarget(target);
        throw new KotlinNothingValueException();
    }

    @NotNull
    protected List<R> resolveClassTarget(@NotNull TestSymbolTarget.ClassTarget target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.unsupportedTarget(target);
        throw new KotlinNothingValueException();
    }

    @NotNull
    protected List<R> resolveScriptTarget(@NotNull TestSymbolTarget.ScriptTarget target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.unsupportedTarget(target);
        throw new KotlinNothingValueException();
    }

    @NotNull
    protected List<R> resolveTypeAliasTarget(@NotNull TestSymbolTarget.TypeAliasTarget target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.unsupportedTarget(target);
        throw new KotlinNothingValueException();
    }

    @NotNull
    protected List<R> resolveCallableTarget(@NotNull TestSymbolTarget.CallableTarget target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.unsupportedTarget(target);
        throw new KotlinNothingValueException();
    }

    @NotNull
    protected List<R> resolveEnumEntryInitializerTarget(@NotNull TestSymbolTarget.EnumEntryInitializerTarget target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.unsupportedTarget(target);
        throw new KotlinNothingValueException();
    }

    @NotNull
    protected List<R> resolveSamConstructorTarget(@NotNull TestSymbolTarget.SamConstructorTarget target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.unsupportedTarget(target);
        throw new KotlinNothingValueException();
    }

    @Nullable
    protected R resolveTypeParameterTarget(@NotNull TestSymbolTarget.TypeParameterTarget target, R owner) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.unsupportedTarget(target);
        throw new KotlinNothingValueException();
    }

    @Nullable
    protected R resolveValueParameterTarget(@NotNull TestSymbolTarget.ValueParameterTarget target, R owner) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.unsupportedTarget(target);
        throw new KotlinNothingValueException();
    }

    private final Void unsupportedTarget(TestSymbolTarget target) {
        throw new IllegalStateException(('`' + Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + "` doesn't support `" + Reflection.getOrCreateKotlinClass(target.getClass()).getSimpleName() + "`.").toString());
    }

    protected final /* synthetic */ <A extends R> void requireSpecificOwner(TestSymbolTarget target, R owner) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        boolean $i$f$requireSpecificOwner = false;
        Intrinsics.reifiedOperationMarker((int)3, (String)"A");
        if (!(owner instanceof Object)) {
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder().append("Expected a `");
            Intrinsics.reifiedOperationMarker((int)4, (String)"A");
            String string = stringBuilder.append(Reflection.getOrCreateKotlinClass(Object.class).getSimpleName()).append("` owner for `").append(target).append("`, but found: ").append(owner).append('.').toString();
            throw new IllegalArgumentException(string.toString());
        }
    }
}

