/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.test.cases.imports;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.impl.base.imports.KaDefaultImportImpl;
import org.jetbrains.kotlin.analysis.api.imports.KaDefaultImport;
import org.jetbrains.kotlin.analysis.api.imports.KaDefaultImportPriority;
import org.jetbrains.kotlin.analysis.api.imports.KaDefaultImportsProviderKt;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaSourceModule;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.LLResolutionFacade;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.LowLevelFirApiFacadeKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.ContextCollector;
import org.jetbrains.kotlin.analysis.test.framework.base.AbstractAnalysisApiBasedTest;
import org.jetbrains.kotlin.analysis.test.framework.projectStructure.KtTestModule;
import org.jetbrains.kotlin.analysis.utils.printer.PrettyPrinter;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirResolvedImport;
import org.jetbrains.kotlin.fir.declarations.FirTowerDataElement;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.impl.DefaultImportPriority;
import org.jetbrains.kotlin.fir.scopes.impl.FirDefaultSimpleImportingScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirDefaultStarImportingScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirSingleLevelDefaultStarImportingScope;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.ImportPath;
import org.jetbrains.kotlin.test.services.AssertionsKt;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u000f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0010\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J\f\u0010\u001a\u001a\u00020\u001b*\u00020\u001cH\u0002J\n\u0010\u001d\u001a\u00020\u0012*\u00020\u0015\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/test/cases/imports/AbstractKaDefaultImportsProviderTest;", "Lorg/jetbrains/kotlin/analysis/test/framework/base/AbstractAnalysisApiBasedTest;", "<init>", "()V", "doTestByMainFile", "", "mainFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "mainModule", "Lorg/jetbrains/kotlin/analysis/test/framework/projectStructure/KtTestModule;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "checkImportsFromKaDefaultImportsProvider", "sourceModule", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaSourceModule;", "checkImportsFromResolve", "checkExcludedImports", "renderDefaultImports", "", "imports", "", "Lorg/jetbrains/kotlin/analysis/api/imports/KaDefaultImport;", "getDefaultImportsUsedInResolve", "kaModule", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "ktFile", "asKaDefaultImportPriority", "Lorg/jetbrains/kotlin/analysis/api/imports/KaDefaultImportPriority;", "Lorg/jetbrains/kotlin/fir/scopes/impl/DefaultImportPriority;", "asString", "analysis-api-fir_testFixtures"})
@SourceDebugExtension(value={"SMAP\nAbstractKaDefaultImportsProviderTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractKaDefaultImportsProviderTest.kt\norg/jetbrains/kotlin/analysis/api/fir/test/cases/imports/AbstractKaDefaultImportsProviderTest\n+ 2 PrettyPrinter.kt\norg/jetbrains/kotlin/analysis/utils/printer/PrettyPrinterKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 PrettyPrinter.kt\norg/jetbrains/kotlin/analysis/utils/printer/PrettyPrinter\n*L\n1#1,132:1\n212#2:133\n212#2:152\n1068#3:134\n777#3:166\n873#3,2:167\n1391#3:194\n1480#3,5:195\n1391#3:200\n1480#3,5:201\n1391#3:206\n1480#3,2:207\n1586#3:209\n1661#3,3:210\n1586#3:213\n1661#3,3:214\n1482#3,3:217\n92#4,17:135\n92#4,11:153\n64#4,2:164\n92#4,17:169\n66#4,2:186\n103#4,6:188\n*S KotlinDebug\n*F\n+ 1 AbstractKaDefaultImportsProviderTest.kt\norg/jetbrains/kotlin/analysis/api/fir/test/cases/imports/AbstractKaDefaultImportsProviderTest\n*L\n52#1:133\n64#1:152\n56#1:134\n69#1:166\n69#1:167,2\n94#1:194\n94#1:195,5\n95#1:200\n95#1:201,5\n96#1:206\n96#1:207,2\n99#1:209\n99#1:210,3\n107#1:213\n107#1:214,3\n96#1:217,3\n56#1:135,17\n65#1:153,11\n67#1:164,2\n78#1:169,17\n67#1:186,2\n65#1:188,6\n*E\n"})
public abstract class AbstractKaDefaultImportsProviderTest
extends AbstractAnalysisApiBasedTest {
    @Override
    protected void doTestByMainFile(@NotNull KtFile mainFile, @NotNull KtTestModule mainModule, @NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)mainFile, (String)"mainFile");
        Intrinsics.checkNotNullParameter((Object)mainModule, (String)"mainModule");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        KaModule kaModule = mainModule.getKtModule();
        Intrinsics.checkNotNull((Object)kaModule, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.analysis.api.projectStructure.KaSourceModule");
        KaSourceModule sourceModule = (KaSourceModule)kaModule;
        this.checkImportsFromKaDefaultImportsProvider(sourceModule, testServices);
        this.checkImportsFromResolve(sourceModule, mainFile, testServices);
        this.checkExcludedImports(sourceModule, testServices);
    }

    private final void checkImportsFromKaDefaultImportsProvider(KaSourceModule sourceModule, TestServices testServices) {
        List imports = KaDefaultImportsProviderKt.getDefaultImports((TargetPlatform)sourceModule.getTargetPlatform(), (Project)sourceModule.getProject()).getDefaultImports();
        String actual2 = this.renderDefaultImports(imports);
        AbstractAnalysisApiBasedTest.assertEqualsToTestOutputFile$default(this, AssertionsKt.getAssertions((TestServices)testServices), actual2, ".default.txt", null, null, 12, null);
    }

    private final void checkImportsFromResolve(KaSourceModule sourceModule, KtFile mainFile, TestServices testServices) {
        List<KaDefaultImport> importsUsedInResolve = this.getDefaultImportsUsedInResolve((KaModule)sourceModule, mainFile);
        String actual2 = this.renderDefaultImports(importsUsedInResolve);
        AbstractAnalysisApiBasedTest.assertEqualsToTestOutputFile$default(this, AssertionsKt.getAssertions((TestServices)testServices), actual2, ".default.txt", null, null, 12, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkExcludedImports(KaSourceModule sourceModule, TestServices testServices) {
        void collection$iv;
        void $this$iv;
        PrettyPrinter prettyPrinter;
        List excludedImports = KaDefaultImportsProviderKt.getDefaultImports((TargetPlatform)sourceModule.getTargetPlatform(), (Project)sourceModule.getProject()).getExcludedFromDefaultImports();
        boolean $i$f$prettyPrint = false;
        PrettyPrinter $this$checkExcludedImports_u24lambda_u240 = prettyPrinter = new PrettyPrinter(0, 1, null);
        boolean bl = false;
        if (excludedImports.isEmpty()) {
            ((Appendable)$this$checkExcludedImports_u24lambda_u240).append("<EMPTY>").append('\n');
        }
        PrettyPrinter prettyPrinter2 = $this$checkExcludedImports_u24lambda_u240;
        Iterable $this$sortedBy$iv = excludedImports;
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ImportPath it = (ImportPath)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getFqName().asString());
                it = (ImportPath)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getFqName().asString())));
            }
        });
        String separator$iv = "\n";
        String prefix$iv = "";
        String postfix$iv = "";
        boolean $i$f$printCollection = false;
        $this$iv.append((CharSequence)prefix$iv);
        Iterator iterator$iv = collection$iv.iterator();
        while (iterator$iv.hasNext()) {
            void it;
            ImportPath importPath = (ImportPath)iterator$iv.next();
            void $this$checkExcludedImports_u24lambda_u240_u241 = $this$iv;
            boolean bl2 = false;
            $this$checkExcludedImports_u24lambda_u240_u241.append((CharSequence)it.getFqName().asString());
            if (!iterator$iv.hasNext()) continue;
            $this$iv.append((CharSequence)separator$iv);
        }
        $this$iv.append((CharSequence)postfix$iv);
        String actual2 = prettyPrinter.toString();
        AbstractAnalysisApiBasedTest.assertEqualsToTestOutputFile$default(this, AssertionsKt.getAssertions((TestServices)testServices), actual2, ".excluded.txt", null, null, 12, null);
    }

    /*
     * WARNING - void declaration
     */
    private final String renderDefaultImports(List<? extends KaDefaultImport> imports) {
        void collection$iv;
        void $this$iv;
        PrettyPrinter prettyPrinter;
        boolean $i$f$prettyPrint = false;
        PrettyPrinter $this$renderDefaultImports_u24lambda_u240 = prettyPrinter = new PrettyPrinter(0, 1, null);
        boolean bl = false;
        PrettyPrinter prettyPrinter2 = $this$renderDefaultImports_u24lambda_u240;
        Iterable iterable = (Iterable)KaDefaultImportPriority.getEntries();
        String separator$iv = "\n";
        String prefix$iv = "";
        String postfix$iv = "";
        boolean $i$f$printCollection = false;
        $this$iv.append((CharSequence)prefix$iv);
        Iterator iterator$iv = collection$iv.iterator();
        while (iterator$iv.hasNext()) {
            KaDefaultImport it;
            void $this$filterTo$iv$iv;
            void priority;
            KaDefaultImportPriority kaDefaultImportPriority = (KaDefaultImportPriority)iterator$iv.next();
            void $this$renderDefaultImports_u24lambda_u240_u240 = $this$iv;
            boolean bl2 = false;
            ((Appendable)$this$renderDefaultImports_u24lambda_u240_u240).append(priority.name() + ':').append('\n');
            void this_$iv = $this$renderDefaultImports_u24lambda_u240_u240;
            boolean $i$f$withIndent = false;
            this_$iv.setIndent(this_$iv.getIndent() + 1);
            void $this$renderDefaultImports_u24lambda_u240_u240_u240 = this_$iv;
            boolean bl3 = false;
            Function1[] $this$filter$iv = (Function1[])imports;
            boolean $i$f$filter2 = false;
            Function1[] function1Array = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (KaDefaultImport)element$iv$iv;
                boolean bl4 = false;
                if (!(it.getPriority() == priority)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = new Function1[]{AbstractKaDefaultImportsProviderTest::renderDefaultImports$lambda$0$0$0$1, AbstractKaDefaultImportsProviderTest::renderDefaultImports$lambda$0$0$0$2, AbstractKaDefaultImportsProviderTest::renderDefaultImports$lambda$0$0$0$3};
            List importsWithCurrentPriority = CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), (Comparator)ComparisonsKt.compareBy((Function1[])$this$filter$iv));
            if (!((Collection)importsWithCurrentPriority).isEmpty()) {
                void collection$iv2;
                void $this$iv2;
                $this$filter$iv = $this$renderDefaultImports_u24lambda_u240_u240_u240;
                Iterable $i$f$filter2 = importsWithCurrentPriority;
                String separator$iv2 = "\n";
                String prefix$iv2 = "";
                String postfix$iv2 = "";
                boolean $i$f$printCollection2 = false;
                $this$iv2.append((CharSequence)prefix$iv2);
                Iterator iterator$iv2 = collection$iv2.iterator();
                while (iterator$iv2.hasNext()) {
                    it = (KaDefaultImport)iterator$iv2.next();
                    void $this$renderDefaultImports_u24lambda_u240_u240_u240_u244 = $this$iv2;
                    boolean bl5 = false;
                    $this$renderDefaultImports_u24lambda_u240_u240_u240_u244.append((CharSequence)this.asString(it));
                    if (!iterator$iv2.hasNext()) continue;
                    $this$iv2.append((CharSequence)separator$iv2);
                }
                $this$iv2.append((CharSequence)postfix$iv2);
            } else {
                $this$renderDefaultImports_u24lambda_u240_u240_u240.append((CharSequence)"<EMPTY>");
            }
            this_$iv.setIndent(this_$iv.getIndent() - 1);
            if (!iterator$iv.hasNext()) continue;
            $this$iv.append((CharSequence)separator$iv);
        }
        $this$iv.append((CharSequence)postfix$iv);
        return prettyPrinter.toString();
    }

    private final List<KaDefaultImport> getDefaultImportsUsedInResolve(KaModule kaModule, KtFile ktFile) {
        FirSingleLevelDefaultStarImportingScope[] firSingleLevelDefaultStarImportingScopeArray;
        Iterable list$iv$iv;
        FirTowerDataElement it;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        LLResolutionFacade resolutionFacade = LowLevelFirApiFacadeKt.getResolutionFacade((KaModule)kaModule, (Project)kaModule.getProject());
        FirFile firFile = LowLevelFirApiFacadeKt.getOrBuildFirFile((KtFile)ktFile, (LLResolutionFacade)resolutionFacade);
        ContextCollector.Context context = ContextCollector.process$default((ContextCollector)ContextCollector.INSTANCE, (LLResolutionFacade)resolutionFacade, (FirFile)firFile, (PsiElement)((PsiElement)ktFile), (boolean)false, (int)8, null);
        Intrinsics.checkNotNull((Object)context);
        ContextCollector.Context context2 = context;
        Iterable iterable = (Iterable)context2.getTowerDataContext().getTowerDataElements();
        boolean $i$f$flatMap = false;
        void var8_8 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (FirTowerDataElement)element$iv$iv;
            boolean bl = false;
            list$iv$iv = FirTowerDataElement.getAvailableScopes$default((FirTowerDataElement)it, null, (int)1, null);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list;
            it = (FirScope)element$iv$iv;
            boolean bl = false;
            if (it instanceof FirDefaultStarImportingScope) {
                firSingleLevelDefaultStarImportingScopeArray = new FirSingleLevelDefaultStarImportingScope[]{((FirDefaultStarImportingScope)it).getFirst(), ((FirDefaultStarImportingScope)it).getSecond()};
                list = CollectionsKt.listOf((Object[])firSingleLevelDefaultStarImportingScopeArray);
            } else {
                list = CollectionsKt.listOf((Object)it);
            }
            list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list;
            FirResolvedImport firResolvedImport;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            boolean $i$f$mapTo;
            Collection destination$iv$iv2;
            boolean $i$f$map;
            Iterable $this$map$iv;
            FirSingleLevelDefaultStarImportingScope[] scope = (FirSingleLevelDefaultStarImportingScope[])element$iv$iv;
            boolean bl = false;
            firSingleLevelDefaultStarImportingScopeArray = scope;
            if (firSingleLevelDefaultStarImportingScopeArray instanceof FirSingleLevelDefaultStarImportingScope) {
                $this$map$iv = ((FirSingleLevelDefaultStarImportingScope)scope).getStarImports();
                $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    FirResolvedImport firResolvedImport2 = (FirResolvedImport)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl2 = false;
                    FqName fqName = firResolvedImport.getImportedFqName();
                    Intrinsics.checkNotNull((Object)fqName);
                    collection.add(new KaDefaultImportImpl(new ImportPath(fqName, true, null, 4, null), this.asKaDefaultImportPriority(((FirSingleLevelDefaultStarImportingScope)scope).getPriority())));
                }
                list = (List)destination$iv$iv2;
            } else if (firSingleLevelDefaultStarImportingScopeArray instanceof FirDefaultSimpleImportingScope) {
                $this$map$iv = CollectionsKt.flatten((Iterable)((FirDefaultSimpleImportingScope)scope).getSimpleImports().values());
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    firResolvedImport = (FirResolvedImport)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl3 = false;
                    FqName fqName = firResolvedImport.getImportedFqName();
                    Intrinsics.checkNotNull((Object)fqName);
                    collection.add(new KaDefaultImportImpl(new ImportPath(fqName, false, null, 4, null), this.asKaDefaultImportPriority(((FirDefaultSimpleImportingScope)scope).getPriority())));
                }
                list = (List)destination$iv$iv2;
            } else {
                list = CollectionsKt.emptyList();
            }
            list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final KaDefaultImportPriority asKaDefaultImportPriority(DefaultImportPriority $this$asKaDefaultImportPriority) {
        KaDefaultImportPriority kaDefaultImportPriority;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$asKaDefaultImportPriority.ordinal()]) {
            case 1: {
                kaDefaultImportPriority = KaDefaultImportPriority.HIGH;
                break;
            }
            case 2: {
                kaDefaultImportPriority = KaDefaultImportPriority.LOW;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return kaDefaultImportPriority;
    }

    @NotNull
    public final String asString(@NotNull KaDefaultImport $this$asString) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$asString, (String)"<this>");
        StringBuilder $this$asString_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$asString_u24lambda_u240.append("import " + $this$asString.getImportPath().getFqName().asString());
        if ($this$asString.getImportPath().isAllUnder()) {
            $this$asString_u24lambda_u240.append(".*");
        }
        return stringBuilder.toString();
    }

    private static final Comparable renderDefaultImports$lambda$0$0$0$1(KaDefaultImport it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Comparable)((Object)it.getImportPath().getFqName().asString());
    }

    private static final Comparable renderDefaultImports$lambda$0$0$0$2(KaDefaultImport it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Boolean.valueOf(it.getImportPath().isAllUnder());
    }

    private static final Comparable renderDefaultImports$lambda$0$0$0$3(KaDefaultImport it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Comparable)((Object)it.getPriority().toString());
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DefaultImportPriority.values().length];
            try {
                nArray[DefaultImportPriority.HIGH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DefaultImportPriority.LOW.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

