/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.test.framework.base;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.test.framework.base.AbstractAnalysisApiExecutionTest;
import org.jetbrains.kotlin.analysis.test.framework.projectStructure.KtTestModule;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.test.services.TestServices;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolver;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0002\u0018\u0000 \u001a2\u00020\u00012\u00020\u00022\u00020\u0003:\u0002\u001a\u001bB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\u0012\u0010\u0014\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u000eH\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/analysis/test/framework/base/AnalysisApiExecutionTestExtension;", "Lorg/junit/jupiter/api/extension/BeforeTestExecutionCallback;", "Lorg/junit/jupiter/api/extension/AfterTestExecutionCallback;", "Lorg/junit/jupiter/api/extension/ParameterResolver;", "<init>", "()V", "cachedState", "Ljava/lang/ThreadLocal;", "Lorg/jetbrains/kotlin/analysis/test/framework/base/AnalysisApiExecutionTestExtension$State;", "supportsParameter", "", "parameterContext", "Lorg/junit/jupiter/api/extension/ParameterContext;", "extensionContext", "Lorg/junit/jupiter/api/extension/ExtensionContext;", "resolveParameter", "", "beforeTestExecution", "", "context", "afterTestExecution", "getTestFilePath", "Ljava/nio/file/Path;", "testDirPathString", "", "testFileName", "Companion", "State", "analysis-test-framework_testFixtures"})
@SourceDebugExtension(value={"SMAP\nAbstractAnalysisApiExecutionTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractAnalysisApiExecutionTest.kt\norg/jetbrains/kotlin/analysis/test/framework/base/AnalysisApiExecutionTestExtension\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,105:1\n1807#2,3:106\n1#3:109\n*S KotlinDebug\n*F\n+ 1 AbstractAnalysisApiExecutionTest.kt\norg/jetbrains/kotlin/analysis/test/framework/base/AnalysisApiExecutionTestExtension\n*L\n69#1:106,3\n*E\n"})
final class AnalysisApiExecutionTestExtension
implements BeforeTestExecutionCallback,
AfterTestExecutionCallback,
ParameterResolver {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private ThreadLocal<State> cachedState = new ThreadLocal();
    @NotNull
    private static final List<Class<? extends Object>> SUPPORTED_PARAMETER_TYPES;

    public boolean supportsParameter(@NotNull ParameterContext parameterContext, @NotNull ExtensionContext extensionContext) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)parameterContext, (String)"parameterContext");
            Intrinsics.checkNotNullParameter((Object)extensionContext, (String)"extensionContext");
            Class<?> parameterType = parameterContext.getParameter().getType();
            Iterable $this$any$iv = SUPPORTED_PARAMETER_TYPES;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Class it = (Class)element$iv;
                    boolean bl2 = false;
                    if (!it.isAssignableFrom(parameterType)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Nullable
    public Object resolveParameter(@NotNull ParameterContext parameterContext, @NotNull ExtensionContext extensionContext) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)parameterContext, (String)"parameterContext");
        Intrinsics.checkNotNullParameter((Object)extensionContext, (String)"extensionContext");
        State state = this.cachedState.get();
        if (state == null) {
            throw new IllegalStateException("State is not cached yet".toString());
        }
        State cachedState = state;
        Class<Object> parameterType = parameterContext.getParameter().getType();
        if (parameterType.isAssignableFrom(TestServices.class)) {
            object = cachedState.getTestServices();
        } else if (parameterType.isAssignableFrom(KtFile.class)) {
            object = cachedState.getMainFile();
        } else if (parameterType.isAssignableFrom(KtTestModule.class)) {
            object = cachedState.getMainModule();
        } else {
            throw new IllegalStateException(("Unsupported parameter type " + parameterType).toString());
        }
        return object;
    }

    public void beforeTestExecution(@NotNull ExtensionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getRequiredTestInstance();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.analysis.test.framework.base.AbstractAnalysisApiExecutionTest");
        AbstractAnalysisApiExecutionTest testInstance = (AbstractAnalysisApiExecutionTest)object;
        String string = testInstance.getTestDirPathString();
        String string2 = context.getRequiredTestMethod().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        Path testFilePath = this.getTestFilePath(string, string2);
        testInstance.performTest(((Object)testFilePath).toString(), (Function3<? super TestServices, ? super KtFile, ? super KtTestModule, Unit>)((Function3)(arg_0, arg_1, arg_2) -> AnalysisApiExecutionTestExtension.beforeTestExecution$lambda$0(this, arg_0, arg_1, arg_2)));
    }

    public void afterTestExecution(@Nullable ExtensionContext context) {
        this.cachedState.remove();
    }

    private final Path getTestFilePath(String testDirPathString, String testFileName) {
        Object object = new String[]{testFileName + ".kt"};
        Object it = object = Paths.get(testDirPathString, object);
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        Object object2 = Files.exists((Path)it, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? object : null;
        if (object2 == null) {
            Object object3 = new String[]{testFileName + ".kts"};
            Object it2 = object3 = Paths.get(testDirPathString, object3);
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it2);
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            object2 = Files.exists((Path)it2, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length)) ? object3 : null;
            if (object2 == null) {
                Object object4 = new String[]{testFileName + ".kotlin_builtins"};
                Object it3 = object4 = Paths.get(testDirPathString, object4);
                boolean bl3 = false;
                Intrinsics.checkNotNull((Object)it3);
                LinkOption[] linkOptionArray3 = new LinkOption[]{};
                object2 = Files.exists((Path)it3, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length)) ? object4 : null;
                if (object2 == null) {
                    throw new IllegalStateException(("Cannot find test file " + testFileName + ".kt(s) in " + testDirPathString).toString());
                }
            }
        }
        return object2;
    }

    private static final Unit beforeTestExecution$lambda$0(AnalysisApiExecutionTestExtension this$0, TestServices testServices, KtFile mainFile, KtTestModule mainModule) {
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        Intrinsics.checkNotNullParameter((Object)mainModule, (String)"mainModule");
        if (!(this$0.cachedState.get() == null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this$0.cachedState.set(new State(testServices, mainFile, mainModule));
        return Unit.INSTANCE;
    }

    static {
        Object[] objectArray = new Class[]{TestServices.class, KtFile.class, KtTestModule.class};
        SUPPORTED_PARAMETER_TYPES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/analysis/test/framework/base/AnalysisApiExecutionTestExtension$Companion;", "", "<init>", "()V", "SUPPORTED_PARAMETER_TYPES", "", "Ljava/lang/Class;", "analysis-test-framework_testFixtures"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/analysis/test/framework/base/AnalysisApiExecutionTestExtension$State;", "", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "mainFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "mainModule", "Lorg/jetbrains/kotlin/analysis/test/framework/projectStructure/KtTestModule;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;Lorg/jetbrains/kotlin/psi/KtFile;Lorg/jetbrains/kotlin/analysis/test/framework/projectStructure/KtTestModule;)V", "getTestServices", "()Lorg/jetbrains/kotlin/test/services/TestServices;", "getMainFile", "()Lorg/jetbrains/kotlin/psi/KtFile;", "getMainModule", "()Lorg/jetbrains/kotlin/analysis/test/framework/projectStructure/KtTestModule;", "analysis-test-framework_testFixtures"})
    private static final class State {
        @NotNull
        private final TestServices testServices;
        @Nullable
        private final KtFile mainFile;
        @NotNull
        private final KtTestModule mainModule;

        public State(@NotNull TestServices testServices, @Nullable KtFile mainFile, @NotNull KtTestModule mainModule) {
            Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
            Intrinsics.checkNotNullParameter((Object)mainModule, (String)"mainModule");
            this.testServices = testServices;
            this.mainFile = mainFile;
            this.mainModule = mainModule;
        }

        @NotNull
        public final TestServices getTestServices() {
            return this.testServices;
        }

        @Nullable
        public final KtFile getMainFile() {
            return this.mainFile;
        }

        @NotNull
        public final KtTestModule getMainModule() {
            return this.mainModule;
        }
    }
}

