/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.impl.base.test.cases.components.resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.components.KaResolver;
import org.jetbrains.kotlin.analysis.api.components.KaResolverKt;
import org.jetbrains.kotlin.analysis.api.impl.base.test.cases.components.TestUtilsKt;
import org.jetbrains.kotlin.analysis.api.impl.base.test.cases.components.resolver.AbstractResolveByElementTest;
import org.jetbrains.kotlin.analysis.api.resolution.KaCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallCandidateInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallableMemberCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaSuccessCallInfo;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.test.services.AssertionsKt;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J9\u0010\r\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u00020\u000fj\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0016J'\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0018\u001a\u00020\nH\u0002R\u00020\u000fj\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0019R\u0014\u0010\u0004\u001a\u00020\u00058TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/analysis/api/impl/base/test/cases/components/resolver/AbstractResolveCandidatesTest;", "Lorg/jetbrains/kotlin/analysis/api/impl/base/test/cases/components/resolver/AbstractResolveByElementTest;", "<init>", "()V", "resolveKind", "", "getResolveKind", "()Ljava/lang/String;", "generateResolveOutput", "mainElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "checkConsistencyWithResolveCall", "", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "<unused var>", "callInfo", "Lorg/jetbrains/kotlin/analysis/api/resolution/KaCallInfo;", "candidates", "", "Lorg/jetbrains/kotlin/analysis/api/resolution/KaCallCandidateInfo;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/analysis/api/resolution/KaCallInfo;Ljava/util/List;Lorg/jetbrains/kotlin/test/services/TestServices;)V", "collectCallCandidates", "element", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtElement;)Ljava/util/List;", "analysis-api-impl-base_testFixtures"})
@SourceDebugExtension(value={"SMAP\nAbstractResolveCandidatesTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractResolveCandidatesTest.kt\norg/jetbrains/kotlin/analysis/api/impl/base/test/cases/components/resolver/AbstractResolveCandidatesTest\n+ 2 KaCallInfo.kt\norg/jetbrains/kotlin/analysis/api/resolution/KaCallInfoKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,80:1\n99#2:81\n1641#3,10:82\n1914#3:92\n1915#3:94\n1651#3:95\n1#4:93\n*S KotlinDebug\n*F\n+ 1 AbstractResolveCandidatesTest.kt\norg/jetbrains/kotlin/analysis/api/impl/base/test/cases/components/resolver/AbstractResolveCandidatesTest\n*L\n48#1:81\n58#1:82,10\n58#1:92\n58#1:94\n58#1:95\n58#1:93\n*E\n"})
public abstract class AbstractResolveCandidatesTest
extends AbstractResolveByElementTest {
    @Override
    @NotNull
    protected String getResolveKind() {
        return "candidates";
    }

    @Override
    @NotNull
    public String generateResolveOutput(@NotNull KtElement mainElement, @NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)mainElement, (String)"mainElement");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        return (String)this.analyzeForTest(mainElement, arg_0 -> AbstractResolveCandidatesTest.generateResolveOutput$lambda$0(this, mainElement, testServices, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final void checkConsistencyWithResolveCall(KaSession kaSession, KaCallInfo callInfo, List<? extends KaCallCandidateInfo> candidates, TestServices testServices) {
        KaCallableMemberCall resolvedCall;
        KaCallableMemberCall kaCallableMemberCall;
        KaCallInfo kaCallInfo = callInfo;
        if (kaCallInfo != null) {
            KaCallInfo $this$successfulCallOrNull$iv = kaCallInfo;
            boolean $i$f$successfulCallOrNull = false;
            KaSuccessCallInfo kaSuccessCallInfo = $this$successfulCallOrNull$iv instanceof KaSuccessCallInfo ? (KaSuccessCallInfo)$this$successfulCallOrNull$iv : null;
            Object object = kaSuccessCallInfo != null ? kaSuccessCallInfo.getCall() : null;
            if (!(object instanceof KaCallableMemberCall)) {
                object = null;
            }
            kaCallableMemberCall = (KaCallableMemberCall)((KaCall)((KaCallableMemberCall)object));
        } else {
            kaCallableMemberCall = resolvedCall = null;
        }
        if (candidates.isEmpty()) {
            AssertionsKt.getAssertions((TestServices)testServices).assertEquals(null, resolvedCall, () -> AbstractResolveCandidatesTest.checkConsistencyWithResolveCall$lambda$0(kaSession, resolvedCall));
        } else {
            void $this$mapNotNullTo$iv$iv;
            if (resolvedCall == null) {
                return;
            }
            String resolvedSymbol = TestUtilsKt.stringRepresentation(kaSession, KaCallKt.getSymbol(resolvedCall));
            Iterable $this$mapNotNull$iv = candidates;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String string;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                KaCallCandidateInfo it = (KaCallCandidateInfo)element$iv$iv;
                boolean bl2 = false;
                if (it.isInBestCandidates()) {
                    KaCall kaCall = it.getCandidate();
                    Intrinsics.checkNotNull((Object)kaCall, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.analysis.api.resolution.KaCallableMemberCall<*, *>");
                    string = TestUtilsKt.stringRepresentation(kaSession, KaCallKt.getSymbol((KaCallableMemberCall)((KaCallableMemberCall)kaCall)));
                } else {
                    string = null;
                }
                if (string == null) continue;
                String it$iv$iv = string;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List candidatesRepresentation = (List)destination$iv$iv;
            AssertionsKt.getAssertions((TestServices)testServices).assertTrue(candidatesRepresentation.contains(resolvedSymbol), () -> AbstractResolveCandidatesTest.checkConsistencyWithResolveCall$lambda$2(resolvedSymbol, candidatesRepresentation));
        }
    }

    private final List<KaCallCandidateInfo> collectCallCandidates(KaSession kaSession, KtElement element) {
        List candidates = KaResolverKt.resolveToCallCandidates((KaResolver)((KaResolver)kaSession), (KtElement)element);
        return CollectionsKt.sortedWith((Iterable)candidates, (arg_0, arg_1) -> AbstractResolveCandidatesTest.collectCallCandidates$lambda$1((arg_0, arg_1) -> AbstractResolveCandidatesTest.collectCallCandidates$lambda$0(kaSession, arg_0, arg_1), arg_0, arg_1));
    }

    private static final Unit generateResolveOutput$lambda$0$0(KaSession $this_analyzeForTest, TestServices $testServices, List $candidates, List $candidatesAgain, AbstractResolveCandidatesTest this$0, KaCallInfo $callInfo) {
        TestUtilsKt.assertStableSymbolResult($this_analyzeForTest, $testServices, $candidates, $candidatesAgain);
        this$0.checkConsistencyWithResolveCall($this_analyzeForTest, $callInfo, $candidates, $testServices);
        return Unit.INSTANCE;
    }

    private static final CharSequence generateResolveOutput$lambda$0$1(KaSession $this_analyzeForTest, KaCallCandidateInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return TestUtilsKt.stringRepresentation($this_analyzeForTest, it);
    }

    private static final String generateResolveOutput$lambda$0(AbstractResolveCandidatesTest this$0, KtElement $mainElement, TestServices $testServices, KaSession $this$analyzeForTest) {
        Intrinsics.checkNotNullParameter((Object)$this$analyzeForTest, (String)"$this$analyzeForTest");
        List<KaCallCandidateInfo> candidates = this$0.collectCallCandidates($this$analyzeForTest, $mainElement);
        List<KaCallCandidateInfo> candidatesAgain = this$0.collectCallCandidates($this$analyzeForTest, $mainElement);
        KaCallInfo callInfo = $this$analyzeForTest.resolveToCall($mainElement);
        this$0.ignoreStabilityIfNeeded((Function0<Unit>)((Function0)() -> AbstractResolveCandidatesTest.generateResolveOutput$lambda$0$0($this$analyzeForTest, $testServices, candidates, candidatesAgain, this$0, callInfo)));
        return candidates.isEmpty() ? "NO_CANDIDATES" : CollectionsKt.joinToString$default((Iterable)candidates, (CharSequence)"\n\n", null, null, (int)0, null, arg_0 -> AbstractResolveCandidatesTest.generateResolveOutput$lambda$0$1($this$analyzeForTest, arg_0), (int)30, null);
    }

    private static final String checkConsistencyWithResolveCall$lambda$0(KaSession kaSession, KaCallableMemberCall $resolvedCall) {
        return "Inconsistency between candidates and resolved call. Resolved call is not null, but no candidates found.\n" + TestUtilsKt.stringRepresentation(kaSession, $resolvedCall);
    }

    private static final String checkConsistencyWithResolveCall$lambda$2(String $resolvedSymbol, List $candidatesRepresentation) {
        return '\'' + $resolvedSymbol + "' is not found in:\n" + CollectionsKt.joinToString$default((Iterable)$candidatesRepresentation, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    private static final int collectCallCandidates$lambda$0(KaSession kaSession, KaCallCandidateInfo candidate1, KaCallCandidateInfo candidate2) {
        return TestUtilsKt.compareCalls(kaSession, candidate1.getCandidate(), candidate2.getCandidate());
    }

    private static final int collectCallCandidates$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }
}

