/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.test.framework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.UtilsKt;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\b\u0010\r\u001a\u00020\nH\u0007R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00058DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/analysis/test/framework/TestWithDisposable;", "", "<init>", "()V", "_disposable", "Lcom/intellij/openapi/Disposable;", "disposable", "getDisposable", "()Lcom/intellij/openapi/Disposable;", "initDisposable", "", "testInfo", "Lorg/junit/jupiter/api/TestInfo;", "disposeDisposable", "analysis-test-framework_test"})
public abstract class TestWithDisposable {
    @Nullable
    private Disposable _disposable = Disposer.newDisposable((String)"Disposable for Analysis Api tests");

    @NotNull
    protected final Disposable getDisposable() {
        Disposable disposable = this._disposable;
        Intrinsics.checkNotNull((Object)disposable);
        return disposable;
    }

    @BeforeEach
    public final void initDisposable(@NotNull TestInfo testInfo) {
        Intrinsics.checkNotNullParameter((Object)testInfo, (String)"testInfo");
        this._disposable = Disposer.newDisposable((String)("disposable for " + testInfo.getDisplayName()));
    }

    @AfterEach
    public final void disposeDisposable() {
        Disposable disposable = this._disposable;
        if (disposable != null) {
            Disposable it = disposable;
            boolean bl = false;
            UtilsKt.disposeRootInWriteAction((Disposable)it);
        }
        this._disposable = null;
    }
}

