/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir;

import com.intellij.testFramework.TestDataPath;
import java.io.File;
import java.util.regex.Pattern;
import org.jetbrains.kotlin.analysis.low.level.api.fir.AbstractSourceDeprecationsResolveTest;
import org.jetbrains.kotlin.test.TestMetadata;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

@TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolveDeprecation")
@TestDataPath(value="$PROJECT_ROOT")
public class SourceDeprecationsResolveTestGenerated
extends AbstractSourceDeprecationsResolveTest {
    @Test
    public void testAllFilesPresentInLazyResolveDeprecation() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolveDeprecation"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolveDeprecation/typeAliases")
    @TestDataPath(value="$PROJECT_ROOT")
    public class TypeAliases {
        @Test
        public void testAllFilesPresentInTypeAliases() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolveDeprecation/typeAliases"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="deprecated.kt")
        public void testDeprecated() {
            SourceDeprecationsResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/typeAliases/deprecated.kt");
        }

        @Test
        @TestMetadata(value="deprecatedJava.kt")
        public void testDeprecatedJava() {
            SourceDeprecationsResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/typeAliases/deprecatedJava.kt");
        }

        @Test
        @TestMetadata(value="noDeprecation.kt")
        public void testNoDeprecation() {
            SourceDeprecationsResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/typeAliases/noDeprecation.kt");
        }

        @Test
        @TestMetadata(value="randomAnnotation.kt")
        public void testRandomAnnotation() {
            SourceDeprecationsResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/typeAliases/randomAnnotation.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolveDeprecation/properties")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Properties {
        @Test
        public void testAllFilesPresentInProperties() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolveDeprecation/properties"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Nested
        @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolveDeprecation/properties/withAcessors")
        @TestDataPath(value="$PROJECT_ROOT")
        public class WithAcessors {
            @Test
            public void testAllFilesPresentInWithAcessors() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolveDeprecation/properties/withAcessors"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
            }

            @Test
            @TestMetadata(value="deprecatedFieldJava.kt")
            public void testDeprecatedFieldJava() {
                SourceDeprecationsResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/properties/withAcessors/deprecatedFieldJava.kt");
            }

            @Test
            @TestMetadata(value="deprecatedGetter.kt")
            public void testDeprecatedGetter() {
                SourceDeprecationsResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/properties/withAcessors/deprecatedGetter.kt");
            }

            @Test
            @TestMetadata(value="deprecatedGetterJava.kt")
            public void testDeprecatedGetterJava() {
                SourceDeprecationsResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/properties/withAcessors/deprecatedGetterJava.kt");
            }

            @Test
            @TestMetadata(value="deprecatedProperty.kt")
            public void testDeprecatedProperty() {
                SourceDeprecationsResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/properties/withAcessors/deprecatedProperty.kt");
            }

            @Test
            @TestMetadata(value="deprecatedPropertyJava.kt")
            public void testDeprecatedPropertyJava() {
                SourceDeprecationsResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/properties/withAcessors/deprecatedPropertyJava.kt");
            }

            @Test
            @TestMetadata(value="deprecatedSetter.kt")
            public void testDeprecatedSetter() {
                SourceDeprecationsResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/properties/withAcessors/deprecatedSetter.kt");
            }

            @Test
            @TestMetadata(value="deprecatedSetterJava.kt")
            public void testDeprecatedSetterJava() {
                SourceDeprecationsResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/properties/withAcessors/deprecatedSetterJava.kt");
            }

            @Test
            @TestMetadata(value="noAnnotations.kt")
            public void testNoAnnotations() {
                SourceDeprecationsResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/properties/withAcessors/noAnnotations.kt");
            }

            @Test
            @TestMetadata(value="randomAnnotationGetter.kt")
            public void testRandomAnnotationGetter() {
                SourceDeprecationsResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/properties/withAcessors/randomAnnotationGetter.kt");
            }

            @Test
            @TestMetadata(value="randomAnnotationProperty.kt")
            public void testRandomAnnotationProperty() {
                SourceDeprecationsResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/properties/withAcessors/randomAnnotationProperty.kt");
            }

            @Test
            @TestMetadata(value="randomAnnotationSetter.kt")
            public void testRandomAnnotationSetter() {
                SourceDeprecationsResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/properties/withAcessors/randomAnnotationSetter.kt");
            }
        }

        @Nested
        @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolveDeprecation/properties/noAcessors")
        @TestDataPath(value="$PROJECT_ROOT")
        public class NoAcessors {
            @Test
            public void testAllFilesPresentInNoAcessors() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolveDeprecation/properties/noAcessors"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
            }

            @Test
            @TestMetadata(value="deprecatedAnnotationPropertyNoAccessors.kt")
            public void testDeprecatedAnnotationPropertyNoAccessors() {
                SourceDeprecationsResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/properties/noAcessors/deprecatedAnnotationPropertyNoAccessors.kt");
            }

            @Test
            @TestMetadata(value="noDeprecatedAnnotationPropertyNoAccessors.kt")
            public void testNoDeprecatedAnnotationPropertyNoAccessors() {
                SourceDeprecationsResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/properties/noAcessors/noDeprecatedAnnotationPropertyNoAccessors.kt");
            }

            @Test
            @TestMetadata(value="randomAnnotationPropertyNoAccessors.kt")
            public void testRandomAnnotationPropertyNoAccessors() {
                SourceDeprecationsResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/properties/noAcessors/randomAnnotationPropertyNoAccessors.kt");
            }
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolveDeprecation/java")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Java {
        @Test
        public void testAllFilesPresentInJava() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolveDeprecation/java"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="javaClass.kt")
        public void testJavaClass() {
            SourceDeprecationsResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/java/javaClass.kt");
        }

        @Test
        @TestMetadata(value="javaClassNoComment.kt")
        public void testJavaClassNoComment() {
            SourceDeprecationsResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/java/javaClassNoComment.kt");
        }

        @Test
        @TestMetadata(value="javaField.kt")
        public void testJavaField() {
            SourceDeprecationsResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/java/javaField.kt");
        }

        @Test
        @TestMetadata(value="javaFieldNoComment.kt")
        public void testJavaFieldNoComment() {
            SourceDeprecationsResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/java/javaFieldNoComment.kt");
        }

        @Test
        @TestMetadata(value="javaMethod.kt")
        public void testJavaMethod() {
            SourceDeprecationsResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/java/javaMethod.kt");
        }

        @Test
        @TestMetadata(value="javaMethodNoComment.kt")
        public void testJavaMethodNoComment() {
            SourceDeprecationsResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/java/javaMethodNoComment.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolveDeprecation/functions")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Functions {
        @Test
        public void testAllFilesPresentInFunctions() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolveDeprecation/functions"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="deprecated.kt")
        public void testDeprecated() {
            SourceDeprecationsResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/functions/deprecated.kt");
        }

        @Test
        @TestMetadata(value="deprecatedJava.kt")
        public void testDeprecatedJava() {
            SourceDeprecationsResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/functions/deprecatedJava.kt");
        }

        @Test
        @TestMetadata(value="noDeprecation.kt")
        public void testNoDeprecation() {
            SourceDeprecationsResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/functions/noDeprecation.kt");
        }

        @Test
        @TestMetadata(value="randomAnnotation.kt")
        public void testRandomAnnotation() {
            SourceDeprecationsResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/functions/randomAnnotation.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolveDeprecation/classes")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Classes {
        @Test
        public void testAllFilesPresentInClasses() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolveDeprecation/classes"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="deprecated.kt")
        public void testDeprecated() {
            SourceDeprecationsResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/classes/deprecated.kt");
        }

        @Test
        @TestMetadata(value="deprecatedJava.kt")
        public void testDeprecatedJava() {
            SourceDeprecationsResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/classes/deprecatedJava.kt");
        }

        @Test
        @TestMetadata(value="noDeprecation.kt")
        public void testNoDeprecation() {
            SourceDeprecationsResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/classes/noDeprecation.kt");
        }

        @Test
        @TestMetadata(value="randomAnnotation.kt")
        public void testRandomAnnotation() {
            SourceDeprecationsResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveDeprecation/classes/randomAnnotation.kt");
        }
    }
}

