/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.standalone.fir.test.cases.session.builder;

import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.kotlin.analysis.api.standalone.fir.test.cases.session.builder.AbstractStandaloneSessionBuilderAgainstStdlibTest;
import org.jetbrains.kotlin.platform.CommonPlatforms;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.js.JsPlatforms;
import org.jetbrains.kotlin.platform.jvm.JvmPlatforms;
import org.jetbrains.kotlin.utils.PathUtil;
import org.junit.Test;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\b\u0010\u0006\u001a\u00020\u0005H\u0007J\b\u0010\u0007\u001a\u00020\u0005H\u0007J\b\u0010\b\u001a\u00020\u0005H\u0007\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/analysis/api/standalone/fir/test/cases/session/builder/StandaloneSessionBuilderAgainstStdlibTest;", "Lorg/jetbrains/kotlin/analysis/api/standalone/fir/test/cases/session/builder/AbstractStandaloneSessionBuilderAgainstStdlibTest;", "<init>", "()V", "testKotlinStdlibJvm", "", "testKotlinStdLibCommon", "testKotlinStdLibJs", "testKotlinStdLibJsWithInvalidKlib", "analysis-api-standalone_test"})
public final class StandaloneSessionBuilderAgainstStdlibTest
extends AbstractStandaloneSessionBuilderAgainstStdlibTest {
    @Test
    public final void testKotlinStdlibJvm() {
        AbstractStandaloneSessionBuilderAgainstStdlibTest abstractStandaloneSessionBuilderAgainstStdlibTest = this;
        TargetPlatform targetPlatform = JvmPlatforms.INSTANCE.getDefaultJvmPlatform();
        Path path = PathUtil.getKotlinPathsForDistDirectory().getStdlibPath().toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        AbstractStandaloneSessionBuilderAgainstStdlibTest.doTestKotlinStdLibResolve$default(abstractStandaloneSessionBuilderAgainstStdlibTest, targetPlatform, path, null, 4, null);
    }

    @Test
    public final void testKotlinStdLibCommon() {
        AbstractStandaloneSessionBuilderAgainstStdlibTest abstractStandaloneSessionBuilderAgainstStdlibTest = this;
        TargetPlatform targetPlatform = CommonPlatforms.INSTANCE.getDefaultCommonPlatform();
        Path path = Paths.get("dist/common/kotlin-stdlib-common.klib", new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        AbstractStandaloneSessionBuilderAgainstStdlibTest.doTestKotlinStdLibResolve$default(abstractStandaloneSessionBuilderAgainstStdlibTest, targetPlatform, path, null, 4, null);
    }

    @Test
    public final void testKotlinStdLibJs() {
        AbstractStandaloneSessionBuilderAgainstStdlibTest abstractStandaloneSessionBuilderAgainstStdlibTest = this;
        TargetPlatform targetPlatform = JsPlatforms.INSTANCE.getDefaultJsPlatform();
        Path path = PathUtil.getKotlinPathsForDistDirectory().getJsStdLibKlibPath().toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        AbstractStandaloneSessionBuilderAgainstStdlibTest.doTestKotlinStdLibResolve$default(abstractStandaloneSessionBuilderAgainstStdlibTest, targetPlatform, path, null, 4, null);
    }

    @Test
    public final void testKotlinStdLibJsWithInvalidKlib() {
        TargetPlatform targetPlatform = JsPlatforms.INSTANCE.getDefaultJsPlatform();
        Path path = PathUtil.getKotlinPathsForDistDirectory().getJsStdLibKlibPath().toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        Object[] objectArray = new Path[]{Paths.get(System.getProperty("java.home"), new String[0]), PathUtil.getKotlinPathsForDistDirectory().getStdlibPath().toPath()};
        this.doTestKotlinStdLibResolve(targetPlatform, path, CollectionsKt.listOf((Object[])objectArray));
    }
}

