/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.test.framework.base;

import com.intellij.mock.MockApplication;
import com.intellij.mock.MockProject;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.projectStructure.DanglingFilesKt;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaDanglingFileResolutionMode;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.analysis.api.standalone.base.projectStructure.AnalysisApiServiceRegistrar;
import org.jetbrains.kotlin.analysis.test.framework.AnalysisApiTestDirectives;
import org.jetbrains.kotlin.analysis.test.framework.TestWithDisposable;
import org.jetbrains.kotlin.analysis.test.framework.base.AbstractAnalysisApiBasedTest;
import org.jetbrains.kotlin.analysis.test.framework.base.RegisterBaseTestServicesKt;
import org.jetbrains.kotlin.analysis.test.framework.projectStructure.AnalysisApiKtTestModuleStructureProviderKt;
import org.jetbrains.kotlin.analysis.test.framework.projectStructure.KtTestModule;
import org.jetbrains.kotlin.analysis.test.framework.services.AnalysisApiEnvironmentManagerKt;
import org.jetbrains.kotlin.analysis.test.framework.services.ExpressionMarkerProvider;
import org.jetbrains.kotlin.analysis.test.framework.services.ExpressionMarkersSourceFilePreprocessorKt;
import org.jetbrains.kotlin.analysis.test.framework.services.libraries.TestModuleCompiler;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiMode;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiTestConfigurator;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiTestServiceRegistrarKt;
import org.jetbrains.kotlin.analysis.test.framework.utils.CommonTestUtilsKt;
import org.jetbrains.kotlin.analysis.test.framework.utils.SkipTestException;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPureElement;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.TestConfiguration;
import org.jetbrains.kotlin.test.backend.handlers.UpdateTestDataSupport;
import org.jetbrains.kotlin.test.builders.DefaultsProviderBuilder;
import org.jetbrains.kotlin.test.builders.TestConfigurationBuilder;
import org.jetbrains.kotlin.test.directives.JvmEnvironmentConfigurationDirectives;
import org.jetbrains.kotlin.test.directives.model.Directive;
import org.jetbrains.kotlin.test.directives.model.DirectiveKt;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectives;
import org.jetbrains.kotlin.test.directives.model.SimpleDirectivesContainer;
import org.jetbrains.kotlin.test.directives.model.StringDirective;
import org.jetbrains.kotlin.test.model.DependencyKind;
import org.jetbrains.kotlin.test.model.FrontendKind;
import org.jetbrains.kotlin.test.model.FrontendKinds;
import org.jetbrains.kotlin.test.model.ResultingArtifact;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.runners.AbstractKotlinCompilerTest;
import org.jetbrains.kotlin.test.services.ArtifactsProvider;
import org.jetbrains.kotlin.test.services.AssertionsService;
import org.jetbrains.kotlin.test.services.JUnit5Assertions;
import org.jetbrains.kotlin.test.services.KotlinTestInfo;
import org.jetbrains.kotlin.test.services.PreAnalysisHandler;
import org.jetbrains.kotlin.test.services.ServiceRegistrationData;
import org.jetbrains.kotlin.test.services.TemporaryDirectoryManager;
import org.jetbrains.kotlin.test.services.TemporaryDirectoryManagerKt;
import org.jetbrains.kotlin.test.services.TestModuleStructure;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestService;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.services.TestServicesKt;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.utils.FunctionsKt;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={UpdateTestDataSupport.class})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b'\u0018\u00002\u00020\u0001:\u0002vwB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000bH\u0014J\"\u0010\u0018\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000bH\u0014J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u000bH\u0014J\u0010\u0010&\u001a\u00020\u00122\u0006\u0010'\u001a\u00020(H\u0014J\u0010\u0010)\u001a\u00020*2\u0006\u0010\u0017\u001a\u00020\u000bH\u0004J\u0012\u0010+\u001a\u0004\u0018\u00010*2\u0006\u0010\u0017\u001a\u00020\u000bH\u0002J\u0012\u0010,\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u000bH\u0004J\u0018\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000bH\u0014J$\u00100\u001a\u0004\u0018\u00010\u00142\u0006\u0010/\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000b2\b\b\u0002\u00101\u001a\u00020.H\u0004J \u00107\u001a\u00020.2\u0006\u00108\u001a\u00020\u00142\u0006\u0010/\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000bH\u0014J:\u00109\u001a\u00020\u0012*\u00020:2\u0006\u0010;\u001a\u0002032\b\b\u0002\u0010<\u001a\u0002032\n\b\u0002\u0010=\u001a\u0004\u0018\u0001032\u000e\b\u0002\u0010>\u001a\b\u0012\u0004\u0012\u0002030\tH\u0004J.\u0010?\u001a\u00020\u001d2\b\b\u0002\u0010<\u001a\u0002032\n\b\u0002\u0010=\u001a\u0004\u0018\u0001032\u000e\b\u0002\u0010>\u001a\b\u0012\u0004\u0012\u0002030\tH\u0004J\u001a\u0010@\u001a\u00020\u001d2\u0006\u0010<\u001a\u0002032\b\u0010=\u001a\u0004\u0018\u000103H\u0002J$\u0010A\u001a\u0004\u0018\u00010\u001d2\u0006\u0010<\u001a\u0002032\b\u0010=\u001a\u0004\u0018\u0001032\u0006\u0010B\u001a\u000203H\u0002J$\u0010C\u001a\u00020\u001d2\u0006\u0010<\u001a\u0002032\b\u0010=\u001a\u0004\u0018\u0001032\b\u0010B\u001a\u0004\u0018\u000103H\u0002J\u0010\u0010H\u001a\u00020\u00122\u0006\u0010I\u001a\u000203H\u0004J$\u0010H\u001a\u00020\u00122\u0006\u0010I\u001a\u0002032\u0012\u0010J\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00120EH\u0004J\b\u0010K\u001a\u00020\u0012H\u0007J\b\u0010L\u001a\u00020MH\u0002J\u0010\u0010N\u001a\u00020\u00122\u0006\u0010O\u001a\u00020MH\u0002J\u0010\u0010P\u001a\u00020\u00122\u0006\u0010O\u001a\u00020MH\u0002J\b\u0010Q\u001a\u00020.H\u0002J\b\u0010R\u001a\u00020.H\u0002J\b\u0010S\u001a\u00020.H\u0002J\b\u0010T\u001a\u00020.H\u0002J5\u0010U\u001a\u0004\u0018\u0001HV\"\b\b\u0000\u0010V*\u00020W*\u00020X2\u0006\u0010Y\u001a\u0002HV2\u0006\u0010Z\u001a\u0002HV2\u0006\u0010[\u001a\u0002HVH\u0004\u00a2\u0006\u0002\u0010\\JN\u0010]\u001a\u0002H^\"\b\b\u0000\u0010_*\u00020`\"\u0004\b\u0001\u0010^2\u0006\u0010a\u001a\u0002H_2\b\b\u0002\u0010b\u001a\u00020c2\u001d\u0010d\u001a\u0019\u0012\u0004\u0012\u00020f\u0012\u0004\u0012\u0002H_\u0012\u0004\u0012\u0002H^0e\u00a2\u0006\u0002\bFH\u0004\u00a2\u0006\u0002\u0010gJ'\u0010h\u001a\u0002H_\"\b\b\u0000\u0010_*\u00020`2\u0006\u0010i\u001a\u0002H_2\u0006\u0010j\u001a\u00020\u0014H\u0004\u00a2\u0006\u0002\u0010kJ4\u0010l\u001a\u0002H^\"\u0004\b\u0000\u0010^2\u0006\u0010a\u001a\u00020`2\u0017\u0010d\u001a\u0013\u0012\u0004\u0012\u00020f\u0012\u0004\u0012\u0002H^0E\u00a2\u0006\u0002\bFH\u0004\u00a2\u0006\u0002\u0010mJ\u0010\u0010n\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020oH\u0007J4\u0010p\u001a\u00020\u0012*\u00020X2\u0006\u0010q\u001a\u00020r2\u0012\u0010s\u001a\u000e\u0012\u0004\u0012\u00020t\u0012\u0004\u0012\u00020.0E2\f\u0010d\u001a\b\u0012\u0004\u0012\u00020\u00120uR\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R \u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\rR\u000e\u0010\u001a\u001a\u00020\u001bX\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001d@BX\u0084.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0010\u0010!\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000b8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u0018\u00102\u001a\u000203*\u0002048DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u00106R%\u0010D\u001a\u0013\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\u00120E\u00a2\u0006\u0002\bFX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\bG\u0010\u0003\u00a8\u0006x"}, d2={"Lorg/jetbrains/kotlin/analysis/test/framework/base/AbstractAnalysisApiBasedTest;", "Lorg/jetbrains/kotlin/analysis/test/framework/TestWithDisposable;", "<init>", "()V", "configurator", "Lorg/jetbrains/kotlin/analysis/test/framework/test/configurators/AnalysisApiTestConfigurator;", "getConfigurator", "()Lorg/jetbrains/kotlin/analysis/test/framework/test/configurators/AnalysisApiTestConfigurator;", "additionalServiceRegistrars", "", "Lorg/jetbrains/kotlin/analysis/api/standalone/base/projectStructure/AnalysisApiServiceRegistrar;", "Lorg/jetbrains/kotlin/test/services/TestServices;", "getAdditionalServiceRegistrars", "()Ljava/util/List;", "additionalDirectives", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getAdditionalDirectives", "doTestByMainFile", "", "mainFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "mainModule", "Lorg/jetbrains/kotlin/analysis/test/framework/projectStructure/KtTestModule;", "testServices", "doTestByMainModuleAndOptionalMainFile", "doTest", "testInfo", "Lorg/jetbrains/kotlin/test/services/KotlinTestInfo;", "value", "Ljava/nio/file/Path;", "testDataPath", "getTestDataPath", "()Ljava/nio/file/Path;", "_testServices", "getTestServices", "()Lorg/jetbrains/kotlin/test/services/TestServices;", "setTestServices", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "configureTest", "builder", "Lorg/jetbrains/kotlin/test/builders/TestConfigurationBuilder;", "findMainFileAndModule", "Lorg/jetbrains/kotlin/analysis/test/framework/base/AbstractAnalysisApiBasedTest$ModuleWithMainFile;", "findMainFileByMarkers", "findMainModule", "isMainModule", "", "ktTestModule", "findMainFile", "acceptSingleFileWithoutAdditionalChecks", "mainFileName", "", "Lorg/jetbrains/kotlin/test/model/TestModule;", "getMainFileName", "(Lorg/jetbrains/kotlin/test/model/TestModule;)Ljava/lang/String;", "isMainFile", "file", "assertEqualsToTestOutputFile", "Lorg/jetbrains/kotlin/test/services/AssertionsService;", "actual", "extension", "subdirectoryName", "testPrefixes", "getTestOutputFile", "getDefaultTestOutputFile", "findPrefixedTestOutputFile", "testPrefix", "buildTestOutputFilePath", "configure", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "getConfigure$annotations", "runTest", "path", "block", "cleanupTemporaryDirectories", "createTestConfiguration", "Lorg/jetbrains/kotlin/test/TestConfiguration;", "createAndRegisterTestModuleStructure", "testConfiguration", "prepareToTheAnalysis", "isDependentModeDisabledForTheTest", "isFe10DisabledForTheTest", "isFirDisabledForTheTest", "isStandaloneDisabledForTheTest", "findSpecificDirective", "T", "Lorg/jetbrains/kotlin/test/directives/model/Directive;", "Lorg/jetbrains/kotlin/test/directives/model/RegisteredDirectives;", "commonDirective", "k1Directive", "k2Directive", "(Lorg/jetbrains/kotlin/test/directives/model/RegisteredDirectives;Lorg/jetbrains/kotlin/test/directives/model/Directive;Lorg/jetbrains/kotlin/test/directives/model/Directive;Lorg/jetbrains/kotlin/test/directives/model/Directive;)Lorg/jetbrains/kotlin/test/directives/model/Directive;", "copyAwareAnalyzeForTest", "R", "E", "Lorg/jetbrains/kotlin/psi/KtElement;", "contextElement", "danglingFileResolutionMode", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaDanglingFileResolutionMode;", "action", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "(Lorg/jetbrains/kotlin/psi/KtElement;Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaDanglingFileResolutionMode;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "getDependentElementFromFile", "originalElement", "contextFile", "(Lorg/jetbrains/kotlin/psi/KtElement;Lorg/jetbrains/kotlin/psi/KtFile;)Lorg/jetbrains/kotlin/psi/KtElement;", "analyzeForTest", "(Lorg/jetbrains/kotlin/psi/KtElement;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "initTestInfo", "Lorg/junit/jupiter/api/TestInfo;", "suppressIf", "suppressionDirective", "Lorg/jetbrains/kotlin/test/directives/model/StringDirective;", "filter", "", "Lkotlin/Function0;", "AdditionalServiceRegistrarsPreAnalysisHandler", "ModuleWithMainFile", "analysis-test-framework_test"})
@SourceDebugExtension(value={"SMAP\nAbstractAnalysisApiBasedTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractAnalysisApiBasedTest.kt\norg/jetbrains/kotlin/analysis/test/framework/base/AbstractAnalysisApiBasedTest\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 TestConfigurationBuilder.kt\norg/jetbrains/kotlin/test/builders/TestConfigurationBuilderKt\n+ 7 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 8 KaSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KaSessionProvider\n+ 9 TestConfigurationBuilder.kt\norg/jetbrains/kotlin/test/builders/TestConfigurationBuilder\n+ 10 TestServices.kt\norg/jetbrains/kotlin/test/services/TestServicesKt\n*L\n1#1,578:1\n195#2:579\n195#2:580\n37#3,2:581\n37#3,2:648\n1#4:583\n1#4:594\n1#4:599\n1617#5,9:584\n1869#5:593\n1870#5:595\n1626#5:596\n1625#5:597\n1869#5:598\n1870#5:600\n1626#5:601\n1869#5,2:603\n1869#5,2:605\n1869#5,2:607\n324#6:602\n65#7,2:609\n30#7,2:611\n30#7,2:628\n36#8,15:613\n36#8,15:630\n61#9:645\n62#9:647\n61#9:650\n62#9:652\n31#10:646\n31#10:651\n*S KotlinDebug\n*F\n+ 1 AbstractAnalysisApiBasedTest.kt\norg/jetbrains/kotlin/analysis/test/framework/base/AbstractAnalysisApiBasedTest\n*L\n196#1:579\n200#1:580\n201#1:581,2\n385#1:648,2\n234#1:594\n312#1:599\n234#1:584,9\n234#1:593\n234#1:595\n234#1:596\n312#1:597\n312#1:598\n312#1:600\n312#1:601\n461#1:603,2\n462#1:605,2\n464#1:607,2\n442#1:602\n508#1:609,2\n516#1:611,2\n546#1:628,2\n516#1:613,15\n546#1:630,15\n383#1:645\n383#1:647\n390#1:650\n390#1:652\n383#1:646\n390#1:651\n*E\n"})
public abstract class AbstractAnalysisApiBasedTest
extends TestWithDisposable {
    private KotlinTestInfo testInfo;
    private Path testDataPath;
    @Nullable
    private TestServices _testServices;
    @NotNull
    private final Function1<TestConfigurationBuilder, Unit> configure = arg_0 -> AbstractAnalysisApiBasedTest.configure$lambda$0(this, arg_0);

    @NotNull
    public abstract AnalysisApiTestConfigurator getConfigurator();

    @NotNull
    public List<AnalysisApiServiceRegistrar<TestServices>> getAdditionalServiceRegistrars() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    public List<DirectivesContainer> getAdditionalDirectives() {
        return CollectionsKt.emptyList();
    }

    protected void doTestByMainFile(@NotNull KtFile mainFile, @NotNull KtTestModule mainModule, @NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)mainFile, (String)"mainFile");
        Intrinsics.checkNotNullParameter((Object)mainModule, (String)"mainModule");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        throw new UnsupportedOperationException("The test case is not fully implemented. 'doTestByMainFile', 'doTestByMainModuleAndOptionalMainFile' or 'doTest' should be overridden");
    }

    protected void doTestByMainModuleAndOptionalMainFile(@Nullable KtFile mainFile, @NotNull KtTestModule mainModule, @NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)mainModule, (String)"mainModule");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        KtFile ktFile = mainFile;
        if (ktFile == null) {
            throw new IllegalStateException("The main file is not found".toString());
        }
        this.doTestByMainFile(ktFile, mainModule, testServices);
    }

    protected void doTest(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        ModuleWithMainFile moduleWithMainFile = this.findMainFileAndModule(testServices);
        KtFile mainFile = moduleWithMainFile.component1();
        KtTestModule mainModule = moduleWithMainFile.component2();
        this.doTestByMainModuleAndOptionalMainFile(mainFile, mainModule, testServices);
    }

    @NotNull
    protected final Path getTestDataPath() {
        Path path = this.testDataPath;
        if (path != null) {
            return path;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"testDataPath");
        return null;
    }

    private final TestServices getTestServices() {
        TestServices testServices = this._testServices;
        if (testServices == null) {
            throw new IllegalStateException("`_testServices` has not been initialized".toString());
        }
        return testServices;
    }

    private final void setTestServices(TestServices value) {
        this._testServices = value;
    }

    protected void configureTest(@NotNull TestConfigurationBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.getConfigurator().configureTest(builder, this.getDisposable());
        Collection $this$ifNotEmpty$iv = this.getAdditionalServiceRegistrars();
        boolean $i$f$ifNotEmpty = false;
        if (!$this$ifNotEmpty$iv.isEmpty()) {
            List $this$configureTest_u24lambda_u240 = (List)$this$ifNotEmpty$iv;
            boolean bl = false;
            Function1[] function1Array = new Function1[]{FunctionsKt.bind((Function2)configureTest.1.1.INSTANCE, (Object)$this$configureTest_u24lambda_u240)};
            builder.usePreAnalysisHandlers(function1Array);
        }
        $this$ifNotEmpty$iv = this.getAdditionalDirectives();
        $i$f$ifNotEmpty = false;
        if (!$this$ifNotEmpty$iv.isEmpty()) {
            List $this$configureTest_u24lambda_u241 = (List)$this$ifNotEmpty$iv;
            boolean bl = false;
            Collection $this$toTypedArray$iv = $this$configureTest_u24lambda_u241;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            DirectivesContainer[] directivesContainerArray = thisCollection$iv.toArray(new DirectivesContainer[0]);
            builder.useDirectives(Arrays.copyOf(directivesContainerArray, directivesContainerArray.length));
        }
    }

    @NotNull
    protected final ModuleWithMainFile findMainFileAndModule(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        ModuleWithMainFile moduleWithMainFile = this.findMainFileByMarkers(testServices);
        if (moduleWithMainFile != null) {
            ModuleWithMainFile it = moduleWithMainFile;
            boolean bl = false;
            return it;
        }
        KtTestModule ktTestModule = this.findMainModule(testServices);
        if (ktTestModule == null) {
            throw new IllegalStateException("Cannot find the main test module".toString());
        }
        KtTestModule mainModule = ktTestModule;
        KtFile mainFile = AbstractAnalysisApiBasedTest.findMainFile$default(this, mainModule, testServices, false, 4, null);
        return new ModuleWithMainFile(mainFile, mainModule);
    }

    /*
     * WARNING - void declaration
     */
    private final ModuleWithMainFile findMainFileByMarkers(TestServices testServices) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = AnalysisApiKtTestModuleStructureProviderKt.getKtTestModuleStructure(testServices).getMainModules();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ModuleWithMainFile moduleWithMainFile;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            KtTestModule module = (KtTestModule)element$iv$iv;
            boolean bl2 = false;
            if (this.findMainFile(module, testServices, false) != null) {
                KtFile mainFile;
                boolean bl3 = false;
                moduleWithMainFile = new ModuleWithMainFile(mainFile, module);
            } else {
                moduleWithMainFile = null;
            }
            if (moduleWithMainFile == null) continue;
            ModuleWithMainFile it$iv$iv = moduleWithMainFile;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (ModuleWithMainFile)CollectionsKt.singleOrNull((List)((List)destination$iv$iv));
    }

    @Nullable
    protected final KtTestModule findMainModule(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        List<KtTestModule> modules = AnalysisApiKtTestModuleStructureProviderKt.getKtTestModuleStructure(testServices).getMainModules();
        KtTestModule ktTestModule = (KtTestModule)CollectionsKt.singleOrNull(modules);
        if (ktTestModule != null) {
            KtTestModule it = ktTestModule;
            boolean bl = false;
            return it;
        }
        return (KtTestModule)CommonTestUtilsKt.singleOrZeroValue((Collection)modules, arg_0 -> AbstractAnalysisApiBasedTest.findMainModule$lambda$1(this, testServices, arg_0), AbstractAnalysisApiBasedTest::findMainModule$lambda$2);
    }

    protected boolean isMainModule(@NotNull KtTestModule ktTestModule, @NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)ktTestModule, (String)"ktTestModule");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        return ktTestModule.getTestModule().getDirectives().contains((Directive)AnalysisApiTestDirectives.INSTANCE.getMAIN_MODULE()) || Intrinsics.areEqual((Object)StringsKt.substringBefore$default((String)ktTestModule.getTestModule().getName(), (char)'-', null, (int)2, null), (Object)"main");
    }

    @Nullable
    protected final KtFile findMainFile(@NotNull KtTestModule ktTestModule, @NotNull TestServices testServices, boolean acceptSingleFileWithoutAdditionalChecks) {
        KtFile ktFile;
        Intrinsics.checkNotNullParameter((Object)ktTestModule, (String)"ktTestModule");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        List<KtFile> ktFiles = ktTestModule.getKtFiles();
        if (acceptSingleFileWithoutAdditionalChecks && (ktFile = (KtFile)CollectionsKt.singleOrNull(ktFiles)) != null) {
            KtFile it = ktFile;
            boolean bl = false;
            return it;
        }
        return (KtFile)CommonTestUtilsKt.singleOrZeroValue((Collection)ktFiles, arg_0 -> AbstractAnalysisApiBasedTest.findMainFile$lambda$1(this, ktTestModule, testServices, arg_0), AbstractAnalysisApiBasedTest::findMainFile$lambda$2);
    }

    public static /* synthetic */ KtFile findMainFile$default(AbstractAnalysisApiBasedTest abstractAnalysisApiBasedTest, KtTestModule ktTestModule, TestServices testServices, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findMainFile");
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return abstractAnalysisApiBasedTest.findMainFile(ktTestModule, testServices, bl);
    }

    @NotNull
    protected final String getMainFileName(@NotNull TestModule $this$mainFileName) {
        Intrinsics.checkNotNullParameter((Object)$this$mainFileName, (String)"<this>");
        String string = DirectiveKt.singleOrZeroValue((RegisteredDirectives)$this$mainFileName.getDirectives(), (StringDirective)AnalysisApiTestDirectives.INSTANCE.getMAIN_FILE_NAME());
        if (string == null) {
            string = "main";
        }
        return string;
    }

    protected boolean isMainFile(@NotNull KtFile file, @NotNull KtTestModule ktTestModule, @NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)ktTestModule, (String)"ktTestModule");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        ExpressionMarkerProvider expressionMarkerProvider = ExpressionMarkersSourceFilePreprocessorKt.getExpressionMarkerProvider(testServices);
        return ExpressionMarkerProvider.getCaretOrNull$default(expressionMarkerProvider, (PsiFile)file, null, 2, null) != null || ExpressionMarkerProvider.getSelectionOrNull$default(expressionMarkerProvider, (PsiFile)file, null, 2, null) != null || Intrinsics.areEqual((Object)file.getVirtualFile().getNameWithoutExtension(), (Object)this.getMainFileName(ktTestModule.getTestModule()));
    }

    /*
     * WARNING - void declaration
     */
    protected final void assertEqualsToTestOutputFile(@NotNull AssertionsService $this$assertEqualsToTestOutputFile, @NotNull String actual2, @NotNull String extension, @Nullable String subdirectoryName, @NotNull List<String> testPrefixes) {
        void $this$mapNotNullTo$iv;
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$assertEqualsToTestOutputFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)actual2, (String)"actual");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        Intrinsics.checkNotNullParameter(testPrefixes, (String)"testPrefixes");
        List $this$assertEqualsToTestOutputFile_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        Iterable iterable = testPrefixes;
        Collection destination$iv = $this$assertEqualsToTestOutputFile_u24lambda_u240;
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            Path it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl2 = false;
            String it = (String)element$iv;
            boolean bl3 = false;
            if (this.findPrefixedTestOutputFile(extension, subdirectoryName, it) == null) continue;
            boolean bl4 = false;
            destination$iv.add(it$iv);
        }
        $this$assertEqualsToTestOutputFile_u24lambda_u240.add(this.getDefaultTestOutputFile(extension, subdirectoryName));
        List expectedFiles = CollectionsKt.build((List)list);
        Path mainExpectedFile = (Path)CollectionsKt.first((List)expectedFiles);
        List otherExpectedFiles = CollectionsKt.drop((Iterable)expectedFiles, (int)1);
        Assertions.assertEqualsToFile$default((Assertions)((Assertions)$this$assertEqualsToTestOutputFile), (Path)mainExpectedFile, (String)actual2, null, (int)4, null);
        for (Path otherExpectedFile : otherExpectedFiles) {
            Assertions assertions = (Assertions)$this$assertEqualsToTestOutputFile;
            File file = otherExpectedFile.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            if (Assertions.doesEqualToFile$default((Assertions)assertions, (File)file, (String)actual2, null, (int)4, null)) {
                throw new AssertionError((Object)("" + '\"' + mainExpectedFile + "\" has the same content as \"" + otherExpectedFile + "\". Delete the prefixed file."));
            }
        }
    }

    public static /* synthetic */ void assertEqualsToTestOutputFile$default(AbstractAnalysisApiBasedTest abstractAnalysisApiBasedTest, AssertionsService assertionsService, String string, String string2, String string3, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: assertEqualsToTestOutputFile");
        }
        if ((n & 2) != 0) {
            string2 = ".txt";
        }
        if ((n & 4) != 0) {
            string3 = null;
        }
        if ((n & 8) != 0) {
            list = abstractAnalysisApiBasedTest.getConfigurator().getTestPrefixes();
        }
        abstractAnalysisApiBasedTest.assertEqualsToTestOutputFile(assertionsService, string, string2, string3, list);
    }

    @NotNull
    protected final Path getTestOutputFile(@NotNull String extension, @Nullable String subdirectoryName, @NotNull List<String> testPrefixes) {
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        Intrinsics.checkNotNullParameter(testPrefixes, (String)"testPrefixes");
        for (String testPrefix : testPrefixes) {
            Path path = this.findPrefixedTestOutputFile(extension, subdirectoryName, testPrefix);
            if (path == null) continue;
            Path it = path;
            boolean bl = false;
            return it;
        }
        return this.getDefaultTestOutputFile(extension, subdirectoryName);
    }

    public static /* synthetic */ Path getTestOutputFile$default(AbstractAnalysisApiBasedTest abstractAnalysisApiBasedTest, String string, String string2, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getTestOutputFile");
        }
        if ((n & 1) != 0) {
            string = "txt";
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            list = abstractAnalysisApiBasedTest.getConfigurator().getTestPrefixes();
        }
        return abstractAnalysisApiBasedTest.getTestOutputFile(string, string2, list);
    }

    private final Path getDefaultTestOutputFile(String extension, String subdirectoryName) {
        return this.buildTestOutputFilePath(extension, subdirectoryName, null);
    }

    private final Path findPrefixedTestOutputFile(String extension, String subdirectoryName, String testPrefix) {
        Path path;
        Path it = path = this.buildTestOutputFilePath(extension, subdirectoryName, testPrefix);
        boolean bl = false;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.exists(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? path : null;
    }

    private final Path buildTestOutputFilePath(String extension, String subdirectoryName, String testPrefix) {
        Object object;
        String baseName;
        String extensionWithDot;
        block3: {
            block2: {
                extensionWithDot = '.' + StringsKt.removePrefix((String)extension, (CharSequence)".");
                baseName = PathsKt.getNameWithoutExtension((Path)this.getTestDataPath());
                object = subdirectoryName;
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                Path path = this.getTestDataPath().resolveSibling(it);
                object = path;
                if (path != null) break block3;
            }
            object = this.getTestDataPath().getParent();
        }
        Object directoryPath = object;
        String relativePath = testPrefix != null ? baseName + '.' + testPrefix + extensionWithDot : baseName + extensionWithDot;
        Path path = directoryPath.resolve(relativePath);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    private static /* synthetic */ void getConfigure$annotations() {
    }

    protected final void runTest(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.runTest(path, (Function1<? super TestServices, Unit>)((Function1)arg_0 -> AbstractAnalysisApiBasedTest.runTest$lambda$0(this, arg_0)));
    }

    protected final void runTest(@NotNull String path, @NotNull Function1<? super TestServices, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        AnalysisApiTestConfigurator analysisApiTestConfigurator = this.getConfigurator();
        Path path2 = Paths.get(path, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        this.testDataPath = analysisApiTestConfigurator.computeTestDataPath(path2);
        TestConfiguration testConfiguration = this.createTestConfiguration();
        this.setTestServices(testConfiguration.getTestServices());
        this.createAndRegisterTestModuleStructure(testConfiguration);
        if (this.getConfigurator().getAnalyseInDependentSession() && this.isDependentModeDisabledForTheTest()) {
            return;
        }
        if (this.getConfigurator().getFrontendKind() == org.jetbrains.kotlin.analysis.test.framework.test.configurators.FrontendKind.Fe10 && this.isFe10DisabledForTheTest() || this.getConfigurator().getFrontendKind() == org.jetbrains.kotlin.analysis.test.framework.test.configurators.FrontendKind.Fir && this.isFirDisabledForTheTest() || this.getConfigurator().getAnalysisApiMode() == AnalysisApiMode.Standalone && this.isStandaloneDisabledForTheTest()) {
            return;
        }
        try {
            this.prepareToTheAnalysis(testConfiguration);
        }
        catch (SkipTestException skipTestException) {
            return;
        }
        block.invoke((Object)this.getTestServices());
    }

    @AfterEach
    public final void cleanupTemporaryDirectories() {
        try {
            TestServices testServices = this._testServices;
            if (testServices != null && (testServices = TemporaryDirectoryManagerKt.getTemporaryDirectoryManager((TestServices)testServices)) != null) {
                testServices.cleanupTemporaryDirectories();
            }
        }
        catch (IOException e) {
            System.out.println((Object)("Failed to clean temporary directories: " + e.getMessage() + '\n' + e.getStackTrace()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final TestConfiguration createTestConfiguration() {
        void testDataPath$iv;
        String string = ((Object)this.getTestDataPath()).toString();
        Function1<TestConfigurationBuilder, Unit> init$iv = this.configure;
        boolean $i$f$testConfiguration = false;
        TestConfigurationBuilder testConfigurationBuilder = new TestConfigurationBuilder();
        init$iv.invoke((Object)testConfigurationBuilder);
        TestConfiguration testConfiguration = testConfigurationBuilder.build((String)testDataPath$iv);
        Disposer.register((Disposable)this.getDisposable(), (Disposable)testConfiguration.getRootDisposable());
        return testConfiguration;
    }

    private final void createAndRegisterTestModuleStructure(TestConfiguration testConfiguration) {
        TestModuleStructure moduleStructure = testConfiguration.getModuleStructureExtractor().splitTestDataByModules(((Object)this.getTestDataPath()).toString(), testConfiguration.getDirectives());
        this.getTestServices().register(Reflection.getOrCreateKotlinClass(TestModuleStructure.class), (TestService)moduleStructure);
    }

    private final void prepareToTheAnalysis(TestConfiguration testConfiguration) {
        PreAnalysisHandler preprocessor;
        TestModuleStructure moduleStructure = TestModuleStructureKt.getModuleStructure((TestServices)this.getTestServices());
        ArtifactsProvider artifactsProvider = new ArtifactsProvider(this.getTestServices(), moduleStructure.getModules());
        TestServicesKt.registerArtifactsProvider((TestServices)this.getTestServices(), (ArtifactsProvider)artifactsProvider);
        Iterable $this$forEach$iv = testConfiguration.getPreAnalysisHandlers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            preprocessor = (PreAnalysisHandler)element$iv;
            boolean bl = false;
            preprocessor.preprocessModuleStructure(moduleStructure);
        }
        $this$forEach$iv = testConfiguration.getPreAnalysisHandlers();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            preprocessor = (PreAnalysisHandler)element$iv;
            boolean bl = false;
            preprocessor.prepareSealedClassInheritors(moduleStructure);
        }
        $this$forEach$iv = AnalysisApiKtTestModuleStructureProviderKt.getKtTestModuleStructure(this.getTestServices()).getMainModules();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtTestModule ktTestModule = (KtTestModule)element$iv;
            boolean bl = false;
            this.getConfigurator().prepareFilesInModule(ktTestModule, this.getTestServices());
        }
    }

    private final boolean isDependentModeDisabledForTheTest() {
        return TestModuleStructureKt.getModuleStructure((TestServices)this.getTestServices()).getAllDirectives().contains((Directive)AnalysisApiTestDirectives.INSTANCE.getDISABLE_DEPENDED_MODE());
    }

    private final boolean isFe10DisabledForTheTest() {
        return TestModuleStructureKt.getModuleStructure((TestServices)this.getTestServices()).getAllDirectives().contains((Directive)AnalysisApiTestDirectives.INSTANCE.getIGNORE_FE10());
    }

    private final boolean isFirDisabledForTheTest() {
        return TestModuleStructureKt.getModuleStructure((TestServices)this.getTestServices()).getAllDirectives().contains((Directive)AnalysisApiTestDirectives.INSTANCE.getIGNORE_FIR());
    }

    private final boolean isStandaloneDisabledForTheTest() {
        return TestModuleStructureKt.getModuleStructure((TestServices)this.getTestServices()).getAllDirectives().contains((Directive)AnalysisApiTestDirectives.INSTANCE.getIGNORE_STANDALONE());
    }

    @Nullable
    protected final <T extends Directive> T findSpecificDirective(@NotNull RegisteredDirectives $this$findSpecificDirective, @NotNull T commonDirective, @NotNull T k1Directive, @NotNull T k2Directive) {
        T t;
        Intrinsics.checkNotNullParameter((Object)$this$findSpecificDirective, (String)"<this>");
        Intrinsics.checkNotNullParameter(commonDirective, (String)"commonDirective");
        Intrinsics.checkNotNullParameter(k1Directive, (String)"k1Directive");
        Intrinsics.checkNotNullParameter(k2Directive, (String)"k2Directive");
        T it = t = commonDirective;
        boolean bl = false;
        Object object = $this$findSpecificDirective.contains(it) ? t : null;
        if (object == null) {
            T t2;
            T it2 = t2 = k1Directive;
            boolean bl2 = false;
            object = this.getConfigurator().getFrontendKind() == org.jetbrains.kotlin.analysis.test.framework.test.configurators.FrontendKind.Fe10 && $this$findSpecificDirective.contains(it2) ? t2 : null;
            if (object == null) {
                it2 = t2 = k2Directive;
                boolean bl3 = false;
                object = this.getConfigurator().getFrontendKind() == org.jetbrains.kotlin.analysis.test.framework.test.configurators.FrontendKind.Fir && $this$findSpecificDirective.contains(it2) ? t2 : null;
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected final <E extends KtElement, R> R copyAwareAnalyzeForTest(@NotNull E contextElement, @NotNull KaDanglingFileResolutionMode danglingFileResolutionMode, @NotNull Function2<? super KaSession, ? super E, ? extends R> action) {
        Object object;
        Intrinsics.checkNotNullParameter(contextElement, (String)"contextElement");
        Intrinsics.checkNotNullParameter((Object)danglingFileResolutionMode, (String)"danglingFileResolutionMode");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        if (this.getConfigurator().getAnalyseInDependentSession()) {
            void useSiteElement$iv2;
            KtFile ktFile = ((KtPureElement)contextElement).getContainingKtFile();
            Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"getContainingKtFile(...)");
            KtFile originalContainingFile = ktFile;
            PsiElement psiElement = originalContainingFile.copy();
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
            KtFile fileCopy = (KtFile)psiElement;
            KtElement ktElement = (KtElement)fileCopy;
            KaDanglingFileResolutionMode resolutionMode$iv = danglingFileResolutionMode;
            boolean $i$f$analyzeCopy = false;
            KtFile ktFile2 = useSiteElement$iv2.getContainingKtFile();
            Intrinsics.checkNotNullExpressionValue((Object)ktFile2, (String)"getContainingKtFile(...)");
            KtFile containingFile$iv = ktFile2;
            object = DanglingFilesKt.withDanglingFileResolutionMode((KtFile)containingFile$iv, (KaDanglingFileResolutionMode)resolutionMode$iv, (Function0)new Function0<R>(containingFile$iv, fileCopy, originalContainingFile, action, this, contextElement){
                final /* synthetic */ KtFile $containingFile;
                final /* synthetic */ KtFile $fileCopy$inlined;
                final /* synthetic */ KtFile $originalContainingFile$inlined;
                final /* synthetic */ Function2 $action$inlined;
                final /* synthetic */ AbstractAnalysisApiBasedTest this$0;
                final /* synthetic */ KtElement $contextElement$inlined;
                {
                    this.$containingFile = $containingFile;
                    this.$fileCopy$inlined = ktFile;
                    this.$originalContainingFile$inlined = ktFile2;
                    this.$action$inlined = function2;
                    this.this$0 = abstractAnalysisApiBasedTest;
                    this.$contextElement$inlined = ktElement;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 */
                public final R invoke() {
                    Object object;
                    void this_$iv$iv;
                    KtElement useSiteElement$iv = (KtElement)this.$containingFile;
                    boolean $i$f$analyze = false;
                    Project project = useSiteElement$iv.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(project);
                    KtElement useSiteElement$iv$iv = useSiteElement$iv;
                    boolean $i$f$analyze2 = false;
                    KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession(useSiteElement$iv$iv);
                    this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
                    try {
                        Object object2;
                        Object lock$iv$iv;
                        Object object3 = lock$iv$iv = new Object();
                        synchronized (object3) {
                            boolean bl = false;
                            KaSession $this$copyAwareAnalyzeForTest_u24lambda_u240 = analysisSession$iv$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)this.$fileCopy$inlined.getOriginalFile(), (Object)this.$originalContainingFile$inlined)) {
                                boolean bl3 = false;
                                String string = "The copied file should have the same original file as the original file (original file: '" + this.$originalContainingFile$inlined + "', copied file: '" + this.$fileCopy$inlined + "').";
                                throw new IllegalStateException(string.toString());
                            }
                            object2 = this.$action$inlined.invoke((Object)$this$copyAwareAnalyzeForTest_u24lambda_u240, (Object)this.this$0.getDependentElementFromFile(this.$contextElement$inlined, this.$fileCopy$inlined));
                        }
                        object = object2;
                    }
                    catch (Throwable throwable$iv$iv) {
                        this_$iv$iv.handleAnalysisException(throwable$iv$iv, analysisSession$iv$iv, useSiteElement$iv$iv);
                        throw new KotlinNothingValueException();
                    }
                    finally {
                        this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
                    }
                    return (R)object;
                }
            });
        } else {
            Object object2;
            void this_$iv$iv;
            E useSiteElement$iv = contextElement;
            boolean $i$f$analyze = false;
            Project project = useSiteElement$iv.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            KaSessionProvider useSiteElement$iv2 = KaSessionProvider.Companion.getInstance(project);
            E useSiteElement$iv$iv = useSiteElement$iv;
            boolean $i$f$analyze2 = false;
            KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession(useSiteElement$iv$iv);
            this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
            try {
                Object object3;
                Object lock$iv$iv;
                Object object4 = lock$iv$iv = new Object();
                synchronized (object4) {
                    boolean bl = false;
                    KaSession $this$copyAwareAnalyzeForTest_u24lambda_u241 = analysisSession$iv$iv;
                    boolean bl2 = false;
                    object3 = action.invoke((Object)$this$copyAwareAnalyzeForTest_u24lambda_u241, contextElement);
                }
                object2 = object3;
            }
            catch (Throwable throwable$iv$iv) {
                this_$iv$iv.handleAnalysisException(throwable$iv$iv, analysisSession$iv$iv, useSiteElement$iv$iv);
                throw new KotlinNothingValueException();
            }
            finally {
                this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
            }
            object = object2;
        }
        return (R)object;
    }

    public static /* synthetic */ Object copyAwareAnalyzeForTest$default(AbstractAnalysisApiBasedTest abstractAnalysisApiBasedTest, KtElement ktElement, KaDanglingFileResolutionMode kaDanglingFileResolutionMode, Function2 function2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copyAwareAnalyzeForTest");
        }
        if ((n & 2) != 0) {
            kaDanglingFileResolutionMode = KaDanglingFileResolutionMode.IGNORE_SELF;
        }
        return abstractAnalysisApiBasedTest.copyAwareAnalyzeForTest(ktElement, kaDanglingFileResolutionMode, function2);
    }

    @NotNull
    protected final <E extends KtElement> E getDependentElementFromFile(@NotNull E originalElement, @NotNull KtFile contextFile) {
        Intrinsics.checkNotNullParameter(originalElement, (String)"originalElement");
        Intrinsics.checkNotNullParameter((Object)contextFile, (String)"contextFile");
        if (!this.getConfigurator().getAnalyseInDependentSession() || !Intrinsics.areEqual((Object)((PsiElement)originalElement).getContainingFile(), (Object)contextFile.getOriginalFile())) {
            return originalElement;
        }
        PsiElement psiElement = PsiTreeUtil.findSameElementInCopy((PsiElement)((PsiElement)originalElement), (PsiFile)((PsiFile)contextFile));
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"findSameElementInCopy(...)");
        return (E)((KtElement)psiElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected final <R> R analyzeForTest(@NotNull KtElement contextElement, @NotNull Function1<? super KaSession, ? extends R> action) {
        Object object;
        void this_$iv$iv;
        Intrinsics.checkNotNullParameter((Object)contextElement, (String)"contextElement");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        if (!(!this.getConfigurator().getAnalyseInDependentSession())) {
            boolean $i$a$-check-AbstractAnalysisApiBasedTest$analyzeForTest$22 = false;
            String $i$a$-check-AbstractAnalysisApiBasedTest$analyzeForTest$22 = "The `analyzeForTest` function should not be used in tests which support dependent analysis mode. Use `copyAwareAnalyzeForTest` instead.";
            throw new IllegalStateException($i$a$-check-AbstractAnalysisApiBasedTest$analyzeForTest$22.toString());
        }
        KtElement useSiteElement$iv = contextElement;
        boolean $i$f$analyze = false;
        Project project = useSiteElement$iv.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(project);
        KtElement useSiteElement$iv$iv = useSiteElement$iv;
        boolean $i$f$analyze2 = false;
        KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession(useSiteElement$iv$iv);
        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
        try {
            Object object2;
            Object lock$iv$iv;
            Object object3 = lock$iv$iv = new Object();
            synchronized (object3) {
                boolean bl = false;
                object2 = action.invoke((Object)analysisSession$iv$iv);
            }
            object = object2;
        }
        catch (Throwable throwable$iv$iv) {
            this_$iv$iv.handleAnalysisException(throwable$iv$iv, analysisSession$iv$iv, useSiteElement$iv$iv);
            throw new KotlinNothingValueException();
        }
        finally {
            this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
        }
        return (R)object;
    }

    @BeforeEach
    public final void initTestInfo(@NotNull TestInfo testInfo) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)testInfo, (String)"testInfo");
        Object object2 = (Class)testInfo.getTestClass().orElseGet(null);
        if (object2 == null || (object2 = ((Class)object2).getName()) == null) {
            object2 = "_undefined_";
        }
        if ((object = (Method)testInfo.getTestMethod().orElseGet(null)) == null || (object = ((Method)object).getName()) == null) {
            object = "_testUndefined_";
        }
        Set set = testInfo.getTags();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getTags(...)");
        this.testInfo = new KotlinTestInfo((String)object2, (String)object, set);
    }

    public final void suppressIf(@NotNull RegisteredDirectives $this$suppressIf, @NotNull StringDirective suppressionDirective, @NotNull Function1<? super Throwable, Boolean> filter, @NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter((Object)$this$suppressIf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)suppressionDirective, (String)"suppressionDirective");
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        boolean hasSuppressionDirective = $this$suppressIf.contains((Directive)suppressionDirective);
        Throwable exception = null;
        try {
            action.invoke();
        }
        catch (Throwable e) {
            exception = e;
        }
        if (exception != null) {
            if (!((Boolean)filter.invoke((Object)exception)).booleanValue() || !hasSuppressionDirective) {
                throw exception;
            }
            return;
        }
        if (hasSuppressionDirective) {
            throw new AssertionError((Object)('\'' + suppressionDirective.getName() + "' directive present but no exception thrown. Please remove directive"));
        }
    }

    private static final KtTestModule findMainModule$lambda$1(AbstractAnalysisApiBasedTest this$0, TestServices $testServices, KtTestModule module) {
        KtTestModule ktTestModule;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        KtTestModule it = ktTestModule = module;
        boolean bl = false;
        return this$0.isMainModule(module, $testServices) ? ktTestModule : null;
    }

    private static final String findMainModule$lambda$2(KtTestModule it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getTestModule().getName();
    }

    private static final KtFile findMainFile$lambda$1(AbstractAnalysisApiBasedTest this$0, KtTestModule $ktTestModule, TestServices $testServices, KtFile file) {
        KtFile ktFile;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        KtFile it = ktFile = file;
        boolean bl = false;
        return this$0.isMainFile(file, $ktTestModule, $testServices) ? ktFile : null;
    }

    private static final String findMainFile$lambda$2(KtFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    private static final Unit configure$lambda$0(AbstractAnalysisApiBasedTest this$0, TestConfigurationBuilder directivesContainerArray) {
        DirectivesContainer[] this_$iv;
        Intrinsics.checkNotNullParameter((Object)directivesContainerArray, (String)"<this>");
        directivesContainerArray.globalDefaults(arg_0 -> AbstractAnalysisApiBasedTest.configure$lambda$0$0(this$0, arg_0));
        directivesContainerArray.setAssertions((AssertionsService)JUnit5Assertions.INSTANCE);
        DirectivesContainer[] directivesContainerArray2 = directivesContainerArray;
        Function1 serviceConstructor$iv = configure.1.2.INSTANCE;
        boolean $i$f$useAdditionalService = false;
        ServiceRegistrationData[] serviceRegistrationDataArray = new ServiceRegistrationData[1];
        Function1 serviceConstructor$iv$iv = serviceConstructor$iv;
        boolean $i$f$service = false;
        serviceRegistrationDataArray[0] = new ServiceRegistrationData(Reflection.getOrCreateKotlinClass(TemporaryDirectoryManager.class), serviceConstructor$iv$iv);
        this_$iv.useAdditionalServices(serviceRegistrationDataArray);
        Collection $this$toTypedArray$iv = AbstractKotlinCompilerTest.Companion.getDefaultDirectiveContainers();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        this_$iv = thisCollection$iv.toArray(new SimpleDirectivesContainer[0]);
        directivesContainerArray.useDirectives((DirectivesContainer[])Arrays.copyOf(this_$iv, this_$iv.length));
        this_$iv = new DirectivesContainer[]{JvmEnvironmentConfigurationDirectives.INSTANCE};
        directivesContainerArray.useDirectives(this_$iv);
        this_$iv = new DirectivesContainer[]{TestModuleCompiler.Directives.INSTANCE};
        directivesContainerArray.useDirectives(this_$iv);
        this_$iv = new Function1[]{configure.1.3.INSTANCE};
        TestConfigurationBuilder.useSourcePreprocessor$default((TestConfigurationBuilder)directivesContainerArray, (Function1[])this_$iv, (boolean)false, (int)2, null);
        this_$iv = directivesContainerArray;
        serviceConstructor$iv = AbstractAnalysisApiBasedTest::configure$lambda$0$1;
        $i$f$useAdditionalService = false;
        serviceRegistrationDataArray = new ServiceRegistrationData[1];
        serviceConstructor$iv$iv = serviceConstructor$iv;
        $i$f$service = false;
        serviceRegistrationDataArray[0] = new ServiceRegistrationData(Reflection.getOrCreateKotlinClass(ExpressionMarkerProvider.class), serviceConstructor$iv$iv);
        this_$iv.useAdditionalServices(serviceRegistrationDataArray);
        directivesContainerArray2 = new DirectivesContainer[]{ExpressionMarkerProvider.Directives.INSTANCE};
        directivesContainerArray.useDirectives(directivesContainerArray2);
        RegisterBaseTestServicesKt.registerAnalysisApiBaseTestServices((TestConfigurationBuilder)directivesContainerArray, this$0.getDisposable(), this$0.getConfigurator());
        this$0.configureTest((TestConfigurationBuilder)directivesContainerArray);
        directivesContainerArray.setStartingArtifactFactory(AbstractAnalysisApiBasedTest::configure$lambda$0$2);
        KotlinTestInfo kotlinTestInfo = this$0.testInfo;
        if (kotlinTestInfo == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"testInfo");
            kotlinTestInfo = null;
        }
        directivesContainerArray.setTestInfo(kotlinTestInfo);
        AbstractTypeChecker.RUN_SLOW_ASSERTIONS = true;
        return Unit.INSTANCE;
    }

    private static final Unit configure$lambda$0$0(AbstractAnalysisApiBasedTest this$0, DefaultsProviderBuilder $this$globalDefaults) {
        Intrinsics.checkNotNullParameter((Object)$this$globalDefaults, (String)"$this$globalDefaults");
        $this$globalDefaults.setFrontend((FrontendKind)FrontendKinds.FIR.INSTANCE);
        $this$globalDefaults.setTargetPlatform(this$0.getConfigurator().getDefaultTargetPlatform());
        $this$globalDefaults.setDependencyKind(DependencyKind.Source);
        return Unit.INSTANCE;
    }

    private static final ExpressionMarkerProvider configure$lambda$0$1(TestServices it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ExpressionMarkerProvider();
    }

    private static final ResultingArtifact.Source configure$lambda$0$2(TestModule it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ResultingArtifact.Source();
    }

    private static final Unit runTest$lambda$0(AbstractAnalysisApiBasedTest this$0, TestServices it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.doTest(it);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/analysis/test/framework/base/AbstractAnalysisApiBasedTest$AdditionalServiceRegistrarsPreAnalysisHandler;", "Lorg/jetbrains/kotlin/test/services/PreAnalysisHandler;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "serviceRegistrars", "", "Lorg/jetbrains/kotlin/analysis/api/standalone/base/projectStructure/AnalysisApiServiceRegistrar;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;Ljava/util/List;)V", "preprocessModuleStructure", "", "moduleStructure", "Lorg/jetbrains/kotlin/test/services/TestModuleStructure;", "analysis-test-framework_test"})
    private static final class AdditionalServiceRegistrarsPreAnalysisHandler
    extends PreAnalysisHandler {
        @NotNull
        private final List<AnalysisApiServiceRegistrar<TestServices>> serviceRegistrars;

        public AdditionalServiceRegistrarsPreAnalysisHandler(@NotNull TestServices testServices, @NotNull List<? extends AnalysisApiServiceRegistrar<? super TestServices>> serviceRegistrars) {
            Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
            Intrinsics.checkNotNullParameter(serviceRegistrars, (String)"serviceRegistrars");
            super(testServices);
            this.serviceRegistrars = serviceRegistrars;
        }

        public void preprocessModuleStructure(@NotNull TestModuleStructure moduleStructure) {
            Intrinsics.checkNotNullParameter((Object)moduleStructure, (String)"moduleStructure");
            Application application = AnalysisApiEnvironmentManagerKt.getEnvironmentManager(this.getTestServices()).getApplication();
            Intrinsics.checkNotNull((Object)application, (String)"null cannot be cast to non-null type com.intellij.mock.MockApplication");
            MockApplication application2 = (MockApplication)application;
            Project project = AnalysisApiEnvironmentManagerKt.getEnvironmentManager(this.getTestServices()).getProject();
            Intrinsics.checkNotNull((Object)project, (String)"null cannot be cast to non-null type com.intellij.mock.MockProject");
            MockProject project2 = (MockProject)project;
            AnalysisApiTestServiceRegistrarKt.registerAllServices(this.serviceRegistrars, application2, project2, this.getTestServices());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001f\u0010\u000e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/analysis/test/framework/base/AbstractAnalysisApiBasedTest$ModuleWithMainFile;", "", "mainFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "module", "Lorg/jetbrains/kotlin/analysis/test/framework/projectStructure/KtTestModule;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtFile;Lorg/jetbrains/kotlin/analysis/test/framework/projectStructure/KtTestModule;)V", "getMainFile", "()Lorg/jetbrains/kotlin/psi/KtFile;", "getModule", "()Lorg/jetbrains/kotlin/analysis/test/framework/projectStructure/KtTestModule;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "analysis-test-framework_test"})
    public static final class ModuleWithMainFile {
        @Nullable
        private final KtFile mainFile;
        @NotNull
        private final KtTestModule module;

        public ModuleWithMainFile(@Nullable KtFile mainFile, @NotNull KtTestModule module) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            this.mainFile = mainFile;
            this.module = module;
        }

        @Nullable
        public final KtFile getMainFile() {
            return this.mainFile;
        }

        @NotNull
        public final KtTestModule getModule() {
            return this.module;
        }

        @Nullable
        public final KtFile component1() {
            return this.mainFile;
        }

        @NotNull
        public final KtTestModule component2() {
            return this.module;
        }

        @NotNull
        public final ModuleWithMainFile copy(@Nullable KtFile mainFile, @NotNull KtTestModule module) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            return new ModuleWithMainFile(mainFile, module);
        }

        public static /* synthetic */ ModuleWithMainFile copy$default(ModuleWithMainFile moduleWithMainFile, KtFile ktFile, KtTestModule ktTestModule, int n, Object object) {
            if ((n & 1) != 0) {
                ktFile = moduleWithMainFile.mainFile;
            }
            if ((n & 2) != 0) {
                ktTestModule = moduleWithMainFile.module;
            }
            return moduleWithMainFile.copy(ktFile, ktTestModule);
        }

        @NotNull
        public String toString() {
            return "ModuleWithMainFile(mainFile=" + this.mainFile + ", module=" + this.module + ')';
        }

        public int hashCode() {
            int result = this.mainFile == null ? 0 : this.mainFile.hashCode();
            result = result * 31 + this.module.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ModuleWithMainFile)) {
                return false;
            }
            ModuleWithMainFile moduleWithMainFile = (ModuleWithMainFile)other;
            if (!Intrinsics.areEqual((Object)this.mainFile, (Object)moduleWithMainFile.mainFile)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.module, (Object)moduleWithMainFile.module);
        }
    }
}

