/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.test.framework.utils;

import com.intellij.mock.MockApplication;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.impl.jar.CoreJarFileSystem;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.diagnostics.PsiDiagnosticUtils;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.test.directives.model.Directive;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectives;
import org.jetbrains.kotlin.test.testFramework.TestApplicationUtilKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000d\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a'\u0010\u0000\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u00012\u000e\b\u0004\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0003H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0004\u001a\u001f\u0010\u0005\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0003\u00a2\u0006\u0002\u0010\u0004\u001a\u001f\u0010\b\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0003\u00a2\u0006\u0002\u0010\u0004\u001a\f\u0010\t\u001a\u00020\n*\u0004\u0018\u00010\u000b\u001a\n\u0010\f\u001a\u00020\n*\u00020\r\u001a\u0012\u0010\u000e\u001a\u00020\n*\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\n\u0010\f\u001a\u00020\n*\u00020\u0011\u001a\n\u0010\u0012\u001a\u00020\n*\u00020\u0013\u001a\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0010\u001a\u0010\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0015*\u00020\u001b\u001a \u0010\u001c\u001a\u00020\u001d*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0003\u001aM\u0010!\u001a\u0004\u0018\u0001H\u0006\"\u0004\b\u0000\u0010\u0001\"\u0004\b\u0001\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00010\"2\u0014\u0010#\u001a\u0010\u0012\u0004\u0012\u0002H\u0001\u0012\u0006\u0012\u0004\u0018\u0001H\u00060$2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u00020\n0$\u00a2\u0006\u0002\u0010&\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006'"}, d2={"runReadAction", "T", "runnable", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "executeOnPooledThreadInReadAction", "R", "action", "withDummyApplication", "position", "", "Lcom/intellij/psi/PsiElement;", "getNameWithPositionString", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaSymbol;", "indented", "indent", "", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "renderLocationDescription", "Lorg/jetbrains/kotlin/psi/KtElement;", "findReferencesAtCaret", "", "Lorg/jetbrains/kotlin/idea/references/KtReference;", "mainKtFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "caretPosition", "unwrapMultiReferences", "Lcom/intellij/psi/PsiReference;", "ignoreExceptionIfIgnoreDirectivePresent", "", "Lorg/jetbrains/kotlin/test/directives/model/RegisteredDirectives;", "ignoreDirective", "Lorg/jetbrains/kotlin/test/directives/model/Directive;", "singleOrZeroValue", "", "transformer", "Lkotlin/Function1;", "ambiguityValueRenderer", "(Ljava/util/Collection;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "analysis-test-framework_test"})
@SourceDebugExtension(value={"SMAP\ncommonTestUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 commonTestUtils.kt\norg/jetbrains/kotlin/analysis/test/framework/utils/CommonTestUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,155:1\n25#1:197\n756#2,10:156\n808#2,11:167\n1617#2,9:184\n1869#2:193\n1870#2:195\n1626#2:196\n1#3:166\n1#3:194\n10135#4:178\n10557#4,5:179\n*S KotlinDebug\n*F\n+ 1 commonTestUtils.kt\norg/jetbrains/kotlin/analysis/test/framework/utils/CommonTestUtilsKt\n*L\n29#1:197\n97#1:156,10\n110#1:167,11\n146#1:184,9\n146#1:193\n146#1:195\n146#1:196\n146#1:194\n114#1:178\n114#1:179,5\n*E\n"})
public final class CommonTestUtilsKt {
    public static final <T> T runReadAction(@NotNull Function0<? extends T> runnable) {
        Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
        boolean $i$f$runReadAction = false;
        return (T)ApplicationManager.getApplication().runReadAction(new Computable(runnable){
            final /* synthetic */ Function0<T> $runnable;
            {
                this.$runnable = $runnable;
            }

            public final T compute() {
                return (T)this.$runnable.invoke();
            }
        });
    }

    public static final <R> R executeOnPooledThreadInReadAction(@NotNull Function0<? extends R> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        return (R)ApplicationManager.getApplication().executeOnPooledThread(() -> CommonTestUtilsKt.executeOnPooledThreadInReadAction$lambda$0(action)).get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <R> R withDummyApplication(@NotNull Function0<? extends R> action) {
        Object object;
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Application previousApplication = ApplicationManager.getApplication();
        Disposable disposable = Disposer.newDisposable((String)"Application disposable for dummy application from Analysis API test framework");
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable disposable2 = disposable;
        try {
            MockApplication.setUp((Disposable)disposable2);
            object = action.invoke();
        }
        catch (Throwable throwable) {
            Disposer.dispose((Disposable)disposable2);
            TestApplicationUtilKt.resetApplicationToNull((Application)previousApplication);
            if (!(ApplicationManager.getApplication() == previousApplication)) {
                boolean bl = false;
                String string = "The managed application should have been reset to the previous application or `null`.";
                throw new IllegalArgumentException(string.toString());
            }
            throw throwable;
        }
        Disposer.dispose((Disposable)disposable2);
        TestApplicationUtilKt.resetApplicationToNull((Application)previousApplication);
        if (!(ApplicationManager.getApplication() == previousApplication)) {
            boolean bl = false;
            String string = "The managed application should have been reset to the previous application or `null`.";
            throw new IllegalArgumentException(string.toString());
        }
        return (R)object;
    }

    @NotNull
    public static final String position(@Nullable PsiElement $this$position) {
        if ($this$position == null) {
            return "(unknown)";
        }
        String string = PsiDiagnosticUtils.offsetToLineAndColumn((Document)$this$position.getContainingFile().getViewProvider().getDocument(), (int)$this$position.getTextRange().getStartOffset()).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public static final String getNameWithPositionString(@NotNull KaSymbol $this$getNameWithPositionString) {
        Intrinsics.checkNotNullParameter((Object)$this$getNameWithPositionString, (String)"<this>");
        PsiElement psi = $this$getNameWithPositionString.getPsi();
        return (psi instanceof KtDeclarationWithBody ? ((KtDeclarationWithBody)psi).getName() : (psi instanceof KtNamedDeclaration ? ((KtNamedDeclaration)psi).getName() : (psi == null ? "null" : Reflection.getOrCreateKotlinClass(psi.getClass()).getSimpleName()))) + '@' + CommonTestUtilsKt.position($this$getNameWithPositionString.getPsi());
    }

    @NotNull
    public static final String indented(@NotNull String $this$indented, int indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indented, (String)"<this>");
        String indentString = StringsKt.repeat((CharSequence)" ", (int)indent);
        return indentString + StringsKt.replace$default((String)$this$indented, (String)"\n", (String)('\n' + indentString), (boolean)false, (int)4, null);
    }

    @NotNull
    public static final String getNameWithPositionString(@NotNull KtDeclaration $this$getNameWithPositionString) {
        Intrinsics.checkNotNullParameter((Object)$this$getNameWithPositionString, (String)"<this>");
        StringBuilder stringBuilder = new StringBuilder();
        Object object = $this$getNameWithPositionString.getPresentation();
        if ((object == null || (object = object.getPresentableText()) == null) && (object = $this$getNameWithPositionString.getName()) == null) {
            object = Reflection.getOrCreateKotlinClass($this$getNameWithPositionString.getClass()).getSimpleName();
        }
        return stringBuilder.append((String)object).append('@').append(CommonTestUtilsKt.position((PsiElement)$this$getNameWithPositionString)).toString();
    }

    @NotNull
    public static final String renderLocationDescription(@NotNull KtElement $this$renderLocationDescription) {
        Object object;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$renderLocationDescription, (String)"<this>");
        StringBuilder $this$renderLocationDescription_u24lambda_u244 = stringBuilder = new StringBuilder();
        boolean bl = false;
        KtFile ktFile = $this$renderLocationDescription.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"getContainingKtFile(...)");
        KtFile ktFile2 = ktFile;
        VirtualFile virtualFile = ktFile2.getVirtualFile();
        VirtualFileSystem virtualFileSystem = virtualFile.getFileSystem();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileSystem, (String)"getFileSystem(...)");
        VirtualFileSystem fileSystem = virtualFileSystem;
        if (fileSystem instanceof CoreJarFileSystem) {
            String string = virtualFile.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            Object object2 = new String[]{"/"};
            Iterable $this$dropWhile$iv = StringsKt.split$default((CharSequence)string, (String[])object2, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$dropWhile = false;
            boolean yielding$iv = false;
            ArrayList list$iv = new ArrayList();
            for (Object item$iv : $this$dropWhile$iv) {
                if (yielding$iv) {
                    list$iv.add(item$iv);
                    continue;
                }
                String it = (String)item$iv;
                boolean bl2 = false;
                if (!StringsKt.endsWith$default((String)it, (String)".jar!", (boolean)false, (int)2, null)) continue;
                list$iv.add(item$iv);
                yielding$iv = true;
            }
            Object it = object2 = CollectionsKt.joinToString$default((Iterable)list$iv, (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
            boolean bl3 = false;
            object = ((CharSequence)it).length() > 0 ? object2 : null;
            if (object == null) {
                throw new IllegalStateException(("Expected a JAR file path for a virtual file in a JAR file system: " + virtualFile.getPath()).toString());
            }
        } else {
            Object object3 = virtualFile.getName();
            Intrinsics.checkNotNull((Object)object3);
            object = object3;
        }
        Object fileDescription = object;
        $this$renderLocationDescription_u24lambda_u244.append('\'' + (String)fileDescription + '\'');
        if (!ktFile2.isCompiled()) {
            $this$renderLocationDescription_u24lambda_u244.append(' ' + CommonTestUtilsKt.position((PsiElement)$this$renderLocationDescription));
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<KtReference> findReferencesAtCaret(@NotNull KtFile mainKtFile, int caretPosition) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)mainKtFile, (String)"mainKtFile");
        PsiReference psiReference = mainKtFile.findReferenceAt(caretPosition);
        List list = psiReference != null ? CommonTestUtilsKt.unwrapMultiReferences(psiReference) : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        Iterable $this$filterIsInstance$iv = list;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof KtReference)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<PsiReference> unwrapMultiReferences(@NotNull PsiReference $this$unwrapMultiReferences) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$unwrapMultiReferences, (String)"<this>");
        PsiReference psiReference = $this$unwrapMultiReferences;
        if (psiReference instanceof KtReference) {
            list = CollectionsKt.listOf((Object)$this$unwrapMultiReferences);
        } else if (psiReference instanceof PsiMultiReference) {
            void $this$flatMapTo$iv$iv;
            PsiReference[] psiReferenceArray = ((PsiMultiReference)$this$unwrapMultiReferences).getReferences();
            Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getReferences(...)");
            Object[] $this$flatMap$iv = psiReferenceArray;
            boolean $i$f$flatMap = false;
            Object[] objectArray = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (void element$iv$iv : $this$flatMapTo$iv$iv) {
                PsiReference it = (PsiReference)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                Iterable list$iv$iv = CommonTestUtilsKt.unwrapMultiReferences(it);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            throw new IllegalStateException(("Unexpected reference " + $this$unwrapMultiReferences).toString());
        }
        return list;
    }

    public static final void ignoreExceptionIfIgnoreDirectivePresent(@NotNull RegisteredDirectives $this$ignoreExceptionIfIgnoreDirectivePresent, @NotNull Directive ignoreDirective, @NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter((Object)$this$ignoreExceptionIfIgnoreDirectivePresent, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)ignoreDirective, (String)"ignoreDirective");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Throwable exception = null;
        try {
            action.invoke();
        }
        catch (Throwable e) {
            exception = e;
        }
        if ($this$ignoreExceptionIfIgnoreDirectivePresent.contains(ignoreDirective)) {
            if (exception != null) {
                return;
            }
            throw new IllegalStateException((ignoreDirective + " is redundant").toString());
        }
        if (exception != null) {
            throw exception;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final <T, R> R singleOrZeroValue(@NotNull Collection<? extends T> $this$singleOrZeroValue, @NotNull Function1<? super T, ? extends R> transformer, @NotNull Function1<? super R, String> ambiguityValueRenderer) {
        Object object;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$singleOrZeroValue, (String)"<this>");
        Intrinsics.checkNotNullParameter(transformer, (String)"transformer");
        Intrinsics.checkNotNullParameter(ambiguityValueRenderer, (String)"ambiguityValueRenderer");
        Iterable $this$mapNotNull$iv = $this$singleOrZeroValue;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            if (transformer.invoke(element$iv$iv) == null) continue;
            boolean bl2 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List newCollection = (List)destination$iv$iv;
        switch (newCollection.size()) {
            case 0: {
                object = null;
                break;
            }
            case 1: {
                object = CollectionsKt.single((List)newCollection);
                break;
            }
            default: {
                CharSequence charSequence = new StringBuilder();
                StringBuilder $this$singleOrZeroValue_u24lambda_u246 = charSequence;
                boolean bl = false;
                $this$singleOrZeroValue_u24lambda_u246.append("Ambiguity values are not expected.").append('\n');
                CollectionsKt.joinTo$default((Iterable)newCollection, (Appendable)$this$singleOrZeroValue_u24lambda_u246, (CharSequence)"\n", null, null, (int)0, null, ambiguityValueRenderer, (int)60, null);
                charSequence = ((StringBuilder)charSequence).toString();
                throw new IllegalStateException(((Object)charSequence).toString());
            }
        }
        return (R)object;
    }

    private static final Object executeOnPooledThreadInReadAction$lambda$0(Function0 $action) {
        boolean $i$f$runReadAction = false;
        return ApplicationManager.getApplication().runReadAction(new /* invalid duplicate definition of identical inner class */);
    }
}

