/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir;

import com.intellij.testFramework.TestDataPath;
import java.io.File;
import java.util.regex.Pattern;
import org.jetbrains.kotlin.analysis.low.level.api.fir.AbstractFirOutOfContentRootLazyDeclarationResolveTest;
import org.jetbrains.kotlin.test.TestMetadata;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

@TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolve")
@TestDataPath(value="$PROJECT_ROOT")
public class FirOutOfContentRootLazyDeclarationResolveTestGenerated
extends AbstractFirOutOfContentRootLazyDeclarationResolveTest {
    @Test
    public void testAllFilesPresentInLazyResolve() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolve"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
    }

    @Test
    @TestMetadata(value="ambiguousLocalEnum.kt")
    public void testAmbiguousLocalEnum() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/ambiguousLocalEnum.kt");
    }

    @Test
    @TestMetadata(value="annotationArgumentsMix.kt")
    public void testAnnotationArgumentsMix() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/annotationArgumentsMix.kt");
    }

    @Test
    @TestMetadata(value="annotationClassWithJavaTarget.kt")
    public void testAnnotationClassWithJavaTarget() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/annotationClassWithJavaTarget.kt");
    }

    @Test
    @TestMetadata(value="annotationFromImplicitJavaType.kt")
    public void testAnnotationFromImplicitJavaType() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/annotationFromImplicitJavaType.kt");
    }

    @Test
    @TestMetadata(value="annotationFromImplicitJavaTypeWithJavaAnnotation.kt")
    public void testAnnotationFromImplicitJavaTypeWithJavaAnnotation() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/annotationFromImplicitJavaTypeWithJavaAnnotation.kt");
    }

    @Test
    @TestMetadata(value="annotationInsideWhereFunction.kt")
    public void testAnnotationInsideWhereFunction() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/annotationInsideWhereFunction.kt");
    }

    @Test
    @TestMetadata(value="annotationInsideWhereProperty.kt")
    public void testAnnotationInsideWhereProperty() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/annotationInsideWhereProperty.kt");
    }

    @Test
    @TestMetadata(value="annotationOnDelegatedInterface.kt")
    public void testAnnotationOnDelegatedInterface() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/annotationOnDelegatedInterface.kt");
    }

    @Test
    @TestMetadata(value="annotationOnLocalClass.kt")
    public void testAnnotationOnLocalClass() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/annotationOnLocalClass.kt");
    }

    @Test
    @TestMetadata(value="annotationParameters.kt")
    public void testAnnotationParameters() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/annotationParameters.kt");
    }

    @Test
    @TestMetadata(value="annotationWithCycleInDefaults.kt")
    public void testAnnotationWithCycleInDefaults() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/annotationWithCycleInDefaults.kt");
    }

    @Test
    @TestMetadata(value="annotationWithDefaults.kt")
    public void testAnnotationWithDefaults() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/annotationWithDefaults.kt");
    }

    @Test
    @TestMetadata(value="annotationWithEnumFromBody.kt")
    public void testAnnotationWithEnumFromBody() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/annotationWithEnumFromBody.kt");
    }

    @Test
    @TestMetadata(value="annotationWithSecondaryConstructor.kt")
    public void testAnnotationWithSecondaryConstructor() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/annotationWithSecondaryConstructor.kt");
    }

    @Test
    @TestMetadata(value="annotationWithSecondaryConstructor2.kt")
    public void testAnnotationWithSecondaryConstructor2() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/annotationWithSecondaryConstructor2.kt");
    }

    @Test
    @TestMetadata(value="annotationWithTypeArgument.kt")
    public void testAnnotationWithTypeArgument() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/annotationWithTypeArgument.kt");
    }

    @Test
    @TestMetadata(value="annotationWithoutDefaults.kt")
    public void testAnnotationWithoutDefaults() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/annotationWithoutDefaults.kt");
    }

    @Test
    @TestMetadata(value="annotations.kt")
    public void testAnnotations() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/annotations.kt");
    }

    @Test
    @TestMetadata(value="anonymousFunctionWithAnnotatedParameter.kt")
    public void testAnonymousFunctionWithAnnotatedParameter() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/anonymousFunctionWithAnnotatedParameter.kt");
    }

    @Test
    @TestMetadata(value="anonymousFunctionWithAnnotatedParameter2.kt")
    public void testAnonymousFunctionWithAnnotatedParameter2() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/anonymousFunctionWithAnnotatedParameter2.kt");
    }

    @Test
    @TestMetadata(value="anonymousFunctionWithAnnotatedParameterOnImplicitTypePhase.kt")
    public void testAnonymousFunctionWithAnnotatedParameterOnImplicitTypePhase() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/anonymousFunctionWithAnnotatedParameterOnImplicitTypePhase.kt");
    }

    @Test
    @TestMetadata(value="classMembers.kt")
    public void testClassMembers() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classMembers.kt");
    }

    @Test
    @TestMetadata(value="compilerRequiredAnnotationOnLocalClass.kt")
    public void testCompilerRequiredAnnotationOnLocalClass() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/compilerRequiredAnnotationOnLocalClass.kt");
    }

    @Test
    @TestMetadata(value="compilerRequiredAnnotationsOnConstructor.kt")
    public void testCompilerRequiredAnnotationsOnConstructor() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/compilerRequiredAnnotationsOnConstructor.kt");
    }

    @Test
    @TestMetadata(value="compilerRequiredAnnotationsOnConstructorProperty.kt")
    public void testCompilerRequiredAnnotationsOnConstructorProperty() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/compilerRequiredAnnotationsOnConstructorProperty.kt");
    }

    @Test
    @TestMetadata(value="compilerRequiredAnnotationsOnFunction.kt")
    public void testCompilerRequiredAnnotationsOnFunction() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/compilerRequiredAnnotationsOnFunction.kt");
    }

    @Test
    @TestMetadata(value="compilerRequiredAnnotationsOnProperty.kt")
    public void testCompilerRequiredAnnotationsOnProperty() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/compilerRequiredAnnotationsOnProperty.kt");
    }

    @Test
    @TestMetadata(value="compilerRequiredAnnotationsOnPropertyDelegate.kt")
    public void testCompilerRequiredAnnotationsOnPropertyDelegate() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/compilerRequiredAnnotationsOnPropertyDelegate.kt");
    }

    @Test
    @TestMetadata(value="complexLocalHierarchy.kt")
    public void testComplexLocalHierarchy() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/complexLocalHierarchy.kt");
    }

    @Test
    @TestMetadata(value="complexRedeclaration.kt")
    public void testComplexRedeclaration() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/complexRedeclaration.kt");
    }

    @Test
    @TestMetadata(value="contextParameters.kt")
    public void testContextParameters() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/contextParameters.kt");
    }

    @Test
    @TestMetadata(value="contextParametersProperty.kt")
    public void testContextParametersProperty() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/contextParametersProperty.kt");
    }

    @Test
    @TestMetadata(value="cyclicHierarchy.kt")
    public void testCyclicHierarchy() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/cyclicHierarchy.kt");
    }

    @Test
    @TestMetadata(value="cyclicHierarchy2.kt")
    public void testCyclicHierarchy2() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/cyclicHierarchy2.kt");
    }

    @Test
    @TestMetadata(value="cyclicHierarchy3.kt")
    public void testCyclicHierarchy3() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/cyclicHierarchy3.kt");
    }

    @Test
    @TestMetadata(value="cyclicNestedHierarchy.kt")
    public void testCyclicNestedHierarchy() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/cyclicNestedHierarchy.kt");
    }

    @Test
    @TestMetadata(value="cyclicNestedHierarchy2.kt")
    public void testCyclicNestedHierarchy2() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/cyclicNestedHierarchy2.kt");
    }

    @Test
    @TestMetadata(value="dataClassCopy.kt")
    public void testDataClassCopy() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/dataClassCopy.kt");
    }

    @Test
    @TestMetadata(value="dataComponent2.kt")
    public void testDataComponent2() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/dataComponent2.kt");
    }

    @Test
    @TestMetadata(value="delegateWithImplicitType.kt")
    public void testDelegateWithImplicitType() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/delegateWithImplicitType.kt");
    }

    @Test
    @TestMetadata(value="delegateWithImplicitTypeInDifferentModules.kt")
    public void testDelegateWithImplicitTypeInDifferentModules() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/delegateWithImplicitTypeInDifferentModules.kt");
    }

    @Test
    @TestMetadata(value="delegatedField.kt")
    public void testDelegatedField() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/delegatedField.kt");
    }

    @Test
    @TestMetadata(value="delegatedFieldNestedNameClash.kt")
    public void testDelegatedFieldNestedNameClash() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/delegatedFieldNestedNameClash.kt");
    }

    @Test
    @TestMetadata(value="delegatedFieldNestedNameClashWithNestedTypes.kt")
    public void testDelegatedFieldNestedNameClashWithNestedTypes() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/delegatedFieldNestedNameClashWithNestedTypes.kt");
    }

    @Test
    @TestMetadata(value="delegates.kt")
    public void testDelegates() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/delegates.kt");
    }

    @Test
    @TestMetadata(value="delegationPropertyGetter.kt")
    public void testDelegationPropertyGetter() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/delegationPropertyGetter.kt");
    }

    @Test
    @TestMetadata(value="delegationPropertyGetterWithImplicitType.kt")
    public void testDelegationPropertyGetterWithImplicitType() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/delegationPropertyGetterWithImplicitType.kt");
    }

    @Test
    @TestMetadata(value="delegationPropertySetter.kt")
    public void testDelegationPropertySetter() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/delegationPropertySetter.kt");
    }

    @Test
    @TestMetadata(value="delegationPropertySetterWithImplicitType.kt")
    public void testDelegationPropertySetterWithImplicitType() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/delegationPropertySetterWithImplicitType.kt");
    }

    @Test
    @TestMetadata(value="enumEntries.kt")
    public void testEnumEntries() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/enumEntries.kt");
    }

    @Test
    @TestMetadata(value="enumEntry.kt")
    public void testEnumEntry() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/enumEntry.kt");
    }

    @Test
    @TestMetadata(value="enumValueOf.kt")
    public void testEnumValueOf() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/enumValueOf.kt");
    }

    @Test
    @TestMetadata(value="enumValues.kt")
    public void testEnumValues() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/enumValues.kt");
    }

    @Test
    @TestMetadata(value="expectClass.kt")
    public void testExpectClass() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/expectClass.kt");
    }

    @Test
    @TestMetadata(value="explicitSubstitutionOverrideProperty.kt")
    public void testExplicitSubstitutionOverrideProperty() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/explicitSubstitutionOverrideProperty.kt");
    }

    @Test
    @TestMetadata(value="externalClassConstructor.kt")
    public void testExternalClassConstructor() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/externalClassConstructor.kt");
    }

    @Test
    @TestMetadata(value="fakeOverride.kt")
    public void testFakeOverride() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/fakeOverride.kt");
    }

    @Test
    @TestMetadata(value="fakePrimaryConstructor.kt")
    public void testFakePrimaryConstructor() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/fakePrimaryConstructor.kt");
    }

    @Test
    @TestMetadata(value="fileAnnotations.kt")
    public void testFileAnnotations() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/fileAnnotations.kt");
    }

    @Test
    @TestMetadata(value="fileElements.kt")
    public void testFileElements() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/fileElements.kt");
    }

    @Test
    @TestMetadata(value="fromLocalHierarchyToOuter.kt")
    public void testFromLocalHierarchyToOuter() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/fromLocalHierarchyToOuter.kt");
    }

    @Test
    @TestMetadata(value="functionWithAnnotatedJavaClass.kt")
    public void testFunctionWithAnnotatedJavaClass() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functionWithAnnotatedJavaClass.kt");
    }

    @Test
    @TestMetadata(value="functionWithImplicitTypeAndAnnotations.kt")
    public void testFunctionWithImplicitTypeAndAnnotations() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functionWithImplicitTypeAndAnnotations.kt");
    }

    @Test
    @TestMetadata(value="functionWithImplicitTypeAndStringTemplateAsDefaultValue.kt")
    public void testFunctionWithImplicitTypeAndStringTemplateAsDefaultValue() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functionWithImplicitTypeAndStringTemplateAsDefaultValue.kt");
    }

    @Test
    @TestMetadata(value="functionWithParameter.kt")
    public void testFunctionWithParameter() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functionWithParameter.kt");
    }

    @Test
    @TestMetadata(value="functionWithWhere.kt")
    public void testFunctionWithWhere() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functionWithWhere.kt");
    }

    @Test
    @TestMetadata(value="implicitSubstitutionOverrideProperty.kt")
    public void testImplicitSubstitutionOverrideProperty() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/implicitSubstitutionOverrideProperty.kt");
    }

    @Test
    @TestMetadata(value="implicitTypeOnFunctionWithRawContract.kt")
    public void testImplicitTypeOnFunctionWithRawContract() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/implicitTypeOnFunctionWithRawContract.kt");
    }

    @Test
    @TestMetadata(value="implicitTypeOnFunctionWithUnresolvedRawContract.kt")
    public void testImplicitTypeOnFunctionWithUnresolvedRawContract() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/implicitTypeOnFunctionWithUnresolvedRawContract.kt");
    }

    @Test
    @TestMetadata(value="implicitTypeOnFunctionWithWrongRawContract.kt")
    public void testImplicitTypeOnFunctionWithWrongRawContract() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/implicitTypeOnFunctionWithWrongRawContract.kt");
    }

    @Test
    @TestMetadata(value="implicitTypeWithInaccessibleAnnotation.kt")
    public void testImplicitTypeWithInaccessibleAnnotation() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/implicitTypeWithInaccessibleAnnotation.kt");
    }

    @Test
    @TestMetadata(value="initWithAnnotation.kt")
    public void testInitWithAnnotation() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/initWithAnnotation.kt");
    }

    @Test
    @TestMetadata(value="lambdaAsSAMInterface.kt")
    public void testLambdaAsSAMInterface() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/lambdaAsSAMInterface.kt");
    }

    @Test
    @TestMetadata(value="lazyProperty.kt")
    public void testLazyProperty() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/lazyProperty.kt");
    }

    @Test
    @TestMetadata(value="localAnnotations.kt")
    public void testLocalAnnotations() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/localAnnotations.kt");
    }

    @Test
    @TestMetadata(value="localConstructor.kt")
    public void testLocalConstructor() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/localConstructor.kt");
    }

    @Test
    @TestMetadata(value="localFunctionInsideAnnotationCall.kt")
    public void testLocalFunctionInsideAnnotationCall() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/localFunctionInsideAnnotationCall.kt");
    }

    @Test
    @TestMetadata(value="localFunctionInsideFunctionLiteral.kt")
    public void testLocalFunctionInsideFunctionLiteral() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/localFunctionInsideFunctionLiteral.kt");
    }

    @Test
    @TestMetadata(value="localFunctionInsideLambdaCallInsideStringTemplate.kt")
    public void testLocalFunctionInsideLambdaCallInsideStringTemplate() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/localFunctionInsideLambdaCallInsideStringTemplate.kt");
    }

    @Test
    @TestMetadata(value="localFunctionInsideStringTemplate.kt")
    public void testLocalFunctionInsideStringTemplate() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/localFunctionInsideStringTemplate.kt");
    }

    @Test
    @TestMetadata(value="localFunctionInsideSuperEntryCall.kt")
    public void testLocalFunctionInsideSuperEntryCall() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/localFunctionInsideSuperEntryCall.kt");
    }

    @Test
    @TestMetadata(value="localNestedClass.kt")
    public void testLocalNestedClass() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/localNestedClass.kt");
    }

    @Test
    @TestMetadata(value="localParameterInsideSuperEntryCall.kt")
    public void testLocalParameterInsideSuperEntryCall() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/localParameterInsideSuperEntryCall.kt");
    }

    @Test
    @TestMetadata(value="nestedCompilerRequiredAnnotations.kt")
    public void testNestedCompilerRequiredAnnotations() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/nestedCompilerRequiredAnnotations.kt");
    }

    @Test
    @TestMetadata(value="nestedCompilerRequiredAnnotationsForMember.kt")
    public void testNestedCompilerRequiredAnnotationsForMember() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/nestedCompilerRequiredAnnotationsForMember.kt");
    }

    @Test
    @TestMetadata(value="nestedCompilerRequiredAnnotationsInsideBody.kt")
    public void testNestedCompilerRequiredAnnotationsInsideBody() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/nestedCompilerRequiredAnnotationsInsideBody.kt");
    }

    @Test
    @TestMetadata(value="nestedTypeAlias.kt")
    public void testNestedTypeAlias() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/nestedTypeAlias.kt");
    }

    @Test
    @TestMetadata(value="nestedTypeAlias2.kt")
    public void testNestedTypeAlias2() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/nestedTypeAlias2.kt");
    }

    @Test
    @TestMetadata(value="parameterOfNonLocalSetter.kt")
    public void testParameterOfNonLocalSetter() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/parameterOfNonLocalSetter.kt");
    }

    @Test
    @TestMetadata(value="parameterOfTopSetter.kt")
    public void testParameterOfTopSetter() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/parameterOfTopSetter.kt");
    }

    @Test
    @TestMetadata(value="primaryConstructor.kt")
    public void testPrimaryConstructor() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/primaryConstructor.kt");
    }

    @Test
    @TestMetadata(value="primaryConstructorParameter.kt")
    public void testPrimaryConstructorParameter() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/primaryConstructorParameter.kt");
    }

    @Test
    @TestMetadata(value="primaryConstructorProperty.kt")
    public void testPrimaryConstructorProperty() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/primaryConstructorProperty.kt");
    }

    @Test
    @TestMetadata(value="propertyDelegateWithImplicitType.kt")
    public void testPropertyDelegateWithImplicitType() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/propertyDelegateWithImplicitType.kt");
    }

    @Test
    @TestMetadata(value="propertyWithGetter.kt")
    public void testPropertyWithGetter() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/propertyWithGetter.kt");
    }

    @Test
    @TestMetadata(value="propertyWithGetterAndSetter.kt")
    public void testPropertyWithGetterAndSetter() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/propertyWithGetterAndSetter.kt");
    }

    @Test
    @TestMetadata(value="propertyWithImplicitTypeAndAnnotations.kt")
    public void testPropertyWithImplicitTypeAndAnnotations() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/propertyWithImplicitTypeAndAnnotations.kt");
    }

    @Test
    @TestMetadata(value="propertyWithImplicitTypeAndFieldAnnotations.kt")
    public void testPropertyWithImplicitTypeAndFieldAnnotations() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/propertyWithImplicitTypeAndFieldAnnotations.kt");
    }

    @Test
    @TestMetadata(value="propertyWithInitializer.kt")
    public void testPropertyWithInitializer() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/propertyWithInitializer.kt");
    }

    @Test
    @TestMetadata(value="propertyWithWhere.kt")
    public void testPropertyWithWhere() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/propertyWithWhere.kt");
    }

    @Test
    @TestMetadata(value="redeclaration.kt")
    public void testRedeclaration() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/redeclaration.kt");
    }

    @Test
    @TestMetadata(value="resolveSuperTypeFromLocalClass.kt")
    public void testResolveSuperTypeFromLocalClass() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/resolveSuperTypeFromLocalClass.kt");
    }

    @Test
    @TestMetadata(value="resolveTypeFromLocalClassConstructor.kt")
    public void testResolveTypeFromLocalClassConstructor() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/resolveTypeFromLocalClassConstructor.kt");
    }

    @Test
    @TestMetadata(value="resolveTypeFromLocalFunction.kt")
    public void testResolveTypeFromLocalFunction() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/resolveTypeFromLocalFunction.kt");
    }

    @Test
    @TestMetadata(value="secondaryConstructor.kt")
    public void testSecondaryConstructor() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/secondaryConstructor.kt");
    }

    @Test
    @TestMetadata(value="secondaryConstructorParameter.kt")
    public void testSecondaryConstructorParameter() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/secondaryConstructorParameter.kt");
    }

    @Test
    @TestMetadata(value="substitutionFakeOverride.kt")
    public void testSubstitutionFakeOverride() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/substitutionFakeOverride.kt");
    }

    @Test
    @TestMetadata(value="substitutionFakeOverrideConstructor.kt")
    public void testSubstitutionFakeOverrideConstructor() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/substitutionFakeOverrideConstructor.kt");
    }

    @Test
    @TestMetadata(value="substitutionFakeOverrideFunction.kt")
    public void testSubstitutionFakeOverrideFunction() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/substitutionFakeOverrideFunction.kt");
    }

    @Test
    @TestMetadata(value="substitutionFakeOverrideFunctionWithImplicitType.kt")
    public void testSubstitutionFakeOverrideFunctionWithImplicitType() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/substitutionFakeOverrideFunctionWithImplicitType.kt");
    }

    @Test
    @TestMetadata(value="substitutionFakeOverrideInDifferentModules.kt")
    public void testSubstitutionFakeOverrideInDifferentModules() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/substitutionFakeOverrideInDifferentModules.kt");
    }

    @Test
    @TestMetadata(value="substitutionFakeOverrideWithImplicitType.kt")
    public void testSubstitutionFakeOverrideWithImplicitType() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/substitutionFakeOverrideWithImplicitType.kt");
    }

    @Test
    @TestMetadata(value="substitutionFakeOverrideWithImplicitTypeAndReceiver.kt")
    public void testSubstitutionFakeOverrideWithImplicitTypeAndReceiver() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/substitutionFakeOverrideWithImplicitTypeAndReceiver.kt");
    }

    @Test
    @TestMetadata(value="superQualifierTypeArgsInDelegatedConstructorInnerClass.kt")
    public void testSuperQualifierTypeArgsInDelegatedConstructorInnerClass() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/superQualifierTypeArgsInDelegatedConstructorInnerClass.kt");
    }

    @Test
    @TestMetadata(value="superQualifierTypeArgsInDelegatedConstructorLocalClass.kt")
    public void testSuperQualifierTypeArgsInDelegatedConstructorLocalClass() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/superQualifierTypeArgsInDelegatedConstructorLocalClass.kt");
    }

    @Test
    @TestMetadata(value="superTypes.kt")
    public void testSuperTypes() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/superTypes.kt");
    }

    @Test
    @TestMetadata(value="superTypesLoop.kt")
    public void testSuperTypesLoop() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/superTypesLoop.kt");
    }

    @Test
    @TestMetadata(value="superclassMetaAnnotation.kt")
    public void testSuperclassMetaAnnotation() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/superclassMetaAnnotation.kt");
    }

    @Test
    @TestMetadata(value="topLevelFunctions.kt")
    public void testTopLevelFunctions() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/topLevelFunctions.kt");
    }

    @Test
    @TestMetadata(value="topLevelFunctionsWithExpressionBodyAndExplicitType.kt")
    public void testTopLevelFunctionsWithExpressionBodyAndExplicitType() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/topLevelFunctionsWithExpressionBodyAndExplicitType.kt");
    }

    @Test
    @TestMetadata(value="topLevelFunctionsWithImplicitType.kt")
    public void testTopLevelFunctionsWithImplicitType() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/topLevelFunctionsWithImplicitType.kt");
    }

    @Test
    @TestMetadata(value="typeParameterBounds.kt")
    public void testTypeParameterBounds() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/typeParameterBounds.kt");
    }

    @Test
    @TestMetadata(value="typeParameterOfClass.kt")
    public void testTypeParameterOfClass() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/typeParameterOfClass.kt");
    }

    @Test
    @TestMetadata(value="typeParameterOfClass2.kt")
    public void testTypeParameterOfClass2() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/typeParameterOfClass2.kt");
    }

    @Test
    @TestMetadata(value="typeParameterOfNonLocalFunction.kt")
    public void testTypeParameterOfNonLocalFunction() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/typeParameterOfNonLocalFunction.kt");
    }

    @Test
    @TestMetadata(value="typeParameterOfTopFunction.kt")
    public void testTypeParameterOfTopFunction() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/typeParameterOfTopFunction.kt");
    }

    @Test
    @TestMetadata(value="typeParameterOfTopSetter.kt")
    public void testTypeParameterOfTopSetter() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/typeParameterOfTopSetter.kt");
    }

    @Test
    @TestMetadata(value="typeParameterOfTypeAlias.kt")
    public void testTypeParameterOfTypeAlias() {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/typeParameterOfTypeAlias.kt");
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolve/withTestCompilerPluginEnabled")
    @TestDataPath(value="$PROJECT_ROOT")
    public class WithTestCompilerPluginEnabled {
        @Test
        public void testAllFilesPresentInWithTestCompilerPluginEnabled() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolve/withTestCompilerPluginEnabled"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="dataClassComponent1.kt")
        public void testDataClassComponent1() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/withTestCompilerPluginEnabled/dataClassComponent1.kt");
        }

        @Test
        @TestMetadata(value="dataClassConstructor.kt")
        public void testDataClassConstructor() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/withTestCompilerPluginEnabled/dataClassConstructor.kt");
        }

        @Test
        @TestMetadata(value="dataClassCopy.kt")
        public void testDataClassCopy() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/withTestCompilerPluginEnabled/dataClassCopy.kt");
        }

        @Test
        @TestMetadata(value="dataClassCopyAnnotation.kt")
        public void testDataClassCopyAnnotation() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/withTestCompilerPluginEnabled/dataClassCopyAnnotation.kt");
        }

        @Test
        @TestMetadata(value="dataClassProperty.kt")
        public void testDataClassProperty() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/withTestCompilerPluginEnabled/dataClassProperty.kt");
        }

        @Test
        @TestMetadata(value="serializable_starImport.kt")
        public void testSerializable_starImport() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/withTestCompilerPluginEnabled/serializable_starImport.kt");
        }

        @Test
        @TestMetadata(value="serializable_starImport_twoAnnotationsChain.kt")
        public void testSerializable_starImport_twoAnnotationsChain() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/withTestCompilerPluginEnabled/serializable_starImport_twoAnnotationsChain.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolve/withCallableMembers")
    @TestDataPath(value="$PROJECT_ROOT")
    public class WithCallableMembers {
        @Test
        public void testAllFilesPresentInWithCallableMembers() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolve/withCallableMembers"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="complexEmptyInterfaceWithSuper.kt")
        public void testComplexEmptyInterfaceWithSuper() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/withCallableMembers/complexEmptyInterfaceWithSuper.kt");
        }

        @Test
        @TestMetadata(value="emptyClassWithSuper.kt")
        public void testEmptyClassWithSuper() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/withCallableMembers/emptyClassWithSuper.kt");
        }

        @Test
        @TestMetadata(value="emptyInterfaceWithSuper.kt")
        public void testEmptyInterfaceWithSuper() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/withCallableMembers/emptyInterfaceWithSuper.kt");
        }

        @Test
        @TestMetadata(value="nonEmptyClassWithSuper.kt")
        public void testNonEmptyClassWithSuper() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/withCallableMembers/nonEmptyClassWithSuper.kt");
        }

        @Test
        @TestMetadata(value="nonEmptyInterfaceWithSuper.kt")
        public void testNonEmptyInterfaceWithSuper() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/withCallableMembers/nonEmptyInterfaceWithSuper.kt");
        }

        @Test
        @TestMetadata(value="preresolvedComplexEmptyInterfaceWithSuper.kt")
        public void testPreresolvedComplexEmptyInterfaceWithSuper() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/withCallableMembers/preresolvedComplexEmptyInterfaceWithSuper.kt");
        }

        @Test
        @TestMetadata(value="preresolvedEmptyClassWithSuper.kt")
        public void testPreresolvedEmptyClassWithSuper() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/withCallableMembers/preresolvedEmptyClassWithSuper.kt");
        }

        @Test
        @TestMetadata(value="preresolvedEmptyInterfaceWithSuper.kt")
        public void testPreresolvedEmptyInterfaceWithSuper() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/withCallableMembers/preresolvedEmptyInterfaceWithSuper.kt");
        }

        @Test
        @TestMetadata(value="preresolvedNonEmptyClassWithSuper.kt")
        public void testPreresolvedNonEmptyClassWithSuper() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/withCallableMembers/preresolvedNonEmptyClassWithSuper.kt");
        }

        @Test
        @TestMetadata(value="preresolvedNonEmptyInterfaceWithSuper.kt")
        public void testPreresolvedNonEmptyInterfaceWithSuper() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/withCallableMembers/preresolvedNonEmptyInterfaceWithSuper.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolve/typeAliases")
    @TestDataPath(value="$PROJECT_ROOT")
    public class TypeAliases {
        @Test
        public void testAllFilesPresentInTypeAliases() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolve/typeAliases"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="typeAliasWithAnnotationOnType.kt")
        public void testTypeAliasWithAnnotationOnType() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/typeAliases/typeAliasWithAnnotationOnType.kt");
        }

        @Test
        @TestMetadata(value="typeAliasWithTypeParameters.kt")
        public void testTypeAliasWithTypeParameters() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/typeAliases/typeAliasWithTypeParameters.kt");
        }

        @Test
        @TestMetadata(value="typeAliasedConstructorCallWithUnderscoredTypeArgument.kt")
        public void testTypeAliasedConstructorCallWithUnderscoredTypeArgument() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/typeAliases/typeAliasedConstructorCallWithUnderscoredTypeArgument.kt");
        }

        @Test
        @TestMetadata(value="typeAliasedSamConstructorCallWithUnderscoredTypeArgument.kt")
        public void testTypeAliasedSamConstructorCallWithUnderscoredTypeArgument() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/typeAliases/typeAliasedSamConstructorCallWithUnderscoredTypeArgument.kt");
        }

        @Test
        @TestMetadata(value="unresolvedAnnotationOnTypeAlias.kt")
        public void testUnresolvedAnnotationOnTypeAlias() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/typeAliases/unresolvedAnnotationOnTypeAlias.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolve/syntheticProperties")
    @TestDataPath(value="$PROJECT_ROOT")
    public class SyntheticProperties {
        @Test
        public void testAllFilesPresentInSyntheticProperties() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolve/syntheticProperties"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="explicitReturnType.kt")
        public void testExplicitReturnType() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/syntheticProperties/explicitReturnType.kt");
        }

        @Test
        @TestMetadata(value="explicitReturnTypeAndAnnotations.kt")
        public void testExplicitReturnTypeAndAnnotations() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/syntheticProperties/explicitReturnTypeAndAnnotations.kt");
        }

        @Test
        @TestMetadata(value="explicitReturnTypeRecursiveResolve.kt")
        public void testExplicitReturnTypeRecursiveResolve() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/syntheticProperties/explicitReturnTypeRecursiveResolve.kt");
        }

        @Test
        @TestMetadata(value="explicitReturnTypeRecursiveResolveAsGetter.kt")
        public void testExplicitReturnTypeRecursiveResolveAsGetter() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/syntheticProperties/explicitReturnTypeRecursiveResolveAsGetter.kt");
        }

        @Test
        @TestMetadata(value="getterFromLibraryAndSetterFromSources.kt")
        public void testGetterFromLibraryAndSetterFromSources() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/syntheticProperties/getterFromLibraryAndSetterFromSources.kt");
        }

        @Test
        @TestMetadata(value="implicitReturnType.kt")
        public void testImplicitReturnType() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/syntheticProperties/implicitReturnType.kt");
        }

        @Test
        @TestMetadata(value="implicitReturnTypeAndAnnotations.kt")
        public void testImplicitReturnTypeAndAnnotations() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/syntheticProperties/implicitReturnTypeAndAnnotations.kt");
        }

        @Test
        @TestMetadata(value="implicitReturnTypeAndAnnotationsAsGetter.kt")
        public void testImplicitReturnTypeAndAnnotationsAsGetter() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/syntheticProperties/implicitReturnTypeAndAnnotationsAsGetter.kt");
        }

        @Test
        @TestMetadata(value="secondGenerationOverride.kt")
        public void testSecondGenerationOverride() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/syntheticProperties/secondGenerationOverride.kt");
        }

        @Test
        @TestMetadata(value="setterAndExplicitReturnType.kt")
        public void testSetterAndExplicitReturnType() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/syntheticProperties/setterAndExplicitReturnType.kt");
        }

        @Test
        @TestMetadata(value="setterAndExplicitReturnTypeAndAnnotations.kt")
        public void testSetterAndExplicitReturnTypeAndAnnotations() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/syntheticProperties/setterAndExplicitReturnTypeAndAnnotations.kt");
        }

        @Test
        @TestMetadata(value="setterAndExplicitReturnTypeAndAnnotationsAsGetter.kt")
        public void testSetterAndExplicitReturnTypeAndAnnotationsAsGetter() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/syntheticProperties/setterAndExplicitReturnTypeAndAnnotationsAsGetter.kt");
        }

        @Test
        @TestMetadata(value="setterAndExplicitReturnTypeAndAnnotationsAsSetter.kt")
        public void testSetterAndExplicitReturnTypeAndAnnotationsAsSetter() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/syntheticProperties/setterAndExplicitReturnTypeAndAnnotationsAsSetter.kt");
        }

        @Test
        @TestMetadata(value="setterFromLibraryAndGetterFromSources.kt")
        public void testSetterFromLibraryAndGetterFromSources() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/syntheticProperties/setterFromLibraryAndGetterFromSources.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolve/properties")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Properties {
        @Test
        public void testAllFilesPresentInProperties() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolve/properties"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="constCyclePropertyWithExplicitType.kt")
        public void testConstCyclePropertyWithExplicitType() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/constCyclePropertyWithExplicitType.kt");
        }

        @Test
        @TestMetadata(value="constErrorPropertyWithExplicitType.kt")
        public void testConstErrorPropertyWithExplicitType() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/constErrorPropertyWithExplicitType.kt");
        }

        @Test
        @TestMetadata(value="constPropertiesWithExplicitType.kt")
        public void testConstPropertiesWithExplicitType() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/constPropertiesWithExplicitType.kt");
        }

        @Test
        @TestMetadata(value="constPropertyWithExplicitTypeAndInitializer.kt")
        public void testConstPropertyWithExplicitTypeAndInitializer() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/constPropertyWithExplicitTypeAndInitializer.kt");
        }

        @Test
        @TestMetadata(value="constructorParameter.kt")
        public void testConstructorParameter() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/constructorParameter.kt");
        }

        @Test
        @TestMetadata(value="constructorParameterWithImplicitParameterAnnotation.kt")
        public void testConstructorParameterWithImplicitParameterAnnotation() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/constructorParameterWithImplicitParameterAnnotation.kt");
        }

        @Test
        @TestMetadata(value="delegateWithAnnotationOnAccessor.kt")
        public void testDelegateWithAnnotationOnAccessor() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/delegateWithAnnotationOnAccessor.kt");
        }

        @Test
        @TestMetadata(value="delegateWithAnnotationOnAccessorWithExplicitType.kt")
        public void testDelegateWithAnnotationOnAccessorWithExplicitType() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/delegateWithAnnotationOnAccessorWithExplicitType.kt");
        }

        @Test
        @TestMetadata(value="generatedPropertyFromParameter.kt")
        public void testGeneratedPropertyFromParameter() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/generatedPropertyFromParameter.kt");
        }

        @Test
        @TestMetadata(value="generatedPropertyFromParameterWithImplicitAnnotation.kt")
        public void testGeneratedPropertyFromParameterWithImplicitAnnotation() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/generatedPropertyFromParameterWithImplicitAnnotation.kt");
        }

        @Test
        @TestMetadata(value="getterWithDelegation.kt")
        public void testGetterWithDelegation() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/getterWithDelegation.kt");
        }

        @Test
        @TestMetadata(value="hierarchyWithOverride.kt")
        public void testHierarchyWithOverride() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/hierarchyWithOverride.kt");
        }

        @Test
        @TestMetadata(value="hierarchyWithOverrideAndNestedClass.kt")
        public void testHierarchyWithOverrideAndNestedClass() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/hierarchyWithOverrideAndNestedClass.kt");
        }

        @Test
        @TestMetadata(value="hierarchyWithOverrideAndNestedClass2.kt")
        public void testHierarchyWithOverrideAndNestedClass2() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/hierarchyWithOverrideAndNestedClass2.kt");
        }

        @Test
        @TestMetadata(value="hierarchyWithOverrideAndNestedClass3.kt")
        public void testHierarchyWithOverrideAndNestedClass3() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/hierarchyWithOverrideAndNestedClass3.kt");
        }

        @Test
        @TestMetadata(value="hierarchyWithOverrideAndNestedClass4.kt")
        public void testHierarchyWithOverrideAndNestedClass4() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/hierarchyWithOverrideAndNestedClass4.kt");
        }

        @Test
        @TestMetadata(value="impliciyTypeWithAnnotationOnFunction.kt")
        public void testImpliciyTypeWithAnnotationOnFunction() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/impliciyTypeWithAnnotationOnFunction.kt");
        }

        @Test
        @TestMetadata(value="impliciyTypeWithAnnotationOnProperty.kt")
        public void testImpliciyTypeWithAnnotationOnProperty() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/impliciyTypeWithAnnotationOnProperty.kt");
        }

        @Test
        @TestMetadata(value="propertyGetterWithExplicitType.kt")
        public void testPropertyGetterWithExplicitType() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/propertyGetterWithExplicitType.kt");
        }

        @Test
        @TestMetadata(value="propertyGetterWithExplicitTypeAndBody.kt")
        public void testPropertyGetterWithExplicitTypeAndBody() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/propertyGetterWithExplicitTypeAndBody.kt");
        }

        @Test
        @TestMetadata(value="propertyGetterWithImplicitType.kt")
        public void testPropertyGetterWithImplicitType() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/propertyGetterWithImplicitType.kt");
        }

        @Test
        @TestMetadata(value="propertySetter.kt")
        public void testPropertySetter() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/propertySetter.kt");
        }

        @Test
        @TestMetadata(value="propertyWithTypeParameters.kt")
        public void testPropertyWithTypeParameters() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/propertyWithTypeParameters.kt");
        }

        @Test
        @TestMetadata(value="simpleLoopInOverride.kt")
        public void testSimpleLoopInOverride() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/simpleLoopInOverride.kt");
        }

        @Test
        @TestMetadata(value="simpleLoopInOverride2.kt")
        public void testSimpleLoopInOverride2() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/simpleLoopInOverride2.kt");
        }

        @Test
        @TestMetadata(value="typeParameterAnnotations.kt")
        public void testTypeParameterAnnotations() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/typeParameterAnnotations.kt");
        }

        @Test
        @TestMetadata(value="unresolvedAnnotationOnPropertyType.kt")
        public void testUnresolvedAnnotationOnPropertyType() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/unresolvedAnnotationOnPropertyType.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolve/noRuntime")
    @TestDataPath(value="$PROJECT_ROOT")
    public class NoRuntime {
        @Test
        public void testAllFilesPresentInNoRuntime() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolve/noRuntime"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="arrayOfCall.kt")
        public void testArrayOfCall() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/noRuntime/arrayOfCall.kt");
        }

        @Test
        @TestMetadata(value="integerLiteralCall.kt")
        public void testIntegerLiteralCall() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/noRuntime/integerLiteralCall.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolve/functions")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Functions {
        @Test
        @TestMetadata(value="actualOverride.kt")
        public void testActualOverride() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/actualOverride.kt");
        }

        @Test
        public void testAllFilesPresentInFunctions() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolve/functions"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="classpathSubstitution.kt")
        public void testClasspathSubstitution() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/classpathSubstitution.kt");
        }

        @Test
        @TestMetadata(value="classpathSubstitution2.kt")
        public void testClasspathSubstitution2() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/classpathSubstitution2.kt");
        }

        @Test
        @TestMetadata(value="classpathSubstitutionWithLibraryClass.kt")
        public void testClasspathSubstitutionWithLibraryClass() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/classpathSubstitutionWithLibraryClass.kt");
        }

        @Test
        @TestMetadata(value="classpathSubstitutionWithPreresolvedClass.kt")
        public void testClasspathSubstitutionWithPreresolvedClass() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/classpathSubstitutionWithPreresolvedClass.kt");
        }

        @Test
        @TestMetadata(value="contract.kt")
        public void testContract() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/contract.kt");
        }

        @Test
        @TestMetadata(value="functionCallWithGenericResult.kt")
        public void testFunctionCallWithGenericResult() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/functionCallWithGenericResult.kt");
        }

        @Test
        @TestMetadata(value="functionParameter.kt")
        public void testFunctionParameter() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/functionParameter.kt");
        }

        @Test
        @TestMetadata(value="functionTypeParameter.kt")
        public void testFunctionTypeParameter() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/functionTypeParameter.kt");
        }

        @Test
        @TestMetadata(value="functionWithGenericExpectedTypeInside.kt")
        public void testFunctionWithGenericExpectedTypeInside() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/functionWithGenericExpectedTypeInside.kt");
        }

        @Test
        @TestMetadata(value="functionWithTypeParameters.kt")
        public void testFunctionWithTypeParameters() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/functionWithTypeParameters.kt");
        }

        @Test
        @TestMetadata(value="hierarchyWithOverride.kt")
        public void testHierarchyWithOverride() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/hierarchyWithOverride.kt");
        }

        @Test
        @TestMetadata(value="hierarchyWithOverrideAndNestedClass.kt")
        public void testHierarchyWithOverrideAndNestedClass() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/hierarchyWithOverrideAndNestedClass.kt");
        }

        @Test
        @TestMetadata(value="hierarchyWithOverrideAndNestedClass2.kt")
        public void testHierarchyWithOverrideAndNestedClass2() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/hierarchyWithOverrideAndNestedClass2.kt");
        }

        @Test
        @TestMetadata(value="hierarchyWithOverrideAndNestedClass3.kt")
        public void testHierarchyWithOverrideAndNestedClass3() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/hierarchyWithOverrideAndNestedClass3.kt");
        }

        @Test
        @TestMetadata(value="implicitTypeFromFunctionWithDuplicatedName.kt")
        public void testImplicitTypeFromFunctionWithDuplicatedName() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/implicitTypeFromFunctionWithDuplicatedName.kt");
        }

        @Test
        @TestMetadata(value="incompleteFunctionTypeParameter.kt")
        public void testIncompleteFunctionTypeParameter() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/incompleteFunctionTypeParameter.kt");
        }

        @Test
        @TestMetadata(value="javaAnnotationWithDefaultValueForenumArray.kt")
        public void testJavaAnnotationWithDefaultValueForenumArray() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/javaAnnotationWithDefaultValueForenumArray.kt");
        }

        @Test
        @TestMetadata(value="multiLevelClasspathSubstitution.kt")
        public void testMultiLevelClasspathSubstitution() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/multiLevelClasspathSubstitution.kt");
        }

        @Test
        @TestMetadata(value="multiLevelClasspathSubstitution2.kt")
        public void testMultiLevelClasspathSubstitution2() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/multiLevelClasspathSubstitution2.kt");
        }

        @Test
        @TestMetadata(value="overrideWithTransitiveClass.kt")
        public void testOverrideWithTransitiveClass() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/overrideWithTransitiveClass.kt");
        }

        @Test
        @TestMetadata(value="overrideWithTransitiveClassWithPreresolvedClass.kt")
        public void testOverrideWithTransitiveClassWithPreresolvedClass() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/overrideWithTransitiveClassWithPreresolvedClass.kt");
        }

        @Test
        @TestMetadata(value="preresolvedMultiLevelClasspathSubstitution.kt")
        public void testPreresolvedMultiLevelClasspathSubstitution() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/preresolvedMultiLevelClasspathSubstitution.kt");
        }

        @Test
        @TestMetadata(value="simpleLoopInOverride.kt")
        public void testSimpleLoopInOverride() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/simpleLoopInOverride.kt");
        }

        @Test
        @TestMetadata(value="simpleLoopInOverride2.kt")
        public void testSimpleLoopInOverride2() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/simpleLoopInOverride2.kt");
        }

        @Test
        @TestMetadata(value="superTypeCallNameClash.kt")
        public void testSuperTypeCallNameClash() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/superTypeCallNameClash.kt");
        }

        @Test
        @TestMetadata(value="superTypeCallNameClashImplicitConstructor.kt")
        public void testSuperTypeCallNameClashImplicitConstructor() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/superTypeCallNameClashImplicitConstructor.kt");
        }

        @Test
        @TestMetadata(value="superTypeCallNestedNameClash.kt")
        public void testSuperTypeCallNestedNameClash() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/superTypeCallNestedNameClash.kt");
        }

        @Test
        @TestMetadata(value="superTypeCallNestedNameClashImplicitConstructor.kt")
        public void testSuperTypeCallNestedNameClashImplicitConstructor() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/superTypeCallNestedNameClashImplicitConstructor.kt");
        }

        @Test
        @TestMetadata(value="transitiveSubstitutionFakeOverride.kt")
        public void testTransitiveSubstitutionFakeOverride() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/transitiveSubstitutionFakeOverride.kt");
        }

        @Test
        @TestMetadata(value="typeArgumentInAnnotation.kt")
        public void testTypeArgumentInAnnotation() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/typeArgumentInAnnotation.kt");
        }

        @Test
        @TestMetadata(value="unresolvedAnnotationOnFunctionType.kt")
        public void testUnresolvedAnnotationOnFunctionType() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/unresolvedAnnotationOnFunctionType.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolve/errors")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Errors {
        @Test
        public void testAllFilesPresentInErrors() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolve/errors"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="annotationWithNamedFunctionArgument.kt")
        public void testAnnotationWithNamedFunctionArgument() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/errors/annotationWithNamedFunctionArgument.kt");
        }

        @Test
        @TestMetadata(value="anonymousObjectInInvalidPosition.kt")
        public void testAnonymousObjectInInvalidPosition() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/errors/anonymousObjectInInvalidPosition.kt");
        }

        @Test
        @TestMetadata(value="classLevelDanglingAnnotationWithNestedDeclarations.kt")
        public void testClassLevelDanglingAnnotationWithNestedDeclarations() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/errors/classLevelDanglingAnnotationWithNestedDeclarations.kt");
        }

        @Test
        @TestMetadata(value="classLevelDeprecatedDanglingAnnotationWithNestedDeclarations.kt")
        public void testClassLevelDeprecatedDanglingAnnotationWithNestedDeclarations() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/errors/classLevelDeprecatedDanglingAnnotationWithNestedDeclarations.kt");
        }

        @Test
        @TestMetadata(value="danglingAnnotationWithNestedDeclarations.kt")
        public void testDanglingAnnotationWithNestedDeclarations() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/errors/danglingAnnotationWithNestedDeclarations.kt");
        }

        @Test
        @TestMetadata(value="deprecatedDanglingAnnotationWithNestedDeclarations.kt")
        public void testDeprecatedDanglingAnnotationWithNestedDeclarations() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/errors/deprecatedDanglingAnnotationWithNestedDeclarations.kt");
        }

        @Test
        @TestMetadata(value="parameterNoType.kt")
        public void testParameterNoType() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/errors/parameterNoType.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolve/classes")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Classes {
        @Test
        @TestMetadata(value="actual.kt")
        public void testActual() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/actual.kt");
        }

        @Test
        public void testAllFilesPresentInClasses() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolve/classes"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="annotationWithArgumentInsideSuperTypeCall.kt")
        public void testAnnotationWithArgumentInsideSuperTypeCall() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/annotationWithArgumentInsideSuperTypeCall.kt");
        }

        @Test
        @TestMetadata(value="annotationWithArgumentInsideSuperTypeCallUnresolved.kt")
        public void testAnnotationWithArgumentInsideSuperTypeCallUnresolved() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/annotationWithArgumentInsideSuperTypeCallUnresolved.kt");
        }

        @Test
        @TestMetadata(value="annotationWithConstantFromNestedClass.kt")
        public void testAnnotationWithConstantFromNestedClass() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/annotationWithConstantFromNestedClass.kt");
        }

        @Test
        @TestMetadata(value="annotationWithTarget.kt")
        public void testAnnotationWithTarget() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/annotationWithTarget.kt");
        }

        @Test
        @TestMetadata(value="classDelegatedInCommonCode.kt")
        public void testClassDelegatedInCommonCode() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/classDelegatedInCommonCode.kt");
        }

        @Test
        @TestMetadata(value="classWithTypeParameters.kt")
        public void testClassWithTypeParameters() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/classWithTypeParameters.kt");
        }

        @Test
        @TestMetadata(value="classpathSubstitution.kt")
        public void testClasspathSubstitution() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/classpathSubstitution.kt");
        }

        @Test
        @TestMetadata(value="compilerRequiredAnnotationConflict.kt")
        public void testCompilerRequiredAnnotationConflict() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/compilerRequiredAnnotationConflict.kt");
        }

        @Test
        @TestMetadata(value="compilerRequiredAnnotationConflict2.kt")
        public void testCompilerRequiredAnnotationConflict2() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/compilerRequiredAnnotationConflict2.kt");
        }

        @Test
        @TestMetadata(value="complexEmptyInterfaceWithSuper.kt")
        public void testComplexEmptyInterfaceWithSuper() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/complexEmptyInterfaceWithSuper.kt");
        }

        @Test
        @TestMetadata(value="cyclicSupertypeWithClasspathSubstitution.kt")
        public void testCyclicSupertypeWithClasspathSubstitution() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/cyclicSupertypeWithClasspathSubstitution.kt");
        }

        @Test
        @TestMetadata(value="cyclicSupertypeWithClasspathSubstitution2.kt")
        public void testCyclicSupertypeWithClasspathSubstitution2() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/cyclicSupertypeWithClasspathSubstitution2.kt");
        }

        @Test
        @TestMetadata(value="cyclicSupertypeWithClasspathSubstitutionAsLibrary.kt")
        public void testCyclicSupertypeWithClasspathSubstitutionAsLibrary() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/cyclicSupertypeWithClasspathSubstitutionAsLibrary.kt");
        }

        @Test
        @TestMetadata(value="cyclicSupertypeWithClasspathSubstitutionAsLibrary2.kt")
        public void testCyclicSupertypeWithClasspathSubstitutionAsLibrary2() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/cyclicSupertypeWithClasspathSubstitutionAsLibrary2.kt");
        }

        @Test
        @TestMetadata(value="cyclicSupertypeWithClasspathSubstitutionOnEachLevelFromBottom.kt")
        public void testCyclicSupertypeWithClasspathSubstitutionOnEachLevelFromBottom() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/cyclicSupertypeWithClasspathSubstitutionOnEachLevelFromBottom.kt");
        }

        @Test
        @TestMetadata(value="cyclicSupertypeWithClasspathSubstitutionOnEachLevelFromBottomBase.kt")
        public void testCyclicSupertypeWithClasspathSubstitutionOnEachLevelFromBottomBase() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/cyclicSupertypeWithClasspathSubstitutionOnEachLevelFromBottomBase.kt");
        }

        @Test
        @TestMetadata(value="cyclicSupertypeWithClasspathSubstitutionOnEachLevelFromBottomBaseWithLibrary.kt")
        public void testCyclicSupertypeWithClasspathSubstitutionOnEachLevelFromBottomBaseWithLibrary() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/cyclicSupertypeWithClasspathSubstitutionOnEachLevelFromBottomBaseWithLibrary.kt");
        }

        @Test
        @TestMetadata(value="cyclicSupertypeWithClasspathSubstitutionOnEachLevelFromBottomWithAlias.kt")
        public void testCyclicSupertypeWithClasspathSubstitutionOnEachLevelFromBottomWithAlias() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/cyclicSupertypeWithClasspathSubstitutionOnEachLevelFromBottomWithAlias.kt");
        }

        @Test
        @TestMetadata(value="cyclicSupertypeWithClasspathSubstitutionOnEachLevelFromBottomWithAliasWithLibrary.kt")
        public void testCyclicSupertypeWithClasspathSubstitutionOnEachLevelFromBottomWithAliasWithLibrary() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/cyclicSupertypeWithClasspathSubstitutionOnEachLevelFromBottomWithAliasWithLibrary.kt");
        }

        @Test
        @TestMetadata(value="cyclicSupertypeWithClasspathSubstitutionOnEachLevelFromBottomWithLibrary.kt")
        public void testCyclicSupertypeWithClasspathSubstitutionOnEachLevelFromBottomWithLibrary() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/cyclicSupertypeWithClasspathSubstitutionOnEachLevelFromBottomWithLibrary.kt");
        }

        @Test
        @TestMetadata(value="cyclicSupertypeWithClasspathSubstitutionOnEachLevelFromMiddle.kt")
        public void testCyclicSupertypeWithClasspathSubstitutionOnEachLevelFromMiddle() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/cyclicSupertypeWithClasspathSubstitutionOnEachLevelFromMiddle.kt");
        }

        @Test
        @TestMetadata(value="cyclicSupertypeWithClasspathSubstitutionOnEachLevelFromMiddleBase.kt")
        public void testCyclicSupertypeWithClasspathSubstitutionOnEachLevelFromMiddleBase() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/cyclicSupertypeWithClasspathSubstitutionOnEachLevelFromMiddleBase.kt");
        }

        @Test
        @TestMetadata(value="cyclicSupertypeWithClasspathSubstitutionOnEachLevelFromTopBase.kt")
        public void testCyclicSupertypeWithClasspathSubstitutionOnEachLevelFromTopBase() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/cyclicSupertypeWithClasspathSubstitutionOnEachLevelFromTopBase.kt");
        }

        @Test
        @TestMetadata(value="cyclicSupertypeWithClasspathSubstitutionOnEachLevelFromTopmost.kt")
        public void testCyclicSupertypeWithClasspathSubstitutionOnEachLevelFromTopmost() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/cyclicSupertypeWithClasspathSubstitutionOnEachLevelFromTopmost.kt");
        }

        @Test
        @TestMetadata(value="cyclicSupertypeWithClasspathSubstitutionOnEachLevelFromTopmostBase.kt")
        public void testCyclicSupertypeWithClasspathSubstitutionOnEachLevelFromTopmostBase() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/cyclicSupertypeWithClasspathSubstitutionOnEachLevelFromTopmostBase.kt");
        }

        @Test
        @TestMetadata(value="deprecatedSinceKotlin.kt")
        public void testDeprecatedSinceKotlin() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/deprecatedSinceKotlin.kt");
        }

        @Test
        @TestMetadata(value="emptyClassWithSuper.kt")
        public void testEmptyClassWithSuper() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/emptyClassWithSuper.kt");
        }

        @Test
        @TestMetadata(value="emptyInterfaceWithSuper.kt")
        public void testEmptyInterfaceWithSuper() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/emptyInterfaceWithSuper.kt");
        }

        @Test
        @TestMetadata(value="expectWithSuperClass.kt")
        public void testExpectWithSuperClass() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/expectWithSuperClass.kt");
        }

        @Test
        @TestMetadata(value="functionInValueClass.kt")
        public void testFunctionInValueClass() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/functionInValueClass.kt");
        }

        @Test
        @TestMetadata(value="hierarchyWithOverride.kt")
        public void testHierarchyWithOverride() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/hierarchyWithOverride.kt");
        }

        @Test
        @TestMetadata(value="hierarchyWithOverrideAndNestedClass.kt")
        public void testHierarchyWithOverrideAndNestedClass() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/hierarchyWithOverrideAndNestedClass.kt");
        }

        @Test
        @TestMetadata(value="hierarchyWithOverrideAndNestedClass2.kt")
        public void testHierarchyWithOverrideAndNestedClass2() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/hierarchyWithOverrideAndNestedClass2.kt");
        }

        @Test
        @TestMetadata(value="hierarchyWithOverrideAndNestedClass3.kt")
        public void testHierarchyWithOverrideAndNestedClass3() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/hierarchyWithOverrideAndNestedClass3.kt");
        }

        @Test
        @TestMetadata(value="hierarchyWithOverrideAndNestedClass4.kt")
        public void testHierarchyWithOverrideAndNestedClass4() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/hierarchyWithOverrideAndNestedClass4.kt");
        }

        @Test
        @TestMetadata(value="multiFieldValueClass.kt")
        public void testMultiFieldValueClass() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/multiFieldValueClass.kt");
        }

        @Test
        @TestMetadata(value="multiFieldValueClassWithTypeAlias.kt")
        public void testMultiFieldValueClassWithTypeAlias() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/multiFieldValueClassWithTypeAlias.kt");
        }

        @Test
        @TestMetadata(value="multiLevelClasspathSubstitution.kt")
        public void testMultiLevelClasspathSubstitution() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/multiLevelClasspathSubstitution.kt");
        }

        @Test
        @TestMetadata(value="nestedClass.kt")
        public void testNestedClass() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/nestedClass.kt");
        }

        @Test
        @TestMetadata(value="nestedClassWithPropertiesOverrides.kt")
        public void testNestedClassWithPropertiesOverrides() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/nestedClassWithPropertiesOverrides.kt");
        }

        @Test
        @TestMetadata(value="nonEmptyClassWithSuper.kt")
        public void testNonEmptyClassWithSuper() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/nonEmptyClassWithSuper.kt");
        }

        @Test
        @TestMetadata(value="nonEmptyInterfaceWithSuper.kt")
        public void testNonEmptyInterfaceWithSuper() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/nonEmptyInterfaceWithSuper.kt");
        }

        @Test
        @TestMetadata(value="recursiveValueClass.kt")
        public void testRecursiveValueClass() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/recursiveValueClass.kt");
        }

        @Test
        @TestMetadata(value="recursiveValueClass2.kt")
        public void testRecursiveValueClass2() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/recursiveValueClass2.kt");
        }

        @Test
        @TestMetadata(value="simpleLoopInOverride.kt")
        public void testSimpleLoopInOverride() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/simpleLoopInOverride.kt");
        }

        @Test
        @TestMetadata(value="simpleLoopInOverride2.kt")
        public void testSimpleLoopInOverride2() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/simpleLoopInOverride2.kt");
        }

        @Test
        @TestMetadata(value="sinceKotlin.kt")
        public void testSinceKotlin() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/sinceKotlin.kt");
        }

        @Test
        @TestMetadata(value="superTypeCallNameClash.kt")
        public void testSuperTypeCallNameClash() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/superTypeCallNameClash.kt");
        }

        @Test
        @TestMetadata(value="superTypeCallNameClashImplicitConstructor.kt")
        public void testSuperTypeCallNameClashImplicitConstructor() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/superTypeCallNameClashImplicitConstructor.kt");
        }

        @Test
        @TestMetadata(value="superTypeCallNestedNameClash.kt")
        public void testSuperTypeCallNestedNameClash() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/superTypeCallNestedNameClash.kt");
        }

        @Test
        @TestMetadata(value="superTypeCallNestedNameClashImplicitConstructor.kt")
        public void testSuperTypeCallNestedNameClashImplicitConstructor() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/superTypeCallNestedNameClashImplicitConstructor.kt");
        }

        @Test
        @TestMetadata(value="valueClassWithAnotherValueClass.kt")
        public void testValueClassWithAnotherValueClass() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/valueClassWithAnotherValueClass.kt");
        }

        @Test
        @TestMetadata(value="valueClassWithMultiFieldValueClass.kt")
        public void testValueClassWithMultiFieldValueClass() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/valueClassWithMultiFieldValueClass.kt");
        }

        @Test
        @TestMetadata(value="valueClassWithNestedClass.kt")
        public void testValueClassWithNestedClass() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/valueClassWithNestedClass.kt");
        }

        @Test
        @TestMetadata(value="valueClassWithNullableMultiFieldValueClass.kt")
        public void testValueClassWithNullableMultiFieldValueClass() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/valueClassWithNullableMultiFieldValueClass.kt");
        }

        @Test
        @TestMetadata(value="valueClassWithParameterizedAlias.kt")
        public void testValueClassWithParameterizedAlias() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/valueClassWithParameterizedAlias.kt");
        }

        @Test
        @TestMetadata(value="valueClassWithTypeAliasOnAnotherValueClass.kt")
        public void testValueClassWithTypeAliasOnAnotherValueClass() {
            FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/valueClassWithTypeAliasOnAnotherValueClass.kt");
        }

        @Nested
        @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolve/classes/dataClass")
        @TestDataPath(value="$PROJECT_ROOT")
        public class DataClass {
            @Test
            public void testAllFilesPresentInDataClass() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolve/classes/dataClass"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
            }

            @Test
            @TestMetadata(value="component1TypeCollision.kt")
            public void testComponent1TypeCollision() {
                FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/dataClass/component1TypeCollision.kt");
            }

            @Test
            @TestMetadata(value="copyTypeCollision.kt")
            public void testCopyTypeCollision() {
                FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/dataClass/copyTypeCollision.kt");
            }

            @Test
            @TestMetadata(value="dataClassComponent1.kt")
            public void testDataClassComponent1() {
                FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/dataClass/dataClassComponent1.kt");
            }

            @Test
            @TestMetadata(value="dataClassConstructor.kt")
            public void testDataClassConstructor() {
                FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/dataClass/dataClassConstructor.kt");
            }

            @Test
            @TestMetadata(value="dataClassCopy.kt")
            public void testDataClassCopy() {
                FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/dataClass/dataClassCopy.kt");
            }

            @Test
            @TestMetadata(value="dataClassProperty.kt")
            public void testDataClassProperty() {
                FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/dataClass/dataClassProperty.kt");
            }

            @Test
            @TestMetadata(value="parameterTypeCollision.kt")
            public void testParameterTypeCollision() {
                FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/dataClass/parameterTypeCollision.kt");
            }

            @Test
            @TestMetadata(value="propertyTypeCollision.kt")
            public void testPropertyTypeCollision() {
                FirOutOfContentRootLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/dataClass/propertyTypeCollision.kt");
            }
        }
    }
}

