/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.impl.base.test.cases.symbols;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaFileSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbolLocationKt;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbolOrigin;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtilKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.test.services.AssertionsKt;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a.\u0010\t\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0005\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a8\u0006\u000f"}, d2={"checkContainingFileSymbol", "", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "ktFileSymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaFileSymbol;", "symbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaSymbol;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "checkContainingJvmClassName", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "ktClass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaCallableSymbol;", "analysis-api-impl-base_test"})
public final class SymbolTestUtilsKt {
    public static final void checkContainingFileSymbol(@NotNull KaSession $this$checkContainingFileSymbol, @NotNull KaFileSymbol ktFileSymbol, @NotNull KaSymbol symbol, @NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)$this$checkContainingFileSymbol, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)ktFileSymbol, (String)"ktFileSymbol");
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        if (symbol.getOrigin() != KaSymbolOrigin.SOURCE) {
            return;
        }
        KaFileSymbol containingFileSymbol = $this$checkContainingFileSymbol.getContainingFile(symbol);
        AssertionsKt.getAssertions((TestServices)testServices).assertEquals((Object)ktFileSymbol, (Object)containingFileSymbol, () -> SymbolTestUtilsKt.checkContainingFileSymbol$lambda$0(symbol, ktFileSymbol, containingFileSymbol));
    }

    public static final void checkContainingJvmClassName(@NotNull KaSession $this$checkContainingJvmClassName, @NotNull KtFile ktFile, @Nullable KtClassOrObject ktClass, @NotNull KaCallableSymbol symbol, @NotNull TestServices testServices) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$checkContainingJvmClassName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)ktFile, (String)"ktFile");
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        if (ktFile.isScript()) {
            return;
        }
        if (KaSymbolLocationKt.isLocal((KaSymbol)((KaSymbol)symbol))) {
            string = null;
        } else if (ktClass != null) {
            ClassId classId = ktClass.getClassId();
            string = classId != null ? classId.asFqNameString() : null;
        } else {
            string = JvmFileClassUtilKt.getJavaFileFacadeFqName((KtFile)ktFile).asString();
        }
        String expectedClassName = string;
        String actualClassName = $this$checkContainingJvmClassName.getContainingJvmClassName(symbol);
        AssertionsKt.getAssertions((TestServices)testServices).assertEquals((Object)expectedClassName, (Object)actualClassName, () -> SymbolTestUtilsKt.checkContainingJvmClassName$lambda$1(symbol, expectedClassName, actualClassName));
    }

    private static final String checkContainingFileSymbol$lambda$0(KaSymbol $symbol, KaFileSymbol $ktFileSymbol, KaFileSymbol $containingFileSymbol) {
        return "Invalid file for " + $symbol + ", expected " + $ktFileSymbol + " but " + $containingFileSymbol + " found";
    }

    private static final String checkContainingJvmClassName$lambda$1(KaCallableSymbol $symbol, String $expectedClassName, String $actualClassName) {
        return "Invalid JvmClassName for " + $symbol + ", expected " + $expectedClassName + " but " + $actualClassName + " found";
    }
}

