/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.low.level.api.fir.ElementContextRenderer;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.LLFirResolveSession;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.LowLevelFirApiFacadeKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSession;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.ContextCollector;
import org.jetbrains.kotlin.analysis.test.framework.base.AbstractAnalysisApiBasedTest;
import org.jetbrains.kotlin.analysis.test.framework.projectStructure.KtTestModule;
import org.jetbrains.kotlin.analysis.test.framework.services.ExpressionMarkersSourceFilePreprocessorKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.renderer.FirRenderer;
import org.jetbrains.kotlin.fir.resolve.SessionHolder;
import org.jetbrains.kotlin.fir.resolve.SessionHolderImpl;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.test.services.AssertionsKt;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007H\u0002J6\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/AbstractContextCollectorTest;", "Lorg/jetbrains/kotlin/analysis/test/framework/base/AbstractAnalysisApiBasedTest;", "<init>", "()V", "doTestByMainFile", "", "mainFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "mainModule", "Lorg/jetbrains/kotlin/analysis/test/framework/projectStructure/KtTestModule;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "createFileCopy", "file", "performTestByMainFile", "testPrefixes", "", "", "useBodyElement", "", "low-level-api-fir_test"})
public abstract class AbstractContextCollectorTest
extends AbstractAnalysisApiBasedTest {
    @Override
    protected void doTestByMainFile(@NotNull KtFile mainFile, @NotNull KtTestModule mainModule, @NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)mainFile, (String)"mainFile");
        Intrinsics.checkNotNullParameter((Object)mainModule, (String)"mainModule");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        this.performTestByMainFile(mainFile, mainModule, testServices, CollectionsKt.emptyList(), false);
        this.performTestByMainFile(mainFile, mainModule, testServices, CollectionsKt.listOf((Object)"body"), true);
        KtFile fakeFile = this.createFileCopy(mainFile);
        this.performTestByMainFile(fakeFile, mainModule, testServices, CollectionsKt.listOf((Object)"copy"), false);
        Object[] objectArray = new String[]{"body.copy", "copy"};
        this.performTestByMainFile(fakeFile, mainModule, testServices, CollectionsKt.listOf((Object[])objectArray), true);
    }

    private final KtFile createFileCopy(KtFile file) {
        PsiElement psiElement = file.copy();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        KtFile fakeFile = (KtFile)psiElement;
        boolean bl = Intrinsics.areEqual((Object)fakeFile.getOriginalFile(), (Object)file);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        boolean bl2 = bl = !fakeFile.isPhysical();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        boolean bl3 = bl = !fakeFile.getViewProvider().isEventSystemEnabled();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        return fakeFile;
    }

    private final void performTestByMainFile(KtFile mainFile, KtTestModule mainModule, TestServices testServices, List<String> testPrefixes, boolean useBodyElement) {
        StringBuilder stringBuilder;
        KaModule kaModule = mainModule.getKtModule();
        Project project = mainFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        LLFirResolveSession resolveSession = LowLevelFirApiFacadeKt.getFirResolveSession((KaModule)kaModule, (Project)project);
        LLFirSession session = resolveSession.getUseSiteFirSession();
        SessionHolderImpl sessionHolder = new SessionHolderImpl((FirSession)session, session.getScopeSession());
        FirFile firFile = LowLevelFirApiFacadeKt.getOrBuildFirFile((KtFile)mainFile, (LLFirResolveSession)resolveSession);
        KtElement targetElement = ExpressionMarkersSourceFilePreprocessorKt.getExpressionMarkerProvider(testServices).getBottommostSelectedElementOfType(mainFile, KtElement.class);
        KtElement bodyElement = useBodyElement ? targetElement : null;
        ContextCollector.Context context = ContextCollector.INSTANCE.process(firFile, (SessionHolder)sessionHolder, (PsiElement)targetElement, (PsiElement)bodyElement);
        if (context == null) {
            throw new IllegalStateException(("Context not found for element " + targetElement).toString());
        }
        ContextCollector.Context elementContext = context;
        FirRenderer firRenderer = FirRenderer.Companion.withResolvePhase();
        StringBuilder $this$performTestByMainFile_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        ElementContextRenderer.INSTANCE.render(elementContext, $this$performTestByMainFile_u24lambda_u240);
        $this$performTestByMainFile_u24lambda_u240.append('\n');
        $this$performTestByMainFile_u24lambda_u240.append(firRenderer.renderElementAsString((FirElement)firFile, true));
        String actualText2 = stringBuilder.toString();
        AbstractAnalysisApiBasedTest.assertEqualsToTestDataFileSibling$default((AbstractAnalysisApiBasedTest)this, AssertionsKt.getAssertions((TestServices)testServices), actualText2, null, testPrefixes, 2, null);
    }
}

