/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.test.framework.base;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.projectStructure.DanglingFilesKt;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaDanglingFileResolutionMode;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.analysis.test.framework.AnalysisApiTestDirectives;
import org.jetbrains.kotlin.analysis.test.framework.TestWithDisposable;
import org.jetbrains.kotlin.analysis.test.framework.base.AbstractAnalysisApiBasedTest;
import org.jetbrains.kotlin.analysis.test.framework.base.RegisterBaseTestServicesKt;
import org.jetbrains.kotlin.analysis.test.framework.projectStructure.AnalysisApiKtTestModuleStructureProviderKt;
import org.jetbrains.kotlin.analysis.test.framework.projectStructure.KtTestModule;
import org.jetbrains.kotlin.analysis.test.framework.services.ExpressionMarkerProvider;
import org.jetbrains.kotlin.analysis.test.framework.services.ExpressionMarkersSourceFilePreprocessorKt;
import org.jetbrains.kotlin.analysis.test.framework.services.libraries.TestModuleCompiler;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiTestConfigurator;
import org.jetbrains.kotlin.analysis.test.framework.utils.CommonTestUtilsKt;
import org.jetbrains.kotlin.analysis.test.framework.utils.SkipTestException;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.TestConfiguration;
import org.jetbrains.kotlin.test.builders.DefaultsProviderBuilder;
import org.jetbrains.kotlin.test.builders.TestConfigurationBuilder;
import org.jetbrains.kotlin.test.directives.JvmEnvironmentConfigurationDirectives;
import org.jetbrains.kotlin.test.directives.model.Directive;
import org.jetbrains.kotlin.test.directives.model.DirectiveKt;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectives;
import org.jetbrains.kotlin.test.directives.model.SimpleDirectivesContainer;
import org.jetbrains.kotlin.test.directives.model.StringDirective;
import org.jetbrains.kotlin.test.model.DependencyKind;
import org.jetbrains.kotlin.test.model.FrontendKind;
import org.jetbrains.kotlin.test.model.FrontendKinds;
import org.jetbrains.kotlin.test.model.ResultingArtifact;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.runners.AbstractKotlinCompilerTest;
import org.jetbrains.kotlin.test.services.AssertionsService;
import org.jetbrains.kotlin.test.services.DependencyProvider;
import org.jetbrains.kotlin.test.services.DependencyProviderImpl;
import org.jetbrains.kotlin.test.services.JUnit5Assertions;
import org.jetbrains.kotlin.test.services.KotlinTestInfo;
import org.jetbrains.kotlin.test.services.PreAnalysisHandler;
import org.jetbrains.kotlin.test.services.ServiceRegistrationData;
import org.jetbrains.kotlin.test.services.TemporaryDirectoryManager;
import org.jetbrains.kotlin.test.services.TemporaryDirectoryManagerKt;
import org.jetbrains.kotlin.test.services.TestModuleStructure;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestService;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.services.TestServicesKt;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001\\B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\"\u0010\u0010\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0010\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020 H\u0014J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u000e\u001a\u00020\u000fH\u0004J\u0012\u0010#\u001a\u0004\u0018\u00010\"2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0004J\u0018\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J$\u0010(\u001a\u0004\u0018\u00010\u000b2\u0006\u0010'\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010)\u001a\u00020&H\u0004J \u0010/\u001a\u00020&2\u0006\u00100\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J*\u00101\u001a\u00020\t*\u0002022\u0006\u00103\u001a\u00020+2\b\b\u0002\u00104\u001a\u00020+2\n\b\u0002\u00105\u001a\u0004\u0018\u00010+H\u0004J,\u00101\u001a\u00020\t*\u0002022\u0006\u00103\u001a\u00020+2\b\b\u0002\u00104\u001a\u00020+2\f\u00106\u001a\b\u0012\u0004\u0012\u00020+07H\u0004J\u001e\u00108\u001a\u00020\u00152\b\b\u0002\u00104\u001a\u00020+2\n\b\u0002\u00105\u001a\u0004\u0018\u00010+H\u0004J\u001c\u00109\u001a\u0004\u0018\u00010\u00152\b\b\u0002\u00104\u001a\u00020+2\u0006\u00105\u001a\u00020+H\u0002J\u0012\u0010:\u001a\u00020\u00152\b\b\u0002\u00104\u001a\u00020+H\u0002J\u0010\u0010?\u001a\u00020\t2\u0006\u0010@\u001a\u00020+H\u0004J\b\u0010A\u001a\u00020\tH\u0007J\b\u0010B\u001a\u00020CH\u0002J\u0010\u0010D\u001a\u00020\t2\u0006\u0010E\u001a\u00020CH\u0002J\u0010\u0010F\u001a\u00020\t2\u0006\u0010E\u001a\u00020CH\u0002J\b\u0010G\u001a\u00020&H\u0002J\b\u0010H\u001a\u00020&H\u0002J\b\u0010I\u001a\u00020&H\u0002J5\u0010J\u001a\u0004\u0018\u0001HK\"\b\b\u0000\u0010K*\u00020L*\u00020M2\u0006\u0010N\u001a\u0002HK2\u0006\u0010O\u001a\u0002HK2\u0006\u0010P\u001a\u0002HKH\u0004\u00a2\u0006\u0002\u0010QJ:\u0010R\u001a\u0002HS\"\u0004\b\u0000\u0010S2\u0006\u0010T\u001a\u00020U2\u001d\u0010V\u001a\u0019\u0012\u0004\u0012\u00020X\u0012\u0004\u0012\u00020U\u0012\u0004\u0012\u0002HS0W\u00a2\u0006\u0002\b=H\u0004\u00a2\u0006\u0002\u0010YJ\u0010\u0010Z\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020[H\u0007R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015@BX\u0084.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000f8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0018\u0010*\u001a\u00020+*\u00020,8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R%\u0010;\u001a\u0013\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\t0<\u00a2\u0006\u0002\b=X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b>\u0010\u0003\u00a8\u0006]"}, d2={"Lorg/jetbrains/kotlin/analysis/test/framework/base/AbstractAnalysisApiBasedTest;", "Lorg/jetbrains/kotlin/analysis/test/framework/TestWithDisposable;", "<init>", "()V", "configurator", "Lorg/jetbrains/kotlin/analysis/test/framework/test/configurators/AnalysisApiTestConfigurator;", "getConfigurator", "()Lorg/jetbrains/kotlin/analysis/test/framework/test/configurators/AnalysisApiTestConfigurator;", "doTestByMainFile", "", "mainFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "mainModule", "Lorg/jetbrains/kotlin/analysis/test/framework/projectStructure/KtTestModule;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "doTestByMainModuleAndOptionalMainFile", "doTest", "testInfo", "Lorg/jetbrains/kotlin/test/services/KotlinTestInfo;", "value", "Ljava/nio/file/Path;", "testDataPath", "getTestDataPath", "()Ljava/nio/file/Path;", "_testServices", "getTestServices", "()Lorg/jetbrains/kotlin/test/services/TestServices;", "setTestServices", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "configureTest", "builder", "Lorg/jetbrains/kotlin/test/builders/TestConfigurationBuilder;", "findMainFileAndModule", "Lorg/jetbrains/kotlin/analysis/test/framework/base/AbstractAnalysisApiBasedTest$ModuleWithMainFile;", "findMainFileByMarkers", "findMainModule", "isMainModule", "", "ktTestModule", "findMainFile", "acceptSingleFileWithoutAdditionalChecks", "mainFileName", "", "Lorg/jetbrains/kotlin/test/model/TestModule;", "getMainFileName", "(Lorg/jetbrains/kotlin/test/model/TestModule;)Ljava/lang/String;", "isMainFile", "file", "assertEqualsToTestDataFileSibling", "Lorg/jetbrains/kotlin/test/services/AssertionsService;", "actual", "extension", "testPrefix", "testPrefixes", "", "getTestDataSibling", "findPrefixedTestDataSibling", "getDefaultTestDataSibling", "configure", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "getConfigure$annotations", "runTest", "path", "cleanupTemporaryDirectories", "createTestConfiguration", "Lorg/jetbrains/kotlin/test/TestConfiguration;", "createAndRegisterTestModuleStructure", "testConfiguration", "prepareToTheAnalysis", "isDependentModeDisabledForTheTest", "isFe10DisabledForTheTest", "isFirDisabledForTheTest", "findSpecificDirective", "T", "Lorg/jetbrains/kotlin/test/directives/model/Directive;", "Lorg/jetbrains/kotlin/test/directives/model/RegisteredDirectives;", "commonDirective", "k1Directive", "k2Directive", "(Lorg/jetbrains/kotlin/test/directives/model/RegisteredDirectives;Lorg/jetbrains/kotlin/test/directives/model/Directive;Lorg/jetbrains/kotlin/test/directives/model/Directive;Lorg/jetbrains/kotlin/test/directives/model/Directive;)Lorg/jetbrains/kotlin/test/directives/model/Directive;", "analyseForTest", "R", "contextElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "action", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "(Lorg/jetbrains/kotlin/psi/KtElement;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "initTestInfo", "Lorg/junit/jupiter/api/TestInfo;", "ModuleWithMainFile", "analysis-test-framework_test"})
@SourceDebugExtension(value={"SMAP\nAbstractAnalysisApiBasedTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractAnalysisApiBasedTest.kt\norg/jetbrains/kotlin/analysis/test/framework/base/AbstractAnalysisApiBasedTest\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 TestConfigurationBuilder.kt\norg/jetbrains/kotlin/test/builders/TestConfigurationBuilderKt\n+ 5 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 6 KaSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KaSessionProvider\n+ 7 TestConfigurationBuilder.kt\norg/jetbrains/kotlin/test/builders/TestConfigurationBuilder\n+ 8 TestServices.kt\norg/jetbrains/kotlin/test/services/TestServicesKt\n+ 9 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,446:1\n1#2:447\n1#2:450\n1619#3:448\n1863#3:449\n1864#3:451\n1620#3:452\n1863#3,2:454\n1863#3,2:456\n1863#3,2:458\n313#4:453\n60#5,2:460\n28#5,2:462\n36#6,13:464\n60#7:477\n61#7:479\n60#7:484\n61#7:486\n25#8:478\n25#8:485\n37#9:480\n36#9,3:481\n*S KotlinDebug\n*F\n+ 1 AbstractAnalysisApiBasedTest.kt\norg/jetbrains/kotlin/analysis/test/framework/base/AbstractAnalysisApiBasedTest\n*L\n270#1:450\n270#1:448\n270#1:449\n270#1:451\n270#1:452\n400#1:454,2\n401#1:456,2\n403#1:458,2\n381#1:453\n430#1:460,2\n434#1:462,2\n434#1:464,13\n326#1:477\n326#1:479\n334#1:484\n334#1:486\n326#1:478\n334#1:485\n328#1:480\n328#1:481,3\n*E\n"})
public abstract class AbstractAnalysisApiBasedTest
extends TestWithDisposable {
    private KotlinTestInfo testInfo;
    private Path testDataPath;
    @Nullable
    private TestServices _testServices;
    @NotNull
    private final Function1<TestConfigurationBuilder, Unit> configure = arg_0 -> AbstractAnalysisApiBasedTest.configure$lambda$19(this, arg_0);

    @NotNull
    public abstract AnalysisApiTestConfigurator getConfigurator();

    protected void doTestByMainFile(@NotNull KtFile mainFile, @NotNull KtTestModule mainModule, @NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)mainFile, (String)"mainFile");
        Intrinsics.checkNotNullParameter((Object)mainModule, (String)"mainModule");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        throw new UnsupportedOperationException("The test case is not fully implemented. 'doTestByMainFile', 'doTestByMainModuleAndOptionalMainFile' or 'doTest' should be overridden");
    }

    protected void doTestByMainModuleAndOptionalMainFile(@Nullable KtFile mainFile, @NotNull KtTestModule mainModule, @NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)mainModule, (String)"mainModule");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        KtFile ktFile = mainFile;
        if (ktFile == null) {
            throw new IllegalStateException("The main file is not found".toString());
        }
        this.doTestByMainFile(ktFile, mainModule, testServices);
    }

    protected void doTest(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        ModuleWithMainFile moduleWithMainFile = this.findMainFileAndModule(testServices);
        KtFile mainFile = moduleWithMainFile.component1();
        KtTestModule mainModule = moduleWithMainFile.component2();
        this.doTestByMainModuleAndOptionalMainFile(mainFile, mainModule, testServices);
    }

    @NotNull
    protected final Path getTestDataPath() {
        Path path = this.testDataPath;
        if (path != null) {
            return path;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"testDataPath");
        return null;
    }

    private final TestServices getTestServices() {
        TestServices testServices = this._testServices;
        if (testServices == null) {
            throw new IllegalStateException("`_testServices` has not been initialized".toString());
        }
        return testServices;
    }

    private final void setTestServices(TestServices value) {
        this._testServices = value;
    }

    protected void configureTest(@NotNull TestConfigurationBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.getConfigurator().configureTest(builder, this.getDisposable());
    }

    @NotNull
    protected final ModuleWithMainFile findMainFileAndModule(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        ModuleWithMainFile moduleWithMainFile = this.findMainFileByMarkers(testServices);
        if (moduleWithMainFile != null) {
            ModuleWithMainFile it = moduleWithMainFile;
            boolean bl = false;
            return it;
        }
        KtTestModule ktTestModule = this.findMainModule(testServices);
        if (ktTestModule == null) {
            throw new IllegalStateException("Cannot find the main test module".toString());
        }
        KtTestModule mainModule = ktTestModule;
        KtFile mainFile = AbstractAnalysisApiBasedTest.findMainFile$default(this, mainModule, testServices, false, 4, null);
        return new ModuleWithMainFile(mainFile, mainModule);
    }

    private final ModuleWithMainFile findMainFileByMarkers(TestServices testServices) {
        return (ModuleWithMainFile)CommonTestUtilsKt.singleOrZeroValue((Collection)AnalysisApiKtTestModuleStructureProviderKt.getKtTestModuleStructure(testServices).getMainModules(), arg_0 -> AbstractAnalysisApiBasedTest.findMainFileByMarkers$lambda$2(this, testServices, arg_0), AbstractAnalysisApiBasedTest::findMainFileByMarkers$lambda$3);
    }

    @Nullable
    protected final KtTestModule findMainModule(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        List<KtTestModule> modules = AnalysisApiKtTestModuleStructureProviderKt.getKtTestModuleStructure(testServices).getMainModules();
        KtTestModule ktTestModule = (KtTestModule)CollectionsKt.singleOrNull(modules);
        if (ktTestModule != null) {
            KtTestModule it = ktTestModule;
            boolean bl = false;
            return it;
        }
        return (KtTestModule)CommonTestUtilsKt.singleOrZeroValue((Collection)modules, arg_0 -> AbstractAnalysisApiBasedTest.findMainModule$lambda$6(this, testServices, arg_0), AbstractAnalysisApiBasedTest::findMainModule$lambda$7);
    }

    protected boolean isMainModule(@NotNull KtTestModule ktTestModule, @NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)ktTestModule, (String)"ktTestModule");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        return ktTestModule.getTestModule().getDirectives().contains((Directive)AnalysisApiTestDirectives.INSTANCE.getMAIN_MODULE()) || Intrinsics.areEqual((Object)StringsKt.substringBefore$default((String)ktTestModule.getTestModule().getName(), (char)'-', null, (int)2, null), (Object)"main");
    }

    @Nullable
    protected final KtFile findMainFile(@NotNull KtTestModule ktTestModule, @NotNull TestServices testServices, boolean acceptSingleFileWithoutAdditionalChecks) {
        KtFile ktFile;
        Intrinsics.checkNotNullParameter((Object)ktTestModule, (String)"ktTestModule");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        List<KtFile> ktFiles = ktTestModule.getKtFiles();
        if (acceptSingleFileWithoutAdditionalChecks && (ktFile = (KtFile)CollectionsKt.singleOrNull(ktFiles)) != null) {
            KtFile it = ktFile;
            boolean bl = false;
            return it;
        }
        return (KtFile)CommonTestUtilsKt.singleOrZeroValue((Collection)ktFiles, arg_0 -> AbstractAnalysisApiBasedTest.findMainFile$lambda$10(this, ktTestModule, testServices, arg_0), AbstractAnalysisApiBasedTest::findMainFile$lambda$11);
    }

    public static /* synthetic */ KtFile findMainFile$default(AbstractAnalysisApiBasedTest abstractAnalysisApiBasedTest, KtTestModule ktTestModule, TestServices testServices, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findMainFile");
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return abstractAnalysisApiBasedTest.findMainFile(ktTestModule, testServices, bl);
    }

    @NotNull
    protected final String getMainFileName(@NotNull TestModule $this$mainFileName) {
        Intrinsics.checkNotNullParameter((Object)$this$mainFileName, (String)"<this>");
        String string = DirectiveKt.singleOrZeroValue((RegisteredDirectives)$this$mainFileName.getDirectives(), (StringDirective)AnalysisApiTestDirectives.INSTANCE.getMAIN_FILE_NAME());
        if (string == null) {
            string = "main";
        }
        return string;
    }

    protected boolean isMainFile(@NotNull KtFile file, @NotNull KtTestModule ktTestModule, @NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)ktTestModule, (String)"ktTestModule");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        ExpressionMarkerProvider expressionMarkerProvider = ExpressionMarkersSourceFilePreprocessorKt.getExpressionMarkerProvider(testServices);
        return ExpressionMarkerProvider.getCaretPositionOrNull$default(expressionMarkerProvider, (PsiFile)file, null, 2, null) != null || expressionMarkerProvider.getSelectedRangeOrNull((PsiFile)file) != null || Intrinsics.areEqual((Object)file.getVirtualFile().getNameWithoutExtension(), (Object)this.getMainFileName(ktTestModule.getTestModule()));
    }

    protected final void assertEqualsToTestDataFileSibling(@NotNull AssertionsService $this$assertEqualsToTestDataFileSibling, @NotNull String actual2, @NotNull String extension, @Nullable String testPrefix) {
        Intrinsics.checkNotNullParameter((Object)$this$assertEqualsToTestDataFileSibling, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)actual2, (String)"actual");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        this.assertEqualsToTestDataFileSibling($this$assertEqualsToTestDataFileSibling, actual2, extension, CollectionsKt.listOfNotNull((Object)testPrefix));
    }

    public static /* synthetic */ void assertEqualsToTestDataFileSibling$default(AbstractAnalysisApiBasedTest abstractAnalysisApiBasedTest, AssertionsService assertionsService, String string, String string2, String string3, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: assertEqualsToTestDataFileSibling");
        }
        if ((n & 2) != 0) {
            string2 = ".txt";
        }
        if ((n & 4) != 0) {
            string3 = abstractAnalysisApiBasedTest.getConfigurator().getTestPrefix();
        }
        abstractAnalysisApiBasedTest.assertEqualsToTestDataFileSibling(assertionsService, string, string2, string3);
    }

    protected final void assertEqualsToTestDataFileSibling(@NotNull AssertionsService $this$assertEqualsToTestDataFileSibling, @NotNull String actual2, @NotNull String extension, @NotNull List<String> testPrefixes) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$assertEqualsToTestDataFileSibling, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)actual2, (String)"actual");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        Intrinsics.checkNotNullParameter(testPrefixes, (String)"testPrefixes");
        List $this$assertEqualsToTestDataFileSibling_u24lambda_u2413 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        Iterable $this$mapNotNullTo$iv = testPrefixes;
        boolean $i$f$mapNotNullTo = false;
        Iterable $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            Path it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl2 = false;
            String it = (String)element$iv;
            boolean bl3 = false;
            if (this.findPrefixedTestDataSibling(extension, it) == null) continue;
            boolean bl4 = false;
            ((Collection)$this$assertEqualsToTestDataFileSibling_u24lambda_u2413).add(it$iv);
        }
        $this$assertEqualsToTestDataFileSibling_u24lambda_u2413.add(this.getDefaultTestDataSibling(extension));
        List expectedFiles = CollectionsKt.build((List)list);
        Path mainExpectedFile = (Path)CollectionsKt.first((List)expectedFiles);
        List otherExpectedFiles = CollectionsKt.drop((Iterable)expectedFiles, (int)1);
        Assertions.assertEqualsToFile$default((Assertions)((Assertions)$this$assertEqualsToTestDataFileSibling), (Path)mainExpectedFile, (String)actual2, null, (int)4, null);
        for (Path otherExpectedFile : otherExpectedFiles) {
            Assertions assertions = (Assertions)$this$assertEqualsToTestDataFileSibling;
            File file = otherExpectedFile.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            if (Assertions.doesEqualToFile$default((Assertions)assertions, (File)file, (String)actual2, null, (int)4, null)) {
                throw new AssertionError((Object)("" + '\"' + mainExpectedFile + "\" has the same content as \"" + otherExpectedFile + "\". Delete the prefixed file."));
            }
        }
    }

    public static /* synthetic */ void assertEqualsToTestDataFileSibling$default(AbstractAnalysisApiBasedTest abstractAnalysisApiBasedTest, AssertionsService assertionsService, String string, String string2, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: assertEqualsToTestDataFileSibling");
        }
        if ((n & 2) != 0) {
            string2 = ".txt";
        }
        abstractAnalysisApiBasedTest.assertEqualsToTestDataFileSibling(assertionsService, string, string2, list);
    }

    @NotNull
    protected final Path getTestDataSibling(@NotNull String extension, @Nullable String testPrefix) {
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        if (testPrefix != null) {
            Path path = this.findPrefixedTestDataSibling(extension, testPrefix);
            if (path != null) {
                Path it = path;
                boolean bl = false;
                return it;
            }
        }
        return this.getDefaultTestDataSibling(extension);
    }

    public static /* synthetic */ Path getTestDataSibling$default(AbstractAnalysisApiBasedTest abstractAnalysisApiBasedTest, String string, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getTestDataSibling");
        }
        if ((n & 1) != 0) {
            string = "txt";
        }
        if ((n & 2) != 0) {
            string2 = abstractAnalysisApiBasedTest.getConfigurator().getTestPrefix();
        }
        return abstractAnalysisApiBasedTest.getTestDataSibling(string, string2);
    }

    private final Path findPrefixedTestDataSibling(String extension, String testPrefix) {
        Path prefixedFile;
        Path path;
        String extensionWithDot = '.' + StringsKt.removePrefix((String)extension, (CharSequence)".");
        String baseName = PathsKt.getNameWithoutExtension((Path)this.getTestDataPath());
        Path it = path = (prefixedFile = this.getTestDataPath().resolveSibling(baseName + '.' + testPrefix + extensionWithDot));
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.exists(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? path : null;
    }

    static /* synthetic */ Path findPrefixedTestDataSibling$default(AbstractAnalysisApiBasedTest abstractAnalysisApiBasedTest, String string, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findPrefixedTestDataSibling");
        }
        if ((n & 1) != 0) {
            string = "txt";
        }
        return abstractAnalysisApiBasedTest.findPrefixedTestDataSibling(string, string2);
    }

    private final Path getDefaultTestDataSibling(String extension) {
        String extensionWithDot = '.' + StringsKt.removePrefix((String)extension, (CharSequence)".");
        String baseName = PathsKt.getNameWithoutExtension((Path)this.getTestDataPath());
        Path path = this.getTestDataPath().resolveSibling(baseName + extensionWithDot);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolveSibling(...)");
        return path;
    }

    static /* synthetic */ Path getDefaultTestDataSibling$default(AbstractAnalysisApiBasedTest abstractAnalysisApiBasedTest, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getDefaultTestDataSibling");
        }
        if ((n & 1) != 0) {
            string = "txt";
        }
        return abstractAnalysisApiBasedTest.getDefaultTestDataSibling(string);
    }

    private static /* synthetic */ void getConfigure$annotations() {
    }

    protected final void runTest(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        AnalysisApiTestConfigurator analysisApiTestConfigurator = this.getConfigurator();
        Path path2 = Paths.get(path, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        this.testDataPath = analysisApiTestConfigurator.computeTestDataPath(path2);
        TestConfiguration testConfiguration = this.createTestConfiguration();
        this.setTestServices(testConfiguration.getTestServices());
        this.createAndRegisterTestModuleStructure(testConfiguration);
        if (this.getConfigurator().getAnalyseInDependentSession() && this.isDependentModeDisabledForTheTest()) {
            return;
        }
        if (this.getConfigurator().getFrontendKind() == org.jetbrains.kotlin.analysis.test.framework.test.configurators.FrontendKind.Fe10 && this.isFe10DisabledForTheTest() || this.getConfigurator().getFrontendKind() == org.jetbrains.kotlin.analysis.test.framework.test.configurators.FrontendKind.Fir && this.isFirDisabledForTheTest()) {
            return;
        }
        try {
            this.prepareToTheAnalysis(testConfiguration);
        }
        catch (SkipTestException skipTestException) {
            return;
        }
        this.doTest(this.getTestServices());
    }

    @AfterEach
    public final void cleanupTemporaryDirectories() {
        try {
            TestServices testServices = this._testServices;
            if (testServices != null && (testServices = TemporaryDirectoryManagerKt.getTemporaryDirectoryManager((TestServices)testServices)) != null) {
                testServices.cleanupTemporaryDirectories();
            }
        }
        catch (IOException e) {
            System.out.println((Object)("Failed to clean temporary directories: " + e.getMessage() + '\n' + e.getStackTrace()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final TestConfiguration createTestConfiguration() {
        void testDataPath$iv;
        String string = ((Object)this.getTestDataPath()).toString();
        Function1<TestConfigurationBuilder, Unit> init$iv = this.configure;
        boolean $i$f$testConfiguration = false;
        TestConfigurationBuilder testConfigurationBuilder = new TestConfigurationBuilder();
        init$iv.invoke((Object)testConfigurationBuilder);
        TestConfiguration testConfiguration = testConfigurationBuilder.build((String)testDataPath$iv);
        Disposer.register((Disposable)this.getDisposable(), (Disposable)testConfiguration.getRootDisposable());
        return testConfiguration;
    }

    private final void createAndRegisterTestModuleStructure(TestConfiguration testConfiguration) {
        TestModuleStructure moduleStructure = testConfiguration.getModuleStructureExtractor().splitTestDataByModules(((Object)this.getTestDataPath()).toString(), testConfiguration.getDirectives());
        this.getTestServices().register(Reflection.getOrCreateKotlinClass(TestModuleStructure.class), (TestService)moduleStructure);
    }

    private final void prepareToTheAnalysis(TestConfiguration testConfiguration) {
        PreAnalysisHandler preprocessor;
        TestModuleStructure moduleStructure = TestModuleStructureKt.getModuleStructure((TestServices)this.getTestServices());
        DependencyProviderImpl dependencyProvider = new DependencyProviderImpl(this.getTestServices(), moduleStructure.getModules());
        TestServicesKt.registerDependencyProvider((TestServices)this.getTestServices(), (DependencyProvider)((DependencyProvider)dependencyProvider));
        Iterable $this$forEach$iv = testConfiguration.getPreAnalysisHandlers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            preprocessor = (PreAnalysisHandler)element$iv;
            boolean bl = false;
            preprocessor.preprocessModuleStructure(moduleStructure);
        }
        $this$forEach$iv = testConfiguration.getPreAnalysisHandlers();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            preprocessor = (PreAnalysisHandler)element$iv;
            boolean bl = false;
            preprocessor.prepareSealedClassInheritors(moduleStructure);
        }
        $this$forEach$iv = AnalysisApiKtTestModuleStructureProviderKt.getKtTestModuleStructure(this.getTestServices()).getMainModules();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtTestModule ktTestModule = (KtTestModule)element$iv;
            boolean bl = false;
            this.getConfigurator().prepareFilesInModule(ktTestModule, this.getTestServices());
        }
    }

    private final boolean isDependentModeDisabledForTheTest() {
        return TestModuleStructureKt.getModuleStructure((TestServices)this.getTestServices()).getAllDirectives().contains((Directive)AnalysisApiTestDirectives.INSTANCE.getDISABLE_DEPENDED_MODE());
    }

    private final boolean isFe10DisabledForTheTest() {
        return TestModuleStructureKt.getModuleStructure((TestServices)this.getTestServices()).getAllDirectives().contains((Directive)AnalysisApiTestDirectives.INSTANCE.getIGNORE_FE10());
    }

    private final boolean isFirDisabledForTheTest() {
        return TestModuleStructureKt.getModuleStructure((TestServices)this.getTestServices()).getAllDirectives().contains((Directive)AnalysisApiTestDirectives.INSTANCE.getIGNORE_FIR());
    }

    @Nullable
    protected final <T extends Directive> T findSpecificDirective(@NotNull RegisteredDirectives $this$findSpecificDirective, @NotNull T commonDirective, @NotNull T k1Directive, @NotNull T k2Directive) {
        T t;
        Intrinsics.checkNotNullParameter((Object)$this$findSpecificDirective, (String)"<this>");
        Intrinsics.checkNotNullParameter(commonDirective, (String)"commonDirective");
        Intrinsics.checkNotNullParameter(k1Directive, (String)"k1Directive");
        Intrinsics.checkNotNullParameter(k2Directive, (String)"k2Directive");
        T it = t = commonDirective;
        boolean bl = false;
        Object object = $this$findSpecificDirective.contains(it) ? t : null;
        if (object == null) {
            T t2;
            T it2 = t2 = k1Directive;
            boolean bl2 = false;
            object = this.getConfigurator().getFrontendKind() == org.jetbrains.kotlin.analysis.test.framework.test.configurators.FrontendKind.Fe10 && $this$findSpecificDirective.contains(it2) ? t2 : null;
            if (object == null) {
                it2 = t2 = k2Directive;
                boolean bl3 = false;
                object = this.getConfigurator().getFrontendKind() == org.jetbrains.kotlin.analysis.test.framework.test.configurators.FrontendKind.Fir && $this$findSpecificDirective.contains(it2) ? t2 : null;
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected final <R> R analyseForTest(@NotNull KtElement contextElement, @NotNull Function2<? super KaSession, ? super KtElement, ? extends R> action) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)contextElement, (String)"contextElement");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        if (this.getConfigurator().getAnalyseInDependentSession()) {
            KtFile ktFile = contextElement.getContainingKtFile();
            Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"getContainingKtFile(...)");
            KtFile originalContainingFile = ktFile;
            PsiElement psiElement = originalContainingFile.copy();
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
            KtFile fileCopy = (KtFile)psiElement;
            KaDanglingFileResolutionMode resolutionMode$iv = KaDanglingFileResolutionMode.IGNORE_SELF;
            boolean $i$f$analyzeCopy = false;
            KtFile ktFile2 = ((KtElement)fileCopy).getContainingKtFile();
            Intrinsics.checkNotNullExpressionValue((Object)ktFile2, (String)"getContainingKtFile(...)");
            KtFile containingFile$iv = ktFile2;
            object = DanglingFilesKt.withDanglingFileResolutionMode((KtFile)containingFile$iv, (KaDanglingFileResolutionMode)resolutionMode$iv, (Function0)new Function0<R>(containingFile$iv, action, contextElement, fileCopy){
                final /* synthetic */ KtFile $containingFile;
                final /* synthetic */ Function2 $action$inlined;
                final /* synthetic */ KtElement $contextElement$inlined;
                final /* synthetic */ KtFile $fileCopy$inlined;
                {
                    this.$containingFile = $containingFile;
                    this.$action$inlined = function2;
                    this.$contextElement$inlined = ktElement;
                    this.$fileCopy$inlined = ktFile;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final R invoke() {
                    Object object;
                    KtElement useSiteElement$iv = (KtElement)this.$containingFile;
                    boolean $i$f$analyze = false;
                    Project project = useSiteElement$iv.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    KaSessionProvider this_$iv$iv = KaSessionProvider.Companion.getInstance(project);
                    boolean $i$f$analyze2 = false;
                    KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession(useSiteElement$iv);
                    this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, useSiteElement$iv);
                    try {
                        Object object2;
                        Object lock$iv$iv;
                        Object object3 = lock$iv$iv = new Object();
                        synchronized (object3) {
                            boolean bl = false;
                            KaSession $this$analyseForTest_u24lambda_u2426 = analysisSession$iv$iv;
                            boolean bl2 = false;
                            PsiElement psiElement = PsiTreeUtil.findSameElementInCopy((PsiElement)((PsiElement)this.$contextElement$inlined), (PsiFile)((PsiFile)this.$fileCopy$inlined));
                            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"findSameElementInCopy(...)");
                            object2 = this.$action$inlined.invoke((Object)$this$analyseForTest_u24lambda_u2426, (Object)psiElement);
                        }
                        object = object2;
                    }
                    finally {
                        this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, useSiteElement$iv);
                    }
                    return (R)object;
                }
            });
        } else {
            Object object2;
            void this_$iv$iv;
            boolean $i$f$analyze = false;
            Project project = contextElement.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            KaSessionProvider fileCopy = KaSessionProvider.Companion.getInstance(project);
            boolean $i$f$analyze2 = false;
            KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession(contextElement);
            this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, contextElement);
            try {
                Object object3;
                Object lock$iv$iv;
                Object object4 = lock$iv$iv = new Object();
                synchronized (object4) {
                    boolean bl = false;
                    KaSession $this$analyseForTest_u24lambda_u2427 = analysisSession$iv$iv;
                    boolean bl2 = false;
                    object3 = action.invoke((Object)$this$analyseForTest_u24lambda_u2427, (Object)contextElement);
                }
                object2 = object3;
            }
            finally {
                this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, contextElement);
            }
            object = object2;
        }
        return (R)object;
    }

    @BeforeEach
    public final void initTestInfo(@NotNull TestInfo testInfo) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)testInfo, (String)"testInfo");
        Object object2 = (Class)testInfo.getTestClass().orElseGet(null);
        if (object2 == null || (object2 = ((Class)object2).getName()) == null) {
            object2 = "_undefined_";
        }
        if ((object = (Method)testInfo.getTestMethod().orElseGet(null)) == null || (object = ((Method)object).getName()) == null) {
            object = "_testUndefined_";
        }
        Set set = testInfo.getTags();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getTags(...)");
        this.testInfo = new KotlinTestInfo((String)object2, (String)object, set);
    }

    private static final ModuleWithMainFile findMainFileByMarkers$lambda$2(AbstractAnalysisApiBasedTest this$0, TestServices $testServices, KtTestModule module) {
        ModuleWithMainFile moduleWithMainFile;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        KtFile ktFile = this$0.findMainFile(module, $testServices, false);
        if (ktFile != null) {
            KtFile mainFile = ktFile;
            boolean bl = false;
            moduleWithMainFile = new ModuleWithMainFile(mainFile, module);
        } else {
            moduleWithMainFile = null;
        }
        return moduleWithMainFile;
    }

    private static final String findMainFileByMarkers$lambda$3(ModuleWithMainFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        KtFile ktFile = it.getMainFile();
        return '\'' + it.getModule().getTestModule().getName() + "' with '" + (ktFile != null ? ktFile.getName() : null) + '\'';
    }

    private static final KtTestModule findMainModule$lambda$6(AbstractAnalysisApiBasedTest this$0, TestServices $testServices, KtTestModule module) {
        KtTestModule ktTestModule;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        KtTestModule it = ktTestModule = module;
        boolean bl = false;
        return this$0.isMainModule(module, $testServices) ? ktTestModule : null;
    }

    private static final String findMainModule$lambda$7(KtTestModule it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getTestModule().getName();
    }

    private static final KtFile findMainFile$lambda$10(AbstractAnalysisApiBasedTest this$0, KtTestModule $ktTestModule, TestServices $testServices, KtFile file) {
        KtFile ktFile;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        KtFile it = ktFile = file;
        boolean bl = false;
        return this$0.isMainFile(file, $ktTestModule, $testServices) ? ktFile : null;
    }

    private static final String findMainFile$lambda$11(KtFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    private static final Unit configure$lambda$19$lambda$16(AbstractAnalysisApiBasedTest this$0, DefaultsProviderBuilder $this$globalDefaults) {
        Intrinsics.checkNotNullParameter((Object)$this$globalDefaults, (String)"$this$globalDefaults");
        $this$globalDefaults.setFrontend((FrontendKind)FrontendKinds.FIR.INSTANCE);
        $this$globalDefaults.setTargetPlatform(this$0.getConfigurator().getDefaultTargetPlatform());
        $this$globalDefaults.setDependencyKind(DependencyKind.Source);
        return Unit.INSTANCE;
    }

    private static final ExpressionMarkerProvider configure$lambda$19$lambda$17(TestServices it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ExpressionMarkerProvider();
    }

    private static final ResultingArtifact.Source configure$lambda$19$lambda$18(TestModule it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ResultingArtifact.Source();
    }

    private static final Unit configure$lambda$19(AbstractAnalysisApiBasedTest this$0, TestConfigurationBuilder directivesContainerArray) {
        DirectivesContainer[] this_$iv;
        Intrinsics.checkNotNullParameter((Object)directivesContainerArray, (String)"<this>");
        directivesContainerArray.globalDefaults(arg_0 -> AbstractAnalysisApiBasedTest.configure$lambda$19$lambda$16(this$0, arg_0));
        directivesContainerArray.setAssertions((AssertionsService)JUnit5Assertions.INSTANCE);
        DirectivesContainer[] directivesContainerArray2 = directivesContainerArray;
        Function1 serviceConstructor$iv = configure.1.2.INSTANCE;
        boolean $i$f$useAdditionalService = false;
        ServiceRegistrationData[] serviceRegistrationDataArray = new ServiceRegistrationData[1];
        boolean $i$f$service = false;
        serviceRegistrationDataArray[0] = new ServiceRegistrationData(Reflection.getOrCreateKotlinClass(TemporaryDirectoryManager.class), serviceConstructor$iv);
        this_$iv.useAdditionalServices(serviceRegistrationDataArray);
        Collection $this$toTypedArray$iv = AbstractKotlinCompilerTest.Companion.getDefaultDirectiveContainers();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        this_$iv = thisCollection$iv.toArray(new SimpleDirectivesContainer[0]);
        directivesContainerArray.useDirectives((DirectivesContainer[])Arrays.copyOf(this_$iv, this_$iv.length));
        this_$iv = new DirectivesContainer[]{JvmEnvironmentConfigurationDirectives.INSTANCE};
        directivesContainerArray.useDirectives(this_$iv);
        this_$iv = new DirectivesContainer[]{TestModuleCompiler.Directives.INSTANCE};
        directivesContainerArray.useDirectives(this_$iv);
        this_$iv = new Function1[]{configure.1.3.INSTANCE};
        TestConfigurationBuilder.useSourcePreprocessor$default((TestConfigurationBuilder)directivesContainerArray, (Function1[])this_$iv, (boolean)false, (int)2, null);
        this_$iv = directivesContainerArray;
        serviceConstructor$iv = AbstractAnalysisApiBasedTest::configure$lambda$19$lambda$17;
        $i$f$useAdditionalService = false;
        serviceRegistrationDataArray = new ServiceRegistrationData[1];
        $i$f$service = false;
        serviceRegistrationDataArray[0] = new ServiceRegistrationData(Reflection.getOrCreateKotlinClass(ExpressionMarkerProvider.class), serviceConstructor$iv);
        this_$iv.useAdditionalServices(serviceRegistrationDataArray);
        directivesContainerArray2 = new DirectivesContainer[]{ExpressionMarkerProvider.Directives.INSTANCE};
        directivesContainerArray.useDirectives(directivesContainerArray2);
        RegisterBaseTestServicesKt.registerAnalysisApiBaseTestServices((TestConfigurationBuilder)directivesContainerArray, this$0.getDisposable(), this$0.getConfigurator());
        this$0.configureTest((TestConfigurationBuilder)directivesContainerArray);
        directivesContainerArray.setStartingArtifactFactory(AbstractAnalysisApiBasedTest::configure$lambda$19$lambda$18);
        KotlinTestInfo kotlinTestInfo = this$0.testInfo;
        if (kotlinTestInfo == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"testInfo");
            kotlinTestInfo = null;
        }
        directivesContainerArray.setTestInfo(kotlinTestInfo);
        AbstractTypeChecker.RUN_SLOW_ASSERTIONS = true;
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001f\u0010\u000e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/analysis/test/framework/base/AbstractAnalysisApiBasedTest$ModuleWithMainFile;", "", "mainFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "module", "Lorg/jetbrains/kotlin/analysis/test/framework/projectStructure/KtTestModule;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtFile;Lorg/jetbrains/kotlin/analysis/test/framework/projectStructure/KtTestModule;)V", "getMainFile", "()Lorg/jetbrains/kotlin/psi/KtFile;", "getModule", "()Lorg/jetbrains/kotlin/analysis/test/framework/projectStructure/KtTestModule;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "analysis-test-framework_test"})
    public static final class ModuleWithMainFile {
        @Nullable
        private final KtFile mainFile;
        @NotNull
        private final KtTestModule module;

        public ModuleWithMainFile(@Nullable KtFile mainFile, @NotNull KtTestModule module) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            this.mainFile = mainFile;
            this.module = module;
        }

        @Nullable
        public final KtFile getMainFile() {
            return this.mainFile;
        }

        @NotNull
        public final KtTestModule getModule() {
            return this.module;
        }

        @Nullable
        public final KtFile component1() {
            return this.mainFile;
        }

        @NotNull
        public final KtTestModule component2() {
            return this.module;
        }

        @NotNull
        public final ModuleWithMainFile copy(@Nullable KtFile mainFile, @NotNull KtTestModule module) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            return new ModuleWithMainFile(mainFile, module);
        }

        public static /* synthetic */ ModuleWithMainFile copy$default(ModuleWithMainFile moduleWithMainFile, KtFile ktFile, KtTestModule ktTestModule, int n, Object object) {
            if ((n & 1) != 0) {
                ktFile = moduleWithMainFile.mainFile;
            }
            if ((n & 2) != 0) {
                ktTestModule = moduleWithMainFile.module;
            }
            return moduleWithMainFile.copy(ktFile, ktTestModule);
        }

        @NotNull
        public String toString() {
            return "ModuleWithMainFile(mainFile=" + this.mainFile + ", module=" + this.module + ')';
        }

        public int hashCode() {
            int result = this.mainFile == null ? 0 : this.mainFile.hashCode();
            result = result * 31 + this.module.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ModuleWithMainFile)) {
                return false;
            }
            ModuleWithMainFile moduleWithMainFile = (ModuleWithMainFile)other;
            if (!Intrinsics.areEqual((Object)this.mainFile, (Object)moduleWithMainFile.mainFile)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.module, (Object)moduleWithMainFile.module);
        }
    }
}

