/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.impl.base.test;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.impl.base.test.SymbolByFqNameKt;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassKind;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassLikeSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaDeclarationSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaDeclarationSymbolKt;
import org.jetbrains.kotlin.analysis.api.symbols.KaEnumEntryInitializerSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaEnumEntrySymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaNamedClassSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaPackageSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSamConstructorSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaTypeAliasSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaTypeParameterSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.markers.KaDeclarationContainerSymbol;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtScript;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00122\u00020\u0001:\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005*\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&\u0082\u0001\b\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/analysis/api/impl/base/test/SymbolData;", "", "<init>", "()V", "toSymbols", "", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaSymbol;", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "PackageData", "ClassData", "ScriptData", "TypeAliasData", "CallableData", "EnumEntryInitializerData", "SamConstructorData", "TypeParameterData", "Companion", "Lorg/jetbrains/kotlin/analysis/api/impl/base/test/SymbolData$CallableData;", "Lorg/jetbrains/kotlin/analysis/api/impl/base/test/SymbolData$ClassData;", "Lorg/jetbrains/kotlin/analysis/api/impl/base/test/SymbolData$EnumEntryInitializerData;", "Lorg/jetbrains/kotlin/analysis/api/impl/base/test/SymbolData$PackageData;", "Lorg/jetbrains/kotlin/analysis/api/impl/base/test/SymbolData$SamConstructorData;", "Lorg/jetbrains/kotlin/analysis/api/impl/base/test/SymbolData$ScriptData;", "Lorg/jetbrains/kotlin/analysis/api/impl/base/test/SymbolData$TypeAliasData;", "Lorg/jetbrains/kotlin/analysis/api/impl/base/test/SymbolData$TypeParameterData;", "analysis-api-impl-base_test"})
public abstract class SymbolData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String[] identifiers;

    private SymbolData() {
    }

    @NotNull
    public abstract List<KaSymbol> toSymbols(@NotNull KaSession var1, @NotNull KtFile var2);

    public /* synthetic */ SymbolData(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    static {
        String[] stringArray = new String[]{"package:", "callable:", "class:", "typealias:", "enum_entry_initializer:", "script", "sam_constructor:", "type_parameter:"};
        identifiers = stringArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t*\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\t*\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/analysis/api/impl/base/test/SymbolData$CallableData;", "Lorg/jetbrains/kotlin/analysis/api/impl/base/test/SymbolData;", "callableId", "Lorg/jetbrains/kotlin/name/CallableId;", "<init>", "(Lorg/jetbrains/kotlin/name/CallableId;)V", "getCallableId", "()Lorg/jetbrains/kotlin/name/CallableId;", "toSymbols", "", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaSymbol;", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "findMatchingCallableSymbols", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaCallableSymbol;", "classSymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaClassSymbol;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "analysis-api-impl-base_test"})
    public static final class CallableData
    extends SymbolData {
        @NotNull
        private final CallableId callableId;

        public CallableData(@NotNull CallableId callableId) {
            Intrinsics.checkNotNullParameter((Object)callableId, (String)"callableId");
            super(null);
            this.callableId = callableId;
        }

        @NotNull
        public final CallableId getCallableId() {
            return this.callableId;
        }

        @Override
        @NotNull
        public List<KaSymbol> toSymbols(@NotNull KaSession $this$toSymbols, @NotNull KtFile ktFile) {
            List<KaCallableSymbol> symbols;
            List<KaCallableSymbol> list;
            Intrinsics.checkNotNullParameter((Object)$this$toSymbols, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)ktFile, (String)"ktFile");
            ClassId classId = this.callableId.getClassId();
            if (classId == null) {
                list = SequencesKt.toList((Sequence)$this$toSymbols.findTopLevelCallables(this.callableId.getPackageName(), this.callableId.getCallableName()));
            } else {
                KaClassSymbol kaClassSymbol = $this$toSymbols.findClass(classId);
                if (kaClassSymbol == null) {
                    throw new IllegalStateException(("Class " + classId + " is not found").toString());
                }
                KaClassSymbol classSymbol = kaClassSymbol;
                list = symbols = this.findMatchingCallableSymbols($this$toSymbols, classSymbol);
            }
            if (symbols.isEmpty()) {
                throw new IllegalStateException(("No callable with fqName " + this.callableId + " found").toString());
            }
            return symbols;
        }

        private final List<KaCallableSymbol> findMatchingCallableSymbols(KaSession $this$findMatchingCallableSymbols, KaClassSymbol classSymbol) {
            Name[] nameArray = new Name[]{this.callableId.getCallableName()};
            List declaredSymbols = SequencesKt.toList((Sequence)$this$findMatchingCallableSymbols.getCombinedDeclaredMemberScope((KaDeclarationContainerSymbol)classSymbol).callables(nameArray));
            if (!((Collection)declaredSymbols).isEmpty()) {
                return declaredSymbols;
            }
            nameArray = new Name[]{this.callableId.getCallableName()};
            return SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)$this$findMatchingCallableSymbols.getCombinedMemberScope((KaDeclarationContainerSymbol)classSymbol).callables(nameArray), arg_0 -> CallableData.findMatchingCallableSymbols$lambda$0($this$findMatchingCallableSymbols, classSymbol, arg_0)));
        }

        @NotNull
        public final CallableId component1() {
            return this.callableId;
        }

        @NotNull
        public final CallableData copy(@NotNull CallableId callableId) {
            Intrinsics.checkNotNullParameter((Object)callableId, (String)"callableId");
            return new CallableData(callableId);
        }

        public static /* synthetic */ CallableData copy$default(CallableData callableData, CallableId callableId, int n, Object object) {
            if ((n & 1) != 0) {
                callableId = callableData.callableId;
            }
            return callableData.copy(callableId);
        }

        @NotNull
        public String toString() {
            return "CallableData(callableId=" + this.callableId + ')';
        }

        public int hashCode() {
            return this.callableId.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CallableData)) {
                return false;
            }
            CallableData callableData = (CallableData)other;
            return Intrinsics.areEqual((Object)this.callableId, (Object)callableData.callableId);
        }

        private static final boolean findMatchingCallableSymbols$lambda$0(KaSession $this_findMatchingCallableSymbols, KaClassSymbol $classSymbol, KaCallableSymbol it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Intrinsics.areEqual((Object)$this_findMatchingCallableSymbols.getContainingDeclaration((KaSymbol)it), (Object)$classSymbol);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t*\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/analysis/api/impl/base/test/SymbolData$ClassData;", "Lorg/jetbrains/kotlin/analysis/api/impl/base/test/SymbolData;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "<init>", "(Lorg/jetbrains/kotlin/name/ClassId;)V", "getClassId", "()Lorg/jetbrains/kotlin/name/ClassId;", "toSymbols", "", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaSymbol;", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "analysis-api-impl-base_test"})
    public static final class ClassData
    extends SymbolData {
        @NotNull
        private final ClassId classId;

        public ClassData(@NotNull ClassId classId) {
            Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
            super(null);
            this.classId = classId;
        }

        @NotNull
        public final ClassId getClassId() {
            return this.classId;
        }

        @Override
        @NotNull
        public List<KaSymbol> toSymbols(@NotNull KaSession $this$toSymbols, @NotNull KtFile ktFile) {
            Intrinsics.checkNotNullParameter((Object)$this$toSymbols, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)ktFile, (String)"ktFile");
            KaClassSymbol kaClassSymbol = $this$toSymbols.findClass(this.classId);
            if (kaClassSymbol == null) {
                throw new IllegalStateException(("Class " + this.classId + " is not found").toString());
            }
            KaClassSymbol symbol = kaClassSymbol;
            return CollectionsKt.listOf((Object)symbol);
        }

        @NotNull
        public final ClassId component1() {
            return this.classId;
        }

        @NotNull
        public final ClassData copy(@NotNull ClassId classId) {
            Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
            return new ClassData(classId);
        }

        public static /* synthetic */ ClassData copy$default(ClassData classData, ClassId classId, int n, Object object) {
            if ((n & 1) != 0) {
                classId = classData.classId;
            }
            return classData.copy(classId);
        }

        @NotNull
        public String toString() {
            return "ClassData(classId=" + this.classId + ')';
        }

        public int hashCode() {
            return this.classId.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ClassData)) {
                return false;
            }
            ClassData classData = (ClassData)other;
            return Intrinsics.areEqual((Object)this.classId, (Object)classData.classId);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006R\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/analysis/api/impl/base/test/SymbolData$Companion;", "", "<init>", "()V", "identifiers", "", "", "getIdentifiers", "()[Ljava/lang/String;", "[Ljava/lang/String;", "create", "Lorg/jetbrains/kotlin/analysis/api/impl/base/test/SymbolData;", "data", "analysis-api-impl-base_test"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String[] getIdentifiers() {
            return identifiers;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NotNull
        public final SymbolData create(@NotNull String data) {
            SymbolData symbolData;
            String value;
            block19: {
                block17: {
                    block20: {
                        block16: {
                            block18: {
                                block21: {
                                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                                    String key = StringsKt.substringBefore$default((String)data, (String)":", null, (int)2, null);
                                    value = ((Object)StringsKt.trim((CharSequence)StringsKt.substringAfter$default((String)data, (String)":", null, (int)2, null))).toString();
                                    String string = key;
                                    switch (string.hashCode()) {
                                        case -807062458: {
                                            if (string.equals("package")) break;
                                            throw new IllegalStateException(("Invalid symbol kind, expected one of: " + this.getIdentifiers()).toString());
                                        }
                                        case -172248904: {
                                            if (!string.equals("callable")) {
                                                throw new IllegalStateException(("Invalid symbol kind, expected one of: " + this.getIdentifiers()).toString());
                                            }
                                            break block16;
                                        }
                                        case -56419430: {
                                            if (!string.equals("sam_constructor")) {
                                                throw new IllegalStateException(("Invalid symbol kind, expected one of: " + this.getIdentifiers()).toString());
                                            }
                                            break block17;
                                        }
                                        case 520977238: {
                                            if (!string.equals("typealias")) {
                                                throw new IllegalStateException(("Invalid symbol kind, expected one of: " + this.getIdentifiers()).toString());
                                            }
                                            break block18;
                                        }
                                        case 1277164772: {
                                            if (!string.equals("type_parameter")) {
                                                throw new IllegalStateException(("Invalid symbol kind, expected one of: " + this.getIdentifiers()).toString());
                                            }
                                            break block19;
                                        }
                                        case -915696937: {
                                            if (!string.equals("enum_entry_initializer")) {
                                                throw new IllegalStateException(("Invalid symbol kind, expected one of: " + this.getIdentifiers()).toString());
                                            }
                                            break block20;
                                        }
                                        case 94742904: {
                                            if (!string.equals("class")) {
                                                throw new IllegalStateException(("Invalid symbol kind, expected one of: " + this.getIdentifiers()).toString());
                                            }
                                            break block21;
                                        }
                                        case -907685685: {
                                            if (!string.equals("script")) throw new IllegalStateException(("Invalid symbol kind, expected one of: " + this.getIdentifiers()).toString());
                                            symbolData = ScriptData.INSTANCE;
                                            return symbolData;
                                        }
                                    }
                                    symbolData = new PackageData(SymbolByFqNameKt.access$extractPackageFqName(value));
                                    return symbolData;
                                }
                                symbolData = new ClassData(ClassId.Companion.fromString$default((ClassId.Companion)ClassId.Companion, (String)value, (boolean)false, (int)2, null));
                                return symbolData;
                            }
                            symbolData = new TypeAliasData(ClassId.Companion.fromString$default((ClassId.Companion)ClassId.Companion, (String)value, (boolean)false, (int)2, null));
                            return symbolData;
                        }
                        symbolData = new CallableData(SymbolByFqNameKt.access$extractCallableId(value));
                        return symbolData;
                    }
                    symbolData = new EnumEntryInitializerData(SymbolByFqNameKt.access$extractCallableId(value));
                    return symbolData;
                }
                symbolData = new SamConstructorData(ClassId.Companion.fromString$default((ClassId.Companion)ClassId.Companion, (String)value, (boolean)false, (int)2, null));
                return symbolData;
            }
            symbolData = SymbolByFqNameKt.access$extractTypeParameterData(value);
            return symbolData;
            throw new IllegalStateException(("Invalid symbol kind, expected one of: " + this.getIdentifiers()).toString());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t*\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/analysis/api/impl/base/test/SymbolData$EnumEntryInitializerData;", "Lorg/jetbrains/kotlin/analysis/api/impl/base/test/SymbolData;", "enumEntryId", "Lorg/jetbrains/kotlin/name/CallableId;", "<init>", "(Lorg/jetbrains/kotlin/name/CallableId;)V", "getEnumEntryId", "()Lorg/jetbrains/kotlin/name/CallableId;", "toSymbols", "", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaSymbol;", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "analysis-api-impl-base_test"})
    @SourceDebugExtension(value={"SMAP\nSymbolByFqName.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SymbolByFqName.kt\norg/jetbrains/kotlin/analysis/api/impl/base/test/SymbolData$EnumEntryInitializerData\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,212:1\n1#2:213\n*E\n"})
    public static final class EnumEntryInitializerData
    extends SymbolData {
        @NotNull
        private final CallableId enumEntryId;

        public EnumEntryInitializerData(@NotNull CallableId enumEntryId) {
            Intrinsics.checkNotNullParameter((Object)enumEntryId, (String)"enumEntryId");
            super(null);
            this.enumEntryId = enumEntryId;
        }

        @NotNull
        public final CallableId getEnumEntryId() {
            return this.enumEntryId;
        }

        @Override
        @NotNull
        public List<KaSymbol> toSymbols(@NotNull KaSession $this$toSymbols, @NotNull KtFile ktFile) {
            Object v2;
            block8: {
                ClassId classId;
                block10: {
                    block9: {
                        Intrinsics.checkNotNullParameter((Object)$this$toSymbols, (String)"<this>");
                        Intrinsics.checkNotNullParameter((Object)ktFile, (String)"ktFile");
                        classId = this.enumEntryId.getClassId();
                        if (classId == null) break block9;
                        ClassId it = classId;
                        boolean bl = false;
                        KaClassSymbol kaClassSymbol = $this$toSymbols.findClass(it);
                        classId = kaClassSymbol;
                        if (kaClassSymbol != null) break block10;
                    }
                    throw new IllegalStateException(("Cannot find enum class `" + this.enumEntryId.getClassId() + "`.").toString());
                }
                ClassId classSymbol = classId;
                if (!(classSymbol instanceof KaNamedClassSymbol)) {
                    boolean $i$a$-require-SymbolData$EnumEntryInitializerData$toSymbols$32 = false;
                    String $i$a$-require-SymbolData$EnumEntryInitializerData$toSymbols$32 = "" + '`' + this.enumEntryId.getClassId() + "` must be a named class.";
                    throw new IllegalArgumentException($i$a$-require-SymbolData$EnumEntryInitializerData$toSymbols$32.toString());
                }
                if (!(classSymbol.getClassKind() == KaClassKind.ENUM_CLASS)) {
                    boolean $i$a$-require-SymbolData$EnumEntryInitializerData$toSymbols$42 = false;
                    String $i$a$-require-SymbolData$EnumEntryInitializerData$toSymbols$42 = "" + '`' + this.enumEntryId.getClassId() + "` must be an enum class.";
                    throw new IllegalArgumentException($i$a$-require-SymbolData$EnumEntryInitializerData$toSymbols$42.toString());
                }
                Iterable iterable = $this$toSymbols.getEnumEntries((KaNamedClassSymbol)classSymbol);
                for (Object t : iterable) {
                    KaEnumEntrySymbol it = (KaEnumEntrySymbol)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)this.enumEntryId.getCallableName())) continue;
                    v2 = t;
                    break block8;
                }
                v2 = null;
            }
            KaEnumEntrySymbol kaEnumEntrySymbol = v2;
            if (kaEnumEntrySymbol == null) {
                throw new IllegalStateException(("Cannot find enum entry symbol `" + this.enumEntryId + "`.").toString());
            }
            KaEnumEntrySymbol enumEntrySymbol = kaEnumEntrySymbol;
            KaEnumEntryInitializerSymbol kaEnumEntryInitializerSymbol = enumEntrySymbol.getEnumEntryInitializer();
            if (kaEnumEntryInitializerSymbol == null) {
                throw new IllegalStateException(("" + '`' + this.enumEntryId.getCallableName() + "` must have an initializer.").toString());
            }
            KaEnumEntryInitializerSymbol initializerSymbol = kaEnumEntryInitializerSymbol;
            return CollectionsKt.listOf((Object)initializerSymbol);
        }

        @NotNull
        public final CallableId component1() {
            return this.enumEntryId;
        }

        @NotNull
        public final EnumEntryInitializerData copy(@NotNull CallableId enumEntryId) {
            Intrinsics.checkNotNullParameter((Object)enumEntryId, (String)"enumEntryId");
            return new EnumEntryInitializerData(enumEntryId);
        }

        public static /* synthetic */ EnumEntryInitializerData copy$default(EnumEntryInitializerData enumEntryInitializerData, CallableId callableId, int n, Object object) {
            if ((n & 1) != 0) {
                callableId = enumEntryInitializerData.enumEntryId;
            }
            return enumEntryInitializerData.copy(callableId);
        }

        @NotNull
        public String toString() {
            return "EnumEntryInitializerData(enumEntryId=" + this.enumEntryId + ')';
        }

        public int hashCode() {
            return this.enumEntryId.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof EnumEntryInitializerData)) {
                return false;
            }
            EnumEntryInitializerData enumEntryInitializerData = (EnumEntryInitializerData)other;
            return Intrinsics.areEqual((Object)this.enumEntryId, (Object)enumEntryInitializerData.enumEntryId);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t*\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/analysis/api/impl/base/test/SymbolData$PackageData;", "Lorg/jetbrains/kotlin/analysis/api/impl/base/test/SymbolData;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "<init>", "(Lorg/jetbrains/kotlin/name/FqName;)V", "getPackageFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "toSymbols", "", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaSymbol;", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "analysis-api-impl-base_test"})
    public static final class PackageData
    extends SymbolData {
        @NotNull
        private final FqName packageFqName;

        public PackageData(@NotNull FqName packageFqName) {
            Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
            super(null);
            this.packageFqName = packageFqName;
        }

        @NotNull
        public final FqName getPackageFqName() {
            return this.packageFqName;
        }

        @Override
        @NotNull
        public List<KaSymbol> toSymbols(@NotNull KaSession $this$toSymbols, @NotNull KtFile ktFile) {
            Intrinsics.checkNotNullParameter((Object)$this$toSymbols, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)ktFile, (String)"ktFile");
            KaPackageSymbol kaPackageSymbol = $this$toSymbols.findPackage(this.packageFqName);
            if (kaPackageSymbol == null) {
                throw new IllegalStateException(("Cannot find a symbol for the package `" + this.packageFqName + "`.").toString());
            }
            KaPackageSymbol symbol = kaPackageSymbol;
            return CollectionsKt.listOf((Object)symbol);
        }

        @NotNull
        public final FqName component1() {
            return this.packageFqName;
        }

        @NotNull
        public final PackageData copy(@NotNull FqName packageFqName) {
            Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
            return new PackageData(packageFqName);
        }

        public static /* synthetic */ PackageData copy$default(PackageData packageData, FqName fqName, int n, Object object) {
            if ((n & 1) != 0) {
                fqName = packageData.packageFqName;
            }
            return packageData.copy(fqName);
        }

        @NotNull
        public String toString() {
            return "PackageData(packageFqName=" + this.packageFqName + ')';
        }

        public int hashCode() {
            return this.packageFqName.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PackageData)) {
                return false;
            }
            PackageData packageData = (PackageData)other;
            return Intrinsics.areEqual((Object)this.packageFqName, (Object)packageData.packageFqName);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t*\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/analysis/api/impl/base/test/SymbolData$SamConstructorData;", "Lorg/jetbrains/kotlin/analysis/api/impl/base/test/SymbolData;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "<init>", "(Lorg/jetbrains/kotlin/name/ClassId;)V", "getClassId", "()Lorg/jetbrains/kotlin/name/ClassId;", "toSymbols", "", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaSymbol;", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "analysis-api-impl-base_test"})
    public static final class SamConstructorData
    extends SymbolData {
        @NotNull
        private final ClassId classId;

        public SamConstructorData(@NotNull ClassId classId) {
            Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
            super(null);
            this.classId = classId;
        }

        @NotNull
        public final ClassId getClassId() {
            return this.classId;
        }

        @Override
        @NotNull
        public List<KaSymbol> toSymbols(@NotNull KaSession $this$toSymbols, @NotNull KtFile ktFile) {
            KaClassLikeSymbol kaClassLikeSymbol;
            Intrinsics.checkNotNullParameter((Object)$this$toSymbols, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)ktFile, (String)"ktFile");
            KaClassSymbol kaClassSymbol = $this$toSymbols.findClass(this.classId);
            if (kaClassSymbol != null) {
                kaClassLikeSymbol = (KaClassLikeSymbol)kaClassSymbol;
            } else {
                KaTypeAliasSymbol kaTypeAliasSymbol = $this$toSymbols.findTypeAlias(this.classId);
                if (kaTypeAliasSymbol != null) {
                    kaClassLikeSymbol = (KaClassLikeSymbol)kaTypeAliasSymbol;
                } else {
                    throw new IllegalStateException(("Class-like symbol is not found by '" + this.classId + '\'').toString());
                }
            }
            KaClassLikeSymbol symbol = kaClassLikeSymbol;
            KaSamConstructorSymbol kaSamConstructorSymbol = $this$toSymbols.getSamConstructor(symbol);
            if (kaSamConstructorSymbol == null) {
                throw new IllegalStateException(("SAM constructor is not found for symbol '" + symbol + '\'').toString());
            }
            KaSamConstructorSymbol samConstructor = kaSamConstructorSymbol;
            return CollectionsKt.listOf((Object)samConstructor);
        }

        @NotNull
        public final ClassId component1() {
            return this.classId;
        }

        @NotNull
        public final SamConstructorData copy(@NotNull ClassId classId) {
            Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
            return new SamConstructorData(classId);
        }

        public static /* synthetic */ SamConstructorData copy$default(SamConstructorData samConstructorData, ClassId classId, int n, Object object) {
            if ((n & 1) != 0) {
                classId = samConstructorData.classId;
            }
            return samConstructorData.copy(classId);
        }

        @NotNull
        public String toString() {
            return "SamConstructorData(classId=" + this.classId + ')';
        }

        public int hashCode() {
            return this.classId.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SamConstructorData)) {
                return false;
            }
            SamConstructorData samConstructorData = (SamConstructorData)other;
            return Intrinsics.areEqual((Object)this.classId, (Object)samConstructorData.classId);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005*\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/analysis/api/impl/base/test/SymbolData$ScriptData;", "Lorg/jetbrains/kotlin/analysis/api/impl/base/test/SymbolData;", "<init>", "()V", "toSymbols", "", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaSymbol;", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "analysis-api-impl-base_test"})
    public static final class ScriptData
    extends SymbolData {
        @NotNull
        public static final ScriptData INSTANCE = new ScriptData();

        private ScriptData() {
            super(null);
        }

        @Override
        @NotNull
        public List<KaSymbol> toSymbols(@NotNull KaSession $this$toSymbols, @NotNull KtFile ktFile) {
            Intrinsics.checkNotNullParameter((Object)$this$toSymbols, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)ktFile, (String)"ktFile");
            KtScript ktScript = ktFile.getScript();
            if (ktScript == null) {
                throw new IllegalStateException("Script is not found".toString());
            }
            KtScript script = ktScript;
            return CollectionsKt.listOf((Object)$this$toSymbols.getSymbol(script));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t*\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/analysis/api/impl/base/test/SymbolData$TypeAliasData;", "Lorg/jetbrains/kotlin/analysis/api/impl/base/test/SymbolData;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "<init>", "(Lorg/jetbrains/kotlin/name/ClassId;)V", "getClassId", "()Lorg/jetbrains/kotlin/name/ClassId;", "toSymbols", "", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaSymbol;", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "analysis-api-impl-base_test"})
    public static final class TypeAliasData
    extends SymbolData {
        @NotNull
        private final ClassId classId;

        public TypeAliasData(@NotNull ClassId classId) {
            Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
            super(null);
            this.classId = classId;
        }

        @NotNull
        public final ClassId getClassId() {
            return this.classId;
        }

        @Override
        @NotNull
        public List<KaSymbol> toSymbols(@NotNull KaSession $this$toSymbols, @NotNull KtFile ktFile) {
            Intrinsics.checkNotNullParameter((Object)$this$toSymbols, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)ktFile, (String)"ktFile");
            KaTypeAliasSymbol kaTypeAliasSymbol = $this$toSymbols.findTypeAlias(this.classId);
            if (kaTypeAliasSymbol == null) {
                throw new IllegalStateException(("Type alias " + this.classId + " is not found").toString());
            }
            KaTypeAliasSymbol symbol = kaTypeAliasSymbol;
            return CollectionsKt.listOf((Object)symbol);
        }

        @NotNull
        public final ClassId component1() {
            return this.classId;
        }

        @NotNull
        public final TypeAliasData copy(@NotNull ClassId classId) {
            Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
            return new TypeAliasData(classId);
        }

        public static /* synthetic */ TypeAliasData copy$default(TypeAliasData typeAliasData, ClassId classId, int n, Object object) {
            if ((n & 1) != 0) {
                classId = typeAliasData.classId;
            }
            return typeAliasData.copy(classId);
        }

        @NotNull
        public String toString() {
            return "TypeAliasData(classId=" + this.classId + ')';
        }

        public int hashCode() {
            return this.classId.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TypeAliasData)) {
                return false;
            }
            TypeAliasData typeAliasData = (TypeAliasData)other;
            return Intrinsics.areEqual((Object)this.classId, (Object)typeAliasData.classId);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0001H\u00c6\u0003J\u001d\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0001H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/analysis/api/impl/base/test/SymbolData$TypeParameterData;", "Lorg/jetbrains/kotlin/analysis/api/impl/base/test/SymbolData;", "name", "Lorg/jetbrains/kotlin/name/Name;", "ownerData", "<init>", "(Lorg/jetbrains/kotlin/name/Name;Lorg/jetbrains/kotlin/analysis/api/impl/base/test/SymbolData;)V", "getName", "()Lorg/jetbrains/kotlin/name/Name;", "getOwnerData", "()Lorg/jetbrains/kotlin/analysis/api/impl/base/test/SymbolData;", "toSymbols", "", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaSymbol;", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "analysis-api-impl-base_test"})
    @SourceDebugExtension(value={"SMAP\nSymbolByFqName.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SymbolByFqName.kt\norg/jetbrains/kotlin/analysis/api/impl/base/test/SymbolData$TypeParameterData\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 checks.kt\norg/jetbrains/kotlin/analysis/utils/errors/ChecksKt\n*L\n1#1,212:1\n1#2:213\n1#2:215\n16#3:214\n17#3:216\n*S KotlinDebug\n*F\n+ 1 SymbolByFqName.kt\norg/jetbrains/kotlin/analysis/api/impl/base/test/SymbolData$TypeParameterData\n*L\n153#1:215\n153#1:214\n153#1:216\n*E\n"})
    public static final class TypeParameterData
    extends SymbolData {
        @NotNull
        private final Name name;
        @NotNull
        private final SymbolData ownerData;

        public TypeParameterData(@NotNull Name name, @NotNull SymbolData ownerData) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)ownerData, (String)"ownerData");
            super(null);
            this.name = name;
            this.ownerData = ownerData;
        }

        @NotNull
        public final Name getName() {
            return this.name;
        }

        @NotNull
        public final SymbolData getOwnerData() {
            return this.ownerData;
        }

        @Override
        @NotNull
        public List<KaSymbol> toSymbols(@NotNull KaSession $this$toSymbols, @NotNull KtFile ktFile) {
            Object v1;
            block4: {
                Intrinsics.checkNotNullParameter((Object)$this$toSymbols, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)ktFile, (String)"ktFile");
                SymbolData $this$toSymbols_u24lambda_u240 = this.ownerData;
                boolean bl = false;
                KaSymbol kaSymbol = (KaSymbol)CollectionsKt.singleOrNull($this$toSymbols_u24lambda_u240.toSymbols($this$toSymbols, ktFile));
                if (kaSymbol == null) {
                    throw new IllegalStateException("No owner found".toString());
                }
                KaSymbol owner = kaSymbol;
                boolean $i$f$requireIsInstance = false;
                if (!(owner instanceof KaDeclarationSymbol)) {
                    boolean bl2 = false;
                    String string = "Expected " + Reflection.getOrCreateKotlinClass(KaDeclarationSymbol.class) + " instead of " + Reflection.getOrCreateKotlinClass(owner.getClass()) + " for " + owner;
                    throw new IllegalArgumentException(string.toString());
                }
                Iterable iterable = KaDeclarationSymbolKt.getTypeParameters((KaDeclarationSymbol)((KaDeclarationSymbol)owner));
                for (Object t : iterable) {
                    KaTypeParameterSymbol it = (KaTypeParameterSymbol)t;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)this.name)) continue;
                    v1 = t;
                    break block4;
                }
                v1 = null;
            }
            KaTypeParameterSymbol kaTypeParameterSymbol = v1;
            if (kaTypeParameterSymbol == null) {
                throw new IllegalStateException(("Type parameter with '" + this.name + "' name is not found in " + this.ownerData).toString());
            }
            KaTypeParameterSymbol parameterSymbol = kaTypeParameterSymbol;
            return CollectionsKt.listOf((Object)parameterSymbol);
        }

        @NotNull
        public final Name component1() {
            return this.name;
        }

        @NotNull
        public final SymbolData component2() {
            return this.ownerData;
        }

        @NotNull
        public final TypeParameterData copy(@NotNull Name name, @NotNull SymbolData ownerData) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)ownerData, (String)"ownerData");
            return new TypeParameterData(name, ownerData);
        }

        public static /* synthetic */ TypeParameterData copy$default(TypeParameterData typeParameterData, Name name, SymbolData symbolData, int n, Object object) {
            if ((n & 1) != 0) {
                name = typeParameterData.name;
            }
            if ((n & 2) != 0) {
                symbolData = typeParameterData.ownerData;
            }
            return typeParameterData.copy(name, symbolData);
        }

        @NotNull
        public String toString() {
            return "TypeParameterData(name=" + this.name + ", ownerData=" + this.ownerData + ')';
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + this.ownerData.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TypeParameterData)) {
                return false;
            }
            TypeParameterData typeParameterData = (TypeParameterData)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)typeParameterData.name)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.ownerData, (Object)typeParameterData.ownerData);
        }
    }
}

