/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.test.framework.services.libraries;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.test.framework.services.libraries.CliTestModuleCompiler;
import org.jetbrains.kotlin.analysis.test.framework.services.libraries.CompilerExecutor;
import org.jetbrains.kotlin.analysis.test.framework.services.libraries.JsKlibTestModuleCompiler;
import org.jetbrains.kotlin.analysis.test.framework.services.libraries.JvmJarTestModuleCompiler;
import org.jetbrains.kotlin.analysis.test.framework.services.libraries.TestModuleCompiler;
import org.jetbrains.kotlin.platform.JsPlatformKt;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/analysis/test/framework/services/libraries/DispatchingTestModuleCompiler;", "Lorg/jetbrains/kotlin/analysis/test/framework/services/libraries/TestModuleCompiler;", "<init>", "()V", "compilersByKind", "", "Lorg/jetbrains/kotlin/analysis/test/framework/services/libraries/CompilerExecutor$CompilerKind;", "Lorg/jetbrains/kotlin/analysis/test/framework/services/libraries/CliTestModuleCompiler;", "compile", "Ljava/nio/file/Path;", "tmpDir", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "dependencyBinaryRoots", "", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "compileTestModuleToLibrarySources", "getCompiler", "analysis-test-framework_test"})
public final class DispatchingTestModuleCompiler
extends TestModuleCompiler {
    @NotNull
    private final Map<CompilerExecutor.CompilerKind, CliTestModuleCompiler> compilersByKind;

    public DispatchingTestModuleCompiler() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)CompilerExecutor.CompilerKind.JVM), (Object)new JvmJarTestModuleCompiler()), TuplesKt.to((Object)((Object)CompilerExecutor.CompilerKind.JS), (Object)new JsKlibTestModuleCompiler())};
        this.compilersByKind = MapsKt.mapOf((Pair[])pairArray);
    }

    @Override
    @NotNull
    public Path compile(@NotNull Path tmpDir, @NotNull TestModule module, @NotNull Collection<? extends Path> dependencyBinaryRoots, @NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)tmpDir, (String)"tmpDir");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(dependencyBinaryRoots, (String)"dependencyBinaryRoots");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        return this.getCompiler(module).compileTestModuleToLibrary(module, dependencyBinaryRoots, testServices);
    }

    @Override
    @NotNull
    public Path compileTestModuleToLibrarySources(@NotNull TestModule module, @NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        return this.getCompiler(module).compileTestModuleToLibrarySources(module, testServices);
    }

    private final CliTestModuleCompiler getCompiler(TestModule module) {
        CompilerExecutor.CompilerKind compilerKind;
        if (JvmPlatformKt.isJvm((TargetPlatform)module.getTargetPlatform())) {
            compilerKind = CompilerExecutor.CompilerKind.JVM;
        } else if (JsPlatformKt.isJs((TargetPlatform)module.getTargetPlatform())) {
            compilerKind = CompilerExecutor.CompilerKind.JS;
        } else {
            throw new IllegalStateException(("DispatchingTestModuleCompiler doesn't support the platform: " + module.getTargetPlatform()).toString());
        }
        CompilerExecutor.CompilerKind compilerKindForModule = compilerKind;
        CliTestModuleCompiler cliTestModuleCompiler = this.compilersByKind.get((Object)compilerKindForModule);
        if (cliTestModuleCompiler == null) {
            throw new IllegalStateException(("TestModuleCompiler is not available for " + compilerKindForModule.name()).toString());
        }
        return cliTestModuleCompiler;
    }
}

