/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.stub.files;

import com.intellij.core.CoreApplicationEnvironment;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.impl.jar.CoreJarFileSystem;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.ClsKotlinBinaryClassCache;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.DummyFileAttributeService;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.FileAttributeService;
import org.jetbrains.kotlin.analysis.decompiler.stub.files.AbstractDecompiledClassTest;
import org.jetbrains.kotlin.analysis.decompiler.stub.files.TestData;
import org.jetbrains.kotlin.cli.common.arguments.CommonToolArgumentsKt;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.test.ApplicationEnvironmentDisposer;
import org.jetbrains.kotlin.test.CompilerTestUtil;
import org.jetbrains.kotlin.test.ConfigurationKind;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.KotlinTestWithEnvironment;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0014J\b\u0010\n\u001a\u00020\u000bH\u0014J\f\u0010\f\u001a\u00020\u000b*\u00020\rH\u0002J\u001d\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u0013J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/stub/files/AbstractDecompiledClassTest;", "Lorg/jetbrains/kotlin/test/KotlinTestWithEnvironment;", "<init>", "()V", "useK2ToCompileCode", "", "getUseK2ToCompileCode", "()Z", "createEnvironment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "setUp", "", "registerApplicationServices", "Lcom/intellij/core/CoreApplicationEnvironment;", "getClassFileToDecompile", "Lcom/intellij/openapi/vfs/VirtualFile;", "testData", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/files/TestData;", "useStringTable", "getClassFileToDecompile$decompiler_to_file_stubs_test", "getLanguageVersionToCompile", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "findClassFileByName", "library", "Ljava/nio/file/Path;", "className", "", "decompiler-to-file-stubs_test"})
public abstract class AbstractDecompiledClassTest
extends KotlinTestWithEnvironment {
    private final boolean useK2ToCompileCode;

    protected boolean getUseK2ToCompileCode() {
        return this.useK2ToCompileCode;
    }

    @NotNull
    protected KotlinCoreEnvironment createEnvironment() {
        KotlinCoreEnvironment kotlinCoreEnvironment = KotlinTestUtils.createEnvironmentWithMockJdkAndIdeaAnnotations((Disposable)ApplicationEnvironmentDisposer.Companion.getROOT_DISPOSABLE(), (ConfigurationKind)ConfigurationKind.JDK_NO_RUNTIME);
        Intrinsics.checkNotNullExpressionValue((Object)kotlinCoreEnvironment, (String)"createEnvironmentWithMoc\u2026dkAndIdeaAnnotations(...)");
        return kotlinCoreEnvironment;
    }

    protected void setUp() {
        super.setUp();
        CoreApplicationEnvironment $this$setUp_u24lambda_u240 = this.getEnvironment().getProjectEnvironment().getEnvironment();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)$this$setUp_u24lambda_u240);
        this.registerApplicationServices($this$setUp_u24lambda_u240);
    }

    private final void registerApplicationServices(CoreApplicationEnvironment $this$registerApplicationServices) {
        if ($this$registerApplicationServices.getApplication().getService(FileAttributeService.class) == null) {
            $this$registerApplicationServices.registerApplicationService(FileAttributeService.class, (Object)new DummyFileAttributeService());
            $this$registerApplicationServices.registerApplicationService(ClsKotlinBinaryClassCache.class, (Object)new ClsKotlinBinaryClassCache());
        }
    }

    @NotNull
    public final VirtualFile getClassFileToDecompile$decompiler_to_file_stubs_test(@NotNull TestData testData, boolean useStringTable) {
        List list;
        Intrinsics.checkNotNullParameter((Object)testData, (String)"testData");
        List $this$getClassFileToDecompile_u24lambda_u241 = list = kotlin.collections.CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$getClassFileToDecompile_u24lambda_u241.add(CommonToolArgumentsKt.getCliArgument((KProperty1)((KProperty1)getClassFileToDecompile.extraOptions.1.1.INSTANCE)));
        if (useStringTable) {
            $this$getClassFileToDecompile_u24lambda_u241.add(CommonToolArgumentsKt.getCliArgument((KProperty1)((KProperty1)getClassFileToDecompile.extraOptions.1.2.INSTANCE)));
        }
        $this$getClassFileToDecompile_u24lambda_u241.addAll((Collection)testData.getAdditionalCompilerOptions());
        Object[] objectArray = new String[]{CommonToolArgumentsKt.getCliArgument((KProperty1)((KProperty1)getClassFileToDecompile.extraOptions.1.3.INSTANCE)), this.getLanguageVersionToCompile().getVersionString()};
        $this$getClassFileToDecompile_u24lambda_u241.addAll(kotlin.collections.CollectionsKt.listOf((Object[])objectArray));
        List extraOptions2 = kotlin.collections.CollectionsKt.build((List)list);
        File file = testData.getDirectory().toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        Path library = CompilerTestUtil.compileJvmLibrary$default((File)file, null, (List)extraOptions2, null, null, (int)26, null).toPath();
        Intrinsics.checkNotNull((Object)library);
        return this.findClassFileByName(library, testData.getJvmFileName());
    }

    /*
     * WARNING - void declaration
     */
    private final LanguageVersion getLanguageVersionToCompile() {
        LanguageVersion languageVersion;
        if (this.getUseK2ToCompileCode()) {
            void var1_1;
            LanguageVersion k2Version = (LanguageVersion)ComparisonsKt.maxOf((Comparable)((Comparable)LanguageVersion.LATEST_STABLE), (Comparable)((Comparable)LanguageVersion.KOTLIN_2_0));
            if (!k2Version.getUsesK2()) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            languageVersion = var1_1;
        } else {
            languageVersion = LanguageVersion.KOTLIN_1_9;
        }
        return languageVersion;
    }

    private final VirtualFile findClassFileByName(Path library, String className) {
        VirtualFileSystem virtualFileSystem = this.getEnvironment().getProjectEnvironment().getEnvironment().getJarFileSystem();
        Intrinsics.checkNotNull((Object)virtualFileSystem, (String)"null cannot be cast to non-null type com.intellij.openapi.vfs.impl.jar.CoreJarFileSystem");
        CoreJarFileSystem jarFileSystem = (CoreJarFileSystem)virtualFileSystem;
        VirtualFile virtualFile = jarFileSystem.refreshAndFindFileByPath(((Object)library.toAbsolutePath()).toString() + "!/");
        Intrinsics.checkNotNull((Object)virtualFile);
        VirtualFile root = virtualFile;
        Set files = new LinkedHashSet();
        VfsUtilCore.iterateChildrenRecursively((VirtualFile)root, arg_0 -> AbstractDecompiledClassTest.findClassFileByName$lambda$2(className, arg_0), arg_0 -> AbstractDecompiledClassTest.findClassFileByName$lambda$3(files, arg_0));
        return (VirtualFile)kotlin.collections.CollectionsKt.single((Iterable)files);
    }

    private static final boolean findClassFileByName$lambda$2(String $className, VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        return virtualFile.isDirectory() || Intrinsics.areEqual((Object)virtualFile.getName(), (Object)($className + ".class"));
    }

    private static final boolean findClassFileByName$lambda$3(Set $files, VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        if (!virtualFile.isDirectory()) {
            CollectionsKt.addIfNotNull((Collection)$files, (Object)virtualFile);
        }
        return true;
    }
}

