/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.impl.base.test.cases.symbols;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KtAnalysisSession;
import org.jetbrains.kotlin.analysis.api.symbols.KtCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtFileSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtSymbolOrigin;
import org.jetbrains.kotlin.analysis.api.symbols.markers.KtSymbolKind;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtilKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.test.services.AssertionsKt;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a)\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000R\u00020\u0002\u00a2\u0006\u0002\u0010\t\u001a3\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0005\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\bH\u0000R\u00020\u0002\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"checkContainingFileSymbol", "", "Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;", "ktFileSymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtFileSymbol;", "symbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtSymbol;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;Lorg/jetbrains/kotlin/analysis/api/symbols/KtFileSymbol;Lorg/jetbrains/kotlin/analysis/api/symbols/KtSymbol;Lorg/jetbrains/kotlin/test/services/TestServices;)V", "checkContainingJvmClassName", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "ktClass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtCallableSymbol;", "(Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;Lorg/jetbrains/kotlin/psi/KtFile;Lorg/jetbrains/kotlin/psi/KtClassOrObject;Lorg/jetbrains/kotlin/analysis/api/symbols/KtCallableSymbol;Lorg/jetbrains/kotlin/test/services/TestServices;)V", "analysis-api-impl-base_test"})
public final class SymbolTestUtilsKt {
    public static final void checkContainingFileSymbol(@NotNull KtAnalysisSession $context_receiver_0, @NotNull KtFileSymbol ktFileSymbol, @NotNull KtSymbol symbol, @NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)ktFileSymbol, (String)"ktFileSymbol");
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        if (symbol.getOrigin() != KtSymbolOrigin.SOURCE) {
            return;
        }
        KtFileSymbol containingFileSymbol = $context_receiver_0.getContainingFileSymbol(symbol);
        AssertionsKt.getAssertions((TestServices)testServices).assertEquals((Object)ktFileSymbol, (Object)containingFileSymbol, () -> SymbolTestUtilsKt.checkContainingFileSymbol$lambda$0(symbol, ktFileSymbol, containingFileSymbol));
    }

    public static final void checkContainingJvmClassName(@NotNull KtAnalysisSession $context_receiver_0, @NotNull KtFile ktFile, @Nullable KtClassOrObject ktClass, @NotNull KtCallableSymbol symbol, @NotNull TestServices testServices) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)ktFile, (String)"ktFile");
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        if (ktFile.isScript()) {
            return;
        }
        if (symbol.getSymbolKind() == KtSymbolKind.LOCAL) {
            string = null;
        } else if (ktClass != null) {
            ClassId classId = ktClass.getClassId();
            string = classId != null ? classId.asFqNameString() : null;
        } else {
            string = JvmFileClassUtilKt.getJavaFileFacadeFqName((KtFile)ktFile).asString();
        }
        String expectedClassName = string;
        String actualClassName = $context_receiver_0.getContainingJvmClassName(symbol);
        AssertionsKt.getAssertions((TestServices)testServices).assertEquals((Object)expectedClassName, (Object)actualClassName, () -> SymbolTestUtilsKt.checkContainingJvmClassName$lambda$1(symbol, expectedClassName, actualClassName));
    }

    private static final String checkContainingFileSymbol$lambda$0(KtSymbol $symbol, KtFileSymbol $ktFileSymbol, KtFileSymbol $containingFileSymbol) {
        Intrinsics.checkNotNullParameter((Object)$symbol, (String)"$symbol");
        Intrinsics.checkNotNullParameter((Object)$ktFileSymbol, (String)"$ktFileSymbol");
        return "Invalid file for " + $symbol + ", expected " + $ktFileSymbol + " but " + $containingFileSymbol + " found";
    }

    private static final String checkContainingJvmClassName$lambda$1(KtCallableSymbol $symbol, String $expectedClassName, String $actualClassName) {
        Intrinsics.checkNotNullParameter((Object)$symbol, (String)"$symbol");
        return "Invalid JvmClassName for " + $symbol + ", expected " + $expectedClassName + " but " + $actualClassName + " found";
    }
}

