/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.impl.base.test.cases.annotations;

import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KtAnalysisSession;
import org.jetbrains.kotlin.analysis.api.annotations.KtAnnotationApplication;
import org.jetbrains.kotlin.analysis.api.annotations.KtAnnotationApplicationWithArgumentsInfo;
import org.jetbrains.kotlin.analysis.api.annotations.KtAnnotationsList;
import org.jetbrains.kotlin.analysis.api.symbols.DebugSymbolRenderer;
import org.jetbrains.kotlin.analysis.api.symbols.KtClassOrObjectSymbol;
import org.jetbrains.kotlin.analysis.test.framework.utils.CommonTestUtilsKt;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bR\u00020\u0006\u00a2\u0006\u0002\u0010\tJ\u0017\u0010\n\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bR\u00020\u0006\u00a2\u0006\u0002\u0010\tJ9\u0010\u000b\u001a\u00020\f*\u00060\u000ej\u0002`\r2\u0006\u0010\u0007\u001a\u00020\b2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u00020\u0006\u00a2\u0006\u0002\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/analysis/api/impl/base/test/cases/annotations/TestAnnotationRenderer;", "", "<init>", "()V", "renderAnnotations", "", "Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;", "annotations", "Lorg/jetbrains/kotlin/analysis/api/annotations/KtAnnotationsList;", "(Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;Lorg/jetbrains/kotlin/analysis/api/annotations/KtAnnotationsList;)Ljava/lang/String;", "renderAnnotationsWithMeta", "renderAnnotationsRecursive", "", "Lkotlin/text/StringBuilder;", "Ljava/lang/StringBuilder;", "currentMetaAnnotations", "", "Lorg/jetbrains/kotlin/name/ClassId;", "indent", "", "(Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;Ljava/lang/StringBuilder;Lorg/jetbrains/kotlin/analysis/api/annotations/KtAnnotationsList;Ljava/util/Set;I)V", "analysis-api-impl-base_test"})
public final class TestAnnotationRenderer {
    @NotNull
    public static final TestAnnotationRenderer INSTANCE = new TestAnnotationRenderer();

    private TestAnnotationRenderer() {
    }

    @NotNull
    public final String renderAnnotations(@NotNull KtAnalysisSession $context_receiver_0, @NotNull KtAnnotationsList annotations) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)annotations, (String)"annotations");
        StringBuilder $this$renderAnnotations_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        INSTANCE.renderAnnotationsRecursive($context_receiver_0, $this$renderAnnotations_u24lambda_u240, annotations, null, 0);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final String renderAnnotationsWithMeta(@NotNull KtAnalysisSession $context_receiver_0, @NotNull KtAnnotationsList annotations) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)annotations, (String)"annotations");
        StringBuilder $this$renderAnnotationsWithMeta_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        INSTANCE.renderAnnotationsRecursive($context_receiver_0, $this$renderAnnotationsWithMeta_u24lambda_u241, annotations, SetsKt.emptySet(), 0);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final void renderAnnotationsRecursive(KtAnalysisSession $context_receiver_0, StringBuilder $this$renderAnnotationsRecursive, KtAnnotationsList annotations, Set<ClassId> currentMetaAnnotations, int indent) {
        StringBuilder stringBuilder = $this$renderAnnotationsRecursive.append(CommonTestUtilsKt.indented("annotations: [", indent));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
        for (KtAnnotationApplicationWithArgumentsInfo annotation : annotations.getAnnotations()) {
            Object object;
            KtAnnotationsList metaAnnotations;
            ClassId classId;
            StringBuilder stringBuilder2 = $this$renderAnnotationsRecursive.append(CommonTestUtilsKt.indented(new DebugSymbolRenderer(false, false, false, 7, null).renderAnnotationApplication($context_receiver_0, (KtAnnotationApplication)annotation), indent + 2));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
            if (currentMetaAnnotations == null || annotation.getClassId() == null) continue;
            if (currentMetaAnnotations.contains(classId)) {
                StringBuilder stringBuilder3 = $this$renderAnnotationsRecursive.append(CommonTestUtilsKt.indented("<recursive meta-annotation " + classId + '>', indent + 4));
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
                continue;
            }
            KtClassOrObjectSymbol ktClassOrObjectSymbol = $context_receiver_0.getClassOrObjectSymbolByClassId(classId);
            Object object2 = metaAnnotations = ktClassOrObjectSymbol != null ? ktClassOrObjectSymbol.getAnnotationsList() : null;
            if (metaAnnotations != null) {
                this.renderAnnotationsRecursive($context_receiver_0, $this$renderAnnotationsRecursive, metaAnnotations, SetsKt.plus(currentMetaAnnotations, (Object)classId), indent + 4);
                object = Unit.INSTANCE;
                continue;
            }
            StringBuilder stringBuilder4 = $this$renderAnnotationsRecursive.append(CommonTestUtilsKt.indented("<unknown meta-annotation " + classId + '>', indent + 4));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
            StringBuilder stringBuilder5 = stringBuilder4.append('\n');
            object = stringBuilder5;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
        }
        StringBuilder stringBuilder6 = $this$renderAnnotationsRecursive.append(CommonTestUtilsKt.indented("]", indent));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6.append('\n'), (String)"append(...)");
    }
}

