/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.standalone.fir.test.cases.session.builder;

import com.intellij.mock.MockVirtualFileSystem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KtAnalysisSession;
import org.jetbrains.kotlin.analysis.api.calls.KtCallInfo;
import org.jetbrains.kotlin.analysis.api.calls.KtCallKt;
import org.jetbrains.kotlin.analysis.api.calls.KtCallableMemberCall;
import org.jetbrains.kotlin.analysis.api.calls.KtFunctionCall;
import org.jetbrains.kotlin.analysis.api.calls.KtSuccessCallInfo;
import org.jetbrains.kotlin.analysis.api.session.KtAnalysisSessionProvider;
import org.jetbrains.kotlin.analysis.api.symbols.KtFunctionLikeSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtFunctionSymbol;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.test.MockLibraryUtil;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.junit.jupiter.api.Assertions;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0012\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u0010\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u0001H\u0000\u001a*\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0000\u00a8\u0006\u0013"}, d2={"testDataPath", "Ljava/nio/file/Path;", "path", "", "assertIsCallOf", "", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "callableId", "Lorg/jetbrains/kotlin/name/CallableId;", "compileCommonKlib", "kLibSourcesRoot", "createDumbVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "fileName", "text", "fileSystem", "Lcom/intellij/openapi/vfs/VirtualFileSystem;", "analysis-api-standalone_test"})
@SourceDebugExtension(value={"SMAP\nsessionBuilderTestUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 sessionBuilderTestUtils.kt\norg/jetbrains/kotlin/analysis/api/standalone/fir/test/cases/session/builder/SessionBuilderTestUtilsKt\n+ 2 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 3 KtAnalysisSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KtAnalysisSessionProvider\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,110:1\n29#2,2:111\n46#3:113\n60#3,8:114\n1628#4,3:122\n*S KotlinDebug\n*F\n+ 1 sessionBuilderTestUtils.kt\norg/jetbrains/kotlin/analysis/api/standalone/fir/test/cases/session/builder/SessionBuilderTestUtilsKt\n*L\n40#1:111,2\n40#1:113\n40#1:114,8\n54#1:122,3\n*E\n"})
public final class SessionBuilderTestUtilsKt {
    @NotNull
    public static final Path testDataPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path path2 = Paths.get("analysis/analysis-api-standalone/testData/sessionBuilder", new String[0]).resolve(path);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        return path2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void assertIsCallOf(@NotNull KtCallExpression $this$assertIsCallOf, @NotNull CallableId callableId) {
        void this_$iv$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$assertIsCallOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)callableId, (String)"callableId");
        boolean $i$f$analyze = false;
        Project project = ((KtElement)$this$assertIsCallOf).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtAnalysisSessionProvider this_$iv$iv = KtAnalysisSessionProvider.Companion.getInstance(project);
        boolean $i$f$analyse = false;
        KtAnalysisSessionProvider ktAnalysisSessionProvider = this_$iv$iv;
        KtAnalysisSession analysisSession$iv$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)$this$assertIsCallOf);
        boolean $i$f$analyse2 = false;
        this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().beforeEnteringAnalysisContext();
        this_$iv$iv$iv.getTokenFactory().beforeEnteringAnalysisContext(analysisSession$iv$iv$iv.getToken());
        try {
            KtAnalysisSession $this$assertIsCallOf_u24lambda_u240 = analysisSession$iv$iv$iv;
            boolean bl = false;
            KtCallInfo ktCallInfo = $this$assertIsCallOf_u24lambda_u240.resolveCall((KtElement)$this$assertIsCallOf);
            Assertions.assertInstanceOf(KtSuccessCallInfo.class, (Object)ktCallInfo);
            Intrinsics.checkNotNull((Object)ktCallInfo, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.analysis.api.calls.KtSuccessCallInfo");
            KtSuccessCallInfo cfr_ignored_0 = (KtSuccessCallInfo)ktCallInfo;
            KtFunctionCall ktFunctionCall = KtCallKt.successfulFunctionCallOrNull((KtCallInfo)ktCallInfo);
            KtFunctionLikeSymbol symbol = ktFunctionCall != null ? (KtFunctionLikeSymbol)KtCallKt.getSymbol((KtCallableMemberCall)((KtCallableMemberCall)ktFunctionCall)) : null;
            Assertions.assertInstanceOf(KtFunctionSymbol.class, (Object)symbol);
            Intrinsics.checkNotNull((Object)symbol, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.analysis.api.symbols.KtFunctionSymbol");
            KtFunctionSymbol cfr_ignored_1 = (KtFunctionSymbol)symbol;
            Assertions.assertEquals((Object)callableId, (Object)((KtFunctionSymbol)symbol).getCallableIdIfNonLocal());
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv$iv$iv.getTokenFactory().afterLeavingAnalysisContext(analysisSession$iv$iv$iv.getToken());
            this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().afterLeavingAnalysisContext();
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Path compileCommonKlib(@NotNull Path kLibSourcesRoot) {
        List list;
        Intrinsics.checkNotNullParameter((Object)kLibSourcesRoot, (String)"kLibSourcesRoot");
        Stream<Path> stream = Files.walk(kLibSourcesRoot, new FileVisitOption[0]);
        Intrinsics.checkNotNullExpressionValue(stream, (String)"walk(...)");
        List ktFiles = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)StreamsKt.asSequence(stream), SessionBuilderTestUtilsKt::compileCommonKlib$lambda$1));
        File file = KtTestUtil.tmpDir((String)"testLibrary");
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"tmpDir(...)");
        Path testKlib = FilesKt.resolve((File)file, (String)"library.klib").toPath();
        List $this$compileCommonKlib_u24lambda_u243 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        Iterable $this$mapTo$iv = ktFiles;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            Path path = (Path)item$iv;
            Collection collection = $this$compileCommonKlib_u24lambda_u243;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(((Object)it.toAbsolutePath()).toString());
        }
        $this$compileCommonKlib_u24lambda_u243.add("-d");
        Intrinsics.checkNotNull((Object)testKlib);
        $this$compileCommonKlib_u24lambda_u243.add(((Object)testKlib.toAbsolutePath()).toString());
        List arguments = CollectionsKt.build((List)list);
        MockLibraryUtil.INSTANCE.runMetadataCompiler(arguments);
        return testKlib;
    }

    @NotNull
    public static final VirtualFile createDumbVirtualFile(@NotNull Project project, @NotNull String fileName, @NotNull String text2, @NotNull VirtualFileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        KtPsiFactory factory = new KtPsiFactory(project, false);
        KtFile ktFile = factory.createFile(fileName, text2);
        return new VirtualFile(fileSystem, fileName, ktFile){
            private final long timeStamp;
            final /* synthetic */ VirtualFileSystem $fileSystem;
            final /* synthetic */ String $fileName;
            final /* synthetic */ KtFile $ktFile;
            {
                this.$fileSystem = $fileSystem;
                this.$fileName = $fileName;
                this.$ktFile = $ktFile;
                this.timeStamp = LocalDateTime.now().toEpochSecond(ZoneOffset.UTC);
            }

            public VirtualFileSystem getFileSystem() {
                return this.$fileSystem;
            }

            public String getName() {
                return this.$fileName;
            }

            public String getPath() {
                return '/' + this.$fileName;
            }

            public boolean isWritable() {
                return false;
            }

            public boolean isDirectory() {
                return false;
            }

            public boolean isValid() {
                return this.$ktFile.isValid();
            }

            public VirtualFile getParent() {
                throw new IllegalStateException("Not yet implemented".toString());
            }

            public VirtualFile[] getChildren() {
                return new VirtualFile[0];
            }

            public InputStream getInputStream() {
                throw new IllegalStateException("Not yet implemented".toString());
            }

            public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) {
                throw new IllegalStateException("Not yet implemented".toString());
            }

            public byte[] contentsToByteArray() {
                String string = this.$ktFile.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                String string2 = string;
                byte[] byArray = string2.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                return byArray;
            }

            public long getLength() {
                return this.$ktFile.getTextLength();
            }

            public long getTimeStamp() {
                return this.timeStamp;
            }

            public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
            }
        };
    }

    public static /* synthetic */ VirtualFile createDumbVirtualFile$default(Project project, String string, String string2, VirtualFileSystem virtualFileSystem, int n, Object object) {
        if ((n & 8) != 0) {
            virtualFileSystem = (VirtualFileSystem)new MockVirtualFileSystem();
        }
        return SessionBuilderTestUtilsKt.createDumbVirtualFile(project, string, string2, virtualFileSystem);
    }

    private static final boolean compileCommonKlib$lambda$1(Path it) {
        Intrinsics.checkNotNull((Object)it);
        return Intrinsics.areEqual((Object)PathsKt.getExtension((Path)it), (Object)"kt");
    }
}

