/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.test.framework.base;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KtAnalysisSession;
import org.jetbrains.kotlin.analysis.api.session.KtAnalysisSessionProvider;
import org.jetbrains.kotlin.analysis.project.structure.DanglingFileResolutionMode;
import org.jetbrains.kotlin.analysis.project.structure.ProjectStructureProviderKt;
import org.jetbrains.kotlin.analysis.test.framework.AnalysisApiTestDirectives;
import org.jetbrains.kotlin.analysis.test.framework.TestWithDisposable;
import org.jetbrains.kotlin.analysis.test.framework.base.AbstractAnalysisApiBasedTest;
import org.jetbrains.kotlin.analysis.test.framework.base.RegisterBaseTestServicesKt;
import org.jetbrains.kotlin.analysis.test.framework.project.structure.AnalysisApiKtModuleProviderImplKt;
import org.jetbrains.kotlin.analysis.test.framework.project.structure.KtTestModule;
import org.jetbrains.kotlin.analysis.test.framework.services.ExpressionMarkerProvider;
import org.jetbrains.kotlin.analysis.test.framework.services.ExpressionMarkersSourceFilePreprocessorKt;
import org.jetbrains.kotlin.analysis.test.framework.services.libraries.TestModuleCompiler;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiTestConfigurator;
import org.jetbrains.kotlin.analysis.test.framework.utils.CommonTestUtilsKt;
import org.jetbrains.kotlin.analysis.test.framework.utils.SkipTestException;
import org.jetbrains.kotlin.platform.jvm.JvmPlatforms;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.TestConfiguration;
import org.jetbrains.kotlin.test.builders.DefaultsProviderBuilder;
import org.jetbrains.kotlin.test.builders.TestConfigurationBuilder;
import org.jetbrains.kotlin.test.directives.JvmEnvironmentConfigurationDirectives;
import org.jetbrains.kotlin.test.directives.model.Directive;
import org.jetbrains.kotlin.test.directives.model.DirectiveKt;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectives;
import org.jetbrains.kotlin.test.directives.model.SimpleDirectivesContainer;
import org.jetbrains.kotlin.test.directives.model.StringDirective;
import org.jetbrains.kotlin.test.model.DependencyKind;
import org.jetbrains.kotlin.test.model.FrontendKind;
import org.jetbrains.kotlin.test.model.FrontendKinds;
import org.jetbrains.kotlin.test.model.ResultingArtifact;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.runners.AbstractKotlinCompilerTest;
import org.jetbrains.kotlin.test.services.AssertionsService;
import org.jetbrains.kotlin.test.services.DependencyProvider;
import org.jetbrains.kotlin.test.services.DependencyProviderImpl;
import org.jetbrains.kotlin.test.services.JUnit5Assertions;
import org.jetbrains.kotlin.test.services.KotlinTestInfo;
import org.jetbrains.kotlin.test.services.PreAnalysisHandler;
import org.jetbrains.kotlin.test.services.ServiceRegistrationData;
import org.jetbrains.kotlin.test.services.TemporaryDirectoryManager;
import org.jetbrains.kotlin.test.services.TemporaryDirectoryManagerKt;
import org.jetbrains.kotlin.test.services.TestModuleStructure;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestService;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.services.TestServicesKt;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001QB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\"\u0010\u0010\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0010\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\"H\u0014J\u0018\u0010#\u001a\u00020$2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0004J\u001a\u0010%\u001a\u0004\u0018\u00010$2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010&\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0004J\u0018\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J$\u0010*\u001a\u0004\u0018\u00010\u000b2\u0006\u0010)\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010+\u001a\u00020(H\u0004J \u00100\u001a\u00020(2\u0006\u00101\u001a\u00020\u000b2\u0006\u0010)\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J*\u00102\u001a\u00020\t*\u0002032\u0006\u00104\u001a\u00020-2\b\b\u0002\u00105\u001a\u00020-2\n\b\u0002\u00106\u001a\u0004\u0018\u00010-H\u0004J\u001a\u00107\u001a\u00020\u00172\u0006\u00105\u001a\u00020-2\b\u00106\u001a\u0004\u0018\u00010-H\u0004J\u0010\u0010<\u001a\u00020\t2\u0006\u0010=\u001a\u00020-H\u0004J\b\u0010>\u001a\u00020\tH\u0007J\b\u0010?\u001a\u00020@H\u0002J\u0010\u0010A\u001a\u00020\u00132\u0006\u0010B\u001a\u00020@H\u0002J\u0010\u0010C\u001a\u00020\t2\u0006\u0010B\u001a\u00020@H\u0002J\b\u0010D\u001a\u00020(H\u0002J\b\u0010E\u001a\u00020(H\u0002J\b\u0010F\u001a\u00020(H\u0002J:\u0010G\u001a\u0002HH\"\u0004\b\u0000\u0010H2\u0006\u0010I\u001a\u00020J2\u001d\u0010K\u001a\u0019\u0012\u0004\u0012\u00020M\u0012\u0004\u0012\u00020J\u0012\u0004\u0012\u0002HH0L\u00a2\u0006\u0002\b:H\u0004\u00a2\u0006\u0002\u0010NJ\u0010\u0010O\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020PH\u0007R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017@BX\u0084.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000f8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0018\u0010,\u001a\u00020-*\u00020\r8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R%\u00108\u001a\u0013\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\t09\u00a2\u0006\u0002\b:X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b;\u0010\u0003\u00a8\u0006R"}, d2={"Lorg/jetbrains/kotlin/analysis/test/framework/base/AbstractAnalysisApiBasedTest;", "Lorg/jetbrains/kotlin/analysis/test/framework/TestWithDisposable;", "<init>", "()V", "configurator", "Lorg/jetbrains/kotlin/analysis/test/framework/test/configurators/AnalysisApiTestConfigurator;", "getConfigurator", "()Lorg/jetbrains/kotlin/analysis/test/framework/test/configurators/AnalysisApiTestConfigurator;", "doTestByMainFile", "", "mainFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "mainModule", "Lorg/jetbrains/kotlin/test/model/TestModule;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "doTestByMainModuleAndOptionalMainFile", "doTestByModuleStructure", "moduleStructure", "Lorg/jetbrains/kotlin/test/services/TestModuleStructure;", "testInfo", "Lorg/jetbrains/kotlin/test/services/KotlinTestInfo;", "value", "Ljava/nio/file/Path;", "testDataPath", "getTestDataPath", "()Ljava/nio/file/Path;", "_testServices", "getTestServices", "()Lorg/jetbrains/kotlin/test/services/TestServices;", "setTestServices", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "configureTest", "builder", "Lorg/jetbrains/kotlin/test/builders/TestConfigurationBuilder;", "findMainFileAndModule", "Lorg/jetbrains/kotlin/analysis/test/framework/base/AbstractAnalysisApiBasedTest$ModuleWithMainFile;", "findMainFileByMarkers", "findMainModule", "isMainModule", "", "module", "findMainFile", "acceptSingleFileWithoutAdditionalChecks", "mainFileName", "", "getMainFileName", "(Lorg/jetbrains/kotlin/test/model/TestModule;)Ljava/lang/String;", "isMainFile", "file", "assertEqualsToTestDataFileSibling", "Lorg/jetbrains/kotlin/test/services/AssertionsService;", "actual", "extension", "testPrefix", "getTestDataFileSiblingPath", "configure", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "getConfigure$annotations", "runTest", "path", "cleanupTemporaryDirectories", "createTestConfiguration", "Lorg/jetbrains/kotlin/test/TestConfiguration;", "createModuleStructure", "testConfiguration", "prepareToTheAnalysis", "isDependentModeDisabledForTheTest", "isFe10DisabledForTheTest", "isFirDisabledForTheTest", "analyseForTest", "R", "contextElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "action", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;", "(Lorg/jetbrains/kotlin/psi/KtElement;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "initTestInfo", "Lorg/junit/jupiter/api/TestInfo;", "ModuleWithMainFile", "analysis-test-framework_test"})
@SourceDebugExtension(value={"SMAP\nAbstractAnalysisApiBasedTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractAnalysisApiBasedTest.kt\norg/jetbrains/kotlin/analysis/test/framework/base/AbstractAnalysisApiBasedTest\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 TestConfigurationBuilder.kt\norg/jetbrains/kotlin/test/builders/TestConfigurationBuilderKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 6 KtAnalysisSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KtAnalysisSessionProvider\n+ 7 TestConfigurationBuilder.kt\norg/jetbrains/kotlin/test/builders/TestConfigurationBuilder\n+ 8 TestServices.kt\norg/jetbrains/kotlin/test/services/TestServicesKt\n+ 9 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,387:1\n1#2:388\n318#3:389\n1863#4,2:390\n1863#4,2:392\n1863#4,2:394\n63#5,2:396\n29#5,2:398\n46#6:400\n60#6,8:401\n60#7:409\n61#7:411\n60#7:414\n61#7:416\n25#8:410\n25#8:415\n37#9,2:412\n*S KotlinDebug\n*F\n+ 1 AbstractAnalysisApiBasedTest.kt\norg/jetbrains/kotlin/analysis/test/framework/base/AbstractAnalysisApiBasedTest\n*L\n329#1:389\n349#1:390,2\n350#1:392,2\n352#1:394,2\n371#1:396,2\n375#1:398,2\n375#1:400\n375#1:401,8\n275#1:409\n275#1:411\n283#1:414\n283#1:416\n275#1:410\n283#1:415\n277#1:412,2\n*E\n"})
public abstract class AbstractAnalysisApiBasedTest
extends TestWithDisposable {
    private KotlinTestInfo testInfo;
    private Path testDataPath;
    @Nullable
    private TestServices _testServices;
    @NotNull
    private final Function1<TestConfigurationBuilder, Unit> configure = arg_0 -> AbstractAnalysisApiBasedTest.configure$lambda$15(this, arg_0);

    @NotNull
    public abstract AnalysisApiTestConfigurator getConfigurator();

    protected void doTestByMainFile(@NotNull KtFile mainFile, @NotNull TestModule mainModule, @NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)mainFile, (String)"mainFile");
        Intrinsics.checkNotNullParameter((Object)mainModule, (String)"mainModule");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        throw new UnsupportedOperationException("The test case is not fully implemented. 'doTestByMainFile', 'doTestByMainModuleAndOptionalMainFile' or 'doTestByModuleStructure' should be overridden");
    }

    protected void doTestByMainModuleAndOptionalMainFile(@Nullable KtFile mainFile, @NotNull TestModule mainModule, @NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)mainModule, (String)"mainModule");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        KtFile ktFile = mainFile;
        if (ktFile == null) {
            throw new IllegalStateException("The main file is not found".toString());
        }
        this.doTestByMainFile(ktFile, mainModule, testServices);
    }

    protected void doTestByModuleStructure(@NotNull TestModuleStructure moduleStructure, @NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)moduleStructure, (String)"moduleStructure");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        ModuleWithMainFile moduleWithMainFile = this.findMainFileAndModule(moduleStructure, testServices);
        KtFile mainFile = moduleWithMainFile.component1();
        TestModule mainModule = moduleWithMainFile.component2();
        this.doTestByMainModuleAndOptionalMainFile(mainFile, mainModule, testServices);
    }

    @NotNull
    protected final Path getTestDataPath() {
        Path path = this.testDataPath;
        if (path != null) {
            return path;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"testDataPath");
        return null;
    }

    private final TestServices getTestServices() {
        TestServices testServices = this._testServices;
        if (testServices == null) {
            throw new IllegalStateException("`_testServices` has not been initialized".toString());
        }
        return testServices;
    }

    private final void setTestServices(TestServices value) {
        this._testServices = value;
    }

    protected void configureTest(@NotNull TestConfigurationBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.getConfigurator().configureTest(builder, this.getDisposable());
    }

    @NotNull
    protected final ModuleWithMainFile findMainFileAndModule(@NotNull TestModuleStructure moduleStructure, @NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)moduleStructure, (String)"moduleStructure");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        ModuleWithMainFile moduleWithMainFile = this.findMainFileByMarkers(moduleStructure, testServices);
        if (moduleWithMainFile != null) {
            ModuleWithMainFile it = moduleWithMainFile;
            boolean bl = false;
            return it;
        }
        TestModule testModule = this.findMainModule(testServices);
        if (testModule == null) {
            throw new IllegalStateException("Cannot find the main test module".toString());
        }
        TestModule mainModule = testModule;
        KtFile mainFile = AbstractAnalysisApiBasedTest.findMainFile$default(this, mainModule, testServices, false, 4, null);
        return new ModuleWithMainFile(mainFile, mainModule);
    }

    private final ModuleWithMainFile findMainFileByMarkers(TestModuleStructure moduleStructure, TestServices testServices) {
        return (ModuleWithMainFile)CommonTestUtilsKt.singleOrZeroValue(moduleStructure.getModules(), arg_0 -> AbstractAnalysisApiBasedTest.findMainFileByMarkers$lambda$2(this, testServices, arg_0), AbstractAnalysisApiBasedTest::findMainFileByMarkers$lambda$3);
    }

    @Nullable
    protected final TestModule findMainModule(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        List testModules = TestModuleStructureKt.getModuleStructure((TestServices)testServices).getModules();
        TestModule testModule = (TestModule)CollectionsKt.singleOrNull((List)testModules);
        if (testModule != null) {
            TestModule it = testModule;
            boolean bl = false;
            return it;
        }
        return (TestModule)CommonTestUtilsKt.singleOrZeroValue(testModules, arg_0 -> AbstractAnalysisApiBasedTest.findMainModule$lambda$6(this, testServices, arg_0), AbstractAnalysisApiBasedTest::findMainModule$lambda$7);
    }

    protected boolean isMainModule(@NotNull TestModule module, @NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        return module.getDirectives().contains((Directive)AnalysisApiTestDirectives.INSTANCE.getMAIN_MODULE()) || Intrinsics.areEqual((Object)StringsKt.substringBefore$default((String)module.getName(), (char)'-', null, (int)2, null), (Object)"main");
    }

    @Nullable
    protected final KtFile findMainFile(@NotNull TestModule module, @NotNull TestServices testServices, boolean acceptSingleFileWithoutAdditionalChecks) {
        KtFile ktFile;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        List<KtFile> ktFiles = AnalysisApiKtModuleProviderImplKt.getKtFiles(AnalysisApiKtModuleProviderImplKt.getKtModuleProvider(testServices), module);
        if (acceptSingleFileWithoutAdditionalChecks && (ktFile = (KtFile)CollectionsKt.singleOrNull(ktFiles)) != null) {
            KtFile it = ktFile;
            boolean bl = false;
            return it;
        }
        return (KtFile)CommonTestUtilsKt.singleOrZeroValue((Collection)ktFiles, arg_0 -> AbstractAnalysisApiBasedTest.findMainFile$lambda$10(this, module, testServices, arg_0), AbstractAnalysisApiBasedTest::findMainFile$lambda$11);
    }

    public static /* synthetic */ KtFile findMainFile$default(AbstractAnalysisApiBasedTest abstractAnalysisApiBasedTest, TestModule testModule, TestServices testServices, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findMainFile");
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return abstractAnalysisApiBasedTest.findMainFile(testModule, testServices, bl);
    }

    @NotNull
    protected final String getMainFileName(@NotNull TestModule $this$mainFileName) {
        Intrinsics.checkNotNullParameter((Object)$this$mainFileName, (String)"<this>");
        String string = DirectiveKt.singleOrZeroValue((RegisteredDirectives)$this$mainFileName.getDirectives(), (StringDirective)AnalysisApiTestDirectives.INSTANCE.getMAIN_FILE_NAME());
        if (string == null) {
            string = "main";
        }
        return string;
    }

    protected boolean isMainFile(@NotNull KtFile file, @NotNull TestModule module, @NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        ExpressionMarkerProvider expressionMarkerProvider = ExpressionMarkersSourceFilePreprocessorKt.getExpressionMarkerProvider(testServices);
        return ExpressionMarkerProvider.getCaretPositionOrNull$default(expressionMarkerProvider, (PsiFile)file, null, 2, null) != null || expressionMarkerProvider.getSelectedRangeOrNull((PsiFile)file) != null || Intrinsics.areEqual((Object)file.getVirtualFile().getNameWithoutExtension(), (Object)this.getMainFileName(module));
    }

    protected final void assertEqualsToTestDataFileSibling(@NotNull AssertionsService $this$assertEqualsToTestDataFileSibling, @NotNull String actual2, @NotNull String extension, @Nullable String testPrefix) {
        Path expectedFileWithoutPrefix;
        Intrinsics.checkNotNullParameter((Object)$this$assertEqualsToTestDataFileSibling, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)actual2, (String)"actual");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        Path expectedFile = this.getTestDataFileSiblingPath(extension, testPrefix);
        Assertions.assertEqualsToFile$default((Assertions)((Assertions)$this$assertEqualsToTestDataFileSibling), (Path)expectedFile, (String)actual2, null, (int)4, null);
        if (testPrefix != null && !Intrinsics.areEqual((Object)expectedFile, (Object)(expectedFileWithoutPrefix = this.getTestDataFileSiblingPath(extension, null)))) {
            Assertions assertions = (Assertions)$this$assertEqualsToTestDataFileSibling;
            File file = expectedFileWithoutPrefix.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            if (!Assertions.doesEqualToFile$default((Assertions)assertions, (File)file, (String)actual2, null, (int)4, null)) {
                return;
            }
            throw new AssertionError((Object)("" + '\"' + expectedFile + "\" has the same content as \"" + expectedFileWithoutPrefix + "\". Delete the prefixed file."));
        }
    }

    public static /* synthetic */ void assertEqualsToTestDataFileSibling$default(AbstractAnalysisApiBasedTest abstractAnalysisApiBasedTest, AssertionsService assertionsService, String string, String string2, String string3, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: assertEqualsToTestDataFileSibling");
        }
        if ((n & 2) != 0) {
            string2 = ".txt";
        }
        if ((n & 4) != 0) {
            string3 = abstractAnalysisApiBasedTest.getConfigurator().getTestPrefix();
        }
        abstractAnalysisApiBasedTest.assertEqualsToTestDataFileSibling(assertionsService, string, string2, string3);
    }

    @NotNull
    protected final Path getTestDataFileSiblingPath(@NotNull String extension, @Nullable String testPrefix) {
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        String extensionWithDot = '.' + StringsKt.removePrefix((String)extension, (CharSequence)".");
        String baseName = PathsKt.getNameWithoutExtension((Path)this.getTestDataPath());
        if (testPrefix != null) {
            Path prefixedFile = this.getTestDataPath().resolveSibling(baseName + '.' + testPrefix + extensionWithDot);
            Intrinsics.checkNotNull((Object)prefixedFile);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists(prefixedFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                return prefixedFile;
            }
        }
        Path path = this.getTestDataPath().resolveSibling(baseName + extensionWithDot);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolveSibling(...)");
        return path;
    }

    private static /* synthetic */ void getConfigure$annotations() {
    }

    protected final void runTest(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        AnalysisApiTestConfigurator analysisApiTestConfigurator = this.getConfigurator();
        Path path2 = Paths.get(path, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        this.testDataPath = analysisApiTestConfigurator.computeTestDataPath(path2);
        TestConfiguration testConfiguration = this.createTestConfiguration();
        this.setTestServices(testConfiguration.getTestServices());
        TestModuleStructure moduleStructure = this.createModuleStructure(testConfiguration);
        if (this.getConfigurator().getAnalyseInDependentSession() && this.isDependentModeDisabledForTheTest()) {
            return;
        }
        if (this.getConfigurator().getFrontendKind() == org.jetbrains.kotlin.analysis.test.framework.test.configurators.FrontendKind.Fe10 && this.isFe10DisabledForTheTest() || this.getConfigurator().getFrontendKind() == org.jetbrains.kotlin.analysis.test.framework.test.configurators.FrontendKind.Fir && this.isFirDisabledForTheTest()) {
            return;
        }
        try {
            this.prepareToTheAnalysis(testConfiguration);
        }
        catch (SkipTestException skipTestException) {
            return;
        }
        this.doTestByModuleStructure(moduleStructure, this.getTestServices());
    }

    @AfterEach
    public final void cleanupTemporaryDirectories() {
        try {
            TestServices testServices = this._testServices;
            if (testServices != null && (testServices = TemporaryDirectoryManagerKt.getTemporaryDirectoryManager((TestServices)testServices)) != null) {
                testServices.cleanupTemporaryDirectories();
            }
        }
        catch (IOException e) {
            System.out.println((Object)("Failed to clean temporary directories: " + e.getMessage() + '\n' + e.getStackTrace()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final TestConfiguration createTestConfiguration() {
        void testDataPath$iv;
        String string = ((Object)this.getTestDataPath()).toString();
        Function1<TestConfigurationBuilder, Unit> init$iv = this.configure;
        boolean $i$f$testConfiguration = false;
        TestConfigurationBuilder testConfigurationBuilder = new TestConfigurationBuilder();
        init$iv.invoke((Object)testConfigurationBuilder);
        TestConfiguration testConfiguration = testConfigurationBuilder.build((String)testDataPath$iv);
        Disposer.register((Disposable)this.getDisposable(), (Disposable)testConfiguration.getRootDisposable());
        return testConfiguration;
    }

    private final TestModuleStructure createModuleStructure(TestConfiguration testConfiguration) {
        TestModuleStructure moduleStructure = testConfiguration.getModuleStructureExtractor().splitTestDataByModules(((Object)this.getTestDataPath()).toString(), testConfiguration.getDirectives());
        this.getTestServices().register(Reflection.getOrCreateKotlinClass(TestModuleStructure.class), (TestService)moduleStructure);
        return moduleStructure;
    }

    private final void prepareToTheAnalysis(TestConfiguration testConfiguration) {
        PreAnalysisHandler preprocessor;
        TestModuleStructure moduleStructure = TestModuleStructureKt.getModuleStructure((TestServices)this.getTestServices());
        DependencyProviderImpl dependencyProvider = new DependencyProviderImpl(this.getTestServices(), moduleStructure.getModules());
        TestServicesKt.registerDependencyProvider((TestServices)this.getTestServices(), (DependencyProvider)((DependencyProvider)dependencyProvider));
        Iterable $this$forEach$iv = testConfiguration.getPreAnalysisHandlers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            preprocessor = (PreAnalysisHandler)element$iv;
            boolean bl = false;
            preprocessor.preprocessModuleStructure(moduleStructure);
        }
        $this$forEach$iv = testConfiguration.getPreAnalysisHandlers();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            preprocessor = (PreAnalysisHandler)element$iv;
            boolean bl = false;
            preprocessor.prepareSealedClassInheritors(moduleStructure);
        }
        $this$forEach$iv = AnalysisApiKtModuleProviderImplKt.getMainModules(AnalysisApiKtModuleProviderImplKt.getKtModuleProvider(this.getTestServices()));
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtTestModule ktTestModule = (KtTestModule)element$iv;
            boolean bl = false;
            this.getConfigurator().prepareFilesInModule(ktTestModule, this.getTestServices());
        }
    }

    private final boolean isDependentModeDisabledForTheTest() {
        return TestModuleStructureKt.getModuleStructure((TestServices)this.getTestServices()).getAllDirectives().contains((Directive)AnalysisApiTestDirectives.INSTANCE.getDISABLE_DEPENDED_MODE());
    }

    private final boolean isFe10DisabledForTheTest() {
        return TestModuleStructureKt.getModuleStructure((TestServices)this.getTestServices()).getAllDirectives().contains((Directive)AnalysisApiTestDirectives.INSTANCE.getIGNORE_FE10());
    }

    private final boolean isFirDisabledForTheTest() {
        return TestModuleStructureKt.getModuleStructure((TestServices)this.getTestServices()).getAllDirectives().contains((Directive)AnalysisApiTestDirectives.INSTANCE.getIGNORE_FIR());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected final <R> R analyseForTest(@NotNull KtElement contextElement, @NotNull Function2<? super KtAnalysisSession, ? super KtElement, ? extends R> action) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)contextElement, (String)"contextElement");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        if (this.getConfigurator().getAnalyseInDependentSession()) {
            KtFile ktFile = contextElement.getContainingKtFile();
            Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"getContainingKtFile(...)");
            KtFile originalContainingFile = ktFile;
            PsiElement psiElement = originalContainingFile.copy();
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
            KtFile fileCopy = (KtFile)psiElement;
            DanglingFileResolutionMode resolutionMode$iv = DanglingFileResolutionMode.IGNORE_SELF;
            boolean $i$f$analyzeCopy = false;
            KtFile ktFile2 = ((KtElement)fileCopy).getContainingKtFile();
            Intrinsics.checkNotNullExpressionValue((Object)ktFile2, (String)"getContainingKtFile(...)");
            KtFile containingFile$iv = ktFile2;
            object = ProjectStructureProviderKt.withDanglingFileResolutionMode((KtFile)containingFile$iv, (DanglingFileResolutionMode)resolutionMode$iv, (Function0)new Function0<R>(containingFile$iv, action, contextElement, fileCopy){
                final /* synthetic */ KtFile $containingFile;
                final /* synthetic */ Function2 $action$inlined;
                final /* synthetic */ KtElement $contextElement$inlined;
                final /* synthetic */ KtFile $fileCopy$inlined;
                {
                    this.$containingFile = $containingFile;
                    this.$action$inlined = function2;
                    this.$contextElement$inlined = ktElement;
                    this.$fileCopy$inlined = ktFile;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 */
                public final R invoke() {
                    Object object;
                    void this_$iv$iv$iv;
                    KtElement useSiteKtElement$iv = (KtElement)this.$containingFile;
                    boolean $i$f$analyze = false;
                    Project project = useSiteKtElement$iv.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    KtAnalysisSessionProvider this_$iv$iv = KtAnalysisSessionProvider.Companion.getInstance(project);
                    boolean $i$f$analyse = false;
                    KtAnalysisSessionProvider ktAnalysisSessionProvider = this_$iv$iv;
                    KtAnalysisSession analysisSession$iv$iv$iv = this_$iv$iv.getAnalysisSession(useSiteKtElement$iv);
                    boolean $i$f$analyse2 = false;
                    this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().beforeEnteringAnalysisContext();
                    this_$iv$iv$iv.getTokenFactory().beforeEnteringAnalysisContext(analysisSession$iv$iv$iv.getToken());
                    try {
                        KtAnalysisSession $this$analyseForTest_u24lambda_u2419 = analysisSession$iv$iv$iv;
                        boolean bl = false;
                        PsiElement psiElement = PsiTreeUtil.findSameElementInCopy((PsiElement)((PsiElement)this.$contextElement$inlined), (PsiFile)((PsiFile)this.$fileCopy$inlined));
                        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"findSameElementInCopy(...)");
                        object = this.$action$inlined.invoke((Object)$this$analyseForTest_u24lambda_u2419, (Object)psiElement);
                    }
                    finally {
                        this_$iv$iv$iv.getTokenFactory().afterLeavingAnalysisContext(analysisSession$iv$iv$iv.getToken());
                        this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().afterLeavingAnalysisContext();
                    }
                    return (R)object;
                }
            });
        } else {
            Object object2;
            void this_$iv$iv$iv;
            void this_$iv$iv;
            boolean $i$f$analyze = false;
            Project project = contextElement.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            KtAnalysisSessionProvider fileCopy = KtAnalysisSessionProvider.Companion.getInstance(project);
            boolean $i$f$analyse = false;
            void $i$f$analyzeCopy = this_$iv$iv;
            KtAnalysisSession analysisSession$iv$iv$iv = this_$iv$iv.getAnalysisSession(contextElement);
            boolean $i$f$analyse2 = false;
            this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().beforeEnteringAnalysisContext();
            this_$iv$iv$iv.getTokenFactory().beforeEnteringAnalysisContext(analysisSession$iv$iv$iv.getToken());
            try {
                KtAnalysisSession $this$analyseForTest_u24lambda_u2420 = analysisSession$iv$iv$iv;
                boolean bl = false;
                object2 = action.invoke((Object)$this$analyseForTest_u24lambda_u2420, (Object)contextElement);
            }
            finally {
                this_$iv$iv$iv.getTokenFactory().afterLeavingAnalysisContext(analysisSession$iv$iv$iv.getToken());
                this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().afterLeavingAnalysisContext();
            }
            object = object2;
        }
        return (R)object;
    }

    @BeforeEach
    public final void initTestInfo(@NotNull TestInfo testInfo) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)testInfo, (String)"testInfo");
        Object object2 = (Class)testInfo.getTestClass().orElseGet(null);
        if (object2 == null || (object2 = ((Class)object2).getName()) == null) {
            object2 = "_undefined_";
        }
        if ((object = (Method)testInfo.getTestMethod().orElseGet(null)) == null || (object = ((Method)object).getName()) == null) {
            object = "_testUndefined_";
        }
        Set set = testInfo.getTags();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getTags(...)");
        this.testInfo = new KotlinTestInfo((String)object2, (String)object, set);
    }

    private static final ModuleWithMainFile findMainFileByMarkers$lambda$2(AbstractAnalysisApiBasedTest this$0, TestServices $testServices, TestModule module) {
        ModuleWithMainFile moduleWithMainFile;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$testServices, (String)"$testServices");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        KtFile ktFile = this$0.findMainFile(module, $testServices, false);
        if (ktFile != null) {
            KtFile mainFile = ktFile;
            boolean bl = false;
            moduleWithMainFile = new ModuleWithMainFile(mainFile, module);
        } else {
            moduleWithMainFile = null;
        }
        return moduleWithMainFile;
    }

    private static final String findMainFileByMarkers$lambda$3(ModuleWithMainFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        KtFile ktFile = it.getMainFile();
        return '\'' + it.getModule().getName() + "' with '" + (ktFile != null ? ktFile.getName() : null) + '\'';
    }

    private static final TestModule findMainModule$lambda$6(AbstractAnalysisApiBasedTest this$0, TestServices $testServices, TestModule module) {
        TestModule testModule;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$testServices, (String)"$testServices");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        TestModule it = testModule = module;
        boolean bl = false;
        return this$0.isMainModule(module, $testServices) ? testModule : null;
    }

    private static final String findMainModule$lambda$7(TestModule it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName();
    }

    private static final KtFile findMainFile$lambda$10(AbstractAnalysisApiBasedTest this$0, TestModule $module, TestServices $testServices, KtFile file) {
        KtFile ktFile;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$module, (String)"$module");
        Intrinsics.checkNotNullParameter((Object)$testServices, (String)"$testServices");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        KtFile it = ktFile = file;
        boolean bl = false;
        return this$0.isMainFile(file, $module, $testServices) ? ktFile : null;
    }

    private static final String findMainFile$lambda$11(KtFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    private static final Unit configure$lambda$15$lambda$12(DefaultsProviderBuilder $this$globalDefaults) {
        Intrinsics.checkNotNullParameter((Object)$this$globalDefaults, (String)"$this$globalDefaults");
        $this$globalDefaults.setFrontend((FrontendKind)FrontendKinds.FIR.INSTANCE);
        $this$globalDefaults.setTargetPlatform(JvmPlatforms.INSTANCE.getDefaultJvmPlatform());
        $this$globalDefaults.setDependencyKind(DependencyKind.Source);
        return Unit.INSTANCE;
    }

    private static final ExpressionMarkerProvider configure$lambda$15$lambda$13(TestServices it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ExpressionMarkerProvider();
    }

    private static final ResultingArtifact.Source configure$lambda$15$lambda$14(TestModule it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ResultingArtifact.Source();
    }

    private static final Unit configure$lambda$15(AbstractAnalysisApiBasedTest this$0, TestConfigurationBuilder directivesContainerArray) {
        DirectivesContainer[] this_$iv;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)directivesContainerArray, (String)"<this>");
        directivesContainerArray.globalDefaults(AbstractAnalysisApiBasedTest::configure$lambda$15$lambda$12);
        directivesContainerArray.setAssertions((AssertionsService)JUnit5Assertions.INSTANCE);
        DirectivesContainer[] directivesContainerArray2 = directivesContainerArray;
        Function1 serviceConstructor$iv = configure.1.2.INSTANCE;
        boolean $i$f$useAdditionalService = false;
        ServiceRegistrationData[] serviceRegistrationDataArray = new ServiceRegistrationData[1];
        boolean $i$f$service = false;
        serviceRegistrationDataArray[0] = new ServiceRegistrationData(Reflection.getOrCreateKotlinClass(TemporaryDirectoryManager.class), serviceConstructor$iv);
        this_$iv.useAdditionalServices(serviceRegistrationDataArray);
        Collection $this$toTypedArray$iv = AbstractKotlinCompilerTest.Companion.getDefaultDirectiveContainers();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        this_$iv = thisCollection$iv.toArray(new SimpleDirectivesContainer[0]);
        directivesContainerArray.useDirectives((DirectivesContainer[])Arrays.copyOf(this_$iv, this_$iv.length));
        this_$iv = new DirectivesContainer[]{JvmEnvironmentConfigurationDirectives.INSTANCE};
        directivesContainerArray.useDirectives(this_$iv);
        this_$iv = new DirectivesContainer[]{TestModuleCompiler.Directives.INSTANCE};
        directivesContainerArray.useDirectives(this_$iv);
        this_$iv = new Function1[]{configure.1.3.INSTANCE};
        TestConfigurationBuilder.useSourcePreprocessor$default((TestConfigurationBuilder)directivesContainerArray, (Function1[])this_$iv, (boolean)false, (int)2, null);
        this_$iv = directivesContainerArray;
        serviceConstructor$iv = AbstractAnalysisApiBasedTest::configure$lambda$15$lambda$13;
        $i$f$useAdditionalService = false;
        serviceRegistrationDataArray = new ServiceRegistrationData[1];
        $i$f$service = false;
        serviceRegistrationDataArray[0] = new ServiceRegistrationData(Reflection.getOrCreateKotlinClass(ExpressionMarkerProvider.class), serviceConstructor$iv);
        this_$iv.useAdditionalServices(serviceRegistrationDataArray);
        directivesContainerArray2 = new DirectivesContainer[]{ExpressionMarkerProvider.Directives.INSTANCE};
        directivesContainerArray.useDirectives(directivesContainerArray2);
        RegisterBaseTestServicesKt.registerAnalysisApiBaseTestServices((TestConfigurationBuilder)directivesContainerArray, this$0.getDisposable(), this$0.getConfigurator());
        this$0.configureTest((TestConfigurationBuilder)directivesContainerArray);
        directivesContainerArray.setStartingArtifactFactory(AbstractAnalysisApiBasedTest::configure$lambda$15$lambda$14);
        KotlinTestInfo kotlinTestInfo = this$0.testInfo;
        if (kotlinTestInfo == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"testInfo");
            kotlinTestInfo = null;
        }
        directivesContainerArray.setTestInfo(kotlinTestInfo);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001f\u0010\u000e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/analysis/test/framework/base/AbstractAnalysisApiBasedTest$ModuleWithMainFile;", "", "mainFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtFile;Lorg/jetbrains/kotlin/test/model/TestModule;)V", "getMainFile", "()Lorg/jetbrains/kotlin/psi/KtFile;", "getModule", "()Lorg/jetbrains/kotlin/test/model/TestModule;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "analysis-test-framework_test"})
    public static final class ModuleWithMainFile {
        @Nullable
        private final KtFile mainFile;
        @NotNull
        private final TestModule module;

        public ModuleWithMainFile(@Nullable KtFile mainFile, @NotNull TestModule module) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            this.mainFile = mainFile;
            this.module = module;
        }

        @Nullable
        public final KtFile getMainFile() {
            return this.mainFile;
        }

        @NotNull
        public final TestModule getModule() {
            return this.module;
        }

        @Nullable
        public final KtFile component1() {
            return this.mainFile;
        }

        @NotNull
        public final TestModule component2() {
            return this.module;
        }

        @NotNull
        public final ModuleWithMainFile copy(@Nullable KtFile mainFile, @NotNull TestModule module) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            return new ModuleWithMainFile(mainFile, module);
        }

        public static /* synthetic */ ModuleWithMainFile copy$default(ModuleWithMainFile moduleWithMainFile, KtFile ktFile, TestModule testModule, int n, Object object) {
            if ((n & 1) != 0) {
                ktFile = moduleWithMainFile.mainFile;
            }
            if ((n & 2) != 0) {
                testModule = moduleWithMainFile.module;
            }
            return moduleWithMainFile.copy(ktFile, testModule);
        }

        @NotNull
        public String toString() {
            return "ModuleWithMainFile(mainFile=" + this.mainFile + ", module=" + this.module + ')';
        }

        public int hashCode() {
            int result = this.mainFile == null ? 0 : this.mainFile.hashCode();
            result = result * 31 + this.module.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ModuleWithMainFile)) {
                return false;
            }
            ModuleWithMainFile moduleWithMainFile = (ModuleWithMainFile)other;
            if (!Intrinsics.areEqual((Object)this.mainFile, (Object)moduleWithMainFile.mainFile)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.module, (Object)moduleWithMainFile.module);
        }
    }
}

