/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.test.framework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.test.TestConfiguration;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.runners.AbstractKotlinCompilerTest;
import org.jetbrains.kotlin.test.services.SourceFileProviderKt;
import org.jetbrains.kotlin.test.services.TestModuleStructure;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\b\u0010\r\u001a\u00020\nH\u0007J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0004J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00058DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/analysis/test/framework/AbstractCompilerBasedTest;", "Lorg/jetbrains/kotlin/test/runners/AbstractKotlinCompilerTest;", "<init>", "()V", "_disposable", "Lcom/intellij/openapi/Disposable;", "disposable", "getDisposable", "()Lcom/intellij/openapi/Disposable;", "initDisposable", "", "testInfo", "Lorg/junit/jupiter/api/TestInfo;", "disposeDisposable", "ignoreTest", "", "filePath", "", "configuration", "Lorg/jetbrains/kotlin/test/TestConfiguration;", "shouldSkipTest", "analysis-api-impl-barebone_test"})
@SourceDebugExtension(value={"SMAP\nAbstractCompilerBasedTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractCompilerBasedTest.kt\norg/jetbrains/kotlin/analysis/test/framework/AbstractCompilerBasedTest\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,46:1\n1#2:47\n2622#3,2:48\n1745#3,3:50\n2624#3:53\n*S KotlinDebug\n*F\n+ 1 AbstractCompilerBasedTest.kt\norg/jetbrains/kotlin/analysis/test/framework/AbstractCompilerBasedTest\n*L\n35#1:48,2\n35#1:50,3\n35#1:53\n*E\n"})
public abstract class AbstractCompilerBasedTest
extends AbstractKotlinCompilerTest {
    @Nullable
    private Disposable _disposable;

    @NotNull
    protected final Disposable getDisposable() {
        Disposable disposable = this._disposable;
        Intrinsics.checkNotNull((Object)disposable);
        return disposable;
    }

    @BeforeEach
    public final void initDisposable(@NotNull TestInfo testInfo) {
        Intrinsics.checkNotNullParameter((Object)testInfo, (String)"testInfo");
        this._disposable = Disposer.newDisposable((String)("disposable for " + testInfo.getDisplayName()));
    }

    @AfterEach
    public final void disposeDisposable() {
        Disposable disposable = this._disposable;
        if (disposable != null) {
            Disposable it = disposable;
            boolean bl = false;
            Disposer.dispose((Disposable)it);
        }
        this._disposable = null;
    }

    protected final boolean ignoreTest(@NotNull String filePath, @NotNull TestConfiguration configuration2) {
        boolean bl;
        block8: {
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
            TestModuleStructure modules = configuration2.getModuleStructureExtractor().splitTestDataByModules(filePath, configuration2.getDirectives());
            Iterable $this$none$iv = modules.getModules();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    boolean bl2;
                    block7: {
                        TestModule it = (TestModule)element$iv;
                        boolean bl3 = false;
                        Iterable $this$any$iv = it.getFiles();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv) {
                                TestFile it2 = (TestFile)element$iv2;
                                boolean bl4 = false;
                                if (!SourceFileProviderKt.isKtFile((TestFile)it2)) continue;
                                bl2 = true;
                                break block7;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                    bl = false;
                    break block8;
                }
                bl = true;
            }
        }
        if (bl) {
            return true;
        }
        return this.shouldSkipTest(filePath, configuration2);
    }

    protected boolean shouldSkipTest(@NotNull String filePath, @NotNull TestConfiguration configuration2) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        return false;
    }
}

