/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.test.framework.services.libraries;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty1;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.test.framework.services.libraries.CliTestModuleCompiler;
import org.jetbrains.kotlin.analysis.test.framework.services.libraries.CompilerExecutor;
import org.jetbrains.kotlin.analysis.test.framework.services.libraries.TestModuleCompiler;
import org.jetbrains.kotlin.cli.common.arguments.CommonToolArgumentsKt;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.test.directives.LanguageSettingsDirectives;
import org.jetbrains.kotlin.test.directives.model.Directive;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.SourceFileProviderKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.util.KtTestUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH$J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/analysis/test/framework/services/libraries/CliTestModuleCompiler;", "Lorg/jetbrains/kotlin/analysis/test/framework/services/libraries/TestModuleCompiler;", "<init>", "()V", "compilerKind", "Lorg/jetbrains/kotlin/analysis/test/framework/services/libraries/CompilerExecutor$CompilerKind;", "getCompilerKind$analysis_test_framework_test", "()Lorg/jetbrains/kotlin/analysis/test/framework/services/libraries/CompilerExecutor$CompilerKind;", "buildPlatformCompilerOptions", "", "", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "compile", "Ljava/nio/file/Path;", "tmpDir", "compileTestModuleToLibrarySources", "buildExtraClasspath", "buildPlatformExtraClasspath", "buildCompilerOptions", "buildCommonCompilerOptions", "addFileToJar", "", "path", "text", "jarOutputStream", "Ljava/util/jar/JarOutputStream;", "analysis-test-framework_test"})
@SourceDebugExtension(value={"SMAP\nCliTestModuleCompilers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CliTestModuleCompilers.kt\norg/jetbrains/kotlin/analysis/test/framework/services/libraries/CliTestModuleCompiler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,162:1\n1#2:163\n*E\n"})
public abstract class CliTestModuleCompiler
extends TestModuleCompiler {
    @NotNull
    public abstract CompilerExecutor.CompilerKind getCompilerKind$analysis_test_framework_test();

    @NotNull
    protected abstract List<String> buildPlatformCompilerOptions(@NotNull TestModule var1, @NotNull TestServices var2);

    @Override
    @NotNull
    public Path compile(@NotNull Path tmpDir, @NotNull TestModule module, @NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)tmpDir, (String)"tmpDir");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        return CompilerExecutor.INSTANCE.compileLibrary(this.getCompilerKind$analysis_test_framework_test(), tmpDir, this.buildCompilerOptions(module, testServices), module.getDirectives().contains((Directive)TestModuleCompiler.Directives.INSTANCE.getCOMPILATION_ERRORS()), module.getName(), this.buildExtraClasspath(module, testServices));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Path compileTestModuleToLibrarySources(@NotNull TestModule module, @NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        Path tmpDir = KtTestUtil.tmpDir((String)"testSourcesToCompile").toPath();
        Intrinsics.checkNotNull((Object)tmpDir);
        Path path = tmpDir.resolve(module.getName() + "-sources.jar");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Path librarySourcesPath = path;
        Object object = new Manifest();
        Manifest $this$compileTestModuleToLibrarySources_u24lambda_u240 = object;
        boolean bl = false;
        Attributes attributes = $this$compileTestModuleToLibrarySources_u24lambda_u240.getMainAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)attributes, (String)"getMainAttributes(...)");
        Map map = attributes;
        Attributes.Name name = Attributes.Name.MANIFEST_VERSION;
        String string = "1.0";
        map.put(name, string);
        Manifest manifest = object;
        OpenOption[] openOptionArray = new OpenOption[]{};
        OutputStream outputStream = Files.newOutputStream(librarySourcesPath, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
        object = new JarOutputStream(outputStream, manifest);
        Throwable throwable = null;
        try {
            JarOutputStream jarOutputStream = (JarOutputStream)object;
            boolean bl2 = false;
            for (TestFile testFile : module.getFiles()) {
                String text2 = SourceFileProviderKt.getSourceFileProvider((TestServices)testServices).getContentOfSourceFile(testFile);
                this.addFileToJar(testFile.getRelativePath(), text2, jarOutputStream);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        return librarySourcesPath;
    }

    private final List<String> buildExtraClasspath(TestModule module, TestServices testServices) {
        List list;
        List $this$buildExtraClasspath_u24lambda_u242 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$buildExtraClasspath_u24lambda_u242.addAll((Collection)this.buildPlatformExtraClasspath(module, testServices));
        return CollectionsKt.build((List)list);
    }

    @NotNull
    protected List<String> buildPlatformExtraClasspath(@NotNull TestModule module, @NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        return CollectionsKt.emptyList();
    }

    private final List<String> buildCompilerOptions(TestModule module, TestServices testServices) {
        List list;
        List $this$buildCompilerOptions_u24lambda_u243 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$buildCompilerOptions_u24lambda_u243.addAll((Collection)this.buildCommonCompilerOptions(module));
        $this$buildCompilerOptions_u24lambda_u243.addAll((Collection)this.buildPlatformCompilerOptions(module, testServices));
        return CollectionsKt.build((List)list);
    }

    private final List<String> buildCommonCompilerOptions(TestModule module) {
        List list;
        List $this$buildCommonCompilerOptions_u24lambda_u246 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        ApiVersion apiVersion = (ApiVersion)CollectionsKt.firstOrNull((List)module.getDirectives().get(LanguageSettingsDirectives.INSTANCE.getAPI_VERSION()));
        if (apiVersion != null) {
            ApiVersion apiVersion2 = apiVersion;
            boolean bl2 = false;
            Object[] objectArray = new String[]{CommonToolArgumentsKt.getCliArgument((KProperty1)((KProperty1)buildCommonCompilerOptions.1.1.1.INSTANCE)), apiVersion2.getVersionString()};
            $this$buildCommonCompilerOptions_u24lambda_u246.addAll(CollectionsKt.listOf((Object[])objectArray));
        }
        String string = (String)CollectionsKt.firstOrNull((List)module.getDirectives().get(LanguageSettingsDirectives.INSTANCE.getLANGUAGE()));
        if (string != null) {
            String it = string;
            boolean bl3 = false;
            $this$buildCommonCompilerOptions_u24lambda_u246.add("-XXLanguage:" + it);
        }
        if (module.getDirectives().contains((Directive)LanguageSettingsDirectives.INSTANCE.getALLOW_KOTLIN_PACKAGE())) {
            $this$buildCommonCompilerOptions_u24lambda_u246.add(CommonToolArgumentsKt.getCliArgument((KProperty1)((KProperty1)buildCommonCompilerOptions.1.3.INSTANCE)));
        }
        $this$buildCommonCompilerOptions_u24lambda_u246.addAll(module.getDirectives().get(TestModuleCompiler.Directives.INSTANCE.getCOMPILER_ARGUMENTS()));
        return CollectionsKt.build((List)list);
    }

    private final void addFileToJar(String path, String text2, JarOutputStream jarOutputStream) {
        jarOutputStream.putNextEntry(new JarEntry(path));
        String string = text2;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        ByteStreamsKt.copyTo$default((InputStream)new ByteArrayInputStream(byArray), (OutputStream)jarOutputStream, (int)0, (int)2, null);
        jarOutputStream.closeEntry();
    }
}

