/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.test.framework.project.structure;

import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.project.structure.KtLibraryModule;
import org.jetbrains.kotlin.analysis.project.structure.KtLibrarySourceModule;
import org.jetbrains.kotlin.analysis.project.structure.KtModule;
import org.jetbrains.kotlin.analysis.test.framework.project.structure.TestModuleStructureFactory;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.resolve.PlatformDependentAnalyzerServices;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0013\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010.H\u0096\u0002J\u000e\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000300H\u0016J\b\u00101\u001a\u000202H\u0016R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0016R\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0016\u0010\u001f\u001a\u0004\u0018\u00010 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00050\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u0016\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/analysis/test/framework/project/structure/LibraryByRoot;", "Lorg/jetbrains/kotlin/analysis/project/structure/KtLibraryModule;", "root", "Ljava/nio/file/Path;", "parentModule", "Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;", "project", "Lcom/intellij/openapi/project/Project;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Ljava/nio/file/Path;Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/test/services/TestServices;)V", "analyzerServices", "Lorg/jetbrains/kotlin/resolve/PlatformDependentAnalyzerServices;", "getAnalyzerServices", "()Lorg/jetbrains/kotlin/resolve/PlatformDependentAnalyzerServices;", "contentScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "getContentScope", "()Lcom/intellij/psi/search/GlobalSearchScope;", "directDependsOnDependencies", "", "getDirectDependsOnDependencies", "()Ljava/util/List;", "directFriendDependencies", "getDirectFriendDependencies", "directRegularDependencies", "getDirectRegularDependencies", "libraryName", "", "getLibraryName", "()Ljava/lang/String;", "librarySources", "Lorg/jetbrains/kotlin/analysis/project/structure/KtLibrarySourceModule;", "getLibrarySources", "()Lorg/jetbrains/kotlin/analysis/project/structure/KtLibrarySourceModule;", "platform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getPlatform", "()Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getProject", "()Lcom/intellij/openapi/project/Project;", "transitiveDependsOnDependencies", "getTransitiveDependsOnDependencies", "equals", "", "other", "", "getBinaryRoots", "", "hashCode", "", "analysis-test-framework_test"})
final class LibraryByRoot
implements KtLibraryModule {
    @NotNull
    private final Path root;
    @NotNull
    private final KtModule parentModule;
    @NotNull
    private final Project project;
    @NotNull
    private final GlobalSearchScope contentScope;

    public LibraryByRoot(@NotNull Path root, @NotNull KtModule parentModule, @NotNull Project project, @NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)parentModule, (String)"parentModule");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        this.root = root;
        this.parentModule = parentModule;
        this.project = project;
        this.contentScope = TestModuleStructureFactory.INSTANCE.getScopeForLibraryByRoots(CollectionsKt.listOf((Object)this.root), this.getProject(), testServices);
    }

    @NotNull
    public Project getProject() {
        return this.project;
    }

    @NotNull
    public GlobalSearchScope getContentScope() {
        return this.contentScope;
    }

    @NotNull
    public String getLibraryName() {
        return "Test Library " + this.root;
    }

    @NotNull
    public List<KtModule> getDirectRegularDependencies() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    public List<KtModule> getDirectDependsOnDependencies() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    public List<KtModule> getTransitiveDependsOnDependencies() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    public List<KtModule> getDirectFriendDependencies() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    public TargetPlatform getPlatform() {
        return this.parentModule.getPlatform();
    }

    @NotNull
    public PlatformDependentAnalyzerServices getAnalyzerServices() {
        return this.parentModule.getAnalyzerServices();
    }

    @NotNull
    public Collection<Path> getBinaryRoots() {
        return CollectionsKt.listOf((Object)this.root);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.analysis.test.framework.project.structure.LibraryByRoot");
        LibraryByRoot cfr_ignored_0 = (LibraryByRoot)other;
        return Intrinsics.areEqual((Object)this.root, (Object)((LibraryByRoot)other).root);
    }

    public int hashCode() {
        return ((Object)this.root).hashCode();
    }

    @Nullable
    public KtLibrarySourceModule getLibrarySources() {
        return null;
    }
}

