/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.low.level.api.fir.AbstractPartialRawFirBuilderTestCase;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.FirDesignation;
import org.jetbrains.kotlin.analysis.low.level.api.fir.lazy.resolve.RawFirNonLocalDeclarationBuilder;
import org.jetbrains.kotlin.analysis.low.level.api.fir.test.base.AbstractLowLevelApiSingleFileTest;
import org.jetbrains.kotlin.analysis.test.framework.base.AbstractAnalysisApiBasedTest;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirElementWithResolveState;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.builder.PsiRawFirBuilder;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.renderer.ConeIdFullRenderer;
import org.jetbrains.kotlin.fir.renderer.ConeIdRenderer;
import org.jetbrains.kotlin.fir.renderer.FirRenderer;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.scopes.FirContainingNamesAwareScope;
import org.jetbrains.kotlin.fir.scopes.FirScopeProvider;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.session.FirSessionFactoryHelper;
import org.jetbrains.kotlin.fir.visitors.FirVisitorVoid;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.test.InTextDirectivesUtils;
import org.jetbrains.kotlin.test.services.AssertionsKt;
import org.jetbrains.kotlin.test.services.AssertionsService;
import org.jetbrains.kotlin.test.services.JUnit5Assertions;
import org.jetbrains.kotlin.test.services.TestModuleStructure;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u00152\u00020\u0001:\u0002\u0015\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002J.\u0010\u000e\u001a\u00020\u0004\"\b\b\u0000\u0010\u000f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00062\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002H\u000f0\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/AbstractPartialRawFirBuilderTestCase;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/test/base/AbstractLowLevelApiSingleFileTest;", "()V", "doTestByFileStructure", "", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "moduleStructure", "Lorg/jetbrains/kotlin/test/services/TestModuleStructure;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "testFunctionPartialBuilding", "nameToFind", "", "testPartialBuilding", "T", "Lorg/jetbrains/kotlin/psi/KtElement;", "file", "findPsiElement", "Lkotlin/Function1;", "testPropertyPartialBuilding", "Companion", "DesignationBuilder", "low-level-api-fir_test"})
public abstract class AbstractPartialRawFirBuilderTestCase
extends AbstractLowLevelApiSingleFileTest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String FUNCTION_DIRECTIVE = "// FUNCTION: ";
    @NotNull
    private static final String PROPERTY_DIRECTIVE = "// PROPERTY: ";

    @Override
    public void doTestByFileStructure(@NotNull KtFile ktFile, @NotNull TestModuleStructure moduleStructure, @NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)ktFile, (String)"ktFile");
        Intrinsics.checkNotNullParameter((Object)moduleStructure, (String)"moduleStructure");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        String fileText = PathsKt.readText$default((Path)this.getTestDataPath(), null, (int)1, null);
        String[] stringArray = new String[]{FUNCTION_DIRECTIVE};
        String functionName = InTextDirectivesUtils.findStringWithPrefixes((String)fileText, (String[])stringArray);
        String[] stringArray2 = new String[]{PROPERTY_DIRECTIVE};
        String propertyName = InTextDirectivesUtils.findStringWithPrefixes((String)fileText, (String[])stringArray2);
        if (functionName != null) {
            this.testFunctionPartialBuilding(ktFile, functionName);
        } else if (propertyName != null) {
            this.testPropertyPartialBuilding(ktFile, propertyName);
        } else {
            AssertionsKt.getAssertions((TestServices)testServices).fail((Function0)doTestByFileStructure.1.INSTANCE);
            throw null;
        }
    }

    private final void testFunctionPartialBuilding(KtFile ktFile, String nameToFind) {
        this.testPartialBuilding(ktFile, (Function1)new Function1<KtFile, KtNamedFunction>(nameToFind){
            final /* synthetic */ String $nameToFind;
            {
                this.$nameToFind = $nameToFind;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final KtNamedFunction invoke(@NotNull KtFile file) {
                void $this$findDescendantOfType$iv;
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                PsiElement psiElement = (PsiElement)file;
                Function1 predicate$iv = (Function1)new Function1<KtNamedFunction, Boolean>(this.$nameToFind){
                    final /* synthetic */ String $nameToFind;
                    {
                        this.$nameToFind = $nameToFind;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull KtNamedFunction it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return Intrinsics.areEqual((Object)it.getName(), (Object)this.$nameToFind);
                    }
                };
                boolean $i$f$findDescendantOfType = false;
                void $this$findDescendantOfType$iv$iv = $this$findDescendantOfType$iv;
                boolean $i$f$findDescendantOfType2 = false;
                PsiUtilsKt.checkDecompiledText((PsiElement)$this$findDescendantOfType$iv$iv);
                Ref.ObjectRef result$iv$iv = new Ref.ObjectRef();
                $this$findDescendantOfType$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv){
                    final /* synthetic */ Function1 $predicate;
                    final /* synthetic */ Ref.ObjectRef $result;
                    {
                        this.$predicate = $predicate;
                        this.$result = $result;
                    }

                    public void visitElement(@NotNull PsiElement element) {
                        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                        if (element instanceof KtNamedFunction && ((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                            this.$result.element = element;
                            this.stopWalking();
                            return;
                        }
                        PsiElement it = element;
                        boolean bl = false;
                        super.visitElement(element);
                    }
                });
                PsiElement psiElement2 = (PsiElement)result$iv$iv.element;
                Intrinsics.checkNotNull((Object)psiElement2);
                return (KtNamedFunction)psiElement2;
            }
        });
    }

    private final void testPropertyPartialBuilding(KtFile ktFile, String nameToFind) {
        this.testPartialBuilding(ktFile, (Function1)new Function1<KtFile, KtProperty>(nameToFind){
            final /* synthetic */ String $nameToFind;
            {
                this.$nameToFind = $nameToFind;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final KtProperty invoke(@NotNull KtFile file) {
                void $this$findDescendantOfType$iv;
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                PsiElement psiElement = (PsiElement)file;
                Function1 predicate$iv = (Function1)new Function1<KtProperty, Boolean>(this.$nameToFind){
                    final /* synthetic */ String $nameToFind;
                    {
                        this.$nameToFind = $nameToFind;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull KtProperty it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return Intrinsics.areEqual((Object)it.getName(), (Object)this.$nameToFind);
                    }
                };
                boolean $i$f$findDescendantOfType = false;
                void $this$findDescendantOfType$iv$iv = $this$findDescendantOfType$iv;
                boolean $i$f$findDescendantOfType2 = false;
                PsiUtilsKt.checkDecompiledText((PsiElement)$this$findDescendantOfType$iv$iv);
                Ref.ObjectRef result$iv$iv = new Ref.ObjectRef();
                $this$findDescendantOfType$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv){
                    final /* synthetic */ Function1 $predicate;
                    final /* synthetic */ Ref.ObjectRef $result;
                    {
                        this.$predicate = $predicate;
                        this.$result = $result;
                    }

                    public void visitElement(@NotNull PsiElement element) {
                        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                        if (element instanceof KtProperty && ((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                            this.$result.element = element;
                            this.stopWalking();
                            return;
                        }
                        PsiElement it = element;
                        boolean bl = false;
                        super.visitElement(element);
                    }
                });
                PsiElement psiElement2 = (PsiElement)result$iv$iv.element;
                Intrinsics.checkNotNull((Object)psiElement2);
                return (KtProperty)psiElement2;
            }
        });
    }

    private final <T extends KtElement> void testPartialBuilding(KtFile file, Function1<? super KtFile, ? extends T> findPsiElement) {
        Object object = findPsiElement.invoke((Object)file);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtDeclaration");
        KtDeclaration elementToBuild = (KtDeclaration)object;
        FirScopeProvider scopeProvider2 = new FirScopeProvider(){

            @NotNull
            public FirTypeScope getUseSiteMemberScope(@NotNull FirClass klass, @NotNull FirSession useSiteSession, @NotNull ScopeSession scopeSession, @Nullable FirResolvePhase memberRequiredPhase) {
                Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
                Intrinsics.checkNotNullParameter((Object)useSiteSession, (String)"useSiteSession");
                Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
                throw new IllegalStateException("Should not be called".toString());
            }

            @Nullable
            public FirContainingNamesAwareScope getStaticMemberScopeForCallables(@NotNull FirClass klass, @NotNull FirSession useSiteSession, @NotNull ScopeSession scopeSession) {
                Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
                Intrinsics.checkNotNullParameter((Object)useSiteSession, (String)"useSiteSession");
                Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
                throw new IllegalStateException("Should not be called".toString());
            }

            @Nullable
            public FirContainingNamesAwareScope getNestedClassifierScope(@NotNull FirClass klass, @NotNull FirSession useSiteSession, @NotNull ScopeSession scopeSession) {
                Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
                Intrinsics.checkNotNullParameter((Object)useSiteSession, (String)"useSiteSession");
                Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
                throw new IllegalStateException("Should not be called".toString());
            }
        };
        FirSession session = FirSessionFactoryHelper.INSTANCE.createEmptySession();
        PsiRawFirBuilder firBuilder = new PsiRawFirBuilder(session, scopeProvider2, null, 4, null);
        FirFile original = firBuilder.buildFirFile(file);
        DesignationBuilder designationBuilder = new DesignationBuilder(elementToBuild);
        original.accept((FirVisitorVoid)designationBuilder);
        FirDesignation designation = designationBuilder.getResultDesignation();
        TestCase.assertTrue((designation != null ? 1 : 0) != 0);
        FirScopeProvider firScopeProvider = scopeProvider2;
        FirDesignation firDesignation = designation;
        Intrinsics.checkNotNull((Object)firDesignation);
        FirDeclaration firElement = RawFirNonLocalDeclarationBuilder.Companion.buildWithReplacement(session, firScopeProvider, firDesignation, (KtElement)elementToBuild, null);
        String firDump = FirRenderer.renderElementAsString$default((FirRenderer)new FirRenderer(null, null, null, null, null, null, null, (ConeIdRenderer)new ConeIdFullRenderer(), null, null, null, null, null, null, null, null, null, 130943, null), (FirElement)((FirElement)firElement), (boolean)false, (int)2, null);
        AbstractAnalysisApiBasedTest.assertEqualsToTestDataFileSibling$default(this, (AssertionsService)JUnit5Assertions.INSTANCE, firDump, null, null, 6, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/AbstractPartialRawFirBuilderTestCase$Companion;", "", "()V", "FUNCTION_DIRECTIVE", "", "PROPERTY_DIRECTIVE", "low-level-api-fir_test"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\b\u001a\u0004\u0018\u00010\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/AbstractPartialRawFirBuilderTestCase$DesignationBuilder;", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitorVoid;", "elementToBuild", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;)V", "path", "", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "<set-?>", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/FirDesignation;", "resultDesignation", "getResultDesignation", "()Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/FirDesignation;", "visitElement", "", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "low-level-api-fir_test"})
    private static final class DesignationBuilder
    extends FirVisitorVoid {
        @NotNull
        private final KtDeclaration elementToBuild;
        @NotNull
        private final List<FirRegularClass> path;
        @Nullable
        private FirDesignation resultDesignation;

        public DesignationBuilder(@NotNull KtDeclaration elementToBuild) {
            Intrinsics.checkNotNullParameter((Object)elementToBuild, (String)"elementToBuild");
            this.elementToBuild = elementToBuild;
            this.path = new ArrayList();
        }

        @Nullable
        public final FirDesignation getResultDesignation() {
            return this.resultDesignation;
        }

        public void visitElement(@NotNull FirElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            if (this.resultDesignation != null) {
                return;
            }
            FirElement firElement = element;
            if (firElement instanceof FirSimpleFunction ? true : firElement instanceof FirProperty) {
                if (Intrinsics.areEqual((Object)UtilsKt.getPsi((FirElement)element), (Object)this.elementToBuild)) {
                    FirDeclaration originalDeclaration = (FirDeclaration)element;
                    this.resultDesignation = new FirDesignation(this.path, (FirElementWithResolveState)originalDeclaration);
                } else {
                    element.acceptChildren((FirVisitorVoid)this);
                }
            } else if (firElement instanceof FirRegularClass) {
                this.path.add((FirRegularClass)element);
                element.acceptChildren((FirVisitorVoid)this);
                if (this.resultDesignation == null) {
                    CollectionsKt.removeLast(this.path);
                }
            } else {
                element.acceptChildren((FirVisitorVoid)this);
            }
        }
    }
}

