/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.caches;

import com.intellij.openapi.progress.ProcessCanceledException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.low.level.api.fir.caches.ValueWithPostComputeTest;
import org.jetbrains.kotlin.analysis.low.level.api.fir.fir.caches.ValueWithPostCompute;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\b\u0010\u0006\u001a\u00020\u0004H\u0007\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/caches/ValueWithPostComputeTest;", "", "()V", "testPCEFromPostCompute", "", "testPCEIsRethrownAndNotSavedInCache", "testTheSameValueIsComputedFromDifferentThreads", "low-level-api-fir_test"})
@SourceDebugExtension(value={"SMAP\nValueWithPostComputeTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ValueWithPostComputeTest.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/caches/ValueWithPostComputeTest\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,129:1\n1549#2:130\n1620#2,3:131\n1855#2,2:134\n1855#2,2:136\n1726#2,3:138\n1#3:141\n*S KotlinDebug\n*F\n+ 1 ValueWithPostComputeTest.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/caches/ValueWithPostComputeTest\n*L\n36#1:130\n36#1:131,3\n41#1:134,2\n42#1:136,2\n48#1:138,3\n*E\n"})
public final class ValueWithPostComputeTest {
    /*
     * WARNING - void declaration
     */
    @Test
    public final void testTheSameValueIsComputedFromDifferentThreads() {
        boolean bl;
        List resultsList;
        block6: {
            Iterator $this$mapTo$iv$iv;
            ValueWithPostCompute valueWithPostCompute2 = new ValueWithPostCompute((Object)1, (Function1)testTheSameValueIsComputedFromDifferentThreads.valueWithPostCompute.1.INSTANCE, (Function3)testTheSameValueIsComputedFromDifferentThreads.valueWithPostCompute.2.INSTANCE);
            ConcurrentLinkedQueue<String> results = new ConcurrentLinkedQueue<String>();
            Iterable $this$map$iv = (Iterable)new IntRange(0, 9);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void threadIndex;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                String string = "" + 't' + (int)threadIndex;
                collection.add(ThreadsKt.thread$default((boolean)false, (boolean)false, null, (String)string, (int)0, (Function0)((Function0)new Function0<Unit>(results, (ValueWithPostCompute<Integer, String, Unit>)valueWithPostCompute2){
                    final /* synthetic */ ConcurrentLinkedQueue<String> $results;
                    final /* synthetic */ ValueWithPostCompute<Integer, String, Unit> $valueWithPostCompute;
                    {
                        this.$results = $results;
                        this.$valueWithPostCompute = $valueWithPostCompute;
                        super(0);
                    }

                    public final void invoke() {
                        this.$results.offer((String)this.$valueWithPostCompute.getValue());
                    }
                }), (int)22, null));
            }
            List threads2 = (List)destination$iv$iv;
            Iterable $this$forEach$iv = threads2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Thread it = (Thread)element$iv;
                boolean bl3 = false;
                it.start();
            }
            $this$forEach$iv = threads2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Thread it = (Thread)element$iv;
                boolean bl4 = false;
                it.join();
            }
            resultsList = CollectionsKt.toList((Iterable)results);
            Assertions.assertEquals((int)threads2.size(), (int)results.size());
            Iterable $this$all$iv = resultsList;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    String it = (String)element$iv;
                    boolean bl5 = false;
                    if (Intrinsics.areEqual((Object)it, resultsList.get(0))) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        Assertions.assertTrue((boolean)bl, (String)("All results got from ValueWithPostCompute should be equal, but was " + resultsList));
    }

    @Test
    public final void testPCEIsRethrownAndNotSavedInCache() {
        Object object;
        Object $i$a$-runCatching-ValueWithPostComputeTest$testPCEIsRethrownAndNotSavedInCache$pceOnFirstAccess$22;
        ValueWithPostCompute valueWithPostCompute2 = new ValueWithPostCompute((Object)1, (Function1)testPCEIsRethrownAndNotSavedInCache.valueWithPostCompute.1.INSTANCE, (Function3)testPCEIsRethrownAndNotSavedInCache.valueWithPostCompute.2.INSTANCE);
        try {
            boolean $i$a$-runCatching-ValueWithPostComputeTest$testPCEIsRethrownAndNotSavedInCache$pceOnFirstAccess$22 = false;
            $i$a$-runCatching-ValueWithPostComputeTest$testPCEIsRethrownAndNotSavedInCache$pceOnFirstAccess$22 = Result.constructor-impl((Object)((String)valueWithPostCompute2.getValue()));
        }
        catch (Throwable throwable) {
            $i$a$-runCatching-ValueWithPostComputeTest$testPCEIsRethrownAndNotSavedInCache$pceOnFirstAccess$22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Throwable pceOnFirstAccess = Result.exceptionOrNull-impl((Object)$i$a$-runCatching-ValueWithPostComputeTest$testPCEIsRethrownAndNotSavedInCache$pceOnFirstAccess$22);
        Assertions.assertInstanceOf(ProcessCanceledException.class, (Object)pceOnFirstAccess);
        try {
            boolean bl = false;
            object = Result.constructor-impl((Object)((String)valueWithPostCompute2.getValue()));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Throwable pceOnSecondAccess = Result.exceptionOrNull-impl((Object)object);
        Assertions.assertInstanceOf(ProcessCanceledException.class, (Object)pceOnSecondAccess);
        Assertions.assertNotEquals((Object)pceOnFirstAccess, (Object)pceOnSecondAccess, (String)"different PCE should be thrown on every access");
    }

    @Test
    public final void testPCEFromPostCompute() {
        for (int i = 1; i < 101; ++i) {
            CountDownLatch t1CalledCalculate = new CountDownLatch(1);
            CountDownLatch t2AccessedTheCache = new CountDownLatch(1);
            AtomicReference<Object> resultRef = new AtomicReference<Object>(null);
            ValueWithPostCompute valueWithPostCompute2 = new ValueWithPostCompute((Object)1, (Function1)new Function1<Integer, Pair<? extends String, ? extends Unit>>(t1CalledCalculate){
                final /* synthetic */ CountDownLatch $t1CalledCalculate;
                {
                    this.$t1CalledCalculate = $t1CalledCalculate;
                    super(1);
                }

                @NotNull
                public final Pair<String, Unit> invoke(int it) {
                    if (Intrinsics.areEqual((Object)Thread.currentThread().getName(), (Object)"t1")) {
                        this.$t1CalledCalculate.countDown();
                    }
                    return TuplesKt.to((Object)Thread.currentThread().getName(), (Object)Unit.INSTANCE);
                }
            }, (Function3)new Function3<Integer, String, Unit, Unit>(t2AccessedTheCache){
                final /* synthetic */ CountDownLatch $t2AccessedTheCache;
                {
                    this.$t2AccessedTheCache = $t2AccessedTheCache;
                    super(3);
                }

                public final void invoke(int n, String string, @NotNull Unit unit) {
                    Intrinsics.checkNotNullParameter((Object)unit, (String)"<anonymous parameter 2>");
                    this.$t2AccessedTheCache.await();
                    if (Intrinsics.areEqual((Object)Thread.currentThread().getName(), (Object)"t1")) {
                        throw new ProcessCanceledException();
                    }
                }
            });
            Thread t12 = ThreadsKt.thread$default((boolean)false, (boolean)false, null, (String)"t1", (int)0, (Function0)((Function0)new Function0<Unit>((ValueWithPostCompute<Integer, String, Unit>)valueWithPostCompute2){
                final /* synthetic */ ValueWithPostCompute<Integer, String, Unit> $valueWithPostCompute;
                {
                    this.$valueWithPostCompute = $valueWithPostCompute;
                    super(0);
                }

                public final void invoke() {
                    try {
                        this.$valueWithPostCompute.getValue();
                    }
                    catch (ProcessCanceledException processCanceledException) {
                        // empty catch block
                    }
                }
            }), (int)23, null);
            Thread t22 = ThreadsKt.thread$default((boolean)false, (boolean)false, null, (String)"t2", (int)0, (Function0)((Function0)new Function0<Unit>(t1CalledCalculate, t2AccessedTheCache, resultRef, (ValueWithPostCompute<Integer, String, Unit>)valueWithPostCompute2){
                final /* synthetic */ CountDownLatch $t1CalledCalculate;
                final /* synthetic */ CountDownLatch $t2AccessedTheCache;
                final /* synthetic */ AtomicReference<Object> $resultRef;
                final /* synthetic */ ValueWithPostCompute<Integer, String, Unit> $valueWithPostCompute;
                {
                    this.$t1CalledCalculate = $t1CalledCalculate;
                    this.$t2AccessedTheCache = $t2AccessedTheCache;
                    this.$resultRef = $resultRef;
                    this.$valueWithPostCompute = $valueWithPostCompute;
                    super(0);
                }

                public final void invoke() {
                    this.$t1CalledCalculate.await();
                    this.$t2AccessedTheCache.countDown();
                    try {
                        this.$resultRef.set(this.$valueWithPostCompute.getValue());
                    }
                    catch (Throwable e) {
                        this.$resultRef.set(e);
                    }
                }
            }), (int)23, null);
            t22.join();
            t12.join();
            Object result = resultRef.get();
            if (result instanceof Throwable) {
                throw (Throwable)result;
            }
            Assertions.assertEquals((Object)"t2", result);
        }
    }
}

