/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.test.framework.project.structure;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.impl.base.util.LibraryUtils;
import org.jetbrains.kotlin.analysis.api.standalone.base.project.structure.KtModuleProjectStructure;
import org.jetbrains.kotlin.analysis.api.standalone.base.project.structure.KtModuleWithFiles;
import org.jetbrains.kotlin.analysis.api.standalone.base.project.structure.StandaloneProjectFactory;
import org.jetbrains.kotlin.analysis.project.structure.KtBinaryModule;
import org.jetbrains.kotlin.analysis.project.structure.KtLibraryModule;
import org.jetbrains.kotlin.analysis.project.structure.KtModule;
import org.jetbrains.kotlin.analysis.test.framework.project.structure.KtJdkModuleImpl;
import org.jetbrains.kotlin.analysis.test.framework.project.structure.KtLibraryModuleImpl;
import org.jetbrains.kotlin.analysis.test.framework.project.structure.KtLibrarySourceModuleImpl;
import org.jetbrains.kotlin.analysis.test.framework.project.structure.KtMainModuleFactory;
import org.jetbrains.kotlin.analysis.test.framework.project.structure.KtModuleWithModifiableDependencies;
import org.jetbrains.kotlin.analysis.test.framework.project.structure.KtSourceModuleImpl;
import org.jetbrains.kotlin.analysis.test.framework.services.AnalysisApiEnvironmentManagerKt;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.jvm.config.JvmClasspathRoot;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.platform.jvm.JvmPlatforms;
import org.jetbrains.kotlin.test.ConfigurationKind;
import org.jetbrains.kotlin.test.TestJdkKind;
import org.jetbrains.kotlin.test.model.DependencyDescription;
import org.jetbrains.kotlin.test.model.DependencyRelation;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.AbstractEnvironmentConfiguratorKt;
import org.jetbrains.kotlin.test.services.CompilerConfigurationProviderKt;
import org.jetbrains.kotlin.test.services.KotlinStandardLibrariesPathProviderKt;
import org.jetbrains.kotlin.test.services.SourceFileProviderKt;
import org.jetbrains.kotlin.test.services.TestModuleStructure;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.services.configuration.JvmEnvironmentConfigurator;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J*\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\tH\u0002J&\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00172\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J&\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dJ$\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00172\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\"\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J&\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00172\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010#\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J&\u0010$\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00100'2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J&\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u00172\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J$\u0010*\u001a\u00020\n*\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/analysis/test/framework/project/structure/TestModuleStructureFactory;", "", "()V", "addModuleDependencies", "", "testModule", "Lorg/jetbrains/kotlin/test/model/TestModule;", "moduleByName", "", "", "Lorg/jetbrains/kotlin/analysis/api/standalone/base/project/structure/KtModuleWithFiles;", "ktModule", "Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;", "createKtLibraryModuleByJar", "Lorg/jetbrains/kotlin/analysis/test/framework/project/structure/KtLibraryModuleImpl;", "jar", "Ljava/nio/file/Path;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "project", "Lcom/intellij/openapi/project/Project;", "libraryName", "createLibrariesByCompilerConfigurators", "", "createProjectStructureByTestStructure", "Lorg/jetbrains/kotlin/analysis/api/standalone/base/project/structure/KtModuleProjectStructure;", "moduleStructure", "Lorg/jetbrains/kotlin/test/services/TestModuleStructure;", "mainModuleFactory", "Lorg/jetbrains/kotlin/analysis/test/framework/project/structure/KtMainModuleFactory;", "createSourcePsiFiles", "Lcom/intellij/psi/PsiFile;", "getJdkModule", "Lorg/jetbrains/kotlin/analysis/test/framework/project/structure/KtJdkModuleImpl;", "getLibraryModules", "getModuleName", "getScopeForLibraryByRoots", "Lcom/intellij/psi/search/GlobalSearchScope;", "roots", "", "getStdlibModules", "Lorg/jetbrains/kotlin/analysis/project/structure/KtLibraryModule;", "toKtModule", "analysis-test-framework_test"})
@SourceDebugExtension(value={"SMAP\nTestModuleStructureFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestModuleStructureFactory.kt\norg/jetbrains/kotlin/analysis/test/framework/project/structure/TestModuleStructureFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 checks.kt\norg/jetbrains/kotlin/analysis/utils/errors/ChecksKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,264:1\n1549#2:265\n1620#2,3:266\n1194#2,2:269\n1222#2,4:271\n1855#2:275\n1855#2:282\n1856#2:290\n1856#2:291\n800#2,11:292\n1549#2:303\n1620#2,3:304\n1855#2,2:313\n1549#2:315\n1620#2,3:316\n1549#2:319\n1620#2,3:320\n1620#2,3:324\n1446#2,5:327\n1549#2:332\n1620#2,3:333\n21#3,4:276\n25#3:281\n13#3,4:307\n17#3:312\n1#4:280\n1#4:311\n1#4:323\n361#5,7:283\n*S KotlinDebug\n*F\n+ 1 TestModuleStructureFactory.kt\norg/jetbrains/kotlin/analysis/test/framework/project/structure/TestModuleStructureFactory\n*L\n75#1:265\n75#1:266,3\n78#1:269,2\n78#1:271,4\n81#1:275\n92#1:282\n92#1:290\n81#1:291\n111#1:292,11\n112#1:303\n112#1:304,3\n129#1:313,2\n147#1:315\n147#1:316,3\n148#1:319\n148#1:320,3\n200#1:324,3\n222#1:327,5\n240#1:332\n240#1:333,3\n83#1:276,4\n83#1:281\n128#1:307,4\n128#1:312\n83#1:280\n128#1:311\n93#1:283,7\n*E\n"})
public final class TestModuleStructureFactory {
    @NotNull
    public static final TestModuleStructureFactory INSTANCE = new TestModuleStructureFactory();

    private TestModuleStructureFactory() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final KtModuleProjectStructure createProjectStructureByTestStructure(@NotNull TestModuleStructure moduleStructure, @NotNull TestServices testServices, @NotNull Project project, @NotNull KtMainModuleFactory mainModuleFactory) {
        void $this$associateByTo$iv$iv;
        Object object;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)moduleStructure, (String)"moduleStructure");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)mainModuleFactory, (String)"mainModuleFactory");
        Iterable $this$map$iv = moduleStructure.getModules();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Iterator testModule;
            TestModule testModule2 = (TestModule)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(INSTANCE.toKtModule((TestModule)testModule, testServices, project, mainModuleFactory));
        }
        List modulesFromTestServices = (List)destination$iv$iv;
        Iterable $this$associateBy$iv = modulesFromTestServices;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable $i$f$mapTo22 = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            KtModuleWithFiles ktModuleWithFiles = (KtModuleWithFiles)element$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            object.put(INSTANCE.getModuleName(it.getKtModule()), element$iv$iv);
        }
        Map moduleByName = destination$iv$iv2;
        Map binaryModulesBySourceRoots = new LinkedHashMap();
        Iterable $this$forEach$iv = moduleStructure.getModules();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$forEach$iv2;
            TestModule testModule = (TestModule)element$iv;
            boolean bl = false;
            KtModule ktModule = ((KtModuleWithFiles)MapsKt.getValue((Map)moduleByName, (Object)testModule.getName())).getKtModule();
            boolean $i$f$checkIsInstance22 = false;
            if (!(ktModule instanceof KtModuleWithModifiableDependencies)) {
                boolean $i$a$-check-ChecksKt$checkIsInstance$2$iv22 = false;
                String $i$a$-check-ChecksKt$checkIsInstance$2$iv22 = "Expected " + Reflection.getOrCreateKotlinClass(KtModuleWithModifiableDependencies.class) + " instead of " + Reflection.getOrCreateKotlinClass(ktModule.getClass()) + " for " + ktModule;
                throw new IllegalStateException($i$a$-check-ChecksKt$checkIsInstance$2$iv22.toString());
            }
            INSTANCE.addModuleDependencies(testModule, moduleByName, ktModule);
            List $this$createProjectStructureByTestStructure_u24lambda_u245_u24lambda_u242 = $i$f$checkIsInstance22 = kotlin.collections.CollectionsKt.createListBuilder();
            boolean bl2 = false;
            CollectionsKt.addIfNotNull((Collection)$this$createProjectStructureByTestStructure_u24lambda_u245_u24lambda_u242, (Object)INSTANCE.getJdkModule(testModule, project, testServices));
            $this$createProjectStructureByTestStructure_u24lambda_u245_u24lambda_u242.addAll((Collection)INSTANCE.getStdlibModules(testModule, project, testServices));
            $this$createProjectStructureByTestStructure_u24lambda_u245_u24lambda_u242.addAll((Collection)INSTANCE.getLibraryModules(testServices, testModule, project));
            $this$createProjectStructureByTestStructure_u24lambda_u245_u24lambda_u242.addAll((Collection)INSTANCE.createLibrariesByCompilerConfigurators(testModule, testServices, project));
            Iterable $i$f$checkIsInstance22 = kotlin.collections.CollectionsKt.build((List)$i$f$checkIsInstance22);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Object object2;
                void $this$getOrPut$iv;
                KtBinaryModule library = (KtBinaryModule)element$iv2;
                boolean bl3 = false;
                Map map = binaryModulesBySourceRoots;
                Set key$iv = kotlin.collections.CollectionsKt.toSet((Iterable)library.getBinaryRoots());
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl4 = false;
                    KtBinaryModule answer$iv = library;
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object2 = answer$iv;
                } else {
                    object2 = value$iv;
                }
                KtBinaryModule cachedLibrary = (KtBinaryModule)object2;
                ((KtModuleWithModifiableDependencies)ktModule).getDirectRegularDependencies().add((KtModule)cachedLibrary);
            }
        }
        return new KtModuleProjectStructure(modulesFromTestServices, (Iterable)binaryModulesBySourceRoots.values());
    }

    /*
     * WARNING - void declaration
     */
    private final List<KtLibraryModuleImpl> createLibrariesByCompilerConfigurators(TestModule testModule, TestServices testServices, Project project) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        CompilerConfiguration compilerConfiguration = CompilerConfigurationProviderKt.createCompilerConfiguration((TestModule)testModule, (List)AbstractEnvironmentConfiguratorKt.getEnvironmentConfigurators((TestServices)testServices));
        Object object = compilerConfiguration.get(CLIConfigurationKeys.CONTENT_ROOTS, (Object)kotlin.collections.CollectionsKt.emptyList());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compilerConfiguration[CL\u2026NTENT_ROOTS, emptyList()]");
        List contentRoots = (List)object;
        Iterable iterable = contentRoots;
        boolean $i$f$filterIsInstance = false;
        void var8_8 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof JvmClasspathRoot)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void root;
            JvmClasspathRoot jvmClasspathRoot = (JvmClasspathRoot)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Path path = root.getFile().toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"root.file.toPath()");
            collection.add(TestModuleStructureFactory.createKtLibraryModuleByJar$default(INSTANCE, path, testServices, project, null, 8, null));
        }
        return (List)destination$iv$iv;
    }

    private final String getModuleName(KtModule ktModule) {
        String string;
        KtModule ktModule2 = ktModule;
        if (ktModule2 instanceof KtSourceModuleImpl) {
            string = ((KtSourceModuleImpl)ktModule).getModuleName();
        } else if (ktModule2 instanceof KtLibraryModuleImpl) {
            string = ((KtLibraryModuleImpl)ktModule).getLibraryName();
        } else if (ktModule2 instanceof KtLibrarySourceModuleImpl) {
            string = ((KtLibrarySourceModuleImpl)ktModule).getLibraryName();
        } else {
            throw new IllegalStateException(("Unknown module " + Reflection.getOrCreateKotlinClass(ktModule.getClass())).toString());
        }
        return string;
    }

    private final void addModuleDependencies(TestModule testModule, Map<String, KtModuleWithFiles> moduleByName, KtModule ktModule) {
        boolean $i$f$requireIsInstance = false;
        if (!(ktModule instanceof KtModuleWithModifiableDependencies)) {
            boolean $i$a$-require-ChecksKt$requireIsInstance$2$iv22 = false;
            String $i$a$-require-ChecksKt$requireIsInstance$2$iv22 = "Expected " + Reflection.getOrCreateKotlinClass(KtModuleWithModifiableDependencies.class) + " instead of " + Reflection.getOrCreateKotlinClass(ktModule.getClass()) + " for " + ktModule;
            throw new IllegalArgumentException($i$a$-require-ChecksKt$requireIsInstance$2$iv22.toString());
        }
        Iterable $this$forEach$iv = testModule.getAllDependencies();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DependencyDescription dependency = (DependencyDescription)element$iv;
            boolean bl = false;
            KtModule dependencyKtModule = ((KtModuleWithFiles)MapsKt.getValue(moduleByName, (Object)dependency.getModuleName())).getKtModule();
            switch (WhenMappings.$EnumSwitchMapping$0[dependency.getRelation().ordinal()]) {
                case 1: {
                    ((KtModuleWithModifiableDependencies)ktModule).getDirectRegularDependencies().add(dependencyKtModule);
                    break;
                }
                case 2: {
                    ((KtModuleWithModifiableDependencies)ktModule).getDirectFriendDependencies().add(dependencyKtModule);
                    break;
                }
                case 3: {
                    ((KtModuleWithModifiableDependencies)ktModule).getDirectRefinementDependencies().add(dependencyKtModule);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<KtLibraryModuleImpl> getLibraryModules(TestServices testServices, TestModule testModule, Project project) {
        Path it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        ConfigurationKind configurationKind = JvmEnvironmentConfigurator.Companion.extractConfigurationKind(testModule.getDirectives());
        Iterable iterable = JvmEnvironmentConfigurator.Companion.getLibraryFilesExceptRealRuntime(testServices, configurationKind, testModule.getDirectives());
        boolean $i$f$map = false;
        void var7_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            File file = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((File)((Object)it)).toPath().toAbsolutePath());
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void jar;
            it = (Path)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)jar, (String)"jar");
            collection.add(TestModuleStructureFactory.createKtLibraryModuleByJar$default(INSTANCE, (Path)jar, testServices, project, null, 8, null));
        }
        return (List)destination$iv$iv;
    }

    private final KtLibraryModuleImpl createKtLibraryModuleByJar(Path jar, TestServices testServices, Project project, String libraryName) {
        if (!Intrinsics.areEqual((Object)PathsKt.getExtension((Path)jar), (Object)"jar")) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(jar, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            boolean bl = false;
            String string = "library " + jar + " does not exist";
            throw new IllegalStateException(string.toString());
        }
        return new KtLibraryModuleImpl(libraryName, JvmPlatforms.INSTANCE.getDefaultJvmPlatform(), this.getScopeForLibraryByRoots(kotlin.collections.CollectionsKt.listOf((Object)jar), project, testServices), project, kotlin.collections.CollectionsKt.listOf((Object)jar), null);
    }

    static /* synthetic */ KtLibraryModuleImpl createKtLibraryModuleByJar$default(TestModuleStructureFactory testModuleStructureFactory, Path path, TestServices testServices, Project project, String string, int n, Object object) {
        if ((n & 8) != 0) {
            string = PathsKt.getNameWithoutExtension((Path)path);
        }
        return testModuleStructureFactory.createKtLibraryModuleByJar(path, testServices, project, string);
    }

    private final List<KtLibraryModule> getStdlibModules(TestModule testModule, Project project, TestServices testServices) {
        ConfigurationKind configurationKind = JvmEnvironmentConfigurator.Companion.extractConfigurationKind(testModule.getDirectives());
        if (!configurationKind.getWithRuntime()) {
            return kotlin.collections.CollectionsKt.emptyList();
        }
        Path path = KotlinStandardLibrariesPathProviderKt.getStandardLibrariesPathProvider((TestServices)testServices).runtimeJarForTests().toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"testServices.standardLib\u2026imeJarForTests().toPath()");
        Path path2 = path.toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toAbsolutePath()");
        Path lib = path2;
        return kotlin.collections.CollectionsKt.listOf((Object)this.createKtLibraryModuleByJar(lib, testServices, project, "kotlin-stdlib"));
    }

    /*
     * WARNING - void declaration
     */
    private final KtJdkModuleImpl getJdkModule(TestModule testModule, Project project, TestServices testServices) {
        void destination$iv;
        void $this$mapTo$iv;
        File it;
        Iterable iterable;
        TestJdkKind jdkKind = JvmEnvironmentConfigurator.Companion.extractJdkKind(testModule.getDirectives());
        Collection $this$getJdkModule_u24lambda_u2413 = iterable = kotlin.collections.CollectionsKt.createListBuilder();
        boolean bl = false;
        File file = JvmEnvironmentConfigurator.Companion.getJdkHome(jdkKind);
        if (file != null) {
            it = file;
            boolean bl2 = false;
            $this$getJdkModule_u24lambda_u2413.add(it.toPath());
        }
        File file2 = JvmEnvironmentConfigurator.Companion.getJdkClasspathRoot(jdkKind);
        if (file2 != null) {
            it = file2;
            boolean bl3 = false;
            $this$getJdkModule_u24lambda_u2413.add(it.toPath());
        }
        iterable = kotlin.collections.CollectionsKt.build((List)iterable);
        $this$getJdkModule_u24lambda_u2413 = new ArrayList();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it2;
            Path path = (Path)item$iv;
            void var13_13 = destination$iv;
            boolean bl4 = false;
            var13_13.add(it2.toAbsolutePath());
        }
        List jdkSourceRoots = (List)destination$iv;
        if (jdkSourceRoots.isEmpty()) {
            return null;
        }
        return new KtJdkModuleImpl("jdk", JvmPlatforms.INSTANCE.getDefaultJvmPlatform(), this.getScopeForLibraryByRoots(jdkSourceRoots, project, testServices), project, jdkSourceRoots);
    }

    /*
     * WARNING - void declaration
     */
    private final GlobalSearchScope getScopeForLibraryByRoots(Collection<? extends Path> roots, Project project, TestServices testServices) {
        void $this$getScopeForLibraryByRoots_u24lambda_u2416;
        List list;
        List virtualFileRoots = StandaloneProjectFactory.INSTANCE.getVirtualFilesForLibraryRoots(roots, AnalysisApiEnvironmentManagerKt.getEnvironmentManager(testServices).getProjectEnvironment());
        List list2 = list = kotlin.collections.CollectionsKt.createListBuilder();
        Project project2 = project;
        boolean bl = false;
        $this$getScopeForLibraryByRoots_u24lambda_u2416.addAll(virtualFileRoots);
        Iterable $this$flatMapTo$iv = virtualFileRoots;
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            VirtualFile it = (VirtualFile)element$iv;
            boolean bl2 = false;
            Iterable list$iv = LibraryUtils.INSTANCE.getAllVirtualFilesFromRoot(it, true);
            kotlin.collections.CollectionsKt.addAll((Collection)((Collection)$this$getScopeForLibraryByRoots_u24lambda_u2416), (Iterable)list$iv);
        }
        Collection cfr_ignored_0 = (Collection)$this$getScopeForLibraryByRoots_u24lambda_u2416;
        GlobalSearchScope globalSearchScope = GlobalSearchScope.filesScope((Project)project2, (Collection)kotlin.collections.CollectionsKt.build((List)list));
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"filesScope(\n            \u2026}\n            }\n        )");
        return globalSearchScope;
    }

    private final KtModuleWithFiles toKtModule(TestModule $this$toKtModule, TestServices testServices, Project project, KtMainModuleFactory mainModuleFactory) {
        return mainModuleFactory.createMainModule($this$toKtModule, testServices, project);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PsiFile> createSourcePsiFiles(@NotNull TestModule testModule, @NotNull TestServices testServices, @NotNull Project project) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)testModule, (String)"testModule");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Iterable $this$map$iv = testModule.getFiles();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            PsiFile psiFile;
            void testFile;
            TestFile testFile2 = (TestFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (SourceFileProviderKt.isKtFile((TestFile)testFile)) {
                String fileText = SourceFileProviderKt.getSourceFileProvider((TestServices)testServices).getContentOfSourceFile((TestFile)testFile);
                psiFile = (PsiFile)KtTestUtil.createFile((String)testFile.getName(), (String)fileText, (Project)project);
            } else if (SourceFileProviderKt.isJavaFile((TestFile)testFile)) {
                VirtualFile virtualFile;
                File filePath = SourceFileProviderKt.getSourceFileProvider((TestServices)testServices).getRealFileForSourceFile((TestFile)testFile);
                if (AnalysisApiEnvironmentManagerKt.getEnvironmentManager(testServices).getApplicationEnvironment().getLocalFileSystem().findFileByIoFile(filePath) == null) {
                    throw new IllegalStateException(("Virtual file not found for " + filePath).toString());
                }
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"testServices.environment\u2026not found for $filePath\")");
                psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
                if (psiFile == null) {
                    throw new IllegalStateException(("PsiFile file not found for " + filePath).toString());
                }
            } else {
                throw new IllegalStateException(("Unexpected file " + testFile.getName()).toString());
            }
            collection.add(psiFile);
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DependencyRelation.values().length];
            try {
                nArray[DependencyRelation.RegularDependency.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DependencyRelation.FriendDependency.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DependencyRelation.DependsOnDependency.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

