/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.test.framework.project.structure;

import com.intellij.psi.PsiFile;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.standalone.base.project.structure.KtModuleProjectStructure;
import org.jetbrains.kotlin.analysis.api.standalone.base.project.structure.KtModuleWithFiles;
import org.jetbrains.kotlin.analysis.project.structure.KtBuiltinsModule;
import org.jetbrains.kotlin.analysis.project.structure.KtLibraryModule;
import org.jetbrains.kotlin.analysis.project.structure.KtLibrarySourceModule;
import org.jetbrains.kotlin.analysis.project.structure.KtModule;
import org.jetbrains.kotlin.analysis.project.structure.KtNotUnderContentRootModule;
import org.jetbrains.kotlin.analysis.project.structure.KtSdkModule;
import org.jetbrains.kotlin.analysis.project.structure.KtSourceModule;
import org.jetbrains.kotlin.analysis.test.framework.project.structure.AnalysisApiKtModuleProvider;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007H\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u000eH\u0014J\b\u0010\u0017\u001a\u00020\nH\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\nH\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/analysis/test/framework/project/structure/AnalysisApiKtModuleProviderImpl;", "Lorg/jetbrains/kotlin/analysis/test/framework/project/structure/AnalysisApiKtModuleProvider;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "modulesByName", "", "", "Lorg/jetbrains/kotlin/analysis/api/standalone/base/project/structure/KtModuleWithFiles;", "modulesStructure", "Lorg/jetbrains/kotlin/analysis/api/standalone/base/project/structure/KtModuleProjectStructure;", "getTestServices", "()Lorg/jetbrains/kotlin/test/services/TestServices;", "getModule", "Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;", "moduleName", "getModuleFiles", "", "Lcom/intellij/psi/PsiFile;", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "getModuleName", "ktModule", "getModuleStructure", "registerProjectStructure", "", "modules", "analysis-test-framework_test"})
@SourceDebugExtension(value={"SMAP\nAnalysisApiKtModuleProviderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnalysisApiKtModuleProviderImpl.kt\norg/jetbrains/kotlin/analysis/test/framework/project/structure/AnalysisApiKtModuleProviderImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,63:1\n1194#2,2:64\n1222#2,4:66\n*S KotlinDebug\n*F\n+ 1 AnalysisApiKtModuleProviderImpl.kt\norg/jetbrains/kotlin/analysis/test/framework/project/structure/AnalysisApiKtModuleProviderImpl\n*L\n46#1:64,2\n46#1:66,4\n*E\n"})
public final class AnalysisApiKtModuleProviderImpl
extends AnalysisApiKtModuleProvider {
    @NotNull
    private final TestServices testServices;
    private KtModuleProjectStructure modulesStructure;
    private Map<String, KtModuleWithFiles> modulesByName;

    public AnalysisApiKtModuleProviderImpl(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        this.testServices = testServices;
    }

    @Override
    @NotNull
    protected TestServices getTestServices() {
        return this.testServices;
    }

    @Override
    @NotNull
    public KtModule getModule(@NotNull String moduleName) {
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Map<String, KtModuleWithFiles> map = this.modulesByName;
        if (map == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"modulesByName");
            map = null;
        }
        return ((KtModuleWithFiles)MapsKt.getValue(map, (Object)moduleName)).getKtModule();
    }

    @Override
    @NotNull
    public List<PsiFile> getModuleFiles(@NotNull TestModule module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Map<String, KtModuleWithFiles> map = this.modulesByName;
        if (map == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"modulesByName");
            map = null;
        }
        return ((KtModuleWithFiles)MapsKt.getValue(map, (Object)module.getName())).getFiles();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void registerProjectStructure(@NotNull KtModuleProjectStructure modules) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Intrinsics.checkNotNullParameter((Object)modules, (String)"modules");
        if (!(this.modulesStructure == null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(this.modulesByName == null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.modulesStructure = modules;
        KtModuleProjectStructure ktModuleProjectStructure = this.modulesStructure;
        if (ktModuleProjectStructure == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"modulesStructure");
            ktModuleProjectStructure = null;
        }
        Iterable iterable = ktModuleProjectStructure.getMainModules();
        AnalysisApiKtModuleProviderImpl analysisApiKtModuleProviderImpl = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var5_8 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            KtModuleWithFiles ktModuleWithFiles = (KtModuleWithFiles)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(this.getModuleName(it.getKtModule()), element$iv$iv);
        }
        analysisApiKtModuleProviderImpl.modulesByName = destination$iv$iv;
    }

    @Override
    @NotNull
    protected String getModuleName(@NotNull KtModule ktModule) {
        String string;
        Intrinsics.checkNotNullParameter((Object)ktModule, (String)"ktModule");
        KtModule ktModule2 = ktModule;
        if (ktModule2 instanceof KtLibraryModule) {
            string = ((KtLibraryModule)ktModule).getLibraryName();
        } else if (ktModule2 instanceof KtSdkModule) {
            string = ((KtSdkModule)ktModule).getSdkName();
        } else if (ktModule2 instanceof KtLibrarySourceModule) {
            string = ((KtLibrarySourceModule)ktModule).getLibraryName();
        } else if (ktModule2 instanceof KtSourceModule) {
            string = ((KtSourceModule)ktModule).getModuleName();
        } else {
            if (ktModule2 instanceof KtNotUnderContentRootModule) {
                throw new NotImplementedError(null, 1, null);
            }
            if (ktModule2 instanceof KtBuiltinsModule) {
                string = "Builtins for " + ktModule.getPlatform();
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @Override
    @NotNull
    public KtModuleProjectStructure getModuleStructure() {
        KtModuleProjectStructure ktModuleProjectStructure = this.modulesStructure;
        if (ktModuleProjectStructure == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"modulesStructure");
            ktModuleProjectStructure = null;
        }
        return ktModuleProjectStructure;
    }
}

