/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.abi.tools.v2;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.abi.tools.api.AbiFilters;
import org.jetbrains.kotlin.abi.tools.api.v2.AbiToolsV2;
import org.jetbrains.kotlin.abi.tools.api.v2.KlibDump;
import org.jetbrains.kotlin.abi.tools.api.v2.KlibTarget;
import org.jetbrains.kotlin.abi.tools.filtering.FiltersMatcher;
import org.jetbrains.kotlin.abi.tools.filtering.FiltersMatcherKt;
import org.jetbrains.kotlin.abi.tools.v2.ClassBinarySignature;
import org.jetbrains.kotlin.abi.tools.v2.KotlinSignaturesLoadingKt;
import org.jetbrains.kotlin.abi.tools.v2.klib.KlibDumpImpl;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J9\u0010\u0004\u001a\u00020\u0005\"\f\b\u0000\u0010\u0006*\u00060\u0007j\u0002`\b2\u0006\u0010\t\u001a\u0002H\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\fH\u0016J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\"\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\f2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\fH\u0002J\u001c\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/abi/tools/v2/ToolsV2;", "Lorg/jetbrains/kotlin/abi/tools/api/v2/AbiToolsV2;", "<init>", "()V", "printJvmDump", "", "T", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "appendable", "inputFiles", "", "Ljava/io/File;", "filters", "Lorg/jetbrains/kotlin/abi/tools/api/AbiFilters;", "(Ljava/lang/Appendable;Ljava/lang/Iterable;Lorg/jetbrains/kotlin/abi/tools/api/AbiFilters;)V", "createKlibDump", "Lorg/jetbrains/kotlin/abi/tools/api/v2/KlibDump;", "loadKlibDump", "dumpFile", "dump", "", "extractKlibAbi", "klib", "target", "Lorg/jetbrains/kotlin/abi/tools/api/v2/KlibTarget;", "streamsFromJar", "Lkotlin/sequences/Sequence;", "Ljava/io/InputStream;", "jarFile", "streamsForInputFiles", "abi-tools"})
public final class ToolsV2
implements AbiToolsV2 {
    @NotNull
    public static final ToolsV2 INSTANCE = new ToolsV2();

    private ToolsV2() {
    }

    public <T extends Appendable> void printJvmDump(@NotNull T appendable, @NotNull Iterable<? extends File> inputFiles, @NotNull AbiFilters filters) {
        Intrinsics.checkNotNullParameter(appendable, (String)"appendable");
        Intrinsics.checkNotNullParameter(inputFiles, (String)"inputFiles");
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        FiltersMatcher filtersMatcher = FiltersMatcherKt.compileMatcher(filters);
        List<ClassBinarySignature> signatures = KotlinSignaturesLoadingKt.filterByMatcher(KotlinSignaturesLoadingKt.loadApiFromJvmClasses(this.streamsForInputFiles(inputFiles)), filtersMatcher);
        KotlinSignaturesLoadingKt.dump(signatures, appendable);
    }

    @NotNull
    public KlibDump createKlibDump() {
        return new KlibDumpImpl();
    }

    @NotNull
    public KlibDump loadKlibDump(@NotNull File dumpFile) {
        Intrinsics.checkNotNullParameter((Object)dumpFile, (String)"dumpFile");
        return KlibDumpImpl.Companion.from$abi_tools(dumpFile);
    }

    @NotNull
    public KlibDump loadKlibDump(@NotNull CharSequence dump) {
        Intrinsics.checkNotNullParameter((Object)dump, (String)"dump");
        return KlibDumpImpl.Companion.from$abi_tools(dump);
    }

    @NotNull
    public KlibDump extractKlibAbi(@NotNull File klib, @Nullable KlibTarget target, @NotNull AbiFilters filters) {
        Intrinsics.checkNotNullParameter((Object)klib, (String)"klib");
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        KlibDump dump = KlibDumpImpl.Companion.fromKlib$abi_tools(klib, filters);
        if (target != null) {
            dump.renameSingleTarget(target);
        }
        return dump;
    }

    private final Sequence<InputStream> streamsFromJar(File jarFile) {
        JarFile jar = new JarFile(jarFile);
        Enumeration<JarEntry> enumeration = jar.entries();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"entries(...)");
        return SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration)), ToolsV2::streamsFromJar$lambda$0), arg_0 -> ToolsV2.streamsFromJar$lambda$1(jar, arg_0));
    }

    private final Sequence<InputStream> streamsForInputFiles(Iterable<? extends File> inputFiles) {
        return SequencesKt.flatMap((Sequence)CollectionsKt.asSequence(inputFiles), ToolsV2::streamsForInputFiles$lambda$0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean streamsFromJar$lambda$0(JarEntry file) {
        if (file.isDirectory()) return false;
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (!StringsKt.endsWith$default((String)string, (String)".class", (boolean)false, (int)2, null)) return false;
        String string2 = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        if (StringsKt.startsWith$default((String)string2, (String)"META-INF/", (boolean)false, (int)2, null)) return false;
        return true;
    }

    private static final InputStream streamsFromJar$lambda$1(JarFile $jar, JarEntry entry) {
        return $jar.getInputStream(entry);
    }

    private static final Sequence streamsForInputFiles$lambda$0(File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!file.exists() || !file.isFile()) {
            return SequencesKt.emptySequence();
        }
        String string = FilesKt.getExtension((File)file);
        return Intrinsics.areEqual((Object)string, (Object)"jar") ? INSTANCE.streamsFromJar(file) : (Intrinsics.areEqual((Object)string, (Object)"class") ? SequencesKt.sequenceOf((Object)new FileInputStream(file)) : SequencesKt.emptySequence());
    }
}

