/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.abi.tools.filtering;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.abi.tools.api.AbiFilters;
import org.jetbrains.kotlin.abi.tools.filtering.ComplexMatcher;
import org.jetbrains.kotlin.abi.tools.filtering.FiltersMatcher;
import org.jetbrains.kotlin.abi.tools.filtering.FiltersMatcherImpl;
import org.jetbrains.kotlin.abi.tools.filtering.PatternsKt;
import org.jetbrains.kotlin.abi.tools.filtering.WildcardsMatcher;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0012\u0010\u0004\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u00a8\u0006\b"}, d2={"compileMatcher", "Lorg/jetbrains/kotlin/abi/tools/filtering/FiltersMatcher;", "filters", "Lorg/jetbrains/kotlin/abi/tools/api/AbiFilters;", "processClasses", "Lorg/jetbrains/kotlin/abi/tools/filtering/WildcardsMatcher;", "", "", "abi-tools"})
@SourceDebugExtension(value={"SMAP\nFiltersMatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FiltersMatcher.kt\norg/jetbrains/kotlin/abi/tools/filtering/FiltersMatcherKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,310:1\n1915#2,2:311\n*S KotlinDebug\n*F\n+ 1 FiltersMatcher.kt\norg/jetbrains/kotlin/abi/tools/filtering/FiltersMatcherKt\n*L\n272#1:311,2\n*E\n"})
public final class FiltersMatcherKt {
    @NotNull
    public static final FiltersMatcher compileMatcher(@NotNull AbiFilters filters) {
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        ComplexMatcher included = new ComplexMatcher(FiltersMatcherKt.processClasses(filters.getIncludedClasses()), FiltersMatcherKt.processClasses(filters.getIncludedAnnotatedWith()));
        ComplexMatcher excluded = new ComplexMatcher(FiltersMatcherKt.processClasses(filters.getExcludedClasses()), FiltersMatcherKt.processClasses(filters.getExcludedAnnotatedWith()));
        return new FiltersMatcherImpl(included, excluded);
    }

    private static final WildcardsMatcher processClasses(Iterable<String> $this$processClasses) {
        Set full = new LinkedHashSet();
        Set anyPostfix = new LinkedHashSet();
        Set anyRightSegment = new LinkedHashSet();
        Set anyPrefix = new LinkedHashSet();
        List regex = new ArrayList();
        Iterable<String> $this$forEach$iv = $this$processClasses;
        boolean $i$f$forEach = false;
        Iterator<String> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            String element$iv;
            String classFilter = element$iv = iterator.next();
            boolean bl = false;
            boolean hasQuestionWildcard = StringsKt.contains$default((CharSequence)classFilter, (char)'?', (boolean)false, (int)2, null);
            boolean hasStarWildcard = StringsKt.contains$default((CharSequence)classFilter, (char)'*', (boolean)false, (int)2, null);
            if (hasQuestionWildcard) {
                ((Collection)regex).add(PatternsKt.wildcardsToRegex(classFilter));
                continue;
            }
            if (!hasStarWildcard) {
                ((Collection)full).add(classFilter);
                continue;
            }
            if (StringsKt.startsWith$default((String)classFilter, (String)"**", (boolean)false, (int)2, null) && StringsKt.lastIndexOf$default((CharSequence)classFilter, (char)'*', (int)0, (boolean)false, (int)6, null) == 1) {
                ((Collection)anyPrefix).add(StringsKt.removePrefix((String)classFilter, (CharSequence)"**"));
                continue;
            }
            if (StringsKt.endsWith$default((String)classFilter, (String)"*", (boolean)false, (int)2, null) && StringsKt.indexOf$default((CharSequence)classFilter, (char)'*', (int)0, (boolean)false, (int)6, null) == classFilter.length() - 1) {
                ((Collection)anyRightSegment).add(StringsKt.removeSuffix((String)classFilter, (CharSequence)"*"));
                continue;
            }
            if (StringsKt.endsWith$default((String)classFilter, (String)"**", (boolean)false, (int)2, null) && StringsKt.indexOf$default((CharSequence)classFilter, (char)'*', (int)0, (boolean)false, (int)6, null) == classFilter.length() - 2) {
                ((Collection)anyPostfix).add(StringsKt.removeSuffix((String)classFilter, (CharSequence)"**"));
                continue;
            }
            ((Collection)regex).add(PatternsKt.wildcardsToRegex(classFilter));
        }
        return new WildcardsMatcher(full, anyPostfix, anyRightSegment, anyPrefix, regex);
    }
}

