/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.abi.tools.filtering;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019BM\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0004R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0017\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/abi/tools/filtering/WildcardsMatcher;", "", "full", "", "", "anyPostfix", "anyRightSegment", "anyPrefix", "regex", "", "Lkotlin/text/Regex;", "<init>", "(Ljava/util/Set;Ljava/util/Set;Ljava/util/Set;Ljava/util/Set;Ljava/util/List;)V", "getFull", "()Ljava/util/Set;", "getAnyPostfix", "getAnyRightSegment", "getAnyPrefix", "getRegex", "()Ljava/util/List;", "matches", "", "className", "isEmpty", "()Z", "Companion", "abi-tools"})
@SourceDebugExtension(value={"SMAP\nFiltersMatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FiltersMatcher.kt\norg/jetbrains/kotlin/abi/tools/filtering/WildcardsMatcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,310:1\n1914#2,2:311\n1914#2,2:313\n1914#2,2:315\n1914#2,2:317\n*S KotlinDebug\n*F\n+ 1 FiltersMatcher.kt\norg/jetbrains/kotlin/abi/tools/filtering/WildcardsMatcher\n*L\n226#1:311,2\n232#1:313,2\n244#1:315,2\n250#1:317,2\n*E\n"})
final class WildcardsMatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<String> full;
    @NotNull
    private final Set<String> anyPostfix;
    @NotNull
    private final Set<String> anyRightSegment;
    @NotNull
    private final Set<String> anyPrefix;
    @NotNull
    private final List<Regex> regex;
    private final boolean isEmpty;
    @NotNull
    private static final WildcardsMatcher EMPTY = new WildcardsMatcher(SetsKt.emptySet(), SetsKt.emptySet(), SetsKt.emptySet(), SetsKt.emptySet(), CollectionsKt.emptyList());

    public WildcardsMatcher(@NotNull Set<String> full, @NotNull Set<String> anyPostfix, @NotNull Set<String> anyRightSegment, @NotNull Set<String> anyPrefix, @NotNull List<Regex> regex) {
        Intrinsics.checkNotNullParameter(full, (String)"full");
        Intrinsics.checkNotNullParameter(anyPostfix, (String)"anyPostfix");
        Intrinsics.checkNotNullParameter(anyRightSegment, (String)"anyRightSegment");
        Intrinsics.checkNotNullParameter(anyPrefix, (String)"anyPrefix");
        Intrinsics.checkNotNullParameter(regex, (String)"regex");
        this.full = full;
        this.anyPostfix = anyPostfix;
        this.anyRightSegment = anyRightSegment;
        this.anyPrefix = anyPrefix;
        this.regex = regex;
        this.isEmpty = this.full.isEmpty() && this.anyPostfix.isEmpty() && this.anyRightSegment.isEmpty() && this.anyPrefix.isEmpty() && this.regex.isEmpty();
    }

    @NotNull
    public final Set<String> getFull() {
        return this.full;
    }

    @NotNull
    public final Set<String> getAnyPostfix() {
        return this.anyPostfix;
    }

    @NotNull
    public final Set<String> getAnyRightSegment() {
        return this.anyRightSegment;
    }

    @NotNull
    public final Set<String> getAnyPrefix() {
        return this.anyPrefix;
    }

    @NotNull
    public final List<Regex> getRegex() {
        return this.regex;
    }

    public final boolean matches(@NotNull String className) {
        String prefix;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        if (this.isEmpty) {
            return false;
        }
        if (!((Collection)this.full).isEmpty() && this.full.contains(className)) {
            return true;
        }
        if (!((Collection)this.anyPostfix).isEmpty()) {
            $this$forEach$iv = this.anyPostfix;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                prefix = (String)element$iv;
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)className, (String)prefix, (boolean)false, (int)2, null)) continue;
                return true;
            }
        }
        if (!((Collection)this.anyRightSegment).isEmpty()) {
            $this$forEach$iv = this.anyRightSegment;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                prefix = (String)element$iv;
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)className, (String)prefix, (boolean)false, (int)2, null) || className.length() != prefix.length() && StringsKt.indexOf$default((CharSequence)className, (char)'.', (int)prefix.length(), (boolean)false, (int)4, null) >= 0) continue;
                return true;
            }
        }
        if (!((Collection)this.anyPrefix).isEmpty()) {
            $this$forEach$iv = this.anyPrefix;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String postfix = (String)element$iv;
                boolean bl = false;
                if (!StringsKt.endsWith$default((String)className, (String)postfix, (boolean)false, (int)2, null)) continue;
                return true;
            }
        }
        if (!((Collection)this.regex).isEmpty()) {
            $this$forEach$iv = this.regex;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Regex regex = (Regex)element$iv;
                boolean bl = false;
                if (!regex.matches((CharSequence)className)) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean isEmpty() {
        return this.isEmpty;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/abi/tools/filtering/WildcardsMatcher$Companion;", "", "<init>", "()V", "EMPTY", "Lorg/jetbrains/kotlin/abi/tools/filtering/WildcardsMatcher;", "getEMPTY", "()Lorg/jetbrains/kotlin/abi/tools/filtering/WildcardsMatcher;", "abi-tools"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final WildcardsMatcher getEMPTY() {
            return EMPTY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

