/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.abi.tools.v2.klib;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.abi.tools.api.v2.KlibTarget;
import org.jetbrains.kotlin.abi.tools.v2.klib.DeclarationType;
import org.jetbrains.kotlin.abi.tools.v2.klib.DeclarationsComparator;
import org.jetbrains.kotlin.abi.tools.v2.klib.KlibAbiDumpFileMergerKt;
import org.jetbrains.kotlin.abi.tools.v2.klib.KlibsTargetsFormatter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0007\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001c\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u001dJ(\u0010\u001e\u001a\u00020\u001f2\n\u0010 \u001a\u00060!j\u0002`\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00110\u001d2\u0006\u0010$\u001a\u00020%J\b\u0010&\u001a\u00020'H\u0002J\u000e\u0010(\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020\u0011J\u001c\u0010*\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020\u00112\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00110\u001dJ\u0014\u0010+\u001a\u00020\u001f2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00110\u001dJ\u000e\u0010-\u001a\u00020\u001f2\u0006\u0010.\u001a\u00020\u0000J\u000e\u0010/\u001a\u00020\u001f2\u0006\u0010.\u001a\u00020\u0000J\u000e\u00100\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0000J\u0010\u00101\u001a\u00020\u001f2\u0006\u00102\u001a\u00020\u0011H\u0002J\u0014\u00103\u001a\u00020\u001f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u001dJ\u001d\u00104\u001a\u00020\u001f2\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u001f06H\u0082\bJ!\u00107\u001a\u00020\u001f2\u0012\u00108\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u001f06H\u0000\u00a2\u0006\u0002\b9R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001d\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00000\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\b\"\u0004\b\u001a\u0010\u001b\u00a8\u0006:"}, d2={"Lorg/jetbrains/kotlin/abi/tools/v2/klib/DeclarationContainer;", "", "text", "", "parent", "<init>", "(Ljava/lang/String;Lorg/jetbrains/kotlin/abi/tools/v2/klib/DeclarationContainer;)V", "getText", "()Ljava/lang/String;", "getParent", "()Lorg/jetbrains/kotlin/abi/tools/v2/klib/DeclarationContainer;", "type", "Lorg/jetbrains/kotlin/abi/tools/v2/klib/DeclarationType;", "getType", "()Lorg/jetbrains/kotlin/abi/tools/v2/klib/DeclarationType;", "targets", "", "Lorg/jetbrains/kotlin/abi/tools/api/v2/KlibTarget;", "getTargets", "()Ljava/util/Set;", "children", "", "getChildren", "()Ljava/util/Map;", "delimiter", "getDelimiter", "setDelimiter", "(Ljava/lang/String;)V", "createOrUpdateChildren", "", "dump", "", "appendable", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "allTargets", "formatter", "Lorg/jetbrains/kotlin/abi/tools/v2/klib/KlibsTargetsFormatter;", "isTypeDeclaration", "", "remove", "target", "retainSpecific", "retainCommon", "commonTargets", "mergeTargetSpecific", "other", "merge", "deepCopy", "addTargetRecursively", "first", "overrideTargets", "mutateChildrenAndRemoveTargetless", "blockAction", "Lkotlin/Function1;", "visit", "action", "visit$abi_tools", "abi-tools"})
@SourceDebugExtension(value={"SMAP\nKlibAbiDumpFileMerger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KlibAbiDumpFileMerger.kt\norg/jetbrains/kotlin/abi/tools/v2/klib/DeclarationContainer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,887:1\n620#1,9:890\n620#1,9:899\n620#1,9:908\n1869#2,2:888\n216#3,2:917\n216#3,2:919\n216#3,2:921\n216#3,2:923\n216#3,2:925\n216#3,2:927\n1#4:929\n*S KotlinDebug\n*F\n+ 1 KlibAbiDumpFileMerger.kt\norg/jetbrains/kotlin/abi/tools/v2/klib/DeclarationContainer\n*L\n534#1:890,9\n544#1:899,9\n563#1:908,9\n499#1:888,2\n568#1:917,2\n577#1:919,2\n587#1:921,2\n610#1:923,2\n616#1:925,2\n631#1:927,2\n*E\n"})
public final class DeclarationContainer {
    @NotNull
    private final String text;
    @Nullable
    private final DeclarationContainer parent;
    @Nullable
    private final DeclarationType type;
    @NotNull
    private final Set<KlibTarget> targets;
    @NotNull
    private final Map<String, DeclarationContainer> children;
    @Nullable
    private String delimiter;

    public DeclarationContainer(@NotNull String text, @Nullable DeclarationContainer parent) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.text = text;
        this.parent = parent;
        this.type = !StringsKt.isBlank((CharSequence)this.text) ? DeclarationType.Companion.parseFromDeclaration(this.text) : null;
        this.targets = new LinkedHashSet();
        this.children = new LinkedHashMap();
    }

    public /* synthetic */ DeclarationContainer(String string, DeclarationContainer declarationContainer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            declarationContainer = null;
        }
        this(string, declarationContainer);
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @Nullable
    public final DeclarationContainer getParent() {
        return this.parent;
    }

    @Nullable
    public final DeclarationType getType() {
        return this.type;
    }

    @NotNull
    public final Set<KlibTarget> getTargets() {
        return this.targets;
    }

    @NotNull
    public final Map<String, DeclarationContainer> getChildren() {
        return this.children;
    }

    @Nullable
    public final String getDelimiter() {
        return this.delimiter;
    }

    public final void setDelimiter(@Nullable String string) {
        this.delimiter = string;
    }

    @NotNull
    public final DeclarationContainer createOrUpdateChildren(@NotNull String text, @NotNull Set<KlibTarget> targets) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(targets, (String)"targets");
        DeclarationContainer declarationContainer = this.children.computeIfAbsent(text, arg_0 -> DeclarationContainer.createOrUpdateChildren$lambda$1(arg_0 -> DeclarationContainer.createOrUpdateChildren$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)declarationContainer, (String)"computeIfAbsent(...)");
        DeclarationContainer child = declarationContainer;
        child.targets.addAll((Collection<KlibTarget>)targets);
        return child;
    }

    public final void dump(@NotNull Appendable appendable, @NotNull Set<KlibTarget> allTargets, @NotNull KlibsTargetsFormatter formatter) {
        Intrinsics.checkNotNullParameter((Object)appendable, (String)"appendable");
        Intrinsics.checkNotNullParameter(allTargets, (String)"allTargets");
        Intrinsics.checkNotNullParameter((Object)formatter, (String)"formatter");
        if (!Intrinsics.areEqual(this.targets, allTargets)) {
            appendable.append(StringsKt.repeat((CharSequence)" ", (int)(KlibAbiDumpFileMergerKt.access$depth(this.text) * 4))).append(formatter.formatDeclarationTargets(this.targets)).append('\n');
        }
        appendable.append(this.text);
        if (((CharSequence)this.text).length() > 0) {
            appendable.append('\n');
        }
        DeclarationContainer previousDeclaration = null;
        Iterable $this$forEach$iv = CollectionsKt.sortedWith((Iterable)this.children.values(), (Comparator)DeclarationsComparator.INSTANCE);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DeclarationContainer currentDeclaration = (DeclarationContainer)element$iv;
            boolean bl = false;
            if (previousDeclaration != null) {
                DeclarationContainer pd = previousDeclaration;
                if (pd.type != currentDeclaration.type || !Intrinsics.areEqual(currentDeclaration.targets, this.targets) || currentDeclaration.isTypeDeclaration()) {
                    appendable.append('\n');
                }
            }
            currentDeclaration.dump(appendable, this.targets, formatter);
            previousDeclaration = currentDeclaration;
        }
        if (this.delimiter != null) {
            appendable.append(this.delimiter).append('\n');
        }
    }

    private final boolean isTypeDeclaration() {
        boolean bl;
        DeclarationType declarationType = this.type;
        switch (declarationType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[declarationType.ordinal()]) {
            case 1: {
                bl = true;
                break;
            }
            case 2: {
                bl = true;
                break;
            }
            case 3: {
                bl = true;
                break;
            }
            case 4: {
                bl = true;
                break;
            }
            case 5: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public final void remove(@NotNull KlibTarget target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (this.parent != null && !this.targets.contains(target)) {
            return;
        }
        this.targets.remove(target);
        DeclarationContainer this_$iv = this;
        boolean $i$f$mutateChildrenAndRemoveTargetless = false;
        Iterator<Map.Entry<String, DeclarationContainer>> iterator$iv = this_$iv.children.entrySet().iterator();
        while (iterator$iv.hasNext()) {
            DeclarationContainer child$iv;
            DeclarationContainer it = child$iv = iterator$iv.next().getValue();
            boolean bl = false;
            it.remove(target);
            if (!child$iv.targets.isEmpty()) continue;
            iterator$iv.remove();
        }
    }

    public final void retainSpecific(@NotNull KlibTarget target, @NotNull Set<KlibTarget> allTargets) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter(allTargets, (String)"allTargets");
        if (this.parent != null && !this.targets.contains(target)) {
            this.children.clear();
            this.targets.clear();
            return;
        }
        DeclarationContainer this_$iv = this;
        boolean $i$f$mutateChildrenAndRemoveTargetless = false;
        Iterator<Map.Entry<String, DeclarationContainer>> iterator$iv = this_$iv.children.entrySet().iterator();
        while (iterator$iv.hasNext()) {
            DeclarationContainer child$iv;
            DeclarationContainer it = child$iv = iterator$iv.next().getValue();
            boolean bl = false;
            it.retainSpecific(target, allTargets);
            if (!child$iv.targets.isEmpty()) continue;
            iterator$iv.remove();
        }
        if (Intrinsics.areEqual(this.targets, allTargets)) {
            if (this.children.isEmpty()) {
                this.targets.clear();
            } else {
                this.targets.retainAll(SetsKt.setOf((Object)target));
            }
        } else {
            this.targets.retainAll(SetsKt.setOf((Object)target));
        }
    }

    public final void retainCommon(@NotNull Set<KlibTarget> commonTargets) {
        Intrinsics.checkNotNullParameter(commonTargets, (String)"commonTargets");
        if (this.parent != null && !Intrinsics.areEqual(this.targets, commonTargets)) {
            this.children.clear();
            this.targets.clear();
            return;
        }
        DeclarationContainer this_$iv = this;
        boolean $i$f$mutateChildrenAndRemoveTargetless = false;
        Iterator<Map.Entry<String, DeclarationContainer>> iterator$iv = this_$iv.children.entrySet().iterator();
        while (iterator$iv.hasNext()) {
            DeclarationContainer child$iv;
            DeclarationContainer it = child$iv = iterator$iv.next().getValue();
            boolean bl = false;
            it.retainCommon(commonTargets);
            if (!child$iv.targets.isEmpty()) continue;
            iterator$iv.remove();
        }
    }

    public final void mergeTargetSpecific(@NotNull DeclarationContainer other) {
        Map.Entry<String, DeclarationContainer> element$iv;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.targets.addAll((Collection<KlibTarget>)other.targets);
        Map<String, DeclarationContainer> $this$forEach$iv = other.children;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, DeclarationContainer>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, DeclarationContainer> otherChild = element$iv = iterator.next();
            boolean bl = false;
            DeclarationContainer child = this.children.get(otherChild.getKey());
            if (child == null) {
                this.children.put(otherChild.getKey(), otherChild.getValue().deepCopy(this));
                continue;
            }
            child.mergeTargetSpecific(otherChild.getValue());
        }
        $this$forEach$iv = this.children;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, DeclarationContainer> it = element$iv = iterator.next();
            boolean bl = false;
            if (it.getValue().targets.contains(CollectionsKt.first((Iterable)other.targets))) continue;
            it.getValue().addTargetRecursively((KlibTarget)CollectionsKt.first((Iterable)other.targets));
        }
    }

    public final void merge(@NotNull DeclarationContainer other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.targets.addAll((Collection<KlibTarget>)other.targets);
        DeclarationContainer parent = this;
        Map<String, DeclarationContainer> $this$forEach$iv = other.children;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, DeclarationContainer>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, DeclarationContainer> element$iv;
            Map.Entry<String, DeclarationContainer> entry = element$iv = iterator.next();
            boolean bl = false;
            String line = entry.getKey();
            DeclarationContainer decl = entry.getValue();
            this.children.compute(line, (arg_0, arg_1) -> DeclarationContainer.merge$lambda$11$lambda$10((arg_0, arg_1) -> DeclarationContainer.merge$lambda$11$lambda$9(decl, parent, arg_0, arg_1), arg_0, arg_1));
        }
    }

    @NotNull
    public final DeclarationContainer deepCopy(@NotNull DeclarationContainer parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        DeclarationContainer copy = new DeclarationContainer(this.text, parent);
        copy.delimiter = this.delimiter;
        copy.targets.addAll((Collection<KlibTarget>)this.targets);
        this.children.forEach((arg_0, arg_1) -> DeclarationContainer.deepCopy$lambda$13((arg_0, arg_1) -> DeclarationContainer.deepCopy$lambda$12(copy, arg_0, arg_1), arg_0, arg_1));
        return copy;
    }

    private final void addTargetRecursively(KlibTarget first) {
        this.targets.add(first);
        Map<String, DeclarationContainer> $this$forEach$iv = this.children;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, DeclarationContainer>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, DeclarationContainer> element$iv;
            Map.Entry<String, DeclarationContainer> it = element$iv = iterator.next();
            boolean bl = false;
            it.getValue().addTargetRecursively(first);
        }
    }

    public final void overrideTargets(@NotNull Set<KlibTarget> targets) {
        Intrinsics.checkNotNullParameter(targets, (String)"targets");
        this.targets.clear();
        this.targets.addAll((Collection<KlibTarget>)targets);
        Map<String, DeclarationContainer> $this$forEach$iv = this.children;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, DeclarationContainer>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, DeclarationContainer> element$iv;
            Map.Entry<String, DeclarationContainer> it = element$iv = iterator.next();
            boolean bl = false;
            it.getValue().overrideTargets(targets);
        }
    }

    private final void mutateChildrenAndRemoveTargetless(Function1<? super DeclarationContainer, Unit> blockAction) {
        boolean $i$f$mutateChildrenAndRemoveTargetless = false;
        Iterator<Map.Entry<String, DeclarationContainer>> iterator = this.children.entrySet().iterator();
        while (iterator.hasNext()) {
            DeclarationContainer child = iterator.next().getValue();
            blockAction.invoke((Object)child);
            if (!child.targets.isEmpty()) continue;
            iterator.remove();
        }
    }

    public final void visit$abi_tools(@NotNull Function1<? super DeclarationContainer, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Map<String, DeclarationContainer> $this$forEach$iv = this.children;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, DeclarationContainer>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, DeclarationContainer> element$iv;
            Map.Entry<String, DeclarationContainer> it = element$iv = iterator.next();
            boolean bl = false;
            action.invoke((Object)it.getValue());
        }
    }

    private static final DeclarationContainer createOrUpdateChildren$lambda$0(DeclarationContainer this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        DeclarationContainer newChild = new DeclarationContainer(it, this$0);
        return newChild;
    }

    private static final DeclarationContainer createOrUpdateChildren$lambda$1(Function1 $tmp0, Object p0) {
        return (DeclarationContainer)$tmp0.invoke(p0);
    }

    private static final DeclarationContainer merge$lambda$11$lambda$9(DeclarationContainer $decl, DeclarationContainer $parent, String string, DeclarationContainer thisDecl) {
        DeclarationContainer declarationContainer;
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        if (thisDecl == null) {
            declarationContainer = $decl.deepCopy($parent);
        } else {
            DeclarationContainer declarationContainer2;
            DeclarationContainer $this$merge_u24lambda_u2411_u24lambda_u249_u24lambda_u248 = declarationContainer2 = thisDecl;
            boolean bl = false;
            $this$merge_u24lambda_u2411_u24lambda_u249_u24lambda_u248.merge($decl);
            declarationContainer = declarationContainer2;
        }
        return declarationContainer;
    }

    private static final DeclarationContainer merge$lambda$11$lambda$10(Function2 $tmp0, Object p0, Object p1) {
        return (DeclarationContainer)$tmp0.invoke(p0, p1);
    }

    private static final Unit deepCopy$lambda$12(DeclarationContainer $copy, String key, DeclarationContainer value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        $copy.children.put(key, value.deepCopy($copy));
        return Unit.INSTANCE;
    }

    private static final void deepCopy$lambda$13(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DeclarationType.values().length];
            try {
                nArray[DeclarationType.Object.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeclarationType.Class.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeclarationType.Interface.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeclarationType.AnnotationClass.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeclarationType.EnumClass.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

