/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.abi.tools.v2.klib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.abi.tools.api.v2.KlibTarget;
import org.jetbrains.kotlin.abi.tools.v2.klib.DeclarationContainer;
import org.jetbrains.kotlin.abi.tools.v2.klib.KlibAbiDumpMerger;
import org.jetbrains.kotlin.abi.tools.v2.klib.TargetHierarchy;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fH\u0002J\u001e\u0010\r\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fH\u0002J\u0014\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J\u0014\u0010\u0013\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/abi/tools/v2/klib/KlibsTargetsFormatter;", "", "klibDump", "Lorg/jetbrains/kotlin/abi/tools/v2/klib/KlibAbiDumpMerger;", "<init>", "(Lorg/jetbrains/kotlin/abi/tools/v2/klib/KlibAbiDumpMerger;)V", "aliases", "", "Lorg/jetbrains/kotlin/abi/tools/v2/klib/KlibsTargetsFormatter$Alias;", "filterOutDumplicateGroups", "", "allGroups", "", "filterOutUnusedGroups", "formatHeader", "", "targets", "", "Lorg/jetbrains/kotlin/abi/tools/api/v2/KlibTarget;", "formatDeclarationTargets", "Alias", "abi-tools"})
@SourceDebugExtension(value={"SMAP\nKlibAbiDumpFileMerger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KlibAbiDumpFileMerger.kt\norg/jetbrains/kotlin/abi/tools/v2/klib/KlibsTargetsFormatter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,887:1\n1869#2,2:888\n1869#2:890\n1563#2:891\n1634#2,3:892\n1870#2:895\n1563#2:896\n1634#2,3:897\n*S KotlinDebug\n*F\n+ 1 KlibAbiDumpFileMerger.kt\norg/jetbrains/kotlin/abi/tools/v2/klib/KlibsTargetsFormatter\n*L\n701#1:888,2\n781#1:890\n783#1:891\n783#1:892,3\n781#1:895\n798#1:896\n798#1:897,3\n*E\n"})
public final class KlibsTargetsFormatter {
    @NotNull
    private final List<Alias> aliases;

    /*
     * WARNING - void declaration
     */
    public KlibsTargetsFormatter(@NotNull KlibAbiDumpMerger klibDump) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)klibDump, (String)"klibDump");
        Comparator comparator = new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(((TargetHierarchy.NodeClosure)it.getValue()).getDepth());
                it = (Map.Entry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(((TargetHierarchy.NodeClosure)it.getValue()).getDepth()));
            }
        };
        Comparator nodesDescendingComparator = new Comparator(comparator){
            final /* synthetic */ Comparator $this_thenByDescending;
            {
                this.$this_thenByDescending = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenByDescending.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    Map.Entry it = (Map.Entry)b;
                    boolean bl = false;
                    Comparable comparable = (Comparable)it.getKey();
                    it = (Map.Entry)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)it.getKey()));
                }
                return n;
            }
        };
        Set<KlibTarget> allTargets = klibDump.getTargets$abi_tools();
        List aliasesBuilder = new ArrayList();
        Iterable iterable = CollectionsKt.sortedWith((Iterable)TargetHierarchy.INSTANCE.getHierarchyIndex$abi_tools().entrySet(), (Comparator)nodesDescendingComparator);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            Set<String> leafs = ((TargetHierarchy.NodeClosure)it.getValue()).getAllLeafs();
            Set availableTargets = SequencesKt.toSet((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)allTargets), arg_0 -> KlibsTargetsFormatter.lambda$3$lambda$2(leafs, arg_0)));
            if (!(!((Collection)availableTargets).isEmpty())) continue;
            aliasesBuilder.add(new Alias((String)it.getKey(), availableTargets));
        }
        aliasesBuilder.removeIf(arg_0 -> KlibsTargetsFormatter._init_$lambda$5(KlibsTargetsFormatter::_init_$lambda$4, arg_0));
        aliasesBuilder.removeIf(arg_0 -> KlibsTargetsFormatter._init_$lambda$7(arg_0 -> KlibsTargetsFormatter._init_$lambda$6(allTargets, arg_0), arg_0));
        this.filterOutDumplicateGroups(aliasesBuilder);
        this.filterOutUnusedGroups(klibDump, aliasesBuilder);
        this.aliases = CollectionsKt.reversed((Iterable)aliasesBuilder);
    }

    private final void filterOutDumplicateGroups(List<Alias> allGroups) {
        for (int idx = allGroups.size() - 1; 0 < idx; --idx) {
            if (!Intrinsics.areEqual(allGroups.get(idx).getTargets(), allGroups.get(idx - 1).getTargets())) continue;
            allGroups.remove(idx);
        }
    }

    private final void filterOutUnusedGroups(KlibAbiDumpMerger klibDump, List<Alias> allGroups) {
        Set targetSetsInUse = new LinkedHashSet();
        Set<KlibTarget> allTargets = klibDump.getTargets$abi_tools();
        klibDump.visit$abi_tools((Function1<? super DeclarationContainer, Unit>)((Function1)new Function1<DeclarationContainer, Unit>(allTargets, (Set<Set<KlibTarget>>)targetSetsInUse){
            final /* synthetic */ Set<KlibTarget> $allTargets;
            final /* synthetic */ Set<Set<KlibTarget>> $targetSetsInUse;
            {
                this.$allTargets = $allTargets;
                this.$targetSetsInUse = $targetSetsInUse;
                super(1, Intrinsics.Kotlin.class, "visitor", "filterOutUnusedGroups$visitor(Ljava/util/Set;Ljava/util/Set;Lorg/jetbrains/kotlin/abi/tools/v2/klib/DeclarationContainer;)V", 0);
            }

            public final void invoke(DeclarationContainer p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                KlibsTargetsFormatter.access$filterOutUnusedGroups$visitor(this.$allTargets, this.$targetSetsInUse, p0);
            }
        }));
        for (int idx = allGroups.size() - 1; -1 < idx; --idx) {
            Alias alias = allGroups.get(idx);
            Set updatedTargetSets = new LinkedHashSet();
            Iterator targetSetIterator = targetSetsInUse.iterator();
            while (targetSetIterator.hasNext()) {
                Set s = (Set)targetSetIterator.next();
                if (!s.containsAll((Collection)alias.getTargets())) continue;
                targetSetIterator.remove();
                updatedTargetSets.add(CollectionsKt.subtract((Iterable)s, (Iterable)alias.getTargets()));
            }
            Object object = updatedTargetSets.isEmpty() ? allGroups.remove(idx) : Boolean.valueOf(targetSetsInUse.addAll(updatedTargetSets));
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String formatHeader(@NotNull Set<KlibTarget> targets) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(targets, (String)"targets");
        StringBuilder $this$formatHeader_u24lambda_u2411 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$formatHeader_u24lambda_u2411.append(SequencesKt.joinToString$default((Sequence)SequencesKt.sorted((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)targets), KlibsTargetsFormatter::formatHeader$lambda$11$lambda$8)), (CharSequence)", ", (CharSequence)"// Targets: [", (CharSequence)"]", (int)0, null, null, (int)56, null));
        Iterable $this$forEach$iv = this.aliases;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Alias it = (Alias)element$iv;
            boolean bl2 = false;
            $this$formatHeader_u24lambda_u2411.append("\n// Alias: " + it.getName() + " => [");
            Iterable iterable = it.getTargets();
            StringBuilder stringBuilder2 = $this$formatHeader_u24lambda_u2411;
            boolean $i$f$map = false;
            void var14_14 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                KlibTarget klibTarget = (KlibTarget)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(it2.toString());
            }
            stringBuilder2.append(CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)((List)destination$iv$iv)), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
            $this$formatHeader_u24lambda_u2411.append("]");
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String formatDeclarationTargets(@NotNull Set<KlibTarget> targets) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(targets, (String)"targets");
        Set mutableTargets = CollectionsKt.toMutableSet((Iterable)targets);
        List resultingTargets = new ArrayList();
        for (Alias alias : this.aliases) {
            if (!mutableTargets.containsAll((Collection)alias.getTargets())) continue;
            mutableTargets.removeAll((Collection)alias.getTargets());
            resultingTargets.add(alias.getName());
        }
        Iterable iterable = mutableTargets;
        List list = resultingTargets;
        boolean $i$f$map = false;
        void var6_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KlibTarget klibTarget = (KlibTarget)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toString());
        }
        list.addAll((List)destination$iv$iv);
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)resultingTargets), (CharSequence)", ", (CharSequence)"// Targets: [", (CharSequence)"]", (int)0, null, null, (int)56, null);
    }

    private static final boolean lambda$3$lambda$2(Set $leafs, KlibTarget it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $leafs.contains(it.getTargetName());
    }

    private static final boolean _init_$lambda$4(Alias it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getTargets().size() < 2;
    }

    private static final boolean _init_$lambda$5(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean _init_$lambda$6(Set $allTargets, Alias it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual(it.getTargets(), (Object)$allTargets);
    }

    private static final boolean _init_$lambda$7(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void filterOutUnusedGroups$visitor(Set<KlibTarget> allTargets, Set<Set<KlibTarget>> targetSetsInUse, DeclarationContainer decl) {
        if (!Intrinsics.areEqual(decl.getTargets(), allTargets)) {
            targetSetsInUse.add(decl.getTargets());
        }
        decl.visit$abi_tools((Function1<? super DeclarationContainer, Unit>)((Function1)new Function1<DeclarationContainer, Unit>(allTargets, targetSetsInUse){
            final /* synthetic */ Set<KlibTarget> $allTargets;
            final /* synthetic */ Set<Set<KlibTarget>> $targetSetsInUse;
            {
                this.$allTargets = $allTargets;
                this.$targetSetsInUse = $targetSetsInUse;
                super(1, Intrinsics.Kotlin.class, "visitor", "filterOutUnusedGroups$visitor(Ljava/util/Set;Ljava/util/Set;Lorg/jetbrains/kotlin/abi/tools/v2/klib/DeclarationContainer;)V", 0);
            }

            public final void invoke(DeclarationContainer p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                KlibsTargetsFormatter.access$filterOutUnusedGroups$visitor(this.$allTargets, this.$targetSetsInUse, p0);
            }
        }));
    }

    private static final String formatHeader$lambda$11$lambda$8(KlibTarget it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.toString();
    }

    public static final /* synthetic */ void access$filterOutUnusedGroups$visitor(Set allTargets, Set targetSetsInUse, DeclarationContainer decl) {
        KlibsTargetsFormatter.filterOutUnusedGroups$visitor(allTargets, targetSetsInUse, decl);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/abi/tools/v2/klib/KlibsTargetsFormatter$Alias;", "", "name", "", "targets", "", "Lorg/jetbrains/kotlin/abi/tools/api/v2/KlibTarget;", "<init>", "(Ljava/lang/String;Ljava/util/Set;)V", "getName", "()Ljava/lang/String;", "getTargets", "()Ljava/util/Set;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "abi-tools"})
    private static final class Alias {
        @NotNull
        private final String name;
        @NotNull
        private final Set<KlibTarget> targets;

        public Alias(@NotNull String name, @NotNull Set<KlibTarget> targets) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(targets, (String)"targets");
            this.name = name;
            this.targets = targets;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final Set<KlibTarget> getTargets() {
            return this.targets;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final Set<KlibTarget> component2() {
            return this.targets;
        }

        @NotNull
        public final Alias copy(@NotNull String name, @NotNull Set<KlibTarget> targets) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(targets, (String)"targets");
            return new Alias(name, targets);
        }

        public static /* synthetic */ Alias copy$default(Alias alias, String string, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                string = alias.name;
            }
            if ((n & 2) != 0) {
                set = alias.targets;
            }
            return alias.copy(string, set);
        }

        @NotNull
        public String toString() {
            return "Alias(name=" + this.name + ", targets=" + this.targets + ')';
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + ((Object)this.targets).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Alias)) {
                return false;
            }
            Alias alias = (Alias)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)alias.name)) {
                return false;
            }
            return Intrinsics.areEqual(this.targets, alias.targets);
        }
    }
}

