/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.abi.tools.v2.klib;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.abi.tools.api.AbiFilters;
import org.jetbrains.kotlin.abi.tools.v2.klib.Filter;
import org.jetbrains.kotlin.library.abi.AbiQualifiedName;
import org.jetbrains.kotlin.library.abi.AbiReadingFilter;
import org.jetbrains.kotlin.library.abi.AbiRenderingSettings;
import org.jetbrains.kotlin.library.abi.AbiSignatureVersion;
import org.jetbrains.kotlin.library.abi.LibraryAbi;
import org.jetbrains.kotlin.library.abi.LibraryAbiReader;
import org.jetbrains.kotlin.library.abi.LibraryAbiRenderer;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0000\u001a\u00020\u00012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\f\u0010\t\u001a\u00020\n*\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"extractAbiFromKlib", "", "to", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "klibFile", "Ljava/io/File;", "filters", "Lorg/jetbrains/kotlin/abi/tools/api/AbiFilters;", "toKotlinQualifiedName", "", "Lorg/jetbrains/kotlin/library/abi/AbiQualifiedName;", "abi-tools"})
@SourceDebugExtension(value={"SMAP\nKlibReading.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KlibReading.kt\norg/jetbrains/kotlin/abi/tools/v2/klib/KlibReadingKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,89:1\n1463#2,14:90\n*S KotlinDebug\n*F\n+ 1 KlibReading.kt\norg/jetbrains/kotlin/abi/tools/v2/klib/KlibReadingKt\n*L\n32#1:90,14\n*E\n"})
public final class KlibReadingKt {
    public static final void extractAbiFromKlib(@NotNull Appendable to, @NotNull File klibFile, @NotNull AbiFilters filters) {
        Object v0;
        Sequence supportedSignatureVersions;
        LibraryAbi libraryAbi;
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter((Object)klibFile, (String)"klibFile");
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        if (!klibFile.exists()) {
            throw new FileNotFoundException("File does not exist: " + klibFile.getAbsolutePath());
        }
        Object[] objectArray = new AbiReadingFilter[]{new Filter(filters)};
        List abiFilters = CollectionsKt.mutableListOf((Object[])objectArray);
        try {
            libraryAbi = LibraryAbiReader.INSTANCE.readAbiInfo(klibFile, abiFilters);
        }
        catch (Throwable t) {
            throw new IllegalStateException("Unable to read klib from " + klibFile.getAbsolutePath(), t);
        }
        LibraryAbi library = libraryAbi;
        Sequence $this$maxByOrNull$iv = supportedSignatureVersions = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)library.getSignatureVersions()), KlibReadingKt::extractAbiFromKlib$lambda$0);
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                AbiSignatureVersion it = (AbiSignatureVersion)maxElem$iv;
                boolean bl = false;
                int maxValue$iv = it.getVersionNumber();
                do {
                    Object e$iv = iterator$iv.next();
                    AbiSignatureVersion it2 = (AbiSignatureVersion)e$iv;
                    $i$a$-maxByOrNull-KlibReadingKt$extractAbiFromKlib$signatureVersion$1 = false;
                    int v$iv = it2.getVersionNumber();
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        AbiSignatureVersion abiSignatureVersion = v0;
        if (abiSignatureVersion == null) {
            throw new IllegalStateException("Can't choose signatureVersion");
        }
        AbiSignatureVersion signatureVersion = abiSignatureVersion;
        LibraryAbiRenderer.INSTANCE.render(library, to, new AbiRenderingSettings(signatureVersion, true, true, null, null, 24, null));
    }

    private static final String toKotlinQualifiedName(AbiQualifiedName $this$toKotlinQualifiedName) {
        String packageName = $this$toKotlinQualifiedName.getPackageName-l9-qHIQ();
        String className = $this$toKotlinQualifiedName.getRelativeName-l9-qHIQ();
        return ((CharSequence)packageName).length() > 0 ? packageName + '.' + className : className;
    }

    private static final boolean extractAbiFromKlib$lambda$0(AbiSignatureVersion it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isSupportedByAbiReader();
    }

    public static final /* synthetic */ String access$toKotlinQualifiedName(AbiQualifiedName $receiver) {
        return KlibReadingKt.toKotlinQualifiedName($receiver);
    }
}

