/*
 * Decompiled with CFR 0.152.
 */
package org.jheaps.array;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.jheaps.AddressableHeap;
import org.jheaps.annotations.LinearTime;
import org.jheaps.array.AbstractArrayAddressableHeap;

public class BinaryArrayAddressableHeap<K, V>
extends AbstractArrayAddressableHeap<K, V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_HEAP_CAPACITY = 16;

    public BinaryArrayAddressableHeap() {
        this(null, 16);
    }

    public BinaryArrayAddressableHeap(int capacity) {
        this(null, capacity);
    }

    public BinaryArrayAddressableHeap(Comparator<? super K> comparator) {
        this(comparator, 16);
    }

    public BinaryArrayAddressableHeap(Comparator<? super K> comparator, int capacity) {
        super(comparator, capacity);
    }

    @LinearTime
    public static <K, V> BinaryArrayAddressableHeap<K, V> heapify(K[] keys2, V[] values2) {
        int i;
        if (keys2 == null) {
            throw new IllegalArgumentException("Key array cannot be null");
        }
        if (values2 != null && keys2.length != values2.length) {
            throw new IllegalArgumentException("Values array must have the same length as the keys array");
        }
        if (keys2.length == 0) {
            return new BinaryArrayAddressableHeap<K, V>();
        }
        BinaryArrayAddressableHeap<K, V> h2 = new BinaryArrayAddressableHeap<K, V>(keys2.length);
        for (i = 0; i < keys2.length; ++i) {
            K key = keys2[i];
            Object value = values2 == null ? null : (Object)values2[i];
            BinaryArrayAddressableHeap<K, V> binaryArrayAddressableHeap = h2;
            Objects.requireNonNull(binaryArrayAddressableHeap);
            AbstractArrayAddressableHeap.ArrayHandle ah = new AbstractArrayAddressableHeap.ArrayHandle(binaryArrayAddressableHeap, key, value);
            ah.index = i + 1;
            h2.array[i + 1] = ah;
        }
        h2.size = keys2.length;
        for (i = keys2.length / 2; i > 0; --i) {
            h2.fixdown(i);
        }
        return h2;
    }

    @LinearTime
    public static <K, V> BinaryArrayAddressableHeap<K, V> heapify(K[] keys2, V[] values2, Comparator<? super K> comparator) {
        int i;
        if (keys2 == null) {
            throw new IllegalArgumentException("Keys array cannot be null");
        }
        if (values2 != null && keys2.length != values2.length) {
            throw new IllegalArgumentException("Values array must have the same length as the keys array");
        }
        if (keys2.length == 0) {
            return new BinaryArrayAddressableHeap<K, V>(comparator);
        }
        BinaryArrayAddressableHeap<K, V> h2 = new BinaryArrayAddressableHeap<K, V>(comparator, keys2.length);
        for (i = 0; i < keys2.length; ++i) {
            K key = keys2[i];
            Object value = values2 == null ? null : (Object)values2[i];
            BinaryArrayAddressableHeap<K, V> binaryArrayAddressableHeap = h2;
            Objects.requireNonNull(binaryArrayAddressableHeap);
            AbstractArrayAddressableHeap.ArrayHandle ah = new AbstractArrayAddressableHeap.ArrayHandle(binaryArrayAddressableHeap, key, value);
            ah.index = i + 1;
            h2.array[i + 1] = ah;
        }
        h2.size = keys2.length;
        for (i = keys2.length / 2; i > 0; --i) {
            h2.fixdownWithComparator(i);
        }
        return h2;
    }

    public Iterator<AddressableHeap.Handle<K, V>> handlesIterator() {
        return new Iterator<AddressableHeap.Handle<K, V>>(){
            private int pos = 1;

            @Override
            public boolean hasNext() {
                return this.pos <= BinaryArrayAddressableHeap.this.size;
            }

            @Override
            public AddressableHeap.Handle<K, V> next() {
                if (this.pos > BinaryArrayAddressableHeap.this.size) {
                    throw new NoSuchElementException();
                }
                return BinaryArrayAddressableHeap.this.array[this.pos++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    protected void ensureCapacity(int capacity) {
        this.checkCapacity(capacity);
        AbstractArrayAddressableHeap.ArrayHandle[] newArray = (AbstractArrayAddressableHeap.ArrayHandle[])Array.newInstance(AbstractArrayAddressableHeap.ArrayHandle.class, capacity + 1);
        System.arraycopy(this.array, 1, newArray, 1, this.size);
        this.array = newArray;
    }

    @Override
    protected void forceFixup(int k) {
        AbstractArrayAddressableHeap.ArrayHandle h2 = this.array[k];
        while (k > 1) {
            this.array[k] = this.array[k / 2];
            this.array[k].index = k;
            k /= 2;
        }
        this.array[k] = h2;
        h2.index = k;
    }

    @Override
    protected void fixup(int k) {
        AbstractArrayAddressableHeap.ArrayHandle h2 = this.array[k];
        while (k > 1 && ((Comparable)this.array[k / 2].getKey()).compareTo(h2.getKey()) > 0) {
            this.array[k] = this.array[k / 2];
            this.array[k].index = k;
            k /= 2;
        }
        this.array[k] = h2;
        h2.index = k;
    }

    @Override
    protected void fixupWithComparator(int k) {
        AbstractArrayAddressableHeap.ArrayHandle h2 = this.array[k];
        while (k > 1 && this.comparator.compare(this.array[k / 2].getKey(), h2.getKey()) > 0) {
            this.array[k] = this.array[k / 2];
            this.array[k].index = k;
            k /= 2;
        }
        this.array[k] = h2;
        h2.index = k;
    }

    @Override
    protected void fixdown(int k) {
        AbstractArrayAddressableHeap.ArrayHandle h2 = this.array[k];
        while (2 * k <= this.size) {
            int j = 2 * k;
            if (j < this.size && ((Comparable)this.array[j].getKey()).compareTo(this.array[j + 1].getKey()) > 0) {
                ++j;
            }
            if (((Comparable)h2.getKey()).compareTo(this.array[j].getKey()) <= 0) break;
            this.array[k] = this.array[j];
            this.array[k].index = k;
            k = j;
        }
        this.array[k] = h2;
        h2.index = k;
    }

    @Override
    protected void fixdownWithComparator(int k) {
        AbstractArrayAddressableHeap.ArrayHandle h2 = this.array[k];
        while (2 * k <= this.size) {
            int j = 2 * k;
            if (j < this.size && this.comparator.compare(this.array[j].getKey(), this.array[j + 1].getKey()) > 0) {
                ++j;
            }
            if (this.comparator.compare(h2.getKey(), this.array[j].getKey()) <= 0) break;
            this.array[k] = this.array[j];
            this.array[k].index = k;
            k = j;
        }
        this.array[k] = h2;
        h2.index = k;
    }
}

