/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.results.location;

import com.jetbrains.pluginverifier.results.location.ClassLocation;
import com.jetbrains.pluginverifier.results.location.ElementType;
import com.jetbrains.pluginverifier.results.location.Location;
import com.jetbrains.pluginverifier.results.modifiers.Modifiers;
import com.jetbrains.pluginverifier.results.presentation.FieldTypeOption;
import com.jetbrains.pluginverifier.results.presentation.HostClassOption;
import com.jetbrains.pluginverifier.results.presentation.LocationsPresentationKt;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\tH\u00c6\u0003J=\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u0096\u0002J\b\u0010%\u001a\u00020&H\u0016R\u0014\u0010\u000b\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\rR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0013R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0013\u00a8\u0006'"}, d2={"Lcom/jetbrains/pluginverifier/results/location/FieldLocation;", "Lcom/jetbrains/pluginverifier/results/location/Location;", "hostClass", "Lcom/jetbrains/pluginverifier/results/location/ClassLocation;", "fieldName", "", "fieldDescriptor", "signature", "modifiers", "Lcom/jetbrains/pluginverifier/results/modifiers/Modifiers;", "(Lcom/jetbrains/pluginverifier/results/location/ClassLocation;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/jetbrains/pluginverifier/results/modifiers/Modifiers;)V", "containingClass", "getContainingClass", "()Lcom/jetbrains/pluginverifier/results/location/ClassLocation;", "elementType", "Lcom/jetbrains/pluginverifier/results/location/ElementType;", "getElementType", "()Lcom/jetbrains/pluginverifier/results/location/ElementType;", "getFieldDescriptor", "()Ljava/lang/String;", "getFieldName", "getHostClass", "getModifiers", "()Lcom/jetbrains/pluginverifier/results/modifiers/Modifiers;", "presentableLocation", "getPresentableLocation", "getSignature", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "", "verifier-core"})
public final class FieldLocation
extends Location {
    @NotNull
    private final ClassLocation hostClass;
    @NotNull
    private final String fieldName;
    @NotNull
    private final String fieldDescriptor;
    @Nullable
    private final String signature;
    @NotNull
    private final Modifiers modifiers;

    public FieldLocation(@NotNull ClassLocation hostClass, @NotNull String fieldName, @NotNull String fieldDescriptor, @Nullable String signature2, @NotNull Modifiers modifiers) {
        Intrinsics.checkNotNullParameter(hostClass, "hostClass");
        Intrinsics.checkNotNullParameter(fieldName, "fieldName");
        Intrinsics.checkNotNullParameter(fieldDescriptor, "fieldDescriptor");
        Intrinsics.checkNotNullParameter(modifiers, "modifiers");
        super(null);
        this.hostClass = hostClass;
        this.fieldName = fieldName;
        this.fieldDescriptor = fieldDescriptor;
        this.signature = signature2;
        this.modifiers = modifiers;
    }

    @NotNull
    public final ClassLocation getHostClass() {
        return this.hostClass;
    }

    @NotNull
    public final String getFieldName() {
        return this.fieldName;
    }

    @NotNull
    public final String getFieldDescriptor() {
        return this.fieldDescriptor;
    }

    @Nullable
    public final String getSignature() {
        return this.signature;
    }

    @NotNull
    public final Modifiers getModifiers() {
        return this.modifiers;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof FieldLocation && Intrinsics.areEqual(this.hostClass, ((FieldLocation)other).hostClass) && Intrinsics.areEqual(this.fieldName, ((FieldLocation)other).fieldName) && Intrinsics.areEqual(this.fieldDescriptor, ((FieldLocation)other).fieldDescriptor);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.hostClass, this.fieldName, this.fieldDescriptor};
        return Objects.hash(objectArray);
    }

    @Override
    @NotNull
    public String getPresentableLocation() {
        return LocationsPresentationKt.formatFieldLocation(this, HostClassOption.FULL_HOST_WITH_SIGNATURE, FieldTypeOption.SIMPLE_TYPE);
    }

    @Override
    @NotNull
    public ElementType getElementType() {
        return ElementType.FIELD;
    }

    @Override
    @NotNull
    public ClassLocation getContainingClass() {
        return this.hostClass;
    }

    @NotNull
    public final ClassLocation component1() {
        return this.hostClass;
    }

    @NotNull
    public final String component2() {
        return this.fieldName;
    }

    @NotNull
    public final String component3() {
        return this.fieldDescriptor;
    }

    @Nullable
    public final String component4() {
        return this.signature;
    }

    @NotNull
    public final Modifiers component5() {
        return this.modifiers;
    }

    @NotNull
    public final FieldLocation copy(@NotNull ClassLocation hostClass, @NotNull String fieldName, @NotNull String fieldDescriptor, @Nullable String signature2, @NotNull Modifiers modifiers) {
        Intrinsics.checkNotNullParameter(hostClass, "hostClass");
        Intrinsics.checkNotNullParameter(fieldName, "fieldName");
        Intrinsics.checkNotNullParameter(fieldDescriptor, "fieldDescriptor");
        Intrinsics.checkNotNullParameter(modifiers, "modifiers");
        return new FieldLocation(hostClass, fieldName, fieldDescriptor, signature2, modifiers);
    }

    public static /* synthetic */ FieldLocation copy$default(FieldLocation fieldLocation, ClassLocation classLocation, String string, String string2, String string3, Modifiers modifiers, int n, Object object) {
        if ((n & 1) != 0) {
            classLocation = fieldLocation.hostClass;
        }
        if ((n & 2) != 0) {
            string = fieldLocation.fieldName;
        }
        if ((n & 4) != 0) {
            string2 = fieldLocation.fieldDescriptor;
        }
        if ((n & 8) != 0) {
            string3 = fieldLocation.signature;
        }
        if ((n & 0x10) != 0) {
            modifiers = fieldLocation.modifiers;
        }
        return fieldLocation.copy(classLocation, string, string2, string3, modifiers);
    }
}

