/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.repository.cleanup;

import com.jetbrains.pluginverifier.repository.cleanup.DiskSpaceSetting;
import com.jetbrains.pluginverifier.repository.cleanup.SpaceAmount;
import com.jetbrains.pluginverifier.repository.cleanup.SweepInfo;
import com.jetbrains.pluginverifier.repository.cleanup.SweepPolicy;
import com.jetbrains.pluginverifier.repository.files.AvailableFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\"\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\b0\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0012H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0006\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\b0\u0007j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/pluginverifier/repository/cleanup/LruFileSizeSweepPolicy;", "K", "Lcom/jetbrains/pluginverifier/repository/cleanup/SweepPolicy;", "diskSpaceSetting", "Lcom/jetbrains/pluginverifier/repository/cleanup/DiskSpaceSetting;", "(Lcom/jetbrains/pluginverifier/repository/cleanup/DiskSpaceSetting;)V", "lruHeaviestFilesComparator", "Ljava/util/Comparator;", "Lcom/jetbrains/pluginverifier/repository/files/AvailableFile;", "Lkotlin/Comparator;", "estimateFreeSpaceAmount", "Lcom/jetbrains/pluginverifier/repository/cleanup/SpaceAmount;", "totalSpaceUsed", "isNecessary", "", "selectFilesForDeletion", "", "sweepInfo", "Lcom/jetbrains/pluginverifier/repository/cleanup/SweepInfo;", "verifier-repository"})
@SourceDebugExtension(value={"SMAP\nLruFileSizeSweepPolicy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LruFileSizeSweepPolicy.kt\ncom/jetbrains/pluginverifier/repository/cleanup/LruFileSizeSweepPolicy\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,51:1\n827#2:52\n855#2,2:53\n*S KotlinDebug\n*F\n+ 1 LruFileSizeSweepPolicy.kt\ncom/jetbrains/pluginverifier/repository/cleanup/LruFileSizeSweepPolicy\n*L\n29#1:52\n29#1:53,2\n*E\n"})
public final class LruFileSizeSweepPolicy<K>
implements SweepPolicy<K> {
    @NotNull
    private final DiskSpaceSetting diskSpaceSetting;
    @NotNull
    private final Comparator<AvailableFile<K>> lruHeaviestFilesComparator;

    public LruFileSizeSweepPolicy(@NotNull DiskSpaceSetting diskSpaceSetting) {
        Intrinsics.checkNotNullParameter(diskSpaceSetting, "diskSpaceSetting");
        this.diskSpaceSetting = diskSpaceSetting;
        Comparator comparator = new Comparator(){

            public final int compare(T a, T b) {
                AvailableFile it = (AvailableFile)a;
                boolean bl = false;
                Comparable comparable = it.getUsageStatistic().getLastAccessTime();
                it = (AvailableFile)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)it.getUsageStatistic().getLastAccessTime());
            }
        };
        comparator = new Comparator(comparator){
            final /* synthetic */ Comparator $this_thenByDescending;
            {
                this.$this_thenByDescending = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenByDescending.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    AvailableFile it = (AvailableFile)b;
                    boolean bl = false;
                    Comparable comparable = it.getFileInfo().getFileSize();
                    it = (AvailableFile)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues(comparable2, (Comparable)it.getFileInfo().getFileSize());
                }
                return n;
            }
        };
        this.lruHeaviestFilesComparator = new Comparator(comparator){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    AvailableFile it = (AvailableFile)a;
                    boolean bl = false;
                    Comparable comparable = it.getFileInfo().getFile().getFileName();
                    it = (AvailableFile)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues(comparable2, (Comparable)it.getFileInfo().getFile().getFileName());
                }
                return n;
            }
        };
    }

    private final SpaceAmount estimateFreeSpaceAmount(SpaceAmount totalSpaceUsed) {
        return this.diskSpaceSetting.getMaxSpaceUsage().minus(totalSpaceUsed);
    }

    @Override
    public boolean isNecessary(@NotNull SpaceAmount totalSpaceUsed) {
        Intrinsics.checkNotNullParameter(totalSpaceUsed, "totalSpaceUsed");
        return this.estimateFreeSpaceAmount(totalSpaceUsed).compareTo(this.diskSpaceSetting.getLowSpaceThreshold()) < 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<AvailableFile<K>> selectFilesForDeletion(@NotNull SweepInfo<? extends K> sweepInfo) {
        Intrinsics.checkNotNullParameter(sweepInfo, "sweepInfo");
        if (this.isNecessary(sweepInfo.getTotalSpaceUsed())) {
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv = sweepInfo.getAvailableFiles();
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                AvailableFile it = (AvailableFile)element$iv$iv;
                boolean bl = false;
                if (it.isLocked()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List freeFiles = (List)destination$iv$iv;
            if (!((Collection)freeFiles).isEmpty()) {
                List<AvailableFile<K>> sortedCandidates = CollectionsKt.sortedWith((Iterable)sweepInfo.getAvailableFiles(), this.lruHeaviestFilesComparator);
                ArrayList<AvailableFile<K>> deleteFiles = new ArrayList<AvailableFile<K>>();
                SpaceAmount estimatedFreeSpaceAmount = this.estimateFreeSpaceAmount(sweepInfo.getTotalSpaceUsed());
                SpaceAmount needToFreeSpace = this.diskSpaceSetting.getMinimumFreeSpaceAfterCleanup().minus(estimatedFreeSpaceAmount);
                for (AvailableFile<K> candidate : sortedCandidates) {
                    if (needToFreeSpace.compareTo(SpaceAmount.Companion.getZERO_SPACE()) <= 0) break;
                    deleteFiles.add(candidate);
                    needToFreeSpace = needToFreeSpace.minus(candidate.getFileInfo().getFileSize());
                }
                return deleteFiles;
            }
        }
        return CollectionsKt.emptyList();
    }
}

