/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.plugin.module;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.intellij.plugin.descriptors.IdeaPluginXmlDetector;
import com.jetbrains.plugin.structure.intellij.plugin.descriptors.IdeaPluginXmlDetectorKt;
import com.jetbrains.plugin.structure.intellij.plugin.module.ContentModule;
import com.jetbrains.plugin.structure.intellij.plugin.module.ContentModuleScannerKt;
import com.jetbrains.plugin.structure.intellij.plugin.module.ContentModules;
import com.jetbrains.plugin.structure.jar.JarArchiveCannotBeOpenException;
import com.jetbrains.plugin.structure.jar.JarFileSystemProvider;
import com.jetbrains.plugin.structure.jar.PluginJar;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\nH\u0002J\u0018\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\nH\u0002J2\u0010\u0011\u001a\u0004\u0018\u0001H\u0012\"\u0004\b\u0000\u0010\u00122\u0006\u0010\u000e\u001a\u00020\n2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u0002H\u00120\u0014H\u0082\b\u00a2\u0006\u0002\u0010\u0016J\f\u0010\u0017\u001a\u00020\u0018*\u00020\nH\u0002J\f\u0010\u0019\u001a\u00020\u001a*\u00020\nH\u0002J\f\u0010\u001b\u001a\u00020\u001a*\u00020\nH\u0002J\f\u0010\u001c\u001a\u00020\u001a*\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/module/ContentModuleScanner;", "", "fileSystemProvider", "Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;", "(Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;)V", "ideaPluginXmlDetector", "Lcom/jetbrains/plugin/structure/intellij/plugin/descriptors/IdeaPluginXmlDetector;", "getContentModules", "Lcom/jetbrains/plugin/structure/intellij/plugin/module/ContentModules;", "pluginArtifact", "Ljava/nio/file/Path;", "getJarContentModules", "", "Lcom/jetbrains/plugin/structure/intellij/plugin/module/ContentModule;", "jarPath", "resolveContentModule", "descriptorPath", "withPluginJar", "T", "action", "Lkotlin/Function1;", "Lcom/jetbrains/plugin/structure/jar/PluginJar;", "(Ljava/nio/file/Path;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "getModuleName", "", "isDescriptor", "", "isMetaInfPluginXml", "isPluginDescriptorInJarRoot", "structure-intellij"})
@SourceDebugExtension(value={"SMAP\nContentModuleScanner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContentModuleScanner.kt\ncom/jetbrains/plugin/structure/intellij/plugin/module/ContentModuleScanner\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n58#1,3:98\n62#1,3:105\n1360#2:92\n1446#2,5:93\n1549#2:101\n1620#2,3:102\n1549#2:108\n1620#2,3:109\n*E\n*S KotlinDebug\n*F\n+ 1 ContentModuleScanner.kt\ncom/jetbrains/plugin/structure/intellij/plugin/module/ContentModuleScanner\n*L\n43#1,3:98\n43#1,3:105\n36#1:92\n36#1,5:93\n45#1:101\n45#1,3:102\n81#1:108\n81#1,3:109\n*E\n"})
public final class ContentModuleScanner {
    @NotNull
    private final JarFileSystemProvider fileSystemProvider;
    @NotNull
    private final IdeaPluginXmlDetector ideaPluginXmlDetector;

    public ContentModuleScanner(@NotNull JarFileSystemProvider fileSystemProvider) {
        Intrinsics.checkNotNullParameter(fileSystemProvider, "fileSystemProvider");
        this.fileSystemProvider = fileSystemProvider;
        this.ideaPluginXmlDetector = IdeaPluginXmlDetectorKt.createIdeaPluginXmlDetector();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ContentModules getContentModules(@NotNull Path pluginArtifact) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(pluginArtifact, "pluginArtifact");
        Path libDir = pluginArtifact.resolve("lib");
        Intrinsics.checkNotNullExpressionValue(libDir, "libDir");
        if (!FileUtilKt.exists(libDir)) {
            return new ContentModules(pluginArtifact, CollectionsKt.emptyList());
        }
        List<Path> jarPaths = FileUtilKt.listJars(libDir);
        Path path = libDir.resolve("modules");
        Intrinsics.checkNotNullExpressionValue(path, "libDir.resolve(MODULES_DIR)");
        List<Path> moduleJarPaths = FileUtilKt.listJars(path);
        Iterable $this$flatMap$iv = CollectionsKt.plus((Collection)jarPaths, (Iterable)moduleJarPaths);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Path jarPath = (Path)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.getJarContentModules(jarPath);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List contentModules = (List)destination$iv$iv;
        return new ContentModules(pluginArtifact, contentModules);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final List<ContentModule> getJarContentModules(Path jarPath) {
        Object object;
        ContentModuleScanner this_$iv = this;
        boolean $i$f$withPluginJar = false;
        try {
            List list;
            object = new PluginJar(jarPath, this_$iv.fileSystemProvider);
            Throwable throwable = null;
            try {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                PluginJar jar$iv = (PluginJar)object;
                boolean bl = false;
                PluginJar jar2 = jar$iv;
                boolean bl2 = false;
                Iterable iterable = jar2.resolveDescriptors(new PluginJar.PluginDescriptorFilter(this){
                    final /* synthetic */ ContentModuleScanner this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public final boolean accept(@NotNull Path it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        return ContentModuleScanner.access$isDescriptor(this.this$0, it);
                    }
                });
                boolean $i$f$map = false;
                void var12_15 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Path path = (Path)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(this.resolveContentModule(jarPath, (Path)it));
                }
                list = (List)destination$iv$iv;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object, throwable);
            }
            object = list;
        }
        catch (JarArchiveCannotBeOpenException e$iv) {
            Throwable throwable = e$iv.getCause();
            ContentModuleScannerKt.access$getLOG$p().warn("Unable to open " + jarPath + ": " + (throwable != null ? throwable.getMessage() : null));
            object = null;
        }
        AutoCloseable autoCloseable = object;
        Object object2 = autoCloseable;
        if (autoCloseable == null) {
            object2 = CollectionsKt.emptyList();
        }
        return object2;
    }

    private final ContentModule resolveContentModule(Path jarPath, Path descriptorPath) {
        String moduleName = this.isMetaInfPluginXml(descriptorPath) ? "ROOT" : this.getModuleName(descriptorPath);
        return new ContentModule(moduleName, jarPath, descriptorPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T withPluginJar(Path jarPath, Function1<? super PluginJar, ? extends T> action) {
        AutoCloseable autoCloseable;
        boolean $i$f$withPluginJar = false;
        try {
            T t2;
            autoCloseable = new PluginJar(jarPath, this.fileSystemProvider);
            Throwable throwable = null;
            try {
                PluginJar jar2 = (PluginJar)autoCloseable;
                boolean bl = false;
                t2 = action.invoke(jar2);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                InlineMarker.finallyStart(1);
                AutoCloseableKt.closeFinally(autoCloseable, throwable);
                InlineMarker.finallyEnd(1);
            }
            autoCloseable = t2;
        }
        catch (JarArchiveCannotBeOpenException e) {
            Throwable throwable = e.getCause();
            ContentModuleScannerKt.access$getLOG$p().warn("Unable to open " + jarPath + ": " + (throwable != null ? throwable.getMessage() : null));
            autoCloseable = null;
        }
        return (T)autoCloseable;
    }

    private final boolean isDescriptor(Path $this$isDescriptor) {
        boolean bl;
        switch ($this$isDescriptor.getNameCount()) {
            case 1: {
                Path path = $this$isDescriptor.getName(0);
                Intrinsics.checkNotNullExpressionValue(path, "getName(0)");
                bl = this.isPluginDescriptorInJarRoot(path);
                break;
            }
            case 2: {
                bl = this.isMetaInfPluginXml($this$isDescriptor);
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isMetaInfPluginXml(Path $this$isMetaInfPluginXml) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = $this$isMetaInfPluginXml;
        List list = ContentModuleScannerKt.access$getMETA_INF_PLUGIN_XML_PATH_COMPONENTS$p();
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Path path = (Path)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toString());
        }
        return Intrinsics.areEqual(list, (List)destination$iv$iv);
    }

    private final boolean isPluginDescriptorInJarRoot(Path $this$isPluginDescriptorInJarRoot) {
        boolean isXml = FileUtilKt.hasExtension($this$isPluginDescriptorInJarRoot, "xml");
        return isXml && this.ideaPluginXmlDetector.isPluginDescriptor($this$isPluginDescriptorInJarRoot);
    }

    private final String getModuleName(Path $this$getModuleName) {
        return StringsKt.removeSuffix(((Object)$this$getModuleName.getFileName()).toString(), (CharSequence)".xml");
    }

    public static final /* synthetic */ boolean access$isDescriptor(ContentModuleScanner $this, Path $receiver) {
        return $this.isDescriptor($receiver);
    }
}

