/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.ide.classes;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.classes.resolvers.CompositeResolver;
import com.jetbrains.plugin.structure.classes.resolvers.FileOrigin;
import com.jetbrains.plugin.structure.classes.resolvers.JarFileResolverKt;
import com.jetbrains.plugin.structure.classes.resolvers.Resolver;
import com.jetbrains.plugin.structure.classes.resolvers.ResolversKt;
import com.jetbrains.plugin.structure.ide.Ide;
import com.jetbrains.plugin.structure.ide.InvalidIdeException;
import com.jetbrains.plugin.structure.ide.classes.IdeFileOrigin;
import com.jetbrains.plugin.structure.ide.classes.IdeResolverConfiguration;
import com.jetbrains.plugin.structure.ide.classes.IdeResolverProvider;
import com.jetbrains.plugin.structure.ide.classes.resolver.ProductInfoClassResolver;
import com.jetbrains.plugin.structure.ide.layout.InvalidIdeLayoutException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\bH\u0002J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\bH\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\rH\u0016\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/plugin/structure/ide/classes/DistributionIdeResolverProvider;", "Lcom/jetbrains/plugin/structure/ide/classes/IdeResolverProvider;", "()V", "getIdeResolver", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver;", "ide", "Lcom/jetbrains/plugin/structure/ide/Ide;", "configuration", "Lcom/jetbrains/plugin/structure/ide/classes/IdeResolverConfiguration;", "getIdeResolverFromDistribution", "resolverConfiguration", "getJarsResolver", "libDirectory", "Ljava/nio/file/Path;", "readMode", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver$ReadMode;", "parentOrigin", "Lcom/jetbrains/plugin/structure/classes/resolvers/FileOrigin;", "getProductInfoClassResolver", "Lcom/jetbrains/plugin/structure/ide/classes/resolver/ProductInfoClassResolver;", "supports", "", "idePath", "structure-ide-classes"})
public final class DistributionIdeResolverProvider
implements IdeResolverProvider {
    @Override
    @NotNull
    public Resolver getIdeResolver(@NotNull Ide ide2, @NotNull IdeResolverConfiguration configuration) throws InvalidIdeException {
        Intrinsics.checkNotNullParameter(ide2, "ide");
        Intrinsics.checkNotNullParameter(configuration, "configuration");
        Path path = ide2.getIdePath();
        Intrinsics.checkNotNullExpressionValue(path, "ide.idePath");
        Path idePath = path;
        if (this.supports(idePath)) {
            return this.getIdeResolverFromDistribution(ide2, configuration);
        }
        throw new InvalidIdeException(idePath, "Invalid IDE " + ide2 + " at " + idePath);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean supports(@NotNull Path idePath) {
        Intrinsics.checkNotNullParameter(idePath, "idePath");
        Path $this$supports_u24lambda_u240 = idePath;
        boolean bl = false;
        Path path = $this$supports_u24lambda_u240.resolve("lib");
        Intrinsics.checkNotNullExpressionValue(path, "resolve(\"lib\")");
        if (!FileUtilKt.isDirectory(path)) return false;
        Path path2 = $this$supports_u24lambda_u240.resolve(".idea");
        Intrinsics.checkNotNullExpressionValue(path2, "resolve(\".idea\")");
        if (FileUtilKt.isDirectory(path2)) return false;
        return true;
    }

    private final Resolver getJarsResolver(Path libDirectory, Resolver.ReadMode readMode, FileOrigin parentOrigin) {
        if (!FileUtilKt.isDirectory(libDirectory)) {
            return ResolversKt.getEMPTY_RESOLVER();
        }
        List<Path> jars = FileUtilKt.listJars(libDirectory);
        Path path = libDirectory.resolve("ant").resolve("lib");
        Intrinsics.checkNotNullExpressionValue(path, "libDirectory.resolve(\"ant\").resolve(\"lib\")");
        List<Path> antJars = FileUtilKt.listJars(path);
        Path path2 = libDirectory.resolve("modules");
        Intrinsics.checkNotNullExpressionValue(path2, "libDirectory.resolve(\"modules\")");
        List<Path> moduleJars = FileUtilKt.listJars(path2);
        return CompositeResolver.Companion.create((Iterable<? extends Resolver>)JarFileResolverKt.buildJarOrZipFileResolvers(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)jars, (Iterable)antJars), (Iterable)moduleJars), readMode, parentOrigin));
    }

    private final Resolver getIdeResolverFromDistribution(Ide ide2, IdeResolverConfiguration resolverConfiguration) {
        Resolver resolver;
        Ide $this$getIdeResolverFromDistribution_u24lambda_u241 = ide2;
        boolean bl = false;
        Path path = $this$getIdeResolverFromDistribution_u24lambda_u241.getIdePath();
        Intrinsics.checkNotNullExpressionValue(path, "idePath");
        if (ProductInfoClassResolver.Companion.supports(path)) {
            resolver = this.getProductInfoClassResolver(ide2, resolverConfiguration);
        } else {
            Path path2 = $this$getIdeResolverFromDistribution_u24lambda_u241.getIdePath().resolve("lib");
            Intrinsics.checkNotNullExpressionValue(path2, "idePath.resolve(\"lib\")");
            resolver = this.getJarsResolver(path2, resolverConfiguration.getReadMode(), new IdeFileOrigin.IdeLibDirectory(ide2));
        }
        return resolver;
    }

    private final ProductInfoClassResolver getProductInfoClassResolver(Ide ide2, IdeResolverConfiguration resolverConfiguration) {
        try {
            return ProductInfoClassResolver.Companion.of(ide2, resolverConfiguration);
        }
        catch (InvalidIdeLayoutException e) {
            Path path = ide2.getIdePath();
            Intrinsics.checkNotNullExpressionValue(path, "ide.idePath");
            throw new InvalidIdeException(path, e);
        }
    }
}

