/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.classes.resolvers.jar;

import com.jetbrains.plugin.structure.base.utils.CharSequencesKt;
import com.jetbrains.plugin.structure.classes.resolvers.jar.PluginIconJarEntryResolverKt;
import com.jetbrains.plugin.structure.jar.JarEntryResolver;
import java.io.File;
import java.util.zip.ZipEntry;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001e\u0010\b\u001a\u0004\u0018\u00010\u00022\n\u0010\t\u001a\u00060\u0002j\u0002`\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lcom/jetbrains/plugin/structure/classes/resolvers/jar/PluginIconJarEntryResolver;", "Lcom/jetbrains/plugin/structure/jar/JarEntryResolver;", "", "()V", "key", "Lcom/jetbrains/plugin/structure/jar/JarEntryResolver$Key;", "getKey", "()Lcom/jetbrains/plugin/structure/jar/JarEntryResolver$Key;", "resolve", "path", "Lcom/jetbrains/plugin/structure/jar/PathInJar;", "zipEntry", "Ljava/util/zip/ZipEntry;", "structure-classes"})
public final class PluginIconJarEntryResolver
implements JarEntryResolver<CharSequence> {
    @NotNull
    private final JarEntryResolver.Key<CharSequence> key = new JarEntryResolver.Key<CharSequence>("PluginIcon", CharSequence.class);

    @Override
    @NotNull
    public JarEntryResolver.Key<CharSequence> getKey() {
        return this.key;
    }

    @Override
    @Nullable
    public CharSequence resolve(@NotNull CharSequence path, @NotNull ZipEntry zipEntry) {
        String iconFileName;
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter(zipEntry, "zipEntry");
        CharSequence descriptorPath = CharSequencesKt.replaceCharacter(path, File.separatorChar, '/', PluginIconJarEntryResolverKt.access$getNO_SUFFIX$p());
        if (StringsKt.startsWith$default(descriptorPath, (CharSequence)"META-INF/", false, 2, null) && CharSequencesKt.occurrences(descriptorPath, '/') == 1 && StringsKt.endsWith(descriptorPath, (CharSequence)".svg", true) && (iconFileName = CharSequencesKt.componentAt(descriptorPath, 1, '/')) != null) {
            return iconFileName;
        }
        return null;
    }
}

