/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.classes.resolvers;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.jetbrains.plugin.structure.classes.resolvers.ResolutionResult;
import com.jetbrains.plugin.structure.classes.resolvers.Resolver;
import com.jetbrains.plugin.structure.classes.resolvers.ResourceBundleNameSet;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.ClassNode;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 62\u00020\u0001:\u000256B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010%\u001a\u00020&H\u0016J\u0014\u0010'\u001a\u00020(2\n\u0010)\u001a\u00060\fj\u0002`\rH\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0011H\u0017J\u0010\u0010*\u001a\u00020(2\u0006\u0010+\u001a\u00020\u0011H\u0016J\"\u0010,\u001a\u00020(2\u0018\u0010-\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a\u0012\u0004\u0012\u00020(0.H\u0016J\u001a\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\n\u0010)\u001a\u00060\fj\u0002`\rH\u0016J\u0016\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010)\u001a\u00020\u0011H\u0017J\u001e\u00100\u001a\b\u0012\u0004\u0012\u00020 0\u001a2\u0006\u00101\u001a\u00020\u00112\u0006\u00102\u001a\u000203H\u0016J\b\u00104\u001a\u00020\u0011H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\f\u0012\b\u0012\u00060\fj\u0002`\r0\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR \u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000b8VX\u0097\u0004\u00a2\u0006\f\u0012\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u000fR \u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u000b8VX\u0097\u0004\u00a2\u0006\f\u0012\u0004\b\u0016\u0010\u0013\u001a\u0004\b\u0017\u0010\u000fR \u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00110\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u000fR \u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\u00020\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u00067"}, d2={"Lcom/jetbrains/plugin/structure/classes/resolvers/CacheResolver;", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver;", "delegate", "cacheSize", "", "(Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver;I)V", "allBundleNameSet", "Lcom/jetbrains/plugin/structure/classes/resolvers/ResourceBundleNameSet;", "getAllBundleNameSet", "()Lcom/jetbrains/plugin/structure/classes/resolvers/ResourceBundleNameSet;", "allClassNames", "", "", "Lcom/jetbrains/plugin/structure/base/BinaryClassName;", "getAllClassNames", "()Ljava/util/Set;", "allClasses", "", "getAllClasses$annotations", "()V", "getAllClasses", "allPackages", "getAllPackages$annotations", "getAllPackages", "classCache", "Lcom/github/benmanes/caffeine/cache/LoadingCache;", "Lcom/jetbrains/plugin/structure/classes/resolvers/ResolutionResult;", "Lorg/objectweb/asm/tree/ClassNode;", "packages", "getPackages", "propertyBundleCache", "Lcom/jetbrains/plugin/structure/classes/resolvers/CacheResolver$BundleCacheKey;", "Ljava/util/PropertyResourceBundle;", "readMode", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver$ReadMode;", "getReadMode", "()Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver$ReadMode;", "close", "", "containsClass", "", "className", "containsPackage", "packageName", "processAllClasses", "processor", "Lkotlin/Function1;", "resolveClass", "resolveExactPropertyResourceBundle", "baseName", "locale", "Ljava/util/Locale;", "toString", "BundleCacheKey", "Companion", "structure-classes"})
public final class CacheResolver
extends Resolver {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Resolver delegate;
    @NotNull
    private final LoadingCache<String, ResolutionResult<ClassNode>> classCache;
    @NotNull
    private final LoadingCache<BundleCacheKey, ResolutionResult<PropertyResourceBundle>> propertyBundleCache;
    private static final int DEFAULT_CACHE_SIZE = 1024;

    public CacheResolver(@NotNull Resolver delegate, int cacheSize) {
        Intrinsics.checkNotNullParameter(delegate, "delegate");
        this.delegate = delegate;
        Function1 function1 = new Function1<String, ResolutionResult<? extends ClassNode>>(this){
            final /* synthetic */ CacheResolver this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final ResolutionResult<ClassNode> invoke(String key) {
                Resolver resolver = CacheResolver.access$getDelegate$p(this.this$0);
                Intrinsics.checkNotNullExpressionValue(key, "key");
                return resolver.resolveClass(key);
            }
        };
        LoadingCache loadingCache = Caffeine.newBuilder().maximumSize(cacheSize).build(new CacheLoader(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter(function, "function");
                this.function = function;
            }

            public final /* synthetic */ Object load(Object p0) {
                return this.function.invoke(p0);
            }
        });
        Intrinsics.checkNotNullExpressionValue(loadingCache, "newBuilder()\n      .maxi\u2026egate.resolveClass(key) }");
        this.classCache = loadingCache;
        function1 = new Function1<BundleCacheKey, ResolutionResult<? extends PropertyResourceBundle>>(this){
            final /* synthetic */ CacheResolver this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final ResolutionResult<PropertyResourceBundle> invoke(BundleCacheKey key) {
                return CacheResolver.access$getDelegate$p(this.this$0).resolveExactPropertyResourceBundle(key.getBaseName(), key.getLocale());
            }
        };
        LoadingCache loadingCache2 = Caffeine.newBuilder().maximumSize(cacheSize).build(new /* invalid duplicate definition of identical inner class */);
        Intrinsics.checkNotNullExpressionValue(loadingCache2, "newBuilder()\n      .maxi\u2026y.baseName, key.locale) }");
        this.propertyBundleCache = loadingCache2;
    }

    public /* synthetic */ CacheResolver(Resolver resolver, int n, int n2, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n2 & 2) != 0) {
            n = 1024;
        }
        this(resolver, n);
    }

    @Override
    @NotNull
    public Set<String> getAllClasses() {
        return this.delegate.getAllClasses();
    }

    @Deprecated(message="Use 'allClassNames' property instead which is more efficient")
    public static /* synthetic */ void getAllClasses$annotations() {
    }

    @Override
    @NotNull
    public Set<CharSequence> getAllClassNames() {
        return this.delegate.getAllClassNames();
    }

    @Override
    @NotNull
    public ResourceBundleNameSet getAllBundleNameSet() {
        return this.delegate.getAllBundleNameSet();
    }

    @Override
    @NotNull
    public Set<String> getAllPackages() {
        return this.delegate.getAllPackages();
    }

    @Deprecated(message="Use 'packages' property instead. This property may be slow on some file systems.")
    public static /* synthetic */ void getAllPackages$annotations() {
    }

    @Override
    @NotNull
    public Set<String> getPackages() {
        return this.delegate.getPackages();
    }

    @Override
    @NotNull
    public Resolver.ReadMode getReadMode() {
        return this.delegate.getReadMode();
    }

    @Override
    @Deprecated(message="Use 'resolveClass(BinaryClassName)' instead")
    @NotNull
    public ResolutionResult<ClassNode> resolveClass(@NotNull String className) {
        ResolutionResult<ClassNode> resolutionResult;
        Intrinsics.checkNotNullParameter(className, "className");
        try {
            ResolutionResult<ClassNode> resolutionResult2 = this.classCache.get(className);
            Intrinsics.checkNotNullExpressionValue(resolutionResult2, "{\n    classCache.get(className)\n  }");
            resolutionResult = resolutionResult2;
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable == null) {
                throwable = e;
            }
            throw throwable;
        }
        return resolutionResult;
    }

    @Override
    @NotNull
    public ResolutionResult<ClassNode> resolveClass(@NotNull CharSequence className) {
        Intrinsics.checkNotNullParameter(className, "className");
        return this.resolveClass(((Object)className).toString());
    }

    @Override
    @NotNull
    public ResolutionResult<PropertyResourceBundle> resolveExactPropertyResourceBundle(@NotNull String baseName, @NotNull Locale locale) {
        ResolutionResult<PropertyResourceBundle> resolutionResult;
        Intrinsics.checkNotNullParameter(baseName, "baseName");
        Intrinsics.checkNotNullParameter(locale, "locale");
        try {
            ResolutionResult<PropertyResourceBundle> resolutionResult2 = this.propertyBundleCache.get(new BundleCacheKey(baseName, locale));
            Intrinsics.checkNotNullExpressionValue(resolutionResult2, "{\n    propertyBundleCach\u2026ey(baseName, locale))\n  }");
            resolutionResult = resolutionResult2;
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable == null) {
                throwable = e;
            }
            throw throwable;
        }
        return resolutionResult;
    }

    @NotNull
    public String toString() {
        return "Caching resolver for " + this.delegate;
    }

    @Override
    @Deprecated(message="Use 'containsClass(BinaryClassName)' instead")
    public boolean containsClass(@NotNull String className) {
        Intrinsics.checkNotNullParameter(className, "className");
        return this.delegate.containsClass(className);
    }

    @Override
    public boolean containsClass(@NotNull CharSequence className) {
        Intrinsics.checkNotNullParameter(className, "className");
        return this.delegate.containsClass(className);
    }

    @Override
    public boolean containsPackage(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter(packageName, "packageName");
        return this.delegate.containsPackage(packageName);
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public boolean processAllClasses(@NotNull Function1<? super ResolutionResult<? extends ClassNode>, Boolean> processor) {
        Intrinsics.checkNotNullParameter(processor, "processor");
        return this.delegate.processAllClasses(processor);
    }

    public static final /* synthetic */ Resolver access$getDelegate$p(CacheResolver $this) {
        return $this.delegate;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/plugin/structure/classes/resolvers/CacheResolver$BundleCacheKey;", "", "baseName", "", "locale", "Ljava/util/Locale;", "(Ljava/lang/String;Ljava/util/Locale;)V", "getBaseName", "()Ljava/lang/String;", "getLocale", "()Ljava/util/Locale;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "structure-classes"})
    private static final class BundleCacheKey {
        @NotNull
        private final String baseName;
        @NotNull
        private final Locale locale;

        public BundleCacheKey(@NotNull String baseName, @NotNull Locale locale) {
            Intrinsics.checkNotNullParameter(baseName, "baseName");
            Intrinsics.checkNotNullParameter(locale, "locale");
            this.baseName = baseName;
            this.locale = locale;
        }

        @NotNull
        public final String getBaseName() {
            return this.baseName;
        }

        @NotNull
        public final Locale getLocale() {
            return this.locale;
        }

        @NotNull
        public final String component1() {
            return this.baseName;
        }

        @NotNull
        public final Locale component2() {
            return this.locale;
        }

        @NotNull
        public final BundleCacheKey copy(@NotNull String baseName, @NotNull Locale locale) {
            Intrinsics.checkNotNullParameter(baseName, "baseName");
            Intrinsics.checkNotNullParameter(locale, "locale");
            return new BundleCacheKey(baseName, locale);
        }

        public static /* synthetic */ BundleCacheKey copy$default(BundleCacheKey bundleCacheKey, String string, Locale locale, int n, Object object) {
            if ((n & 1) != 0) {
                string = bundleCacheKey.baseName;
            }
            if ((n & 2) != 0) {
                locale = bundleCacheKey.locale;
            }
            return bundleCacheKey.copy(string, locale);
        }

        @NotNull
        public String toString() {
            return "BundleCacheKey(baseName=" + this.baseName + ", locale=" + this.locale + ")";
        }

        public int hashCode() {
            int result2 = this.baseName.hashCode();
            result2 = result2 * 31 + this.locale.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BundleCacheKey)) {
                return false;
            }
            BundleCacheKey bundleCacheKey = (BundleCacheKey)other;
            if (!Intrinsics.areEqual(this.baseName, bundleCacheKey.baseName)) {
                return false;
            }
            return Intrinsics.areEqual(this.locale, bundleCacheKey.locale);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/plugin/structure/classes/resolvers/CacheResolver$Companion;", "", "()V", "DEFAULT_CACHE_SIZE", "", "structure-classes"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

