/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.base.decompress;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003J\u0018\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003H\u0002J\u0018\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u0003H\u0002J\b\u0010\u0010\u001a\u00020\bH\u0016J\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J*\u0010\u0015\u001a\u00020\b2\b\u0010\u0012\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/plugin/structure/base/decompress/ZipCompressor;", "Ljava/io/Closeable;", "outputFile", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "outStream", "Ljava/util/zip/ZipOutputStream;", "addDirectory", "", "directory", "addFile", "entryName", "", "file", "addRecursively", "prefix", "close", "writeDirectoryEntry", "name", "timestamp", "", "writeFileEntry", "source", "Ljava/io/InputStream;", "length", "structure-base"})
@SourceDebugExtension(value={"SMAP\nZipCompressor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZipCompressor.kt\ncom/jetbrains/plugin/structure/base/decompress/ZipCompressor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n1855#2,2:83\n1855#2,2:85\n*E\n*S KotlinDebug\n*F\n+ 1 ZipCompressor.kt\ncom/jetbrains/plugin/structure/base/decompress/ZipCompressor\n*L\n25#1,2:83\n46#1,2:85\n*E\n"})
public final class ZipCompressor
implements Closeable {
    @NotNull
    private final ZipOutputStream outStream;

    public ZipCompressor(@NotNull Path outputFile) {
        Intrinsics.checkNotNullParameter(outputFile, "outputFile");
        this.outStream = new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(outputFile, new OpenOption[0])));
    }

    public final void addDirectory(@NotNull Path directory) throws IOException {
        Intrinsics.checkNotNullParameter(directory, "directory");
        Iterable $this$forEach$iv = FileUtilKt.listFiles(directory);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Path child = (Path)element$iv;
            boolean bl = false;
            String name = FileUtilKt.getSimpleName(child);
            if (FileUtilKt.isDirectory(child)) {
                this.addRecursively(name, child);
                continue;
            }
            this.addFile(name, child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addFile(String entryName, Path file) {
        Closeable closeable = Files.newInputStream(file, new OpenOption[0]);
        Throwable throwable = null;
        try {
            InputStream source2 = (InputStream)closeable;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(source2, "source");
            this.writeFileEntry(entryName, source2, Files.size(file), Files.getLastModifiedTime(file, new LinkOption[0]).toMillis());
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    private final void addRecursively(String prefix, Path directory) {
        if (((CharSequence)prefix).length() > 0) {
            this.writeDirectoryEntry(prefix, Files.getLastModifiedTime(directory, new LinkOption[0]).toMillis());
        }
        List<Path> children = FileUtilKt.listFiles(directory);
        Iterable $this$forEach$iv = children;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String name;
            Path child = (Path)element$iv;
            boolean bl = false;
            String string = name = ((CharSequence)prefix).length() == 0 ? FileUtilKt.getSimpleName(child) : prefix + "/" + FileUtilKt.getSimpleName(child);
            if (FileUtilKt.isDirectory(child)) {
                this.addRecursively(name, child);
                continue;
            }
            this.addFile(name, child);
        }
    }

    private final void writeDirectoryEntry(String name, long timestamp) {
        ZipEntry e = new ZipEntry(name + "/");
        e.setMethod(0);
        e.setSize(0L);
        e.setCrc(0L);
        e.setTime(timestamp);
        this.outStream.putNextEntry(e);
        this.outStream.closeEntry();
    }

    private final void writeFileEntry(String name, InputStream source2, long length, long timestamp) {
        ZipEntry e = new ZipEntry(name);
        if (length == 0L) {
            e.setMethod(0);
            e.setSize(0L);
            e.setCrc(0L);
        }
        e.setTime(timestamp);
        this.outStream.putNextEntry(e);
        ByteStreamsKt.copyTo(source2, this.outStream, 4096);
        this.outStream.closeEntry();
    }

    @Override
    public void close() {
        this.outStream.close();
    }
}

