/*
 * Decompiled with CFR 0.152.
 */
package retrofit2;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public final class Invocation {
    private final Class<?> service;
    @Nullable
    private final Object instance;
    private final Method method;
    private final List<?> arguments;

    public static <T> Invocation of(Class<T> service, T instance, Method method, List<?> arguments2) {
        Objects.requireNonNull(service, "service == null");
        Objects.requireNonNull(instance, "instance == null");
        Objects.requireNonNull(method, "method == null");
        Objects.requireNonNull(arguments2, "arguments == null");
        return new Invocation(service, instance, method, new ArrayList(arguments2));
    }

    @Deprecated
    public static Invocation of(Method method, List<?> arguments2) {
        Objects.requireNonNull(method, "method == null");
        Objects.requireNonNull(arguments2, "arguments == null");
        return new Invocation(method.getDeclaringClass(), null, method, new ArrayList(arguments2));
    }

    Invocation(Class<?> service, @Nullable Object instance, Method method, List<?> arguments2) {
        this.service = service;
        this.instance = instance;
        this.method = method;
        this.arguments = Collections.unmodifiableList(arguments2);
    }

    public Class<?> service() {
        return this.service;
    }

    @Nullable
    public Object instance() {
        return this.instance;
    }

    public Method method() {
        return this.method;
    }

    public List<?> arguments() {
        return this.arguments;
    }

    public String toString() {
        return String.format("%s.%s() %s", this.service.getName(), this.method.getName(), this.arguments);
    }
}

