/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.results.problems;

import com.jetbrains.plugin.structure.base.utils.FormatUtilsKt;
import com.jetbrains.pluginverifier.results.location.ClassLocation;
import com.jetbrains.pluginverifier.results.modifiers.Modifiers;
import com.jetbrains.pluginverifier.results.problems.CompatibilityProblem;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0096\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u000f\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/pluginverifier/results/problems/SuperInterfaceBecameClassProblem;", "Lcom/jetbrains/pluginverifier/results/problems/CompatibilityProblem;", "child", "Lcom/jetbrains/pluginverifier/results/location/ClassLocation;", "clazz", "(Lcom/jetbrains/pluginverifier/results/location/ClassLocation;Lcom/jetbrains/pluginverifier/results/location/ClassLocation;)V", "getChild", "()Lcom/jetbrains/pluginverifier/results/location/ClassLocation;", "getClazz", "fullDescription", "", "getFullDescription", "()Ljava/lang/String;", "problemType", "getProblemType", "shortDescription", "getShortDescription", "equals", "", "other", "", "hashCode", "", "verifier-core"})
public final class SuperInterfaceBecameClassProblem
extends CompatibilityProblem {
    @NotNull
    private final ClassLocation child;
    @NotNull
    private final ClassLocation clazz;

    public SuperInterfaceBecameClassProblem(@NotNull ClassLocation child, @NotNull ClassLocation clazz) {
        Intrinsics.checkNotNullParameter(child, "child");
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        this.child = child;
        this.clazz = clazz;
    }

    @NotNull
    public final ClassLocation getChild() {
        return this.child;
    }

    @NotNull
    public final ClassLocation getClazz() {
        return this.clazz;
    }

    @Override
    @NotNull
    public String getProblemType() {
        return "Incompatible change of super interface to class";
    }

    @Override
    @NotNull
    public String getShortDescription() {
        Object[] objectArray = new Object[]{this.clazz};
        return FormatUtilsKt.formatMessage("Incompatible change of super interface {0} to class", objectArray);
    }

    @Override
    @NotNull
    public String getFullDescription() {
        String type2 = this.child.getModifiers().contains(Modifiers.Modifier.INTERFACE) ? "Interface" : "Class";
        Object[] objectArray = new Object[]{type2, this.child, this.clazz};
        return FormatUtilsKt.formatMessage("{0} {1} has a *super interface* {2} which is actually a *class*. This can lead to **IncompatibleClassChangeError** exception at runtime.", objectArray);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof SuperInterfaceBecameClassProblem && Intrinsics.areEqual(this.child, ((SuperInterfaceBecameClassProblem)other).child) && Intrinsics.areEqual(this.clazz, ((SuperInterfaceBecameClassProblem)other).clazz);
    }

    @Override
    public int hashCode() {
        Object[] objectArray = new Object[]{this.child, this.clazz};
        return Objects.hash(objectArray);
    }
}

