/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.classes.locator;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.classes.resolvers.FileOrigin;
import com.jetbrains.plugin.structure.classes.resolvers.JarFileResolverKt;
import com.jetbrains.plugin.structure.classes.resolvers.Resolver;
import com.jetbrains.plugin.structure.intellij.classes.locator.ClassesLocator;
import com.jetbrains.plugin.structure.intellij.classes.locator.FileOriginProvider;
import com.jetbrains.plugin.structure.intellij.classes.locator.LibModulesDirectoryKey;
import com.jetbrains.plugin.structure.intellij.classes.locator.LibModulesDirectoryOriginProvider;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/plugin/structure/intellij/classes/locator/LibModulesDirectoryLocator;", "Lcom/jetbrains/plugin/structure/intellij/classes/locator/ClassesLocator;", "readMode", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver$ReadMode;", "fileOriginProvider", "Lcom/jetbrains/plugin/structure/intellij/classes/locator/FileOriginProvider;", "(Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver$ReadMode;Lcom/jetbrains/plugin/structure/intellij/classes/locator/FileOriginProvider;)V", "locationKey", "Lcom/jetbrains/plugin/structure/intellij/classes/locator/LibModulesDirectoryKey;", "getLocationKey", "()Lcom/jetbrains/plugin/structure/intellij/classes/locator/LibModulesDirectoryKey;", "findClasses", "", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver;", "idePlugin", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;", "pluginFile", "Ljava/nio/file/Path;", "structure-intellij-classes"})
public final class LibModulesDirectoryLocator
implements ClassesLocator {
    @NotNull
    private final Resolver.ReadMode readMode;
    @NotNull
    private final FileOriginProvider fileOriginProvider;
    @NotNull
    private final LibModulesDirectoryKey locationKey;

    public LibModulesDirectoryLocator(@NotNull Resolver.ReadMode readMode, @NotNull FileOriginProvider fileOriginProvider) {
        Intrinsics.checkNotNullParameter((Object)readMode, "readMode");
        Intrinsics.checkNotNullParameter(fileOriginProvider, "fileOriginProvider");
        this.readMode = readMode;
        this.fileOriginProvider = fileOriginProvider;
        this.locationKey = LibModulesDirectoryKey.INSTANCE;
    }

    public /* synthetic */ LibModulesDirectoryLocator(Resolver.ReadMode readMode, FileOriginProvider fileOriginProvider, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 2) != 0) {
            fileOriginProvider = LibModulesDirectoryOriginProvider.INSTANCE;
        }
        this(readMode, fileOriginProvider);
    }

    @Override
    @NotNull
    public LibModulesDirectoryKey getLocationKey() {
        return this.locationKey;
    }

    @Override
    @NotNull
    public List<Resolver> findClasses(@NotNull IdePlugin idePlugin, @NotNull Path pluginFile) {
        Intrinsics.checkNotNullParameter(idePlugin, "idePlugin");
        Intrinsics.checkNotNullParameter(pluginFile, "pluginFile");
        Path modulesDir = pluginFile.resolve("lib").resolve("modules");
        Intrinsics.checkNotNullExpressionValue(modulesDir, "modulesDir");
        if (!FileUtilKt.isDirectory(modulesDir)) {
            return CollectionsKt.emptyList();
        }
        FileOrigin origin = this.fileOriginProvider.getFileOrigin(idePlugin, pluginFile);
        List<Path> jarsOrZips = FileUtilKt.listJars(modulesDir);
        return JarFileResolverKt.buildJarOrZipFileResolvers((Iterable<? extends Path>)jarsOrZips, this.readMode, origin);
    }
}

