/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.analysis;

import com.jetbrains.plugin.structure.ide.Ide;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.version.IdeVersion;
import com.jetbrains.pluginverifier.analysis.CompatibilityProblemChangeList;
import com.jetbrains.pluginverifier.analysis.ExtractedJsonPluginAnalyzerKt;
import com.jetbrains.pluginverifier.results.problems.ClassNotFoundProblem;
import com.jetbrains.pluginverifier.results.problems.CompatibilityProblem;
import com.jetbrains.pluginverifier.results.problems.UndeclaredPluginDependencyProblem;
import com.jetbrains.pluginverifier.verifiers.resolution.MethodsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J\u0014\u0010\u0016\u001a\u00020\u00142\n\u0010\u0017\u001a\u00060\u0005j\u0002`\u0018H\u0002J\u0014\u0010\u0019\u001a\u00020\u00142\n\u0010\u0017\u001a\u00060\u0005j\u0002`\u0018H\u0002J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\nH\u0002J\u0014\u0010\u001b\u001a\u00020\u001c2\n\u0010\u0017\u001a\u00060\u0005j\u0002`\u0018H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/pluginverifier/analysis/ExtractedJsonPluginAnalyzer;", "", "()V", "removedClasses", "", "", "removedPackages", "analyze", "Lcom/jetbrains/pluginverifier/analysis/CompatibilityProblemChangeList;", "ide", "Lcom/jetbrains/plugin/structure/ide/Ide;", "plugin", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;", "compatibilityProblems", "", "Lcom/jetbrains/pluginverifier/results/problems/CompatibilityProblem;", "getRemovedPackage", "Lcom/jetbrains/pluginverifier/analysis/ExtractedJsonPluginAnalyzer$Package;", "pkg", "isAtLeastVersion", "", "expectedVersion", "isRemovedClass", "className", "Lcom/jetbrains/pluginverifier/verifiers/resolution/BinaryClassName;", "isRemovedPackage", "supports", "undeclaredPluginDependency", "Lcom/jetbrains/pluginverifier/results/problems/UndeclaredPluginDependencyProblem;", "Package", "verifier-intellij"})
@SourceDebugExtension(value={"SMAP\nExtractedJsonPluginAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtractedJsonPluginAnalyzer.kt\ncom/jetbrains/pluginverifier/analysis/ExtractedJsonPluginAnalyzer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,134:1\n800#2,11:135\n1855#2,2:146\n288#2,2:148\n*S KotlinDebug\n*F\n+ 1 ExtractedJsonPluginAnalyzer.kt\ncom/jetbrains/pluginverifier/analysis/ExtractedJsonPluginAnalyzer\n*L\n47#1:135,11\n48#1:146,2\n72#1:148,2\n*E\n"})
public final class ExtractedJsonPluginAnalyzer {
    @NotNull
    private final List<String> removedPackages;
    @NotNull
    private final List<String> removedClasses;

    public ExtractedJsonPluginAnalyzer() {
        String[] stringArray = new String[]{"com.intellij.json", "com.intellij.json.codeinsight", "com.intellij.json.highlighting", "com.intellij.json.psi", "com.jetbrains.jsonSchema"};
        this.removedPackages = CollectionsKt.listOf(stringArray);
        stringArray = new String[]{"com.intellij.json.JsonElementTypes", "com.intellij.json.JsonFileType", "com.intellij.json.JsonLanguage", "com.intellij.json.JsonParserDefinition", "com.intellij.json.JsonTokenType"};
        this.removedClasses = CollectionsKt.listOf(stringArray);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CompatibilityProblemChangeList analyze(@NotNull Ide ide2, @NotNull IdePlugin plugin, @NotNull Collection<? extends CompatibilityProblem> compatibilityProblems) {
        CompatibilityProblemChangeList compatibilityProblemChangeList;
        Intrinsics.checkNotNullParameter(ide2, "ide");
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(compatibilityProblems, "compatibilityProblems");
        if (!this.supports(ide2)) {
            compatibilityProblemChangeList = new CompatibilityProblemChangeList();
        } else {
            void $this$forEach$iv;
            void $this$filterIsInstanceTo$iv$iv;
            CompatibilityProblemChangeList compatibilityProblemChangeList2;
            CompatibilityProblemChangeList problems = compatibilityProblemChangeList2 = new CompatibilityProblemChangeList();
            boolean bl = false;
            Iterable $this$filterIsInstance$iv = compatibilityProblems;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof ClassNotFoundProblem)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ClassNotFoundProblem problem = (ClassNotFoundProblem)element$iv;
                boolean bl2 = false;
                String className = problem.getUnresolved().getClassName();
                if (!this.isRemovedClass(className) && !this.isRemovedPackage(className)) continue;
                problems.plusAssign(this.undeclaredPluginDependency(className));
                problems.minusAssign(problem);
            }
            compatibilityProblemChangeList = compatibilityProblemChangeList2;
        }
        return compatibilityProblemChangeList;
    }

    private final boolean supports(Ide ide2) {
        return this.isAtLeastVersion(ide2, "243");
    }

    private final boolean isRemovedClass(String className) {
        return this.removedClasses.contains(MethodsKt.toFullyQualifiedClassName(className));
    }

    private final boolean isRemovedPackage(String className) {
        Package pkg = Package.Companion.of(className);
        Package removedPkg = this.getRemovedPackage(pkg);
        return removedPkg != null;
    }

    private final Package getRemovedPackage(Package pkg) {
        Package package_;
        Object v0;
        block3: {
            Iterable $this$firstOrNull$iv = this.removedPackages;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it, pkg.getName())) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        String removedPackage = v0;
        if (removedPackage != null) {
            package_ = new Package(removedPackage);
        } else {
            Package it = pkg.getParent();
            boolean bl = false;
            package_ = Intrinsics.areEqual(it, Package.Companion.getROOT()) ? null : this.getRemovedPackage(it);
        }
        return package_;
    }

    private final UndeclaredPluginDependencyProblem undeclaredPluginDependency(String className) {
        return new UndeclaredPluginDependencyProblem("com.intellij.modules.json", new UndeclaredPluginDependencyProblem.ApiElement.Class(MethodsKt.toFullyQualifiedClassName(className)), "JSON support has been extracted to a separate plugin.");
    }

    private final boolean isAtLeastVersion(Ide ide2, String expectedVersion) {
        return ide2.getVersion().compareTo(IdeVersion.createIdeVersion(expectedVersion)) > 0;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/pluginverifier/analysis/ExtractedJsonPluginAnalyzer$Package;", "", "name", "", "(Ljava/lang/String;)V", "elements", "", "getName", "()Ljava/lang/String;", "parent", "getParent", "()Lcom/jetbrains/pluginverifier/analysis/ExtractedJsonPluginAnalyzer$Package;", "equals", "", "other", "hashCode", "", "Companion", "verifier-intellij"})
    public static final class Package {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String name;
        @NotNull
        private final List<String> elements;
        @NotNull
        private static final Package ROOT = new Package("");

        public Package(@NotNull String name) {
            Intrinsics.checkNotNullParameter(name, "name");
            this.name = name;
            String[] stringArray = new String[]{"."};
            this.elements = StringsKt.split$default((CharSequence)this.name, stringArray, false, 0, 6, null);
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final Package getParent() {
            List<String> parentElements = CollectionsKt.dropLast(this.elements, 1);
            return parentElements.isEmpty() ? ROOT : new Package(CollectionsKt.joinToString$default(parentElements, ".", null, null, 0, null, null, 62, null));
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Intrinsics.checkNotNull(other, "null cannot be cast to non-null type com.jetbrains.pluginverifier.analysis.ExtractedJsonPluginAnalyzer.Package");
            Package cfr_ignored_0 = (Package)other;
            return Intrinsics.areEqual(this.name, ((Package)other).name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u00020\u00042\n\u0010\b\u001a\u00060\tj\u0002`\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/pluginverifier/analysis/ExtractedJsonPluginAnalyzer$Package$Companion;", "", "()V", "ROOT", "Lcom/jetbrains/pluginverifier/analysis/ExtractedJsonPluginAnalyzer$Package;", "getROOT", "()Lcom/jetbrains/pluginverifier/analysis/ExtractedJsonPluginAnalyzer$Package;", "of", "className", "", "Lcom/jetbrains/pluginverifier/verifiers/resolution/BinaryClassName;", "verifier-intellij"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Package getROOT() {
                return ROOT;
            }

            @NotNull
            public final Package of(@NotNull String className) {
                Intrinsics.checkNotNullParameter(className, "className");
                return new Package(MethodsKt.toFullyQualifiedClassName(ExtractedJsonPluginAnalyzerKt.access$getPackageName(className)));
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

