/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.classes.resolvers;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.base.utils.LanguageUtilsKt;
import com.jetbrains.plugin.structure.classes.resolvers.FileOrigin;
import com.jetbrains.plugin.structure.classes.resolvers.InvalidClassFileException;
import com.jetbrains.plugin.structure.classes.resolvers.ResolutionResult;
import com.jetbrains.plugin.structure.classes.resolvers.Resolver;
import com.jetbrains.plugin.structure.classes.resolvers.ResourceBundleNameSet;
import com.jetbrains.plugin.structure.classes.utils.AsmUtil;
import com.jetbrains.plugin.structure.classes.utils.PropertyBundleUtilsKt;
import com.jetbrains.plugin.structure.jar.Packages;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.ClassNode;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010(\u001a\u00020)H\u0016J\u0014\u0010*\u001a\u00020+2\n\u0010,\u001a\u00060\u000fj\u0002`\u0010H\u0016J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0015H\u0017J\u0010\u0010-\u001a\u00020+2\u0006\u0010.\u001a\u00020\u0015H\u0016J\u001a\u0010/\u001a\u0004\u0018\u00010\u00032\u0006\u00100\u001a\u00020\u00032\u0006\u0010,\u001a\u00020\u0015H\u0002J\"\u00101\u001a\u00020+2\u0018\u00102\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020504\u0012\u0004\u0012\u00020+03H\u0016J\u001e\u00106\u001a\b\u0012\u0004\u0012\u000205042\u0006\u0010,\u001a\u00020\u00152\u0006\u00100\u001a\u00020\u0003H\u0002J\u001a\u00107\u001a\b\u0012\u0004\u0012\u000205042\n\u0010,\u001a\u00060\u000fj\u0002`\u0010H\u0016J\u0016\u00107\u001a\b\u0012\u0004\u0012\u000205042\u0006\u0010,\u001a\u00020\u0015H\u0017J\u001e\u00108\u001a\b\u0012\u0004\u0012\u000209042\u0006\u0010:\u001a\u00020\u00152\u0006\u0010;\u001a\u00020<H\u0016J\b\u0010=\u001a\u00020\u0015H\u0016R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\r\u001a\f\u0012\b\u0012\u00060\u000fj\u0002`\u00100\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R \u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00148VX\u0097\u0004\u00a2\u0006\f\u0012\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0012R$\u0010\u0019\u001a\f\u0012\b\u0012\u00060\u0015j\u0002`\u001a0\u000e8VX\u0097\u0004\u00a2\u0006\f\u0012\u0004\b\u001b\u0010\u0017\u001a\u0004\b\u001c\u0010\u0012R6\u0010\u001d\u001a*\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u001ej\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u0014`\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010 \u001a\u001e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00030\u001ej\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0003`\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010!\u001a\u001e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00030\u001ej\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0003`\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00150\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0012R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/jetbrains/plugin/structure/classes/resolvers/DirectoryResolver;", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver;", "root", "Ljava/nio/file/Path;", "fileOrigin", "Lcom/jetbrains/plugin/structure/classes/resolvers/FileOrigin;", "readMode", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver$ReadMode;", "(Ljava/nio/file/Path;Lcom/jetbrains/plugin/structure/classes/resolvers/FileOrigin;Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver$ReadMode;)V", "allBundleNameSet", "Lcom/jetbrains/plugin/structure/classes/resolvers/ResourceBundleNameSet;", "getAllBundleNameSet", "()Lcom/jetbrains/plugin/structure/classes/resolvers/ResourceBundleNameSet;", "allClassNames", "", "", "Lcom/jetbrains/plugin/structure/base/BinaryClassName;", "getAllClassNames", "()Ljava/util/Set;", "allClasses", "", "", "getAllClasses$annotations", "()V", "getAllClasses", "allPackages", "Lcom/jetbrains/plugin/structure/jar/BinaryPackageName;", "getAllPackages$annotations", "getAllPackages", "bundleNames", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "bundlePathToFile", "classNameToFile", "packageSet", "Lcom/jetbrains/plugin/structure/jar/Packages;", "packages", "getPackages", "getReadMode", "()Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver$ReadMode;", "close", "", "containsClass", "", "className", "containsPackage", "packageName", "getClassRoot", "classFile", "processAllClasses", "processor", "Lkotlin/Function1;", "Lcom/jetbrains/plugin/structure/classes/resolvers/ResolutionResult;", "Lorg/objectweb/asm/tree/ClassNode;", "readClass", "resolveClass", "resolveExactPropertyResourceBundle", "Ljava/util/PropertyResourceBundle;", "baseName", "locale", "Ljava/util/Locale;", "toString", "structure-classes"})
@SourceDebugExtension(value={"SMAP\nDirectoryResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DirectoryResolver.kt\ncom/jetbrains/plugin/structure/classes/resolvers/DirectoryResolver\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,157:1\n1099#2,3:158\n*E\n*S KotlinDebug\n*F\n+ 1 DirectoryResolver.kt\ncom/jetbrains/plugin/structure/classes/resolvers/DirectoryResolver\n*L\n58#1,3:158\n*E\n"})
public final class DirectoryResolver
extends Resolver {
    @NotNull
    private final Path root;
    @NotNull
    private final FileOrigin fileOrigin;
    @NotNull
    private final Resolver.ReadMode readMode;
    @NotNull
    private final HashMap<String, Path> classNameToFile;
    @NotNull
    private final HashMap<String, Path> bundlePathToFile;
    @NotNull
    private final HashMap<String, Set<String>> bundleNames;
    @NotNull
    private final Packages packageSet;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DirectoryResolver(@NotNull Path root, @NotNull FileOrigin fileOrigin, @NotNull Resolver.ReadMode readMode) {
        Intrinsics.checkNotNullParameter(root, "root");
        Intrinsics.checkNotNullParameter(fileOrigin, "fileOrigin");
        Intrinsics.checkNotNullParameter((Object)readMode, "readMode");
        this.root = root;
        this.fileOrigin = fileOrigin;
        this.readMode = readMode;
        this.classNameToFile = new HashMap();
        this.bundlePathToFile = new HashMap();
        this.bundleNames = new HashMap();
        this.packageSet = new Packages();
        AutoCloseable autoCloseable = Files.walk(this.root, new FileVisitOption[0]);
        Throwable throwable = null;
        try {
            Stream fileStream = (Stream)autoCloseable;
            boolean bl = false;
            Function1 function1 = new Function1<Path, Unit>(this){
                final /* synthetic */ DirectoryResolver this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(Path file) {
                    Intrinsics.checkNotNullExpressionValue(file, "file");
                    if (Intrinsics.areEqual(FileUtilKt.getExtension(file), "class")) {
                        String string = AsmUtil.readClassName(file);
                        Intrinsics.checkNotNullExpressionValue(string, "readClassName(file)");
                        String className = string;
                        Path classRoot = DirectoryResolver.access$getClassRoot(this.this$0, file, className);
                        if (classRoot != null) {
                            ((Map)DirectoryResolver.access$getClassNameToFile$p(this.this$0)).put(className, file);
                            DirectoryResolver.access$getPackageSet$p(this.this$0).addClass(className);
                        }
                    }
                    if (Intrinsics.areEqual(FileUtilKt.getExtension(file), "properties")) {
                        Object object;
                        void $this$getOrPut$iv;
                        String bundlePath = FileUtilKt.toSystemIndependentName(((Object)DirectoryResolver.access$getRoot$p(this.this$0).relativize(file)).toString());
                        ((Map)DirectoryResolver.access$getBundlePathToFile$p(this.this$0)).put(bundlePath, file);
                        String fullBundleName = PropertyBundleUtilsKt.getBundleNameByBundlePath(bundlePath);
                        Map map = DirectoryResolver.access$getBundleNames$p(this.this$0);
                        String key$iv = PropertyBundleUtilsKt.getBundleBaseName(fullBundleName);
                        boolean $i$f$getOrPut = false;
                        V value$iv = $this$getOrPut$iv.get(key$iv);
                        if (value$iv == null) {
                            boolean bl = false;
                            Set answer$iv = new HashSet<E>();
                            $this$getOrPut$iv.put(key$iv, answer$iv);
                            object = answer$iv;
                        } else {
                            object = value$iv;
                        }
                        ((Collection)object).add(fullBundleName);
                    }
                }
            };
            fileStream.forEach(new Consumer(function1){
                private final /* synthetic */ Function1 function;
                {
                    Intrinsics.checkNotNullParameter(function, "function");
                    this.function = function;
                }

                public final /* synthetic */ void accept(Object p0) {
                    this.function.invoke(p0);
                }
            });
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    public /* synthetic */ DirectoryResolver(Path path, FileOrigin fileOrigin, Resolver.ReadMode readMode, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 4) != 0) {
            readMode = Resolver.ReadMode.FULL;
        }
        this(path, fileOrigin, readMode);
    }

    @Override
    @NotNull
    public Resolver.ReadMode getReadMode() {
        return this.readMode;
    }

    private final Path getClassRoot(Path classFile, String className) {
        CharSequence $this$count$iv = className;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (int i = 0; i < $this$count$iv.length(); ++i) {
            char element$iv;
            char it = element$iv = $this$count$iv.charAt(i);
            boolean bl = false;
            if (!(it == '/')) continue;
            ++count$iv;
        }
        int levelsUp = count$iv;
        Path root = classFile;
        int n = levelsUp + 1;
        for (int i = 0; i < n; ++i) {
            Path path = root;
            root = path != null ? path.getParent() : null;
        }
        return root;
    }

    @Override
    @Deprecated(message="Use 'resolveClass(BinaryClassName)' instead")
    @NotNull
    public ResolutionResult<ClassNode> resolveClass(@NotNull String className) {
        Intrinsics.checkNotNullParameter(className, "className");
        Path path = this.classNameToFile.get(className);
        if (path == null) {
            return ResolutionResult.NotFound.INSTANCE;
        }
        Path classFile = path;
        return this.readClass(className, classFile);
    }

    @Override
    @NotNull
    public ResolutionResult<ClassNode> resolveClass(@NotNull CharSequence className) {
        Intrinsics.checkNotNullParameter(className, "className");
        return this.resolveClass(((Object)className).toString());
    }

    private final ResolutionResult<ClassNode> readClass(String className, Path classFile) {
        ResolutionResult resolutionResult;
        try {
            ClassNode classNode = AsmUtil.readClassFromFile(className, classFile, this.getReadMode() == Resolver.ReadMode.FULL);
            Intrinsics.checkNotNullExpressionValue(classNode, "readClassFromFile(classN\u2026eadMode == ReadMode.FULL)");
            ClassNode classNode2 = classNode;
            resolutionResult = new ResolutionResult.Found<ClassNode>(classNode2, this.fileOrigin);
        }
        catch (InvalidClassFileException e) {
            resolutionResult = new ResolutionResult.Invalid(e.getMessage());
        }
        catch (Exception e) {
            LanguageUtilsKt.rethrowIfInterrupted(e);
            String string = e.getMessage();
            if (string == null) {
                string = e.getClass().getName();
            }
            Intrinsics.checkNotNullExpressionValue(string, "e.message ?: e.javaClass.name");
            resolutionResult = new ResolutionResult.FailedToRead(string);
        }
        return resolutionResult;
    }

    @Override
    @NotNull
    public ResolutionResult<PropertyResourceBundle> resolveExactPropertyResourceBundle(@NotNull String baseName, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter(baseName, "baseName");
        Intrinsics.checkNotNullParameter(locale, "locale");
        ResourceBundle.Control control = ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_PROPERTIES);
        String bundleName = control.toBundleName(baseName, locale);
        String bundlePath = control.toResourceName(bundleName, "properties");
        Path bundleFile = this.bundlePathToFile.get(bundlePath);
        if (bundleFile != null) {
            Object object;
            try {
                InputStream inputStream2 = Files.newInputStream(bundleFile, new OpenOption[0]);
                Intrinsics.checkNotNullExpressionValue(inputStream2, "newInputStream(bundleFile)");
                object = inputStream2;
                Charset charset = Charsets.UTF_8;
                Reader reader = new InputStreamReader((InputStream)object, charset);
                int n = 8192;
                object = new PropertyResourceBundle(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n));
            }
            catch (IllegalArgumentException e) {
                String string = e.getMessage();
                if (string == null) {
                    string = e.getClass().getName();
                }
                Intrinsics.checkNotNullExpressionValue(string, "e.message ?: e.javaClass.name");
                return new ResolutionResult.Invalid(string);
            }
            catch (Exception e) {
                String string = e.getMessage();
                if (string == null) {
                    string = e.getClass().getName();
                }
                Intrinsics.checkNotNullExpressionValue(string, "e.message ?: e.javaClass.name");
                return new ResolutionResult.FailedToRead(string);
            }
            Object propertyResourceBundle = object;
            return new ResolutionResult.Found<Object>(propertyResourceBundle, this.fileOrigin);
        }
        return ResolutionResult.NotFound.INSTANCE;
    }

    @Override
    @NotNull
    public Set<String> getAllPackages() {
        return this.packageSet.getAll();
    }

    @Deprecated(message="Use 'packages' property instead. This property may be slow on some file systems.")
    public static /* synthetic */ void getAllPackages$annotations() {
    }

    @Override
    @NotNull
    public Set<String> getPackages() {
        return this.packageSet.getEntries();
    }

    @Override
    @NotNull
    public ResourceBundleNameSet getAllBundleNameSet() {
        return new ResourceBundleNameSet((Map<String, ? extends Set<String>>)this.bundleNames);
    }

    @Override
    @NotNull
    public Set<String> getAllClasses() {
        Set<String> set = this.classNameToFile.keySet();
        Intrinsics.checkNotNullExpressionValue(set, "classNameToFile.keys");
        return set;
    }

    @Deprecated(message="Use 'allClassNames' property instead which is more efficient")
    public static /* synthetic */ void getAllClasses$annotations() {
    }

    @Override
    @NotNull
    public Set<CharSequence> getAllClassNames() {
        return this.getAllClasses();
    }

    @Override
    @Deprecated(message="Use 'containsClass(BinaryClassName)' instead")
    public boolean containsClass(@NotNull String className) {
        Intrinsics.checkNotNullParameter(className, "className");
        return ((Map)this.classNameToFile).containsKey(className);
    }

    @Override
    public boolean containsClass(@NotNull CharSequence className) {
        Intrinsics.checkNotNullParameter(className, "className");
        return this.containsClass(((Object)className).toString());
    }

    @Override
    public boolean containsPackage(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter(packageName, "packageName");
        return this.packageSet.contains(packageName);
    }

    @Override
    public void close() {
    }

    @Override
    public boolean processAllClasses(@NotNull Function1<? super ResolutionResult<? extends ClassNode>, Boolean> processor) {
        Intrinsics.checkNotNullParameter(processor, "processor");
        for (Map.Entry entry : ((Map)this.classNameToFile).entrySet()) {
            Path classFile;
            String className = (String)entry.getKey();
            ResolutionResult<ClassNode> result2 = this.readClass(className, classFile = (Path)entry.getValue());
            if (processor.invoke(result2).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public String toString() {
        return ((Object)this.root.toAbsolutePath()).toString();
    }

    public static final /* synthetic */ Path access$getClassRoot(DirectoryResolver $this, Path classFile, String className) {
        return $this.getClassRoot(classFile, className);
    }

    public static final /* synthetic */ HashMap access$getClassNameToFile$p(DirectoryResolver $this) {
        return $this.classNameToFile;
    }

    public static final /* synthetic */ Packages access$getPackageSet$p(DirectoryResolver $this) {
        return $this.packageSet;
    }

    public static final /* synthetic */ Path access$getRoot$p(DirectoryResolver $this) {
        return $this.root;
    }

    public static final /* synthetic */ HashMap access$getBundlePathToFile$p(DirectoryResolver $this) {
        return $this.bundlePathToFile;
    }

    public static final /* synthetic */ HashMap access$getBundleNames$p(DirectoryResolver $this) {
        return $this.bundleNames;
    }
}

