/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.base.utils.trie;

import com.jetbrains.plugin.structure.base.utils.trie.Trie;
import com.jetbrains.plugin.structure.base.utils.trie.TrieTraversals;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\f\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u0007J\u0016\u0010\b\u001a\u00020\t\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u0007J\u0016\u0010\n\u001a\u00020\t\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u0007J#\u0010\u000b\u001a\u00020\t\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u00072\u0006\u0010\f\u001a\u0002H\u0006\u00a2\u0006\u0002\u0010\rJ$\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u00072\u0006\u0010\u000f\u001a\u00020\u0010J\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u0007J+\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u00072\b\u0010\f\u001a\u0004\u0018\u0001H\u0006\u00a2\u0006\u0002\u0010\u0013\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/plugin/structure/base/utils/trie/TrieTraversals;", "", "()V", "getInsertions", "", "", "V", "Lcom/jetbrains/plugin/structure/base/utils/trie/Trie;", "leafCount", "", "nodeCount", "valueCount", "expectedValue", "(Lcom/jetbrains/plugin/structure/base/utils/trie/Trie;Ljava/lang/Object;)I", "withDelimiter", "delimiter", "", "withNonNullValues", "withValue", "(Lcom/jetbrains/plugin/structure/base/utils/trie/Trie;Ljava/lang/Object;)Ljava/util/Set;", "Leaves", "structure-base"})
public final class TrieTraversals {
    @NotNull
    public static final TrieTraversals INSTANCE = new TrieTraversals();

    private TrieTraversals() {
    }

    public final <V> int leafCount(@NotNull Trie<V> $this$leafCount) {
        Intrinsics.checkNotNullParameter($this$leafCount, "<this>");
        return CollectionsKt.sumOfInt($this$leafCount.visit(leafCount.1.INSTANCE));
    }

    public final <V> int nodeCount(@NotNull Trie<V> $this$nodeCount) {
        Intrinsics.checkNotNullParameter($this$nodeCount, "<this>");
        return CollectionsKt.sumOfInt($this$nodeCount.visit(nodeCount.1.INSTANCE));
    }

    public final <V> int valueCount(@NotNull Trie<V> $this$valueCount, V expectedValue) {
        Intrinsics.checkNotNullParameter($this$valueCount, "<this>");
        return CollectionsKt.sumOfInt($this$valueCount.visit(new Trie.NodeVisitor(expectedValue){
            final /* synthetic */ V $expectedValue;
            {
                this.$expectedValue = $expectedValue;
            }

            @NotNull
            public final Integer visit(@NotNull Trie.NodeVisitor.NodeVisit<V> nodeVisit) {
                Intrinsics.checkNotNullParameter(nodeVisit, "<name for destructuring parameter 0>");
                V value = nodeVisit.component2();
                return Intrinsics.areEqual(this.$expectedValue, value) ? 1 : 0;
            }
        }));
    }

    @NotNull
    public final <V> Set<String> withNonNullValues(@NotNull Trie<V> $this$withNonNullValues) {
        Intrinsics.checkNotNullParameter($this$withNonNullValues, "<this>");
        return (Set)CollectionsKt.filterNotNullTo($this$withNonNullValues.visit(withNonNullValues.1.INSTANCE), (Collection)new LinkedHashSet());
    }

    @NotNull
    public final <V> Set<String> withValue(@NotNull Trie<V> $this$withValue, @Nullable V expectedValue) {
        Intrinsics.checkNotNullParameter($this$withValue, "<this>");
        return (Set)CollectionsKt.filterNotNullTo($this$withValue.visit(new Trie.NodeVisitor(expectedValue){
            final /* synthetic */ V $expectedValue;
            {
                this.$expectedValue = $expectedValue;
            }

            @Nullable
            public final String visit(@NotNull Trie.NodeVisitor.NodeVisit<V> nodeVisit) {
                Intrinsics.checkNotNullParameter(nodeVisit, "<name for destructuring parameter 0>");
                CharSequence prefix = nodeVisit.component1();
                V value = nodeVisit.component2();
                CharSequence charSequence = prefix;
                V v = this.$expectedValue;
                CharSequence it = charSequence;
                boolean bl = false;
                CharSequence charSequence2 = Intrinsics.areEqual(value, v) ? charSequence : null;
                return charSequence2 != null ? ((Object)charSequence2).toString() : null;
            }
        }), (Collection)new LinkedHashSet());
    }

    @NotNull
    public final <V> Set<String> getInsertions(@NotNull Trie<V> $this$getInsertions) {
        Set set;
        Intrinsics.checkNotNullParameter($this$getInsertions, "<this>");
        Set $this$getInsertions_u24lambda_u240 = set = (Set)new LinkedHashSet();
        boolean bl = false;
        $this$getInsertions.visit(new Trie.NodeVisitor($this$getInsertions_u24lambda_u240){
            final /* synthetic */ Set<String> $this_apply;
            {
                this.$this_apply = $receiver;
            }

            public final void visit(@NotNull Trie.NodeVisitor.NodeVisit<V> nodeVisit) {
                Intrinsics.checkNotNullParameter(nodeVisit, "<name for destructuring parameter 0>");
                CharSequence prefix = nodeVisit.component1();
                boolean isTerminal = nodeVisit.component4();
                if (isTerminal) {
                    this.$this_apply.add(((Object)prefix).toString());
                }
            }
        });
        return set;
    }

    @NotNull
    public final <V> Set<String> withDelimiter(@NotNull Trie<V> $this$withDelimiter, char delimiter) {
        Set set;
        Intrinsics.checkNotNullParameter($this$withDelimiter, "<this>");
        Set $this$withDelimiter_u24lambda_u241 = set = (Set)new LinkedHashSet();
        boolean bl = false;
        $this$withDelimiter.visit(new Trie.NodeVisitor($this$withDelimiter_u24lambda_u241, delimiter){
            final /* synthetic */ Set<String> $this_apply;
            final /* synthetic */ char $delimiter;
            {
                this.$this_apply = $receiver;
                this.$delimiter = $delimiter;
            }

            @Nullable
            public final V visit(@NotNull Trie.NodeVisitor.NodeVisit<V> nodeVisit) {
                Intrinsics.checkNotNullParameter(nodeVisit, "<name for destructuring parameter 0>");
                CharSequence prefix = nodeVisit.component1();
                V value = nodeVisit.component2();
                boolean isTerminal = nodeVisit.component4();
                if (isTerminal) {
                    this.$this_apply.add(((Object)prefix).toString());
                } else if (prefix.length() > 0 && StringsKt.last(prefix) == this.$delimiter) {
                    this.$this_apply.add(((Object)prefix.subSequence(0, StringsKt.getLastIndex(prefix))).toString());
                }
                return value;
            }
        });
        return set;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\r\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00030\u0002B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\n\u001a\u00020\u00032\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\fH\u0016R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\r"}, d2={"Lcom/jetbrains/plugin/structure/base/utils/trie/TrieTraversals$Leaves;", "V", "Lcom/jetbrains/plugin/structure/base/utils/trie/Trie$NodeVisitor;", "", "()V", "result", "", "", "getResult", "()Ljava/util/Set;", "visit", "n", "Lcom/jetbrains/plugin/structure/base/utils/trie/Trie$NodeVisitor$NodeVisit;", "structure-base"})
    public static final class Leaves<V>
    implements Trie.NodeVisitor<V, Unit> {
        @NotNull
        private final Set<CharSequence> result = new LinkedHashSet();

        @NotNull
        public final Set<CharSequence> getResult() {
            return this.result;
        }

        @Override
        public void visit(@NotNull Trie.NodeVisitor.NodeVisit<V> n) {
            Intrinsics.checkNotNullParameter(n, "n");
            if (n.isLeaf()) {
                ((Collection)this.result).add(((Object)n.getWord()).toString());
            }
        }
    }
}

