/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.base.utils.contentBuilder;

import com.jetbrains.plugin.structure.base.utils.contentBuilder.ContentBuilder;
import com.jetbrains.plugin.structure.base.utils.contentBuilder.ContentBuilderImpl;
import com.jetbrains.plugin.structure.base.utils.contentBuilder.ContentSpec;
import com.jetbrains.plugin.structure.base.utils.contentBuilder.DirectorySpec;
import com.jetbrains.plugin.structure.base.utils.contentBuilder.ZipSpec;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a'\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0017\u0010\u0003\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\b\u0007\u001a\u001f\u0010\b\u001a\u00020\t2\u0017\u0010\u0003\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\b\u0007\u001a'\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00012\u0017\u0010\u0003\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\b\u0007\u001a\u001f\u0010\f\u001a\u00020\t2\u0017\u0010\u0003\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\b\u0007\u00a8\u0006\r"}, d2={"buildDirectory", "Ljava/nio/file/Path;", "directory", "content", "Lkotlin/Function1;", "Lcom/jetbrains/plugin/structure/base/utils/contentBuilder/ContentBuilder;", "", "Lkotlin/ExtensionFunctionType;", "buildDirectoryContent", "Lcom/jetbrains/plugin/structure/base/utils/contentBuilder/ContentSpec;", "buildZipFile", "zipFile", "buildZipFileContent", "structure-base"})
public final class ContentBuilderKt {
    @NotNull
    public static final Path buildDirectory(@NotNull Path directory, @NotNull Function1<? super ContentBuilder, Unit> content) {
        Intrinsics.checkNotNullParameter(directory, "directory");
        Intrinsics.checkNotNullParameter(content, "content");
        ContentSpec spec = ContentBuilderKt.buildDirectoryContent(content);
        spec.generate(directory);
        return directory;
    }

    @NotNull
    public static final Path buildZipFile(@NotNull Path zipFile, @NotNull Function1<? super ContentBuilder, Unit> content) {
        Intrinsics.checkNotNullParameter(zipFile, "zipFile");
        Intrinsics.checkNotNullParameter(content, "content");
        ContentSpec spec = ContentBuilderKt.buildZipFileContent(content);
        spec.generate(zipFile);
        return zipFile;
    }

    @NotNull
    public static final ContentSpec buildDirectoryContent(@NotNull Function1<? super ContentBuilder, Unit> content) {
        Intrinsics.checkNotNullParameter(content, "content");
        DirectorySpec result2 = new DirectorySpec();
        content.invoke(new ContentBuilderImpl(result2));
        return result2;
    }

    @NotNull
    public static final ContentSpec buildZipFileContent(@NotNull Function1<? super ContentBuilder, Unit> content) {
        Intrinsics.checkNotNullParameter(content, "content");
        ZipSpec result2 = new ZipSpec();
        content.invoke(new ContentBuilderImpl(result2));
        return result2;
    }
}

