/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.usages.nonExtendable;

import com.jetbrains.pluginverifier.results.location.ClassLocation;
import com.jetbrains.pluginverifier.results.location.ElementType;
import com.jetbrains.pluginverifier.results.location.LocationToReferenceKt;
import com.jetbrains.pluginverifier.results.presentation.ClassGenericsSignatureOption;
import com.jetbrains.pluginverifier.results.presentation.ClassOption;
import com.jetbrains.pluginverifier.results.presentation.LocationsPresentationKt;
import com.jetbrains.pluginverifier.results.reference.ClassReference;
import com.jetbrains.pluginverifier.usages.UsageLocationPresentationKt;
import com.jetbrains.pluginverifier.usages.nonExtendable.NonExtendableApiUsage;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0096\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0014\u0010\u0012\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000fR\u0014\u0010\u0014\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000fR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0007\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/pluginverifier/usages/nonExtendable/NonExtendableTypeInherited;", "Lcom/jetbrains/pluginverifier/usages/nonExtendable/NonExtendableApiUsage;", "apiElement", "Lcom/jetbrains/pluginverifier/results/location/ClassLocation;", "usageLocation", "(Lcom/jetbrains/pluginverifier/results/location/ClassLocation;Lcom/jetbrains/pluginverifier/results/location/ClassLocation;)V", "getApiElement", "()Lcom/jetbrains/pluginverifier/results/location/ClassLocation;", "apiReference", "Lcom/jetbrains/pluginverifier/results/reference/ClassReference;", "getApiReference", "()Lcom/jetbrains/pluginverifier/results/reference/ClassReference;", "fullDescription", "", "getFullDescription", "()Ljava/lang/String;", "inheritanceVerb", "getInheritanceVerb", "problemType", "getProblemType", "shortDescription", "getShortDescription", "getUsageLocation", "equals", "", "other", "", "hashCode", "", "verifier-intellij"})
public final class NonExtendableTypeInherited
extends NonExtendableApiUsage {
    @NotNull
    private final ClassLocation apiElement;
    @NotNull
    private final ClassLocation usageLocation;

    public NonExtendableTypeInherited(@NotNull ClassLocation apiElement, @NotNull ClassLocation usageLocation) {
        Intrinsics.checkNotNullParameter(apiElement, "apiElement");
        Intrinsics.checkNotNullParameter(usageLocation, "usageLocation");
        this.apiElement = apiElement;
        this.usageLocation = usageLocation;
    }

    @Override
    @NotNull
    public ClassLocation getApiElement() {
        return this.apiElement;
    }

    @Override
    @NotNull
    public ClassLocation getUsageLocation() {
        return this.usageLocation;
    }

    @Override
    @NotNull
    public String getProblemType() {
        return "Non-extendable type inherited";
    }

    @Override
    @NotNull
    public ClassReference getApiReference() {
        return LocationToReferenceKt.toReference(this.getApiElement());
    }

    private final String getInheritanceVerb() {
        return this.getApiElement().getElementType() == ElementType.INTERFACE && this.getUsageLocation().getElementType() == ElementType.INTERFACE ? "extended" : (this.getApiElement().getElementType() == ElementType.CLASS && this.getUsageLocation().getElementType() == ElementType.CLASS ? "extended" : (this.getApiElement().getElementType() == ElementType.INTERFACE && this.getUsageLocation().getElementType() == ElementType.CLASS ? "implemented" : "inherited"));
    }

    @Override
    @NotNull
    public String getShortDescription() {
        return "Non-extendable " + this.getApiElement().getElementType().getPresentableName() + " " + LocationsPresentationKt.formatClassLocation(this.getApiElement(), ClassOption.FULL_NAME, ClassGenericsSignatureOption.NO_GENERICS) + " is " + this.getInheritanceVerb();
    }

    @Override
    @NotNull
    public String getFullDescription() {
        StringBuilder stringBuilder;
        StringBuilder $this$_get_fullDescription__u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$_get_fullDescription__u24lambda_u240.append("Non-extendable " + this.getApiElement().getElementType().getPresentableName() + " " + LocationsPresentationKt.formatClassLocation(this.getApiElement(), ClassOption.FULL_NAME, ClassGenericsSignatureOption.WITH_GENERICS) + " is " + this.getInheritanceVerb() + " by ");
        $this$_get_fullDescription__u24lambda_u240.append(UsageLocationPresentationKt.formatUsageLocation(this.getUsageLocation()) + ". ");
        $this$_get_fullDescription__u24lambda_u240.append("This " + this.getApiElement().getElementType().getPresentableName());
        $this$_get_fullDescription__u24lambda_u240.append(" is marked with @org.jetbrains.annotations.ApiStatus.NonExtendable, which indicates that the ");
        $this$_get_fullDescription__u24lambda_u240.append(this.getApiElement().getElementType().getPresentableName());
        $this$_get_fullDescription__u24lambda_u240.append(" is not supposed to be extended. See documentation of the @ApiStatus.NonExtendable for more info.");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof NonExtendableTypeInherited && Intrinsics.areEqual(this.getApiElement(), ((NonExtendableTypeInherited)other).getApiElement()) && Intrinsics.areEqual(this.getUsageLocation(), ((NonExtendableTypeInherited)other).getUsageLocation());
    }

    @Override
    public int hashCode() {
        Object[] objectArray = new Object[]{this.getApiElement(), this.getUsageLocation()};
        return Objects.hash(objectArray);
    }
}

